/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
	"time"
)

// BastionListEntry struct for BastionListEntry
type BastionListEntry struct {
	AccessId *string `json:"access_id,omitempty"`
	AllowedAccessIds *[]string `json:"allowed_access_ids,omitempty"`
	AllowedUrls *[]string `json:"allowed_urls,omitempty"`
	AllowedUrlsPerInstance *map[string][]string `json:"allowed_urls_per_instance,omitempty"`
	ClusterName *string `json:"cluster_name,omitempty"`
	DisplayName *string `json:"display_name,omitempty"`
	HasGatewayIdentity *bool `json:"has_gateway_identity,omitempty"`
	LastReport *time.Time `json:"last_report,omitempty"`
}

// NewBastionListEntry instantiates a new BastionListEntry object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewBastionListEntry() *BastionListEntry {
	this := BastionListEntry{}
	return &this
}

// NewBastionListEntryWithDefaults instantiates a new BastionListEntry object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewBastionListEntryWithDefaults() *BastionListEntry {
	this := BastionListEntry{}
	return &this
}

// GetAccessId returns the AccessId field value if set, zero value otherwise.
func (o *BastionListEntry) GetAccessId() string {
	if o == nil || o.AccessId == nil {
		var ret string
		return ret
	}
	return *o.AccessId
}

// GetAccessIdOk returns a tuple with the AccessId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *BastionListEntry) GetAccessIdOk() (*string, bool) {
	if o == nil || o.AccessId == nil {
		return nil, false
	}
	return o.AccessId, true
}

// HasAccessId returns a boolean if a field has been set.
func (o *BastionListEntry) HasAccessId() bool {
	if o != nil && o.AccessId != nil {
		return true
	}

	return false
}

// SetAccessId gets a reference to the given string and assigns it to the AccessId field.
func (o *BastionListEntry) SetAccessId(v string) {
	o.AccessId = &v
}

// GetAllowedAccessIds returns the AllowedAccessIds field value if set, zero value otherwise.
func (o *BastionListEntry) GetAllowedAccessIds() []string {
	if o == nil || o.AllowedAccessIds == nil {
		var ret []string
		return ret
	}
	return *o.AllowedAccessIds
}

// GetAllowedAccessIdsOk returns a tuple with the AllowedAccessIds field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *BastionListEntry) GetAllowedAccessIdsOk() (*[]string, bool) {
	if o == nil || o.AllowedAccessIds == nil {
		return nil, false
	}
	return o.AllowedAccessIds, true
}

// HasAllowedAccessIds returns a boolean if a field has been set.
func (o *BastionListEntry) HasAllowedAccessIds() bool {
	if o != nil && o.AllowedAccessIds != nil {
		return true
	}

	return false
}

// SetAllowedAccessIds gets a reference to the given []string and assigns it to the AllowedAccessIds field.
func (o *BastionListEntry) SetAllowedAccessIds(v []string) {
	o.AllowedAccessIds = &v
}

// GetAllowedUrls returns the AllowedUrls field value if set, zero value otherwise.
func (o *BastionListEntry) GetAllowedUrls() []string {
	if o == nil || o.AllowedUrls == nil {
		var ret []string
		return ret
	}
	return *o.AllowedUrls
}

// GetAllowedUrlsOk returns a tuple with the AllowedUrls field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *BastionListEntry) GetAllowedUrlsOk() (*[]string, bool) {
	if o == nil || o.AllowedUrls == nil {
		return nil, false
	}
	return o.AllowedUrls, true
}

// HasAllowedUrls returns a boolean if a field has been set.
func (o *BastionListEntry) HasAllowedUrls() bool {
	if o != nil && o.AllowedUrls != nil {
		return true
	}

	return false
}

// SetAllowedUrls gets a reference to the given []string and assigns it to the AllowedUrls field.
func (o *BastionListEntry) SetAllowedUrls(v []string) {
	o.AllowedUrls = &v
}

// GetAllowedUrlsPerInstance returns the AllowedUrlsPerInstance field value if set, zero value otherwise.
func (o *BastionListEntry) GetAllowedUrlsPerInstance() map[string][]string {
	if o == nil || o.AllowedUrlsPerInstance == nil {
		var ret map[string][]string
		return ret
	}
	return *o.AllowedUrlsPerInstance
}

// GetAllowedUrlsPerInstanceOk returns a tuple with the AllowedUrlsPerInstance field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *BastionListEntry) GetAllowedUrlsPerInstanceOk() (*map[string][]string, bool) {
	if o == nil || o.AllowedUrlsPerInstance == nil {
		return nil, false
	}
	return o.AllowedUrlsPerInstance, true
}

// HasAllowedUrlsPerInstance returns a boolean if a field has been set.
func (o *BastionListEntry) HasAllowedUrlsPerInstance() bool {
	if o != nil && o.AllowedUrlsPerInstance != nil {
		return true
	}

	return false
}

// SetAllowedUrlsPerInstance gets a reference to the given map[string][]string and assigns it to the AllowedUrlsPerInstance field.
func (o *BastionListEntry) SetAllowedUrlsPerInstance(v map[string][]string) {
	o.AllowedUrlsPerInstance = &v
}

// GetClusterName returns the ClusterName field value if set, zero value otherwise.
func (o *BastionListEntry) GetClusterName() string {
	if o == nil || o.ClusterName == nil {
		var ret string
		return ret
	}
	return *o.ClusterName
}

// GetClusterNameOk returns a tuple with the ClusterName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *BastionListEntry) GetClusterNameOk() (*string, bool) {
	if o == nil || o.ClusterName == nil {
		return nil, false
	}
	return o.ClusterName, true
}

// HasClusterName returns a boolean if a field has been set.
func (o *BastionListEntry) HasClusterName() bool {
	if o != nil && o.ClusterName != nil {
		return true
	}

	return false
}

// SetClusterName gets a reference to the given string and assigns it to the ClusterName field.
func (o *BastionListEntry) SetClusterName(v string) {
	o.ClusterName = &v
}

// GetDisplayName returns the DisplayName field value if set, zero value otherwise.
func (o *BastionListEntry) GetDisplayName() string {
	if o == nil || o.DisplayName == nil {
		var ret string
		return ret
	}
	return *o.DisplayName
}

// GetDisplayNameOk returns a tuple with the DisplayName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *BastionListEntry) GetDisplayNameOk() (*string, bool) {
	if o == nil || o.DisplayName == nil {
		return nil, false
	}
	return o.DisplayName, true
}

// HasDisplayName returns a boolean if a field has been set.
func (o *BastionListEntry) HasDisplayName() bool {
	if o != nil && o.DisplayName != nil {
		return true
	}

	return false
}

// SetDisplayName gets a reference to the given string and assigns it to the DisplayName field.
func (o *BastionListEntry) SetDisplayName(v string) {
	o.DisplayName = &v
}

// GetHasGatewayIdentity returns the HasGatewayIdentity field value if set, zero value otherwise.
func (o *BastionListEntry) GetHasGatewayIdentity() bool {
	if o == nil || o.HasGatewayIdentity == nil {
		var ret bool
		return ret
	}
	return *o.HasGatewayIdentity
}

// GetHasGatewayIdentityOk returns a tuple with the HasGatewayIdentity field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *BastionListEntry) GetHasGatewayIdentityOk() (*bool, bool) {
	if o == nil || o.HasGatewayIdentity == nil {
		return nil, false
	}
	return o.HasGatewayIdentity, true
}

// HasHasGatewayIdentity returns a boolean if a field has been set.
func (o *BastionListEntry) HasHasGatewayIdentity() bool {
	if o != nil && o.HasGatewayIdentity != nil {
		return true
	}

	return false
}

// SetHasGatewayIdentity gets a reference to the given bool and assigns it to the HasGatewayIdentity field.
func (o *BastionListEntry) SetHasGatewayIdentity(v bool) {
	o.HasGatewayIdentity = &v
}

// GetLastReport returns the LastReport field value if set, zero value otherwise.
func (o *BastionListEntry) GetLastReport() time.Time {
	if o == nil || o.LastReport == nil {
		var ret time.Time
		return ret
	}
	return *o.LastReport
}

// GetLastReportOk returns a tuple with the LastReport field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *BastionListEntry) GetLastReportOk() (*time.Time, bool) {
	if o == nil || o.LastReport == nil {
		return nil, false
	}
	return o.LastReport, true
}

// HasLastReport returns a boolean if a field has been set.
func (o *BastionListEntry) HasLastReport() bool {
	if o != nil && o.LastReport != nil {
		return true
	}

	return false
}

// SetLastReport gets a reference to the given time.Time and assigns it to the LastReport field.
func (o *BastionListEntry) SetLastReport(v time.Time) {
	o.LastReport = &v
}

func (o BastionListEntry) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AccessId != nil {
		toSerialize["access_id"] = o.AccessId
	}
	if o.AllowedAccessIds != nil {
		toSerialize["allowed_access_ids"] = o.AllowedAccessIds
	}
	if o.AllowedUrls != nil {
		toSerialize["allowed_urls"] = o.AllowedUrls
	}
	if o.AllowedUrlsPerInstance != nil {
		toSerialize["allowed_urls_per_instance"] = o.AllowedUrlsPerInstance
	}
	if o.ClusterName != nil {
		toSerialize["cluster_name"] = o.ClusterName
	}
	if o.DisplayName != nil {
		toSerialize["display_name"] = o.DisplayName
	}
	if o.HasGatewayIdentity != nil {
		toSerialize["has_gateway_identity"] = o.HasGatewayIdentity
	}
	if o.LastReport != nil {
		toSerialize["last_report"] = o.LastReport
	}
	return json.Marshal(toSerialize)
}

type NullableBastionListEntry struct {
	value *BastionListEntry
	isSet bool
}

func (v NullableBastionListEntry) Get() *BastionListEntry {
	return v.value
}

func (v *NullableBastionListEntry) Set(val *BastionListEntry) {
	v.value = val
	v.isSet = true
}

func (v NullableBastionListEntry) IsSet() bool {
	return v.isSet
}

func (v *NullableBastionListEntry) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableBastionListEntry(val *BastionListEntry) *NullableBastionListEntry {
	return &NullableBastionListEntry{value: val, isSet: true}
}

func (v NullableBastionListEntry) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableBastionListEntry) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


