/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// AWSIAMAccessRules struct for AWSIAMAccessRules
type AWSIAMAccessRules struct {
	// The list of account ids that the login is restricted to.
	AccountId *[]string `json:"account_id,omitempty"`
	// The list of ARNs that the login is restricted to.
	Arn *[]string `json:"arn,omitempty"`
	// The list of resource ids that the login is restricted to.
	ResourceId *[]string `json:"resource_id,omitempty"`
	// The list of role ids that the login is restricted to.
	RoleId *[]string `json:"role_id,omitempty"`
	// The list of role names that the login is restricted to.
	RoleName *[]string `json:"role_name,omitempty"`
	// The sts URL.
	StsEndpoint *string `json:"sts_endpoint,omitempty"`
	// A unique identifier to distinguish different users
	UniqueIdentifier *string `json:"unique_identifier,omitempty"`
	// The list of user ids that the login is restricted to.
	UserId *[]string `json:"user_id,omitempty"`
	// The list of user names that the login is restricted to.
	UserName *[]string `json:"user_name,omitempty"`
}

// NewAWSIAMAccessRules instantiates a new AWSIAMAccessRules object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAWSIAMAccessRules() *AWSIAMAccessRules {
	this := AWSIAMAccessRules{}
	return &this
}

// NewAWSIAMAccessRulesWithDefaults instantiates a new AWSIAMAccessRules object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAWSIAMAccessRulesWithDefaults() *AWSIAMAccessRules {
	this := AWSIAMAccessRules{}
	return &this
}

// GetAccountId returns the AccountId field value if set, zero value otherwise.
func (o *AWSIAMAccessRules) GetAccountId() []string {
	if o == nil || o.AccountId == nil {
		var ret []string
		return ret
	}
	return *o.AccountId
}

// GetAccountIdOk returns a tuple with the AccountId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AWSIAMAccessRules) GetAccountIdOk() (*[]string, bool) {
	if o == nil || o.AccountId == nil {
		return nil, false
	}
	return o.AccountId, true
}

// HasAccountId returns a boolean if a field has been set.
func (o *AWSIAMAccessRules) HasAccountId() bool {
	if o != nil && o.AccountId != nil {
		return true
	}

	return false
}

// SetAccountId gets a reference to the given []string and assigns it to the AccountId field.
func (o *AWSIAMAccessRules) SetAccountId(v []string) {
	o.AccountId = &v
}

// GetArn returns the Arn field value if set, zero value otherwise.
func (o *AWSIAMAccessRules) GetArn() []string {
	if o == nil || o.Arn == nil {
		var ret []string
		return ret
	}
	return *o.Arn
}

// GetArnOk returns a tuple with the Arn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AWSIAMAccessRules) GetArnOk() (*[]string, bool) {
	if o == nil || o.Arn == nil {
		return nil, false
	}
	return o.Arn, true
}

// HasArn returns a boolean if a field has been set.
func (o *AWSIAMAccessRules) HasArn() bool {
	if o != nil && o.Arn != nil {
		return true
	}

	return false
}

// SetArn gets a reference to the given []string and assigns it to the Arn field.
func (o *AWSIAMAccessRules) SetArn(v []string) {
	o.Arn = &v
}

// GetResourceId returns the ResourceId field value if set, zero value otherwise.
func (o *AWSIAMAccessRules) GetResourceId() []string {
	if o == nil || o.ResourceId == nil {
		var ret []string
		return ret
	}
	return *o.ResourceId
}

// GetResourceIdOk returns a tuple with the ResourceId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AWSIAMAccessRules) GetResourceIdOk() (*[]string, bool) {
	if o == nil || o.ResourceId == nil {
		return nil, false
	}
	return o.ResourceId, true
}

// HasResourceId returns a boolean if a field has been set.
func (o *AWSIAMAccessRules) HasResourceId() bool {
	if o != nil && o.ResourceId != nil {
		return true
	}

	return false
}

// SetResourceId gets a reference to the given []string and assigns it to the ResourceId field.
func (o *AWSIAMAccessRules) SetResourceId(v []string) {
	o.ResourceId = &v
}

// GetRoleId returns the RoleId field value if set, zero value otherwise.
func (o *AWSIAMAccessRules) GetRoleId() []string {
	if o == nil || o.RoleId == nil {
		var ret []string
		return ret
	}
	return *o.RoleId
}

// GetRoleIdOk returns a tuple with the RoleId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AWSIAMAccessRules) GetRoleIdOk() (*[]string, bool) {
	if o == nil || o.RoleId == nil {
		return nil, false
	}
	return o.RoleId, true
}

// HasRoleId returns a boolean if a field has been set.
func (o *AWSIAMAccessRules) HasRoleId() bool {
	if o != nil && o.RoleId != nil {
		return true
	}

	return false
}

// SetRoleId gets a reference to the given []string and assigns it to the RoleId field.
func (o *AWSIAMAccessRules) SetRoleId(v []string) {
	o.RoleId = &v
}

// GetRoleName returns the RoleName field value if set, zero value otherwise.
func (o *AWSIAMAccessRules) GetRoleName() []string {
	if o == nil || o.RoleName == nil {
		var ret []string
		return ret
	}
	return *o.RoleName
}

// GetRoleNameOk returns a tuple with the RoleName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AWSIAMAccessRules) GetRoleNameOk() (*[]string, bool) {
	if o == nil || o.RoleName == nil {
		return nil, false
	}
	return o.RoleName, true
}

// HasRoleName returns a boolean if a field has been set.
func (o *AWSIAMAccessRules) HasRoleName() bool {
	if o != nil && o.RoleName != nil {
		return true
	}

	return false
}

// SetRoleName gets a reference to the given []string and assigns it to the RoleName field.
func (o *AWSIAMAccessRules) SetRoleName(v []string) {
	o.RoleName = &v
}

// GetStsEndpoint returns the StsEndpoint field value if set, zero value otherwise.
func (o *AWSIAMAccessRules) GetStsEndpoint() string {
	if o == nil || o.StsEndpoint == nil {
		var ret string
		return ret
	}
	return *o.StsEndpoint
}

// GetStsEndpointOk returns a tuple with the StsEndpoint field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AWSIAMAccessRules) GetStsEndpointOk() (*string, bool) {
	if o == nil || o.StsEndpoint == nil {
		return nil, false
	}
	return o.StsEndpoint, true
}

// HasStsEndpoint returns a boolean if a field has been set.
func (o *AWSIAMAccessRules) HasStsEndpoint() bool {
	if o != nil && o.StsEndpoint != nil {
		return true
	}

	return false
}

// SetStsEndpoint gets a reference to the given string and assigns it to the StsEndpoint field.
func (o *AWSIAMAccessRules) SetStsEndpoint(v string) {
	o.StsEndpoint = &v
}

// GetUniqueIdentifier returns the UniqueIdentifier field value if set, zero value otherwise.
func (o *AWSIAMAccessRules) GetUniqueIdentifier() string {
	if o == nil || o.UniqueIdentifier == nil {
		var ret string
		return ret
	}
	return *o.UniqueIdentifier
}

// GetUniqueIdentifierOk returns a tuple with the UniqueIdentifier field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AWSIAMAccessRules) GetUniqueIdentifierOk() (*string, bool) {
	if o == nil || o.UniqueIdentifier == nil {
		return nil, false
	}
	return o.UniqueIdentifier, true
}

// HasUniqueIdentifier returns a boolean if a field has been set.
func (o *AWSIAMAccessRules) HasUniqueIdentifier() bool {
	if o != nil && o.UniqueIdentifier != nil {
		return true
	}

	return false
}

// SetUniqueIdentifier gets a reference to the given string and assigns it to the UniqueIdentifier field.
func (o *AWSIAMAccessRules) SetUniqueIdentifier(v string) {
	o.UniqueIdentifier = &v
}

// GetUserId returns the UserId field value if set, zero value otherwise.
func (o *AWSIAMAccessRules) GetUserId() []string {
	if o == nil || o.UserId == nil {
		var ret []string
		return ret
	}
	return *o.UserId
}

// GetUserIdOk returns a tuple with the UserId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AWSIAMAccessRules) GetUserIdOk() (*[]string, bool) {
	if o == nil || o.UserId == nil {
		return nil, false
	}
	return o.UserId, true
}

// HasUserId returns a boolean if a field has been set.
func (o *AWSIAMAccessRules) HasUserId() bool {
	if o != nil && o.UserId != nil {
		return true
	}

	return false
}

// SetUserId gets a reference to the given []string and assigns it to the UserId field.
func (o *AWSIAMAccessRules) SetUserId(v []string) {
	o.UserId = &v
}

// GetUserName returns the UserName field value if set, zero value otherwise.
func (o *AWSIAMAccessRules) GetUserName() []string {
	if o == nil || o.UserName == nil {
		var ret []string
		return ret
	}
	return *o.UserName
}

// GetUserNameOk returns a tuple with the UserName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AWSIAMAccessRules) GetUserNameOk() (*[]string, bool) {
	if o == nil || o.UserName == nil {
		return nil, false
	}
	return o.UserName, true
}

// HasUserName returns a boolean if a field has been set.
func (o *AWSIAMAccessRules) HasUserName() bool {
	if o != nil && o.UserName != nil {
		return true
	}

	return false
}

// SetUserName gets a reference to the given []string and assigns it to the UserName field.
func (o *AWSIAMAccessRules) SetUserName(v []string) {
	o.UserName = &v
}

func (o AWSIAMAccessRules) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AccountId != nil {
		toSerialize["account_id"] = o.AccountId
	}
	if o.Arn != nil {
		toSerialize["arn"] = o.Arn
	}
	if o.ResourceId != nil {
		toSerialize["resource_id"] = o.ResourceId
	}
	if o.RoleId != nil {
		toSerialize["role_id"] = o.RoleId
	}
	if o.RoleName != nil {
		toSerialize["role_name"] = o.RoleName
	}
	if o.StsEndpoint != nil {
		toSerialize["sts_endpoint"] = o.StsEndpoint
	}
	if o.UniqueIdentifier != nil {
		toSerialize["unique_identifier"] = o.UniqueIdentifier
	}
	if o.UserId != nil {
		toSerialize["user_id"] = o.UserId
	}
	if o.UserName != nil {
		toSerialize["user_name"] = o.UserName
	}
	return json.Marshal(toSerialize)
}

type NullableAWSIAMAccessRules struct {
	value *AWSIAMAccessRules
	isSet bool
}

func (v NullableAWSIAMAccessRules) Get() *AWSIAMAccessRules {
	return v.value
}

func (v *NullableAWSIAMAccessRules) Set(val *AWSIAMAccessRules) {
	v.value = val
	v.isSet = true
}

func (v NullableAWSIAMAccessRules) IsSet() bool {
	return v.isSet
}

func (v *NullableAWSIAMAccessRules) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAWSIAMAccessRules(val *AWSIAMAccessRules) *NullableAWSIAMAccessRules {
	return &NullableAWSIAMAccessRules{value: val, isSet: true}
}

func (v NullableAWSIAMAccessRules) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAWSIAMAccessRules) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


