/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// AuthMethodCreateAzureAD authMethodCreateAzureAD is a command that creates a new auth method that will be able to authenticate using Azure Active Directory credentials.
type AuthMethodCreateAzureAD struct {
	// Access expiration date in Unix timestamp (select 0 for access without expiry date)
	AccessExpires *int64 `json:"access-expires,omitempty"`
	// Deprecated (Deprecated) The audience in the JWT
	Audience *string `json:"audience,omitempty"`
	// Subclaims to include in audit logs, e.g \"--audit-logs-claims email --audit-logs-claims username\"
	AuditLogsClaims *[]string `json:"audit-logs-claims,omitempty"`
	// A list of group ids that the access is restricted to
	BoundGroupId *[]string `json:"bound-group-id,omitempty"`
	// A CIDR whitelist with the IPs that the access is restricted to
	BoundIps *[]string `json:"bound-ips,omitempty"`
	// A list of resource providers that the access is restricted to (e.g, Microsoft.Compute, Microsoft.ManagedIdentity, etc)
	BoundProviders *[]string `json:"bound-providers,omitempty"`
	// A list of full resource ids that the access is restricted to
	BoundResourceId *[]string `json:"bound-resource-id,omitempty"`
	// A list of resource names that the access is restricted to (e.g, a virtual machine name, scale set name, etc).
	BoundResourceNames *[]string `json:"bound-resource-names,omitempty"`
	// A list of resource types that the access is restricted to (e.g, virtualMachines, userAssignedIdentities, etc)
	BoundResourceTypes *[]string `json:"bound-resource-types,omitempty"`
	// A list of resource groups that the access is restricted to
	BoundRgId *[]string `json:"bound-rg-id,omitempty"`
	// A list of service principal IDs that the access is restricted to
	BoundSpid *[]string `json:"bound-spid,omitempty"`
	// A list of subscription ids that the access is restricted to
	BoundSubId *[]string `json:"bound-sub-id,omitempty"`
	// The Azure tenant id that the access is restricted to
	BoundTenantId string `json:"bound-tenant-id"`
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Auth Method description
	Description *string `json:"description,omitempty"`
	// if true: enforce role-association must include sub claims
	ForceSubClaims *bool `json:"force-sub-claims,omitempty"`
	// A CIDR whitelist with the GW IPs that the access is restricted to
	GwBoundIps *[]string `json:"gw-bound-ips,omitempty"`
	// Issuer URL
	Issuer *string `json:"issuer,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.
	JwksUri *string `json:"jwks-uri,omitempty"`
	// Jwt TTL
	JwtTtl *int64 `json:"jwt-ttl,omitempty"`
	// Auth Method name
	Name string `json:"name"`
	// Choose the relevant product type for the auth method [sm, sra, pm, dp, ca]
	ProductType *[]string `json:"product-type,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// A unique identifier (ID) value which is a \"sub claim\" name that contains details uniquely identifying that resource. This \"sub claim\" is used to distinguish between different identities.
	UniqueIdentifier *string `json:"unique-identifier,omitempty"`
}

// NewAuthMethodCreateAzureAD instantiates a new AuthMethodCreateAzureAD object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAuthMethodCreateAzureAD(boundTenantId string, name string, ) *AuthMethodCreateAzureAD {
	this := AuthMethodCreateAzureAD{}
	var accessExpires int64 = 0
	this.AccessExpires = &accessExpires
	var audience string = "https://management.azure.com/"
	this.Audience = &audience
	this.BoundTenantId = boundTenantId
	var issuer string = "https://sts.windows.net/---bound_tenant_id---"
	this.Issuer = &issuer
	var json bool = false
	this.Json = &json
	var jwksUri string = "https://login.microsoftonline.com/common/discovery/keys"
	this.JwksUri = &jwksUri
	var jwtTtl int64 = 0
	this.JwtTtl = &jwtTtl
	this.Name = name
	return &this
}

// NewAuthMethodCreateAzureADWithDefaults instantiates a new AuthMethodCreateAzureAD object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAuthMethodCreateAzureADWithDefaults() *AuthMethodCreateAzureAD {
	this := AuthMethodCreateAzureAD{}
	var accessExpires int64 = 0
	this.AccessExpires = &accessExpires
	var audience string = "https://management.azure.com/"
	this.Audience = &audience
	var issuer string = "https://sts.windows.net/---bound_tenant_id---"
	this.Issuer = &issuer
	var json bool = false
	this.Json = &json
	var jwksUri string = "https://login.microsoftonline.com/common/discovery/keys"
	this.JwksUri = &jwksUri
	var jwtTtl int64 = 0
	this.JwtTtl = &jwtTtl
	return &this
}

// GetAccessExpires returns the AccessExpires field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetAccessExpires() int64 {
	if o == nil || o.AccessExpires == nil {
		var ret int64
		return ret
	}
	return *o.AccessExpires
}

// GetAccessExpiresOk returns a tuple with the AccessExpires field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetAccessExpiresOk() (*int64, bool) {
	if o == nil || o.AccessExpires == nil {
		return nil, false
	}
	return o.AccessExpires, true
}

// HasAccessExpires returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasAccessExpires() bool {
	if o != nil && o.AccessExpires != nil {
		return true
	}

	return false
}

// SetAccessExpires gets a reference to the given int64 and assigns it to the AccessExpires field.
func (o *AuthMethodCreateAzureAD) SetAccessExpires(v int64) {
	o.AccessExpires = &v
}

// GetAudience returns the Audience field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetAudience() string {
	if o == nil || o.Audience == nil {
		var ret string
		return ret
	}
	return *o.Audience
}

// GetAudienceOk returns a tuple with the Audience field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetAudienceOk() (*string, bool) {
	if o == nil || o.Audience == nil {
		return nil, false
	}
	return o.Audience, true
}

// HasAudience returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasAudience() bool {
	if o != nil && o.Audience != nil {
		return true
	}

	return false
}

// SetAudience gets a reference to the given string and assigns it to the Audience field.
func (o *AuthMethodCreateAzureAD) SetAudience(v string) {
	o.Audience = &v
}

// GetAuditLogsClaims returns the AuditLogsClaims field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetAuditLogsClaims() []string {
	if o == nil || o.AuditLogsClaims == nil {
		var ret []string
		return ret
	}
	return *o.AuditLogsClaims
}

// GetAuditLogsClaimsOk returns a tuple with the AuditLogsClaims field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetAuditLogsClaimsOk() (*[]string, bool) {
	if o == nil || o.AuditLogsClaims == nil {
		return nil, false
	}
	return o.AuditLogsClaims, true
}

// HasAuditLogsClaims returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasAuditLogsClaims() bool {
	if o != nil && o.AuditLogsClaims != nil {
		return true
	}

	return false
}

// SetAuditLogsClaims gets a reference to the given []string and assigns it to the AuditLogsClaims field.
func (o *AuthMethodCreateAzureAD) SetAuditLogsClaims(v []string) {
	o.AuditLogsClaims = &v
}

// GetBoundGroupId returns the BoundGroupId field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetBoundGroupId() []string {
	if o == nil || o.BoundGroupId == nil {
		var ret []string
		return ret
	}
	return *o.BoundGroupId
}

// GetBoundGroupIdOk returns a tuple with the BoundGroupId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetBoundGroupIdOk() (*[]string, bool) {
	if o == nil || o.BoundGroupId == nil {
		return nil, false
	}
	return o.BoundGroupId, true
}

// HasBoundGroupId returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasBoundGroupId() bool {
	if o != nil && o.BoundGroupId != nil {
		return true
	}

	return false
}

// SetBoundGroupId gets a reference to the given []string and assigns it to the BoundGroupId field.
func (o *AuthMethodCreateAzureAD) SetBoundGroupId(v []string) {
	o.BoundGroupId = &v
}

// GetBoundIps returns the BoundIps field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetBoundIps() []string {
	if o == nil || o.BoundIps == nil {
		var ret []string
		return ret
	}
	return *o.BoundIps
}

// GetBoundIpsOk returns a tuple with the BoundIps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetBoundIpsOk() (*[]string, bool) {
	if o == nil || o.BoundIps == nil {
		return nil, false
	}
	return o.BoundIps, true
}

// HasBoundIps returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasBoundIps() bool {
	if o != nil && o.BoundIps != nil {
		return true
	}

	return false
}

// SetBoundIps gets a reference to the given []string and assigns it to the BoundIps field.
func (o *AuthMethodCreateAzureAD) SetBoundIps(v []string) {
	o.BoundIps = &v
}

// GetBoundProviders returns the BoundProviders field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetBoundProviders() []string {
	if o == nil || o.BoundProviders == nil {
		var ret []string
		return ret
	}
	return *o.BoundProviders
}

// GetBoundProvidersOk returns a tuple with the BoundProviders field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetBoundProvidersOk() (*[]string, bool) {
	if o == nil || o.BoundProviders == nil {
		return nil, false
	}
	return o.BoundProviders, true
}

// HasBoundProviders returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasBoundProviders() bool {
	if o != nil && o.BoundProviders != nil {
		return true
	}

	return false
}

// SetBoundProviders gets a reference to the given []string and assigns it to the BoundProviders field.
func (o *AuthMethodCreateAzureAD) SetBoundProviders(v []string) {
	o.BoundProviders = &v
}

// GetBoundResourceId returns the BoundResourceId field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetBoundResourceId() []string {
	if o == nil || o.BoundResourceId == nil {
		var ret []string
		return ret
	}
	return *o.BoundResourceId
}

// GetBoundResourceIdOk returns a tuple with the BoundResourceId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetBoundResourceIdOk() (*[]string, bool) {
	if o == nil || o.BoundResourceId == nil {
		return nil, false
	}
	return o.BoundResourceId, true
}

// HasBoundResourceId returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasBoundResourceId() bool {
	if o != nil && o.BoundResourceId != nil {
		return true
	}

	return false
}

// SetBoundResourceId gets a reference to the given []string and assigns it to the BoundResourceId field.
func (o *AuthMethodCreateAzureAD) SetBoundResourceId(v []string) {
	o.BoundResourceId = &v
}

// GetBoundResourceNames returns the BoundResourceNames field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetBoundResourceNames() []string {
	if o == nil || o.BoundResourceNames == nil {
		var ret []string
		return ret
	}
	return *o.BoundResourceNames
}

// GetBoundResourceNamesOk returns a tuple with the BoundResourceNames field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetBoundResourceNamesOk() (*[]string, bool) {
	if o == nil || o.BoundResourceNames == nil {
		return nil, false
	}
	return o.BoundResourceNames, true
}

// HasBoundResourceNames returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasBoundResourceNames() bool {
	if o != nil && o.BoundResourceNames != nil {
		return true
	}

	return false
}

// SetBoundResourceNames gets a reference to the given []string and assigns it to the BoundResourceNames field.
func (o *AuthMethodCreateAzureAD) SetBoundResourceNames(v []string) {
	o.BoundResourceNames = &v
}

// GetBoundResourceTypes returns the BoundResourceTypes field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetBoundResourceTypes() []string {
	if o == nil || o.BoundResourceTypes == nil {
		var ret []string
		return ret
	}
	return *o.BoundResourceTypes
}

// GetBoundResourceTypesOk returns a tuple with the BoundResourceTypes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetBoundResourceTypesOk() (*[]string, bool) {
	if o == nil || o.BoundResourceTypes == nil {
		return nil, false
	}
	return o.BoundResourceTypes, true
}

// HasBoundResourceTypes returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasBoundResourceTypes() bool {
	if o != nil && o.BoundResourceTypes != nil {
		return true
	}

	return false
}

// SetBoundResourceTypes gets a reference to the given []string and assigns it to the BoundResourceTypes field.
func (o *AuthMethodCreateAzureAD) SetBoundResourceTypes(v []string) {
	o.BoundResourceTypes = &v
}

// GetBoundRgId returns the BoundRgId field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetBoundRgId() []string {
	if o == nil || o.BoundRgId == nil {
		var ret []string
		return ret
	}
	return *o.BoundRgId
}

// GetBoundRgIdOk returns a tuple with the BoundRgId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetBoundRgIdOk() (*[]string, bool) {
	if o == nil || o.BoundRgId == nil {
		return nil, false
	}
	return o.BoundRgId, true
}

// HasBoundRgId returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasBoundRgId() bool {
	if o != nil && o.BoundRgId != nil {
		return true
	}

	return false
}

// SetBoundRgId gets a reference to the given []string and assigns it to the BoundRgId field.
func (o *AuthMethodCreateAzureAD) SetBoundRgId(v []string) {
	o.BoundRgId = &v
}

// GetBoundSpid returns the BoundSpid field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetBoundSpid() []string {
	if o == nil || o.BoundSpid == nil {
		var ret []string
		return ret
	}
	return *o.BoundSpid
}

// GetBoundSpidOk returns a tuple with the BoundSpid field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetBoundSpidOk() (*[]string, bool) {
	if o == nil || o.BoundSpid == nil {
		return nil, false
	}
	return o.BoundSpid, true
}

// HasBoundSpid returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasBoundSpid() bool {
	if o != nil && o.BoundSpid != nil {
		return true
	}

	return false
}

// SetBoundSpid gets a reference to the given []string and assigns it to the BoundSpid field.
func (o *AuthMethodCreateAzureAD) SetBoundSpid(v []string) {
	o.BoundSpid = &v
}

// GetBoundSubId returns the BoundSubId field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetBoundSubId() []string {
	if o == nil || o.BoundSubId == nil {
		var ret []string
		return ret
	}
	return *o.BoundSubId
}

// GetBoundSubIdOk returns a tuple with the BoundSubId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetBoundSubIdOk() (*[]string, bool) {
	if o == nil || o.BoundSubId == nil {
		return nil, false
	}
	return o.BoundSubId, true
}

// HasBoundSubId returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasBoundSubId() bool {
	if o != nil && o.BoundSubId != nil {
		return true
	}

	return false
}

// SetBoundSubId gets a reference to the given []string and assigns it to the BoundSubId field.
func (o *AuthMethodCreateAzureAD) SetBoundSubId(v []string) {
	o.BoundSubId = &v
}

// GetBoundTenantId returns the BoundTenantId field value
func (o *AuthMethodCreateAzureAD) GetBoundTenantId() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.BoundTenantId
}

// GetBoundTenantIdOk returns a tuple with the BoundTenantId field value
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetBoundTenantIdOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.BoundTenantId, true
}

// SetBoundTenantId sets field value
func (o *AuthMethodCreateAzureAD) SetBoundTenantId(v string) {
	o.BoundTenantId = v
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *AuthMethodCreateAzureAD) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *AuthMethodCreateAzureAD) SetDescription(v string) {
	o.Description = &v
}

// GetForceSubClaims returns the ForceSubClaims field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetForceSubClaims() bool {
	if o == nil || o.ForceSubClaims == nil {
		var ret bool
		return ret
	}
	return *o.ForceSubClaims
}

// GetForceSubClaimsOk returns a tuple with the ForceSubClaims field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetForceSubClaimsOk() (*bool, bool) {
	if o == nil || o.ForceSubClaims == nil {
		return nil, false
	}
	return o.ForceSubClaims, true
}

// HasForceSubClaims returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasForceSubClaims() bool {
	if o != nil && o.ForceSubClaims != nil {
		return true
	}

	return false
}

// SetForceSubClaims gets a reference to the given bool and assigns it to the ForceSubClaims field.
func (o *AuthMethodCreateAzureAD) SetForceSubClaims(v bool) {
	o.ForceSubClaims = &v
}

// GetGwBoundIps returns the GwBoundIps field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetGwBoundIps() []string {
	if o == nil || o.GwBoundIps == nil {
		var ret []string
		return ret
	}
	return *o.GwBoundIps
}

// GetGwBoundIpsOk returns a tuple with the GwBoundIps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetGwBoundIpsOk() (*[]string, bool) {
	if o == nil || o.GwBoundIps == nil {
		return nil, false
	}
	return o.GwBoundIps, true
}

// HasGwBoundIps returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasGwBoundIps() bool {
	if o != nil && o.GwBoundIps != nil {
		return true
	}

	return false
}

// SetGwBoundIps gets a reference to the given []string and assigns it to the GwBoundIps field.
func (o *AuthMethodCreateAzureAD) SetGwBoundIps(v []string) {
	o.GwBoundIps = &v
}

// GetIssuer returns the Issuer field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetIssuer() string {
	if o == nil || o.Issuer == nil {
		var ret string
		return ret
	}
	return *o.Issuer
}

// GetIssuerOk returns a tuple with the Issuer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetIssuerOk() (*string, bool) {
	if o == nil || o.Issuer == nil {
		return nil, false
	}
	return o.Issuer, true
}

// HasIssuer returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasIssuer() bool {
	if o != nil && o.Issuer != nil {
		return true
	}

	return false
}

// SetIssuer gets a reference to the given string and assigns it to the Issuer field.
func (o *AuthMethodCreateAzureAD) SetIssuer(v string) {
	o.Issuer = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *AuthMethodCreateAzureAD) SetJson(v bool) {
	o.Json = &v
}

// GetJwksUri returns the JwksUri field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetJwksUri() string {
	if o == nil || o.JwksUri == nil {
		var ret string
		return ret
	}
	return *o.JwksUri
}

// GetJwksUriOk returns a tuple with the JwksUri field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetJwksUriOk() (*string, bool) {
	if o == nil || o.JwksUri == nil {
		return nil, false
	}
	return o.JwksUri, true
}

// HasJwksUri returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasJwksUri() bool {
	if o != nil && o.JwksUri != nil {
		return true
	}

	return false
}

// SetJwksUri gets a reference to the given string and assigns it to the JwksUri field.
func (o *AuthMethodCreateAzureAD) SetJwksUri(v string) {
	o.JwksUri = &v
}

// GetJwtTtl returns the JwtTtl field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetJwtTtl() int64 {
	if o == nil || o.JwtTtl == nil {
		var ret int64
		return ret
	}
	return *o.JwtTtl
}

// GetJwtTtlOk returns a tuple with the JwtTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetJwtTtlOk() (*int64, bool) {
	if o == nil || o.JwtTtl == nil {
		return nil, false
	}
	return o.JwtTtl, true
}

// HasJwtTtl returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasJwtTtl() bool {
	if o != nil && o.JwtTtl != nil {
		return true
	}

	return false
}

// SetJwtTtl gets a reference to the given int64 and assigns it to the JwtTtl field.
func (o *AuthMethodCreateAzureAD) SetJwtTtl(v int64) {
	o.JwtTtl = &v
}

// GetName returns the Name field value
func (o *AuthMethodCreateAzureAD) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *AuthMethodCreateAzureAD) SetName(v string) {
	o.Name = v
}

// GetProductType returns the ProductType field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetProductType() []string {
	if o == nil || o.ProductType == nil {
		var ret []string
		return ret
	}
	return *o.ProductType
}

// GetProductTypeOk returns a tuple with the ProductType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetProductTypeOk() (*[]string, bool) {
	if o == nil || o.ProductType == nil {
		return nil, false
	}
	return o.ProductType, true
}

// HasProductType returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasProductType() bool {
	if o != nil && o.ProductType != nil {
		return true
	}

	return false
}

// SetProductType gets a reference to the given []string and assigns it to the ProductType field.
func (o *AuthMethodCreateAzureAD) SetProductType(v []string) {
	o.ProductType = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *AuthMethodCreateAzureAD) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *AuthMethodCreateAzureAD) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUniqueIdentifier returns the UniqueIdentifier field value if set, zero value otherwise.
func (o *AuthMethodCreateAzureAD) GetUniqueIdentifier() string {
	if o == nil || o.UniqueIdentifier == nil {
		var ret string
		return ret
	}
	return *o.UniqueIdentifier
}

// GetUniqueIdentifierOk returns a tuple with the UniqueIdentifier field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateAzureAD) GetUniqueIdentifierOk() (*string, bool) {
	if o == nil || o.UniqueIdentifier == nil {
		return nil, false
	}
	return o.UniqueIdentifier, true
}

// HasUniqueIdentifier returns a boolean if a field has been set.
func (o *AuthMethodCreateAzureAD) HasUniqueIdentifier() bool {
	if o != nil && o.UniqueIdentifier != nil {
		return true
	}

	return false
}

// SetUniqueIdentifier gets a reference to the given string and assigns it to the UniqueIdentifier field.
func (o *AuthMethodCreateAzureAD) SetUniqueIdentifier(v string) {
	o.UniqueIdentifier = &v
}

func (o AuthMethodCreateAzureAD) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AccessExpires != nil {
		toSerialize["access-expires"] = o.AccessExpires
	}
	if o.Audience != nil {
		toSerialize["audience"] = o.Audience
	}
	if o.AuditLogsClaims != nil {
		toSerialize["audit-logs-claims"] = o.AuditLogsClaims
	}
	if o.BoundGroupId != nil {
		toSerialize["bound-group-id"] = o.BoundGroupId
	}
	if o.BoundIps != nil {
		toSerialize["bound-ips"] = o.BoundIps
	}
	if o.BoundProviders != nil {
		toSerialize["bound-providers"] = o.BoundProviders
	}
	if o.BoundResourceId != nil {
		toSerialize["bound-resource-id"] = o.BoundResourceId
	}
	if o.BoundResourceNames != nil {
		toSerialize["bound-resource-names"] = o.BoundResourceNames
	}
	if o.BoundResourceTypes != nil {
		toSerialize["bound-resource-types"] = o.BoundResourceTypes
	}
	if o.BoundRgId != nil {
		toSerialize["bound-rg-id"] = o.BoundRgId
	}
	if o.BoundSpid != nil {
		toSerialize["bound-spid"] = o.BoundSpid
	}
	if o.BoundSubId != nil {
		toSerialize["bound-sub-id"] = o.BoundSubId
	}
	if true {
		toSerialize["bound-tenant-id"] = o.BoundTenantId
	}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.ForceSubClaims != nil {
		toSerialize["force-sub-claims"] = o.ForceSubClaims
	}
	if o.GwBoundIps != nil {
		toSerialize["gw-bound-ips"] = o.GwBoundIps
	}
	if o.Issuer != nil {
		toSerialize["issuer"] = o.Issuer
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.JwksUri != nil {
		toSerialize["jwks-uri"] = o.JwksUri
	}
	if o.JwtTtl != nil {
		toSerialize["jwt-ttl"] = o.JwtTtl
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.ProductType != nil {
		toSerialize["product-type"] = o.ProductType
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UniqueIdentifier != nil {
		toSerialize["unique-identifier"] = o.UniqueIdentifier
	}
	return json.Marshal(toSerialize)
}

type NullableAuthMethodCreateAzureAD struct {
	value *AuthMethodCreateAzureAD
	isSet bool
}

func (v NullableAuthMethodCreateAzureAD) Get() *AuthMethodCreateAzureAD {
	return v.value
}

func (v *NullableAuthMethodCreateAzureAD) Set(val *AuthMethodCreateAzureAD) {
	v.value = val
	v.isSet = true
}

func (v NullableAuthMethodCreateAzureAD) IsSet() bool {
	return v.isSet
}

func (v *NullableAuthMethodCreateAzureAD) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAuthMethodCreateAzureAD(val *AuthMethodCreateAzureAD) *NullableAuthMethodCreateAzureAD {
	return &NullableAuthMethodCreateAzureAD{value: val, isSet: true}
}

func (v NullableAuthMethodCreateAzureAD) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAuthMethodCreateAzureAD) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


