/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// AliasDetails struct for AliasDetails
type AliasDetails struct {
	// Account alias
	AccountAlias string `json:"account-alias"`
	// Auth method name
	AuthMethodName string `json:"auth-method-name"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
}

// NewAliasDetails instantiates a new AliasDetails object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAliasDetails(accountAlias string, authMethodName string, ) *AliasDetails {
	this := AliasDetails{}
	this.AccountAlias = accountAlias
	this.AuthMethodName = authMethodName
	var json bool = false
	this.Json = &json
	return &this
}

// NewAliasDetailsWithDefaults instantiates a new AliasDetails object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAliasDetailsWithDefaults() *AliasDetails {
	this := AliasDetails{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetAccountAlias returns the AccountAlias field value
func (o *AliasDetails) GetAccountAlias() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.AccountAlias
}

// GetAccountAliasOk returns a tuple with the AccountAlias field value
// and a boolean to check if the value has been set.
func (o *AliasDetails) GetAccountAliasOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.AccountAlias, true
}

// SetAccountAlias sets field value
func (o *AliasDetails) SetAccountAlias(v string) {
	o.AccountAlias = v
}

// GetAuthMethodName returns the AuthMethodName field value
func (o *AliasDetails) GetAuthMethodName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.AuthMethodName
}

// GetAuthMethodNameOk returns a tuple with the AuthMethodName field value
// and a boolean to check if the value has been set.
func (o *AliasDetails) GetAuthMethodNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.AuthMethodName, true
}

// SetAuthMethodName sets field value
func (o *AliasDetails) SetAuthMethodName(v string) {
	o.AuthMethodName = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *AliasDetails) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AliasDetails) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *AliasDetails) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *AliasDetails) SetJson(v bool) {
	o.Json = &v
}

func (o AliasDetails) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["account-alias"] = o.AccountAlias
	}
	if true {
		toSerialize["auth-method-name"] = o.AuthMethodName
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	return json.Marshal(toSerialize)
}

type NullableAliasDetails struct {
	value *AliasDetails
	isSet bool
}

func (v NullableAliasDetails) Get() *AliasDetails {
	return v.value
}

func (v *NullableAliasDetails) Set(val *AliasDetails) {
	v.value = val
	v.isSet = true
}

func (v NullableAliasDetails) IsSet() bool {
	return v.isSet
}

func (v *NullableAliasDetails) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAliasDetails(val *AliasDetails) *NullableAliasDetails {
	return &NullableAliasDetails{value: val, isSet: true}
}

func (v NullableAliasDetails) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAliasDetails) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


