/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// AccountGeneralSettings AccountGeneralSettings describes general settings for an account
type AccountGeneralSettings struct {
	// AccountDefaultKeyItemID is the item ID of the DFC key item configured as the default protection key
	AccountDefaultKeyItemId *int64 `json:"account_default_key_item_id,omitempty"`
	// AccountDefaultKeyName is the name of the DFC key item configured as the default key This is here simply for the response to include the item name in addition to the display ID so the client can properly show this to the user. It will not be saved to the DB, only the AccountDefaultKeyItemID will.
	AccountDefaultKeyName *string `json:"account_default_key_name,omitempty"`
	AllowedClientsIps *AllowedIpSettings `json:"allowed_clients_ips,omitempty"`
	AllowedGatewaysIps *AllowedIpSettings `json:"allowed_gateways_ips,omitempty"`
	AuthUsageEvent *UsageEventSetting `json:"auth_usage_event,omitempty"`
	DataProtectionSection *DataProtectionSection `json:"data_protection_section,omitempty"`
	DynamicSecretMaxTtl *DynamicSecretMaxTtl `json:"dynamic_secret_max_ttl,omitempty"`
	EnableRequestForAccess *bool `json:"enable_request_for_access,omitempty"`
	// InvalidCharacters is the invalid characters for items/targets/roles/auths/notifier_forwarder naming convention
	InvalidCharacters *string `json:"invalid_characters,omitempty"`
	ItemUsageEvent *UsageEventSetting `json:"item_usage_event,omitempty"`
	// LockDefaultKey determines whether the configured default key can be updated by end-users on a per-request basis true - all requests use the configured default key false - every request can determine its protection key (default) nil - change nothing (every request can determine its protection key (default)) This parameter is only relevant if AccountDefaultKeyItemID is not empty
	LockDefaultKey *bool `json:"lock_default_key,omitempty"`
	PasswordExpirationInfo *PasswordExpirationInfo `json:"password_expiration_info,omitempty"`
	PasswordPolicy *PasswordPolicyInfo `json:"password_policy,omitempty"`
	ProtectItemsByDefault *bool `json:"protect_items_by_default,omitempty"`
	RotationSecretMaxInterval *RotationSecretMaxInterval `json:"rotation_secret_max_interval,omitempty"`
	SharingPolicy *SharingPolicyInfo `json:"sharing_policy,omitempty"`
}

// NewAccountGeneralSettings instantiates a new AccountGeneralSettings object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAccountGeneralSettings() *AccountGeneralSettings {
	this := AccountGeneralSettings{}
	return &this
}

// NewAccountGeneralSettingsWithDefaults instantiates a new AccountGeneralSettings object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAccountGeneralSettingsWithDefaults() *AccountGeneralSettings {
	this := AccountGeneralSettings{}
	return &this
}

// GetAccountDefaultKeyItemId returns the AccountDefaultKeyItemId field value if set, zero value otherwise.
func (o *AccountGeneralSettings) GetAccountDefaultKeyItemId() int64 {
	if o == nil || o.AccountDefaultKeyItemId == nil {
		var ret int64
		return ret
	}
	return *o.AccountDefaultKeyItemId
}

// GetAccountDefaultKeyItemIdOk returns a tuple with the AccountDefaultKeyItemId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccountGeneralSettings) GetAccountDefaultKeyItemIdOk() (*int64, bool) {
	if o == nil || o.AccountDefaultKeyItemId == nil {
		return nil, false
	}
	return o.AccountDefaultKeyItemId, true
}

// HasAccountDefaultKeyItemId returns a boolean if a field has been set.
func (o *AccountGeneralSettings) HasAccountDefaultKeyItemId() bool {
	if o != nil && o.AccountDefaultKeyItemId != nil {
		return true
	}

	return false
}

// SetAccountDefaultKeyItemId gets a reference to the given int64 and assigns it to the AccountDefaultKeyItemId field.
func (o *AccountGeneralSettings) SetAccountDefaultKeyItemId(v int64) {
	o.AccountDefaultKeyItemId = &v
}

// GetAccountDefaultKeyName returns the AccountDefaultKeyName field value if set, zero value otherwise.
func (o *AccountGeneralSettings) GetAccountDefaultKeyName() string {
	if o == nil || o.AccountDefaultKeyName == nil {
		var ret string
		return ret
	}
	return *o.AccountDefaultKeyName
}

// GetAccountDefaultKeyNameOk returns a tuple with the AccountDefaultKeyName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccountGeneralSettings) GetAccountDefaultKeyNameOk() (*string, bool) {
	if o == nil || o.AccountDefaultKeyName == nil {
		return nil, false
	}
	return o.AccountDefaultKeyName, true
}

// HasAccountDefaultKeyName returns a boolean if a field has been set.
func (o *AccountGeneralSettings) HasAccountDefaultKeyName() bool {
	if o != nil && o.AccountDefaultKeyName != nil {
		return true
	}

	return false
}

// SetAccountDefaultKeyName gets a reference to the given string and assigns it to the AccountDefaultKeyName field.
func (o *AccountGeneralSettings) SetAccountDefaultKeyName(v string) {
	o.AccountDefaultKeyName = &v
}

// GetAllowedClientsIps returns the AllowedClientsIps field value if set, zero value otherwise.
func (o *AccountGeneralSettings) GetAllowedClientsIps() AllowedIpSettings {
	if o == nil || o.AllowedClientsIps == nil {
		var ret AllowedIpSettings
		return ret
	}
	return *o.AllowedClientsIps
}

// GetAllowedClientsIpsOk returns a tuple with the AllowedClientsIps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccountGeneralSettings) GetAllowedClientsIpsOk() (*AllowedIpSettings, bool) {
	if o == nil || o.AllowedClientsIps == nil {
		return nil, false
	}
	return o.AllowedClientsIps, true
}

// HasAllowedClientsIps returns a boolean if a field has been set.
func (o *AccountGeneralSettings) HasAllowedClientsIps() bool {
	if o != nil && o.AllowedClientsIps != nil {
		return true
	}

	return false
}

// SetAllowedClientsIps gets a reference to the given AllowedIpSettings and assigns it to the AllowedClientsIps field.
func (o *AccountGeneralSettings) SetAllowedClientsIps(v AllowedIpSettings) {
	o.AllowedClientsIps = &v
}

// GetAllowedGatewaysIps returns the AllowedGatewaysIps field value if set, zero value otherwise.
func (o *AccountGeneralSettings) GetAllowedGatewaysIps() AllowedIpSettings {
	if o == nil || o.AllowedGatewaysIps == nil {
		var ret AllowedIpSettings
		return ret
	}
	return *o.AllowedGatewaysIps
}

// GetAllowedGatewaysIpsOk returns a tuple with the AllowedGatewaysIps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccountGeneralSettings) GetAllowedGatewaysIpsOk() (*AllowedIpSettings, bool) {
	if o == nil || o.AllowedGatewaysIps == nil {
		return nil, false
	}
	return o.AllowedGatewaysIps, true
}

// HasAllowedGatewaysIps returns a boolean if a field has been set.
func (o *AccountGeneralSettings) HasAllowedGatewaysIps() bool {
	if o != nil && o.AllowedGatewaysIps != nil {
		return true
	}

	return false
}

// SetAllowedGatewaysIps gets a reference to the given AllowedIpSettings and assigns it to the AllowedGatewaysIps field.
func (o *AccountGeneralSettings) SetAllowedGatewaysIps(v AllowedIpSettings) {
	o.AllowedGatewaysIps = &v
}

// GetAuthUsageEvent returns the AuthUsageEvent field value if set, zero value otherwise.
func (o *AccountGeneralSettings) GetAuthUsageEvent() UsageEventSetting {
	if o == nil || o.AuthUsageEvent == nil {
		var ret UsageEventSetting
		return ret
	}
	return *o.AuthUsageEvent
}

// GetAuthUsageEventOk returns a tuple with the AuthUsageEvent field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccountGeneralSettings) GetAuthUsageEventOk() (*UsageEventSetting, bool) {
	if o == nil || o.AuthUsageEvent == nil {
		return nil, false
	}
	return o.AuthUsageEvent, true
}

// HasAuthUsageEvent returns a boolean if a field has been set.
func (o *AccountGeneralSettings) HasAuthUsageEvent() bool {
	if o != nil && o.AuthUsageEvent != nil {
		return true
	}

	return false
}

// SetAuthUsageEvent gets a reference to the given UsageEventSetting and assigns it to the AuthUsageEvent field.
func (o *AccountGeneralSettings) SetAuthUsageEvent(v UsageEventSetting) {
	o.AuthUsageEvent = &v
}

// GetDataProtectionSection returns the DataProtectionSection field value if set, zero value otherwise.
func (o *AccountGeneralSettings) GetDataProtectionSection() DataProtectionSection {
	if o == nil || o.DataProtectionSection == nil {
		var ret DataProtectionSection
		return ret
	}
	return *o.DataProtectionSection
}

// GetDataProtectionSectionOk returns a tuple with the DataProtectionSection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccountGeneralSettings) GetDataProtectionSectionOk() (*DataProtectionSection, bool) {
	if o == nil || o.DataProtectionSection == nil {
		return nil, false
	}
	return o.DataProtectionSection, true
}

// HasDataProtectionSection returns a boolean if a field has been set.
func (o *AccountGeneralSettings) HasDataProtectionSection() bool {
	if o != nil && o.DataProtectionSection != nil {
		return true
	}

	return false
}

// SetDataProtectionSection gets a reference to the given DataProtectionSection and assigns it to the DataProtectionSection field.
func (o *AccountGeneralSettings) SetDataProtectionSection(v DataProtectionSection) {
	o.DataProtectionSection = &v
}

// GetDynamicSecretMaxTtl returns the DynamicSecretMaxTtl field value if set, zero value otherwise.
func (o *AccountGeneralSettings) GetDynamicSecretMaxTtl() DynamicSecretMaxTtl {
	if o == nil || o.DynamicSecretMaxTtl == nil {
		var ret DynamicSecretMaxTtl
		return ret
	}
	return *o.DynamicSecretMaxTtl
}

// GetDynamicSecretMaxTtlOk returns a tuple with the DynamicSecretMaxTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccountGeneralSettings) GetDynamicSecretMaxTtlOk() (*DynamicSecretMaxTtl, bool) {
	if o == nil || o.DynamicSecretMaxTtl == nil {
		return nil, false
	}
	return o.DynamicSecretMaxTtl, true
}

// HasDynamicSecretMaxTtl returns a boolean if a field has been set.
func (o *AccountGeneralSettings) HasDynamicSecretMaxTtl() bool {
	if o != nil && o.DynamicSecretMaxTtl != nil {
		return true
	}

	return false
}

// SetDynamicSecretMaxTtl gets a reference to the given DynamicSecretMaxTtl and assigns it to the DynamicSecretMaxTtl field.
func (o *AccountGeneralSettings) SetDynamicSecretMaxTtl(v DynamicSecretMaxTtl) {
	o.DynamicSecretMaxTtl = &v
}

// GetEnableRequestForAccess returns the EnableRequestForAccess field value if set, zero value otherwise.
func (o *AccountGeneralSettings) GetEnableRequestForAccess() bool {
	if o == nil || o.EnableRequestForAccess == nil {
		var ret bool
		return ret
	}
	return *o.EnableRequestForAccess
}

// GetEnableRequestForAccessOk returns a tuple with the EnableRequestForAccess field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccountGeneralSettings) GetEnableRequestForAccessOk() (*bool, bool) {
	if o == nil || o.EnableRequestForAccess == nil {
		return nil, false
	}
	return o.EnableRequestForAccess, true
}

// HasEnableRequestForAccess returns a boolean if a field has been set.
func (o *AccountGeneralSettings) HasEnableRequestForAccess() bool {
	if o != nil && o.EnableRequestForAccess != nil {
		return true
	}

	return false
}

// SetEnableRequestForAccess gets a reference to the given bool and assigns it to the EnableRequestForAccess field.
func (o *AccountGeneralSettings) SetEnableRequestForAccess(v bool) {
	o.EnableRequestForAccess = &v
}

// GetInvalidCharacters returns the InvalidCharacters field value if set, zero value otherwise.
func (o *AccountGeneralSettings) GetInvalidCharacters() string {
	if o == nil || o.InvalidCharacters == nil {
		var ret string
		return ret
	}
	return *o.InvalidCharacters
}

// GetInvalidCharactersOk returns a tuple with the InvalidCharacters field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccountGeneralSettings) GetInvalidCharactersOk() (*string, bool) {
	if o == nil || o.InvalidCharacters == nil {
		return nil, false
	}
	return o.InvalidCharacters, true
}

// HasInvalidCharacters returns a boolean if a field has been set.
func (o *AccountGeneralSettings) HasInvalidCharacters() bool {
	if o != nil && o.InvalidCharacters != nil {
		return true
	}

	return false
}

// SetInvalidCharacters gets a reference to the given string and assigns it to the InvalidCharacters field.
func (o *AccountGeneralSettings) SetInvalidCharacters(v string) {
	o.InvalidCharacters = &v
}

// GetItemUsageEvent returns the ItemUsageEvent field value if set, zero value otherwise.
func (o *AccountGeneralSettings) GetItemUsageEvent() UsageEventSetting {
	if o == nil || o.ItemUsageEvent == nil {
		var ret UsageEventSetting
		return ret
	}
	return *o.ItemUsageEvent
}

// GetItemUsageEventOk returns a tuple with the ItemUsageEvent field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccountGeneralSettings) GetItemUsageEventOk() (*UsageEventSetting, bool) {
	if o == nil || o.ItemUsageEvent == nil {
		return nil, false
	}
	return o.ItemUsageEvent, true
}

// HasItemUsageEvent returns a boolean if a field has been set.
func (o *AccountGeneralSettings) HasItemUsageEvent() bool {
	if o != nil && o.ItemUsageEvent != nil {
		return true
	}

	return false
}

// SetItemUsageEvent gets a reference to the given UsageEventSetting and assigns it to the ItemUsageEvent field.
func (o *AccountGeneralSettings) SetItemUsageEvent(v UsageEventSetting) {
	o.ItemUsageEvent = &v
}

// GetLockDefaultKey returns the LockDefaultKey field value if set, zero value otherwise.
func (o *AccountGeneralSettings) GetLockDefaultKey() bool {
	if o == nil || o.LockDefaultKey == nil {
		var ret bool
		return ret
	}
	return *o.LockDefaultKey
}

// GetLockDefaultKeyOk returns a tuple with the LockDefaultKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccountGeneralSettings) GetLockDefaultKeyOk() (*bool, bool) {
	if o == nil || o.LockDefaultKey == nil {
		return nil, false
	}
	return o.LockDefaultKey, true
}

// HasLockDefaultKey returns a boolean if a field has been set.
func (o *AccountGeneralSettings) HasLockDefaultKey() bool {
	if o != nil && o.LockDefaultKey != nil {
		return true
	}

	return false
}

// SetLockDefaultKey gets a reference to the given bool and assigns it to the LockDefaultKey field.
func (o *AccountGeneralSettings) SetLockDefaultKey(v bool) {
	o.LockDefaultKey = &v
}

// GetPasswordExpirationInfo returns the PasswordExpirationInfo field value if set, zero value otherwise.
func (o *AccountGeneralSettings) GetPasswordExpirationInfo() PasswordExpirationInfo {
	if o == nil || o.PasswordExpirationInfo == nil {
		var ret PasswordExpirationInfo
		return ret
	}
	return *o.PasswordExpirationInfo
}

// GetPasswordExpirationInfoOk returns a tuple with the PasswordExpirationInfo field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccountGeneralSettings) GetPasswordExpirationInfoOk() (*PasswordExpirationInfo, bool) {
	if o == nil || o.PasswordExpirationInfo == nil {
		return nil, false
	}
	return o.PasswordExpirationInfo, true
}

// HasPasswordExpirationInfo returns a boolean if a field has been set.
func (o *AccountGeneralSettings) HasPasswordExpirationInfo() bool {
	if o != nil && o.PasswordExpirationInfo != nil {
		return true
	}

	return false
}

// SetPasswordExpirationInfo gets a reference to the given PasswordExpirationInfo and assigns it to the PasswordExpirationInfo field.
func (o *AccountGeneralSettings) SetPasswordExpirationInfo(v PasswordExpirationInfo) {
	o.PasswordExpirationInfo = &v
}

// GetPasswordPolicy returns the PasswordPolicy field value if set, zero value otherwise.
func (o *AccountGeneralSettings) GetPasswordPolicy() PasswordPolicyInfo {
	if o == nil || o.PasswordPolicy == nil {
		var ret PasswordPolicyInfo
		return ret
	}
	return *o.PasswordPolicy
}

// GetPasswordPolicyOk returns a tuple with the PasswordPolicy field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccountGeneralSettings) GetPasswordPolicyOk() (*PasswordPolicyInfo, bool) {
	if o == nil || o.PasswordPolicy == nil {
		return nil, false
	}
	return o.PasswordPolicy, true
}

// HasPasswordPolicy returns a boolean if a field has been set.
func (o *AccountGeneralSettings) HasPasswordPolicy() bool {
	if o != nil && o.PasswordPolicy != nil {
		return true
	}

	return false
}

// SetPasswordPolicy gets a reference to the given PasswordPolicyInfo and assigns it to the PasswordPolicy field.
func (o *AccountGeneralSettings) SetPasswordPolicy(v PasswordPolicyInfo) {
	o.PasswordPolicy = &v
}

// GetProtectItemsByDefault returns the ProtectItemsByDefault field value if set, zero value otherwise.
func (o *AccountGeneralSettings) GetProtectItemsByDefault() bool {
	if o == nil || o.ProtectItemsByDefault == nil {
		var ret bool
		return ret
	}
	return *o.ProtectItemsByDefault
}

// GetProtectItemsByDefaultOk returns a tuple with the ProtectItemsByDefault field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccountGeneralSettings) GetProtectItemsByDefaultOk() (*bool, bool) {
	if o == nil || o.ProtectItemsByDefault == nil {
		return nil, false
	}
	return o.ProtectItemsByDefault, true
}

// HasProtectItemsByDefault returns a boolean if a field has been set.
func (o *AccountGeneralSettings) HasProtectItemsByDefault() bool {
	if o != nil && o.ProtectItemsByDefault != nil {
		return true
	}

	return false
}

// SetProtectItemsByDefault gets a reference to the given bool and assigns it to the ProtectItemsByDefault field.
func (o *AccountGeneralSettings) SetProtectItemsByDefault(v bool) {
	o.ProtectItemsByDefault = &v
}

// GetRotationSecretMaxInterval returns the RotationSecretMaxInterval field value if set, zero value otherwise.
func (o *AccountGeneralSettings) GetRotationSecretMaxInterval() RotationSecretMaxInterval {
	if o == nil || o.RotationSecretMaxInterval == nil {
		var ret RotationSecretMaxInterval
		return ret
	}
	return *o.RotationSecretMaxInterval
}

// GetRotationSecretMaxIntervalOk returns a tuple with the RotationSecretMaxInterval field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccountGeneralSettings) GetRotationSecretMaxIntervalOk() (*RotationSecretMaxInterval, bool) {
	if o == nil || o.RotationSecretMaxInterval == nil {
		return nil, false
	}
	return o.RotationSecretMaxInterval, true
}

// HasRotationSecretMaxInterval returns a boolean if a field has been set.
func (o *AccountGeneralSettings) HasRotationSecretMaxInterval() bool {
	if o != nil && o.RotationSecretMaxInterval != nil {
		return true
	}

	return false
}

// SetRotationSecretMaxInterval gets a reference to the given RotationSecretMaxInterval and assigns it to the RotationSecretMaxInterval field.
func (o *AccountGeneralSettings) SetRotationSecretMaxInterval(v RotationSecretMaxInterval) {
	o.RotationSecretMaxInterval = &v
}

// GetSharingPolicy returns the SharingPolicy field value if set, zero value otherwise.
func (o *AccountGeneralSettings) GetSharingPolicy() SharingPolicyInfo {
	if o == nil || o.SharingPolicy == nil {
		var ret SharingPolicyInfo
		return ret
	}
	return *o.SharingPolicy
}

// GetSharingPolicyOk returns a tuple with the SharingPolicy field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AccountGeneralSettings) GetSharingPolicyOk() (*SharingPolicyInfo, bool) {
	if o == nil || o.SharingPolicy == nil {
		return nil, false
	}
	return o.SharingPolicy, true
}

// HasSharingPolicy returns a boolean if a field has been set.
func (o *AccountGeneralSettings) HasSharingPolicy() bool {
	if o != nil && o.SharingPolicy != nil {
		return true
	}

	return false
}

// SetSharingPolicy gets a reference to the given SharingPolicyInfo and assigns it to the SharingPolicy field.
func (o *AccountGeneralSettings) SetSharingPolicy(v SharingPolicyInfo) {
	o.SharingPolicy = &v
}

func (o AccountGeneralSettings) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AccountDefaultKeyItemId != nil {
		toSerialize["account_default_key_item_id"] = o.AccountDefaultKeyItemId
	}
	if o.AccountDefaultKeyName != nil {
		toSerialize["account_default_key_name"] = o.AccountDefaultKeyName
	}
	if o.AllowedClientsIps != nil {
		toSerialize["allowed_clients_ips"] = o.AllowedClientsIps
	}
	if o.AllowedGatewaysIps != nil {
		toSerialize["allowed_gateways_ips"] = o.AllowedGatewaysIps
	}
	if o.AuthUsageEvent != nil {
		toSerialize["auth_usage_event"] = o.AuthUsageEvent
	}
	if o.DataProtectionSection != nil {
		toSerialize["data_protection_section"] = o.DataProtectionSection
	}
	if o.DynamicSecretMaxTtl != nil {
		toSerialize["dynamic_secret_max_ttl"] = o.DynamicSecretMaxTtl
	}
	if o.EnableRequestForAccess != nil {
		toSerialize["enable_request_for_access"] = o.EnableRequestForAccess
	}
	if o.InvalidCharacters != nil {
		toSerialize["invalid_characters"] = o.InvalidCharacters
	}
	if o.ItemUsageEvent != nil {
		toSerialize["item_usage_event"] = o.ItemUsageEvent
	}
	if o.LockDefaultKey != nil {
		toSerialize["lock_default_key"] = o.LockDefaultKey
	}
	if o.PasswordExpirationInfo != nil {
		toSerialize["password_expiration_info"] = o.PasswordExpirationInfo
	}
	if o.PasswordPolicy != nil {
		toSerialize["password_policy"] = o.PasswordPolicy
	}
	if o.ProtectItemsByDefault != nil {
		toSerialize["protect_items_by_default"] = o.ProtectItemsByDefault
	}
	if o.RotationSecretMaxInterval != nil {
		toSerialize["rotation_secret_max_interval"] = o.RotationSecretMaxInterval
	}
	if o.SharingPolicy != nil {
		toSerialize["sharing_policy"] = o.SharingPolicy
	}
	return json.Marshal(toSerialize)
}

type NullableAccountGeneralSettings struct {
	value *AccountGeneralSettings
	isSet bool
}

func (v NullableAccountGeneralSettings) Get() *AccountGeneralSettings {
	return v.value
}

func (v *NullableAccountGeneralSettings) Set(val *AccountGeneralSettings) {
	v.value = val
	v.isSet = true
}

func (v NullableAccountGeneralSettings) IsSet() bool {
	return v.isSet
}

func (v *NullableAccountGeneralSettings) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAccountGeneralSettings(val *AccountGeneralSettings) *NullableAccountGeneralSettings {
	return &NullableAccountGeneralSettings{value: val, isSet: true}
}

func (v NullableAccountGeneralSettings) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAccountGeneralSettings) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


