%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM2":  ["0x4142434465666768", "0x5152535455565758", "0x0000000000000000", "0x0000000000000000"],
    "XMM3":  ["0x4142434461626364", "0x5152535455565758", "0x0000000000000000", "0x0000000000000000"],
    "XMM4":  ["0x7576777845464748", "0x5152535455565758", "0x0000000000000000", "0x0000000000000000"],
    "XMM5":  ["0x4142434445464748", "0x5152535471727374", "0x0000000000000000", "0x0000000000000000"],
    "XMM6":  ["0x4142434445464748", "0x7576777855565758", "0x0000000000000000", "0x0000000000000000"],
    "XMM7":  ["0x4142434445464748", "0x5152535475767778", "0x0000000000000000", "0x0000000000000000"],
    "XMM8":  ["0x7576777845464748", "0x5152535455565758", "0x0000000000000000", "0x0000000000000000"],
    "XMM9":  ["0x4142434475767778", "0x5152535455565758", "0x0000000000000000", "0x0000000000000000"],
    "XMM10": ["0x0000000065666768", "0x5152535455565758", "0x0000000000000000", "0x0000000000000000"],
    "XMM11": ["0x0000000061626364", "0x5152535455565758", "0x0000000000000000", "0x0000000000000000"],
    "XMM12": ["0x0000000000000000", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM13": ["0x0000000000000000", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd xmm0, [rdx]
vmovapd xmm1, [rdx + 16]

; Simple move Reg<-Reg
vinsertps xmm2, xmm0, xmm1, ((0b00 << 6) | (0b00 << 4) | (0b0000))
vinsertps xmm3, xmm0, xmm1, ((0b01 << 6) | (0b00 << 4) | (0b0000))
vinsertps xmm4, xmm0, xmm1, ((0b10 << 6) | (0b01 << 4) | (0b0000))
vinsertps xmm5, xmm0, xmm1, ((0b11 << 6) | (0b10 << 4) | (0b0000))

; Simple move Reg<-Mem
vinsertps xmm6, xmm0, [rdx + 8 * 3], ((0b00 << 6) | (0b11 << 4) | (0b0000))
vinsertps xmm7, xmm0, [rdx + 8 * 3], ((0b01 << 6) | (0b10 << 4) | (0b0000))
vinsertps xmm8, xmm0, [rdx + 8 * 3], ((0b10 << 6) | (0b01 << 4) | (0b0000))
vinsertps xmm9, xmm0, [rdx + 8 * 3], ((0b11 << 6) | (0b00 << 4) | (0b0000))

; Simple move Reg<-Reg with mask
vinsertps xmm10, xmm0, xmm1, ((0b00 << 6) | (0b00 << 4) | (0b0010))
vinsertps xmm11, xmm0, xmm1, ((0b01 << 6) | (0b00 << 4) | (0b0010))

; Full ZMask
vinsertps xmm12, xmm0, xmm1, ((0b00 << 6) | (0b00 << 4) | (0b1111))

; Full ZMask, with garbage in the upper bits
vmovapd ymm13, [rel .data_bad]
vinsertps xmm13, xmm0, xmm1, ((0b00 << 6) | (0b00 << 4) | (0b1111))

hlt

align 32
.data:
dq 0x4142434445464748
dq 0x5152535455565758

dq 0x6162636465666768
dq 0x7172737475767778

.data_bad:
dq 0x1111111122222222
dq 0x3333333344444444
dq 0x5555555566666666
dq 0x7777777788888888
