/*  This file is part of FreeDoko.
    FreeDoko is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version (see <http://www.gnu.org/licenses/>).

    Diese Datei ist Teil von FreeDoko.
    FreeDoko ist Freie Software: Sie können es unter den Bedingungen der GNU General Public License, wie von der Free Software Foundation, Version 3 der Lizenz oder (nach Ihrer Wahl) jeder neueren veröffentlichten Version, weiter verteilen und/oder modifizieren (siehe <https://www.gnu.org/licenses/>).
    */

#pragma once

#include "constants.h"

#include "rating.h"

/**
 ** linear rater
 ** Returns the linear value calculated by the given values.
 ** 2/(n*(n+1)) * \\Sum_i=1^n i * value[i]
 **/
class Rating::Linear : public Rating {
  public:
    Linear() : Rating(Type::linear) { }
    ~Linear() override = default;

    auto value() const -> int override
    {
      if (this->values.empty())
	return INT_MIN;
      this->sort();
      int const size = this->values.size();
      int v = 0;
      for (int i = 0; i < size; ++i) {
	v += (i + 1) * this->values[i];
      }
      return v / ((size * (size + 1)) / 2);
    }
}; // class Rating::Linear : public Rating
