/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.vmd;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.vmd.VMDColorScheme;
import org.netbeans.api.visual.vmd.VMDFactory;
import org.netbeans.api.visual.widget.Widget;

public class VMDNodeAnchor
extends Anchor {
    private boolean requiresRecalculation = true;
    private HashMap<Anchor.Entry, Anchor.Result> results = new HashMap();
    private final boolean vertical;
    private VMDColorScheme scheme;

    public VMDNodeAnchor(Widget widget) {
        this(widget, true);
    }

    public VMDNodeAnchor(Widget widget, boolean bl) {
        this(widget, bl, VMDFactory.getOriginalScheme());
    }

    public VMDNodeAnchor(Widget widget, boolean bl, VMDColorScheme vMDColorScheme) {
        super(widget);
        assert (widget != null);
        assert (vMDColorScheme != null);
        this.vertical = bl;
        this.scheme = vMDColorScheme;
    }

    @Override
    protected void notifyEntryAdded(Anchor.Entry entry) {
        this.requiresRecalculation = true;
    }

    @Override
    protected void notifyEntryRemoved(Anchor.Entry entry) {
        this.results.remove(entry);
        this.requiresRecalculation = true;
    }

    @Override
    protected void notifyRevalidate() {
        this.requiresRecalculation = true;
    }

    private void recalculate() {
        Anchor.Entry entry;
        int n;
        int n2;
        int n3;
        if (!this.requiresRecalculation) {
            return;
        }
        Widget widget = this.getRelatedWidget();
        Point point = this.getRelatedSceneLocation();
        Rectangle rectangle = widget.convertLocalToScene(widget.getBounds());
        HashMap<Anchor.Entry, Float> hashMap = new HashMap<Anchor.Entry, Float>();
        HashMap<Anchor.Entry, Float> hashMap2 = new HashMap<Anchor.Entry, Float>();
        for (Anchor.Entry entryArray2 : this.getEntries()) {
            Point n4 = this.getOppositeSceneLocation(entryArray2);
            if (n4 == null || point == null) {
                this.results.put(entryArray2, (Anchor)this.new Anchor.Result(new Point(rectangle.x, rectangle.y), DIRECTION_ANY));
                continue;
            }
            n3 = n4.y - point.y;
            n2 = n4.x - point.x;
            if (this.vertical) {
                if (n3 > 0) {
                    hashMap2.put(entryArray2, Float.valueOf((float)n2 / (float)n3));
                    continue;
                }
                if (n3 < 0) {
                    hashMap.put(entryArray2, Float.valueOf((float)(-n2) / (float)n3));
                    continue;
                }
                hashMap.put(entryArray2, Float.valueOf(n2 < 0 ? Float.MAX_VALUE : Float.MIN_VALUE));
                continue;
            }
            if (n2 > 0) {
                hashMap2.put(entryArray2, Float.valueOf((float)n3 / (float)n2));
                continue;
            }
            if (n3 < 0) {
                hashMap.put(entryArray2, Float.valueOf((float)(-n3) / (float)n2));
                continue;
            }
            hashMap.put(entryArray2, Float.valueOf(n3 < 0 ? Float.MAX_VALUE : Float.MIN_VALUE));
        }
        Anchor.Entry[] entryArray3 = this.toArray(hashMap);
        Anchor.Entry[] entryArray = this.toArray(hashMap2);
        int n4 = this.scheme.getNodeAnchorGap(this);
        n3 = rectangle.y - n4;
        n2 = rectangle.x - n4;
        int n5 = entryArray3.length;
        for (n = 0; n < n5; ++n) {
            entry = entryArray3[n];
            if (this.vertical) {
                n2 = rectangle.x + (n + 1) * rectangle.width / (n5 + 1);
            } else {
                n3 = rectangle.y + (n + 1) * rectangle.height / (n5 + 1);
            }
            this.results.put(entry, (Anchor)this.new Anchor.Result(new Point(n2, n3), this.vertical ? Anchor.Direction.TOP : Anchor.Direction.LEFT));
        }
        n3 = rectangle.y + rectangle.height + n4;
        n2 = rectangle.x + rectangle.width + n4;
        n5 = entryArray.length;
        for (n = 0; n < n5; ++n) {
            entry = entryArray[n];
            if (this.vertical) {
                n2 = rectangle.x + (n + 1) * rectangle.width / (n5 + 1);
            } else {
                n3 = rectangle.y + (n + 1) * rectangle.height / (n5 + 1);
            }
            this.results.put(entry, (Anchor)this.new Anchor.Result(new Point(n2, n3), this.vertical ? Anchor.Direction.BOTTOM : Anchor.Direction.RIGHT));
        }
        this.requiresRecalculation = false;
    }

    private Anchor.Entry[] toArray(final HashMap<Anchor.Entry, Float> hashMap) {
        Set<Anchor.Entry> set = hashMap.keySet();
        Anchor.Entry[] entryArray = set.toArray(new Anchor.Entry[0]);
        Arrays.sort(entryArray, new Comparator<Anchor.Entry>(){

            @Override
            public int compare(Anchor.Entry entry, Anchor.Entry entry2) {
                float f = ((Float)hashMap.get(entry)).floatValue() - ((Float)hashMap.get(entry2)).floatValue();
                if (f > 0.0f) {
                    return 1;
                }
                if (f < 0.0f) {
                    return -1;
                }
                return 0;
            }
        });
        return entryArray;
    }

    @Override
    public Anchor.Result compute(Anchor.Entry entry) {
        this.recalculate();
        return this.results.get(entry);
    }
}

