/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Objects;
import java.util.Random;
import sun.net.PortConfig;

class DNSDatagramSocketFactory {
    static final int DEVIATION = 3;
    static final int THRESHOLD = 6;
    static final int BIT_DEVIATION = 2;
    static final int HISTORY = 32;
    static final int MAX_RANDOM_TRIES = 5;
    int lastport;
    int lastSystemAllocated;
    int suitablePortCount;
    int unsuitablePortCount;
    final ProtocolFamily family;
    final int thresholdCount;
    final int deviation;
    final Random random;
    final PortHistory history;

    private static int findFirstFreePort() {
        int n;
        PrivilegedExceptionAction<DatagramSocket> privilegedExceptionAction = () -> new DatagramSocket(0);
        try {
            DatagramSocket datagramSocket;
            try (DatagramSocket datagramSocket2 = datagramSocket = AccessController.doPrivileged(privilegedExceptionAction);){
                n = datagramSocket2.getLocalPort();
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    DNSDatagramSocketFactory() {
        this(new Random());
    }

    DNSDatagramSocketFactory(Random random) {
        this(Objects.requireNonNull(random), null, 3, 6);
    }

    DNSDatagramSocketFactory(Random random, ProtocolFamily protocolFamily, int n, int n2) {
        this.lastSystemAllocated = this.lastport = DNSDatagramSocketFactory.findFirstFreePort();
        this.random = Objects.requireNonNull(random);
        this.history = new PortHistory(32, random);
        this.family = protocolFamily;
        this.deviation = Math.max(1, n);
        this.thresholdCount = Math.max(2, n2);
    }

    public synchronized DatagramSocket open() throws SocketException {
        boolean bl;
        DatagramSocket datagramSocket;
        boolean bl2;
        int n = this.lastport;
        boolean bl3 = bl2 = this.unsuitablePortCount > this.thresholdCount;
        if (bl2) {
            datagramSocket = this.openRandom();
            if (datagramSocket != null) {
                return datagramSocket;
            }
            this.unsuitablePortCount = 0;
            this.suitablePortCount = 0;
            n = 0;
        }
        datagramSocket = this.openDefault();
        this.lastport = datagramSocket.getLocalPort();
        if (n == 0) {
            this.lastSystemAllocated = this.lastport;
            this.history.offer(this.lastport);
            return datagramSocket;
        }
        bl2 = this.suitablePortCount > this.thresholdCount;
        boolean bl4 = this.farEnough(n);
        if (bl4 && this.lastSystemAllocated > 0) {
            bl4 = this.farEnough(this.lastSystemAllocated);
        }
        boolean bl5 = this.history.contains(this.lastport);
        boolean bl6 = bl = bl2 || bl4 && !bl5;
        if (bl && !bl5) {
            this.history.add(this.lastport);
        }
        if (bl) {
            if (!bl2) {
                ++this.suitablePortCount;
            } else if (!bl4 || bl5) {
                this.unsuitablePortCount = 1;
                this.suitablePortCount = this.thresholdCount / 2;
            }
            this.lastSystemAllocated = this.lastport;
            return datagramSocket;
        }
        assert (!bl2);
        DatagramSocket datagramSocket2 = this.openRandom();
        if (datagramSocket2 == null) {
            return datagramSocket;
        }
        ++this.unsuitablePortCount;
        datagramSocket.close();
        return datagramSocket2;
    }

    private DatagramSocket openDefault() throws SocketException {
        if (this.family != null) {
            try {
                DatagramChannel datagramChannel = DatagramChannel.open(this.family);
                try {
                    DatagramSocket datagramSocket = datagramChannel.socket();
                    datagramSocket.bind(null);
                    return datagramSocket;
                }
                catch (Throwable throwable) {
                    datagramChannel.close();
                    throw throwable;
                }
            }
            catch (SocketException socketException) {
                throw socketException;
            }
            catch (IOException iOException) {
                SocketException socketException = new SocketException(iOException.getMessage());
                socketException.initCause(iOException);
                throw socketException;
            }
        }
        return new DatagramSocket();
    }

    synchronized boolean isUsingNativePortRandomization() {
        return this.unsuitablePortCount <= this.thresholdCount && this.suitablePortCount > this.thresholdCount;
    }

    synchronized boolean isUsingJavaPortRandomization() {
        return this.unsuitablePortCount > this.thresholdCount;
    }

    synchronized boolean isUndecided() {
        return !this.isUsingJavaPortRandomization() && !this.isUsingNativePortRandomization();
    }

    private boolean farEnough(int n) {
        return Integer.bitCount(n ^ this.lastport) > 2 && Math.abs(n - this.lastport) > this.deviation;
    }

    private DatagramSocket openRandom() {
        int n = 5;
        while (n-- > 0) {
            boolean bl;
            int n2;
            boolean bl2;
            int n3 = 5;
            do {
                n2 = EphemeralPortRange.LOWER + this.random.nextInt(EphemeralPortRange.RANGE);
                bl = this.history.contains(n2);
                boolean bl3 = bl2 = this.lastport == 0 || this.farEnough(n2) && !bl;
            } while (n3-- > 0 && !bl2);
            if (!bl2) continue;
            try {
                if (this.family != null) {
                    DatagramChannel datagramChannel = DatagramChannel.open(this.family);
                    try {
                        DatagramSocket datagramSocket = datagramChannel.socket();
                        datagramSocket.bind(new InetSocketAddress(n2));
                        this.lastport = datagramSocket.getLocalPort();
                        if (!bl) {
                            this.history.add(n2);
                        }
                        return datagramSocket;
                    }
                    catch (Throwable throwable) {
                        datagramChannel.close();
                        throw throwable;
                    }
                }
                DatagramSocket datagramSocket = new DatagramSocket(n2);
                this.lastport = datagramSocket.getLocalPort();
                if (!bl) {
                    this.history.add(n2);
                }
                return datagramSocket;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    static final class PortHistory {
        final int capacity;
        final int[] ports;
        final Random random;
        int index;

        PortHistory(int n, Random random) {
            this.random = random;
            this.capacity = n;
            this.ports = new int[n];
        }

        public boolean contains(int n) {
            int n2 = 0;
            for (int i = 0; i < this.capacity && (n2 = this.ports[i]) != 0 && n2 != n; ++i) {
            }
            return n2 == n;
        }

        public boolean add(int n) {
            if (this.ports[this.index] != 0) {
                int n2 = this.random.nextInt(this.capacity);
                if ((n2 + 1) % this.capacity == this.index) {
                    n2 = this.index;
                }
                this.index = n2;
                this.ports[this.index] = n;
            } else {
                this.ports[this.index] = n;
            }
            if (++this.index == this.capacity) {
                this.index = 0;
            }
            return true;
        }

        public boolean offer(int n) {
            if (this.contains(n)) {
                return false;
            }
            return this.add(n);
        }
    }

    static final class EphemeralPortRange {
        static final int LOWER = PortConfig.getLower();
        static final int UPPER = PortConfig.getUpper();
        static final int RANGE = UPPER - LOWER + 1;

        private EphemeralPortRange() {
        }
    }
}

