/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.settings;

import java.util.Objects;
import java.util.Set;
import jdk.jfr.Description;
import jdk.jfr.Label;
import jdk.jfr.MetadataDefinition;
import jdk.jfr.Name;
import jdk.jfr.Timespan;
import jdk.jfr.internal.Control;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;

@MetadataDefinition
@Label(value="Cutoff")
@Description(value="Limit running time of event")
@Name(value="jdk.settings.Cutoff")
@Timespan
public final class CutoffSetting
extends Control {
    private static final long typeId = Type.getTypeId(CutoffSetting.class);
    private String value = "0 ns";
    private final PlatformEventType eventType;

    public CutoffSetting(PlatformEventType platformEventType, String string) {
        super(string);
        this.eventType = Objects.requireNonNull(platformEventType);
    }

    @Override
    public String combine(Set<String> set) {
        long l = 0L;
        String string = "0 ns";
        for (String string2 : set) {
            long l2 = Utils.parseTimespanWithInfinity(string2);
            if (l2 <= l) continue;
            string = string2;
            l = l2;
        }
        return string;
    }

    @Override
    public void setValue(String string) {
        long l = Utils.parseTimespanWithInfinity(string);
        this.value = string;
        this.eventType.setCutoff(l);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public static boolean isType(long l) {
        return typeId == l;
    }

    public static long parseValueSafe(String string) {
        if (string == null) {
            return 0L;
        }
        try {
            return Utils.parseTimespanWithInfinity(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }
}

