/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Set;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.RepositoryChunk;
import jdk.jfr.internal.SecuritySupport;

public final class Repository {
    private static final int MAX_REPO_CREATION_RETRIES = 1000;
    private static final JVM jvm = JVM.getJVM();
    private static final Repository instance = new Repository();
    public static final DateTimeFormatter REPO_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm_ss");
    private final Set<SecuritySupport.SafePath> cleanupDirectories = new HashSet<SecuritySupport.SafePath>();
    private SecuritySupport.SafePath baseLocation;
    private SecuritySupport.SafePath repository;

    private Repository() {
    }

    public static Repository getRepository() {
        return instance;
    }

    public synchronized void setBasePath(SecuritySupport.SafePath safePath) throws Exception {
        this.repository = Repository.createRepository(safePath);
        try {
            SecuritySupport.delete(this.repository);
        }
        catch (IOException iOException) {
            Logger.log(LogTag.JFR, LogLevel.INFO, "Could not delete disk repository " + this.repository);
        }
        this.baseLocation = safePath;
    }

    synchronized void ensureRepository() throws Exception {
        if (this.baseLocation == null) {
            this.setBasePath(SecuritySupport.JAVA_IO_TMPDIR);
        }
    }

    synchronized RepositoryChunk newChunk(Instant instant) {
        try {
            if (!SecuritySupport.existDirectory(this.repository)) {
                this.repository = Repository.createRepository(this.baseLocation);
                jvm.setRepositoryLocation(this.repository.toString());
                this.cleanupDirectories.add(this.repository);
            }
            return new RepositoryChunk(this.repository, instant);
        }
        catch (Exception exception) {
            String string = String.format("Could not create chunk in repository %s, %s", this.repository, exception.getMessage());
            Logger.log(LogTag.JFR, LogLevel.ERROR, string);
            jvm.abort(string);
            throw new InternalError("Could not abort after JFR disk creation error");
        }
    }

    private static SecuritySupport.SafePath createRepository(SecuritySupport.SafePath safePath) throws Exception {
        int n;
        String string;
        SecuritySupport.SafePath safePath2 = Repository.createRealBasePath(safePath);
        SecuritySupport.SafePath safePath3 = null;
        String string2 = string = REPO_DATE_FORMAT.format(LocalDateTime.now()) + "_" + JVM.getJVM().getPid();
        for (n = 0; n < 1000 && !Repository.tryToUseAsRepository(safePath3 = new SecuritySupport.SafePath(safePath2.toPath().resolve(string2))); ++n) {
            string2 = string + "_" + n;
        }
        if (n == 1000) {
            throw new Exception("Unable to create JFR repository directory using base location (" + safePath + ")");
        }
        SecuritySupport.SafePath safePath4 = SecuritySupport.toRealPath(safePath3);
        return safePath4;
    }

    private static SecuritySupport.SafePath createRealBasePath(SecuritySupport.SafePath safePath) throws Exception {
        if (SecuritySupport.exists(safePath)) {
            if (!SecuritySupport.isWritable(safePath)) {
                throw new IOException("JFR repository directory (" + safePath.toString() + ") exists, but isn't writable");
            }
            return SecuritySupport.toRealPath(safePath);
        }
        SecuritySupport.SafePath safePath2 = SecuritySupport.createDirectories(safePath);
        return SecuritySupport.toRealPath(safePath2);
    }

    private static boolean tryToUseAsRepository(SecuritySupport.SafePath safePath) {
        Path path = safePath.toPath().getParent();
        if (path == null) {
            return false;
        }
        try {
            try {
                SecuritySupport.createDirectories(safePath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!SecuritySupport.exists(safePath)) {
                return false;
            }
            return SecuritySupport.isDirectory(safePath);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    synchronized void clear() {
        for (SecuritySupport.SafePath safePath : this.cleanupDirectories) {
            try {
                SecuritySupport.clearDirectory(safePath);
                Logger.log(LogTag.JFR, LogLevel.INFO, "Removed repository " + safePath);
            }
            catch (IOException iOException) {
                Logger.log(LogTag.JFR, LogLevel.ERROR, "Repository " + safePath + " could not be removed at shutdown: " + iOException.getMessage());
            }
        }
    }

    public synchronized SecuritySupport.SafePath getRepositoryPath() {
        return this.repository;
    }
}

