/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdk.jfr.internal.RepositoryChunk;
import jdk.jfr.internal.SecuritySupport;

final class ChunkInputStream
extends InputStream {
    private final Iterator<RepositoryChunk> chunks;
    private RepositoryChunk currentChunk;
    private InputStream stream;

    ChunkInputStream(List<RepositoryChunk> list) throws IOException {
        ArrayList<RepositoryChunk> arrayList = new ArrayList<RepositoryChunk>(list.size());
        for (RepositoryChunk repositoryChunk : list) {
            repositoryChunk.use();
            arrayList.add(repositoryChunk);
        }
        this.chunks = arrayList.iterator();
        this.nextStream();
    }

    @Override
    public int available() throws IOException {
        if (this.stream != null) {
            return this.stream.available();
        }
        return 0;
    }

    private boolean nextStream() throws IOException {
        if (!this.nextChunk()) {
            return false;
        }
        this.stream = new BufferedInputStream(SecuritySupport.newFileInputStream(this.currentChunk.getFile()));
        return true;
    }

    private boolean nextChunk() {
        if (!this.chunks.hasNext()) {
            return false;
        }
        this.currentChunk = this.chunks.next();
        return true;
    }

    @Override
    public int read() throws IOException {
        do {
            if (this.stream == null) continue;
            int n = this.stream.read();
            if (n != -1) {
                return n;
            }
            this.stream.close();
            this.currentChunk.release();
            this.stream = null;
            this.currentChunk = null;
        } while (this.nextStream());
        return -1;
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
        while (this.currentChunk != null) {
            this.currentChunk.release();
            this.currentChunk = null;
            if (this.nextChunk()) continue;
            return;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

