/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	corev1 "k8s.io/api/core/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// LimitRangeLister helps list LimitRanges.
// All objects returned here must be treated as read-only.
type LimitRangeLister interface {
	// List lists all LimitRanges in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*corev1.LimitRange, err error)
	// LimitRanges returns an object that can list and get LimitRanges.
	LimitRanges(namespace string) LimitRangeNamespaceLister
	LimitRangeListerExpansion
}

// limitRangeLister implements the LimitRangeLister interface.
type limitRangeLister struct {
	listers.ResourceIndexer[*corev1.LimitRange]
}

// NewLimitRangeLister returns a new LimitRangeLister.
func NewLimitRangeLister(indexer cache.Indexer) LimitRangeLister {
	return &limitRangeLister{listers.New[*corev1.LimitRange](indexer, corev1.Resource("limitrange"))}
}

// LimitRanges returns an object that can list and get LimitRanges.
func (s *limitRangeLister) LimitRanges(namespace string) LimitRangeNamespaceLister {
	return limitRangeNamespaceLister{listers.NewNamespaced[*corev1.LimitRange](s.ResourceIndexer, namespace)}
}

// LimitRangeNamespaceLister helps list and get LimitRanges.
// All objects returned here must be treated as read-only.
type LimitRangeNamespaceLister interface {
	// List lists all LimitRanges in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*corev1.LimitRange, err error)
	// Get retrieves the LimitRange from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*corev1.LimitRange, error)
	LimitRangeNamespaceListerExpansion
}

// limitRangeNamespaceLister implements the LimitRangeNamespaceLister
// interface.
type limitRangeNamespaceLister struct {
	listers.ResourceIndexer[*corev1.LimitRange]
}
