/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.net.ssh;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.ssh.SSHUtils;
import org.jkiss.dbeaver.model.net.ssh.config.SSHHostConfiguration;
import org.jkiss.dbeaver.registry.configurator.DBPConnectionEditIntention;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.net.ssh.SSHTunnelDefaultConfiguratorUI;

public class SSHTunnelCredsOnlyConfiguratorUI
implements IObjectPropertyConfigurator<Object, DBWHandlerConfiguration> {
    private List<SSHTunnelDefaultConfiguratorUI.ConfigurationWrapper> configurations;
    private List<SSHTunnelDefaultConfiguratorUI.CredentialsPanel> credPanels;
    private Composite credPanelsContainer;
    private Runnable propertyChangeListener;

    public void createControl(@NotNull Composite parent, Object object, @NotNull Runnable propertyChangeListener) {
        this.credPanelsContainer = UIUtils.createControlGroup((Composite)parent, (String)"SSH tunnel credentials", (int)1, (int)768, (int)-1);
        this.propertyChangeListener = propertyChangeListener;
    }

    public void loadSettings(@NotNull DBWHandlerConfiguration handlerConfiguration) {
        try {
            this.configurations = Arrays.stream(SSHUtils.loadHostConfigurations((DBWHandlerConfiguration)handlerConfiguration, (boolean)false)).map(SSHTunnelDefaultConfiguratorUI.ConfigurationWrapper::new).toList();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("SSH configuration", "Unable to load SSH configuration due to an error", (Throwable)e);
            return;
        }
        Arrays.stream(this.credPanelsContainer.getChildren()).forEach(Widget::dispose);
        this.credPanels = new ArrayList<SSHTunnelDefaultConfiguratorUI.CredentialsPanel>();
        for (SSHTunnelDefaultConfiguratorUI.ConfigurationWrapper cfg : this.configurations) {
            SSHTunnelDefaultConfiguratorUI.CredentialsPanel credsPanel = new SSHTunnelDefaultConfiguratorUI.CredentialsPanel(this.credPanelsContainer, this.propertyChangeListener, DBPConnectionEditIntention.CREDENTIALS_ONLY);
            this.credPanels.add(credsPanel);
            credsPanel.loadSettings(cfg, false);
        }
        this.credPanelsContainer.pack(true);
    }

    public void saveSettings(@NotNull DBWHandlerConfiguration handlerConfiguration) {
        SSHUtils.saveHostConfigurations((DBWHandlerConfiguration)handlerConfiguration, (SSHHostConfiguration[])((SSHHostConfiguration[])this.credPanels.stream().map(SSHTunnelDefaultConfiguratorUI.CredentialsPanel::saveSettings).toArray(SSHHostConfiguration[]::new)));
    }

    public void resetSettings(@NotNull DBWHandlerConfiguration handlerConfiguration) {
    }

    public boolean isComplete() {
        return this.credPanels.stream().map(SSHTunnelDefaultConfiguratorUI.CredentialsPanel::saveSettings).map(SSHTunnelDefaultConfiguratorUI::validateConfiguration).allMatch(Objects::isNull);
    }
}

