package teambition_aliyun

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOrganizationMembers invokes the teambition_aliyun.GetOrganizationMembers API synchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/getorganizationmembers.html
func (client *Client) GetOrganizationMembers(request *GetOrganizationMembersRequest) (response *GetOrganizationMembersResponse, err error) {
	response = CreateGetOrganizationMembersResponse()
	err = client.DoAction(request, response)
	return
}

// GetOrganizationMembersWithChan invokes the teambition_aliyun.GetOrganizationMembers API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/getorganizationmembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOrganizationMembersWithChan(request *GetOrganizationMembersRequest) (<-chan *GetOrganizationMembersResponse, <-chan error) {
	responseChan := make(chan *GetOrganizationMembersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOrganizationMembers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOrganizationMembersWithCallback invokes the teambition_aliyun.GetOrganizationMembers API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/getorganizationmembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOrganizationMembersWithCallback(request *GetOrganizationMembersRequest, callback func(response *GetOrganizationMembersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOrganizationMembersResponse
		var err error
		defer close(result)
		response, err = client.GetOrganizationMembers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOrganizationMembersRequest is the request struct for api GetOrganizationMembers
type GetOrganizationMembersRequest struct {
	*requests.RpcRequest
	OrgId string `position:"Body" name:"OrgId"`
}

// GetOrganizationMembersResponse is the response struct for api GetOrganizationMembers
type GetOrganizationMembersResponse struct {
	*responses.BaseResponse
	Successful bool     `json:"Successful" xml:"Successful"`
	ErrorCode  string   `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string   `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	Object     []Member `json:"Object" xml:"Object"`
}

// CreateGetOrganizationMembersRequest creates a request to invoke GetOrganizationMembers API
func CreateGetOrganizationMembersRequest() (request *GetOrganizationMembersRequest) {
	request = &GetOrganizationMembersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("teambition-aliyun", "2020-02-26", "GetOrganizationMembers", "", "")
	request.Method = requests.POST
	return
}

// CreateGetOrganizationMembersResponse creates a response to parse from GetOrganizationMembers response
func CreateGetOrganizationMembersResponse() (response *GetOrganizationMembersResponse) {
	response = &GetOrganizationMembersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
