package teambition_aliyun

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteProjectSprint invokes the teambition_aliyun.DeleteProjectSprint API synchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/deleteprojectsprint.html
func (client *Client) DeleteProjectSprint(request *DeleteProjectSprintRequest) (response *DeleteProjectSprintResponse, err error) {
	response = CreateDeleteProjectSprintResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteProjectSprintWithChan invokes the teambition_aliyun.DeleteProjectSprint API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/deleteprojectsprint.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteProjectSprintWithChan(request *DeleteProjectSprintRequest) (<-chan *DeleteProjectSprintResponse, <-chan error) {
	responseChan := make(chan *DeleteProjectSprintResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteProjectSprint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteProjectSprintWithCallback invokes the teambition_aliyun.DeleteProjectSprint API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/deleteprojectsprint.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteProjectSprintWithCallback(request *DeleteProjectSprintRequest, callback func(response *DeleteProjectSprintResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteProjectSprintResponse
		var err error
		defer close(result)
		response, err = client.DeleteProjectSprint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteProjectSprintRequest is the request struct for api DeleteProjectSprint
type DeleteProjectSprintRequest struct {
	*requests.RpcRequest
	SprintId string `position:"Body" name:"SprintId"`
	OrgId    string `position:"Body" name:"OrgId"`
}

// DeleteProjectSprintResponse is the response struct for api DeleteProjectSprint
type DeleteProjectSprintResponse struct {
	*responses.BaseResponse
	Successful bool   `json:"Successful" xml:"Successful"`
	ErrorCode  string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Object     bool   `json:"Object" xml:"Object"`
}

// CreateDeleteProjectSprintRequest creates a request to invoke DeleteProjectSprint API
func CreateDeleteProjectSprintRequest() (request *DeleteProjectSprintRequest) {
	request = &DeleteProjectSprintRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("teambition-aliyun", "2020-02-26", "DeleteProjectSprint", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteProjectSprintResponse creates a response to parse from DeleteProjectSprint response
func CreateDeleteProjectSprintResponse() (response *DeleteProjectSprintResponse) {
	response = &DeleteProjectSprintResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
