package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SyncQualityCheck invokes the qualitycheck.SyncQualityCheck API synchronously
func (client *Client) SyncQualityCheck(request *SyncQualityCheckRequest) (response *SyncQualityCheckResponse, err error) {
	response = CreateSyncQualityCheckResponse()
	err = client.DoAction(request, response)
	return
}

// SyncQualityCheckWithChan invokes the qualitycheck.SyncQualityCheck API asynchronously
func (client *Client) SyncQualityCheckWithChan(request *SyncQualityCheckRequest) (<-chan *SyncQualityCheckResponse, <-chan error) {
	responseChan := make(chan *SyncQualityCheckResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SyncQualityCheck(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SyncQualityCheckWithCallback invokes the qualitycheck.SyncQualityCheck API asynchronously
func (client *Client) SyncQualityCheckWithCallback(request *SyncQualityCheckRequest, callback func(response *SyncQualityCheckResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SyncQualityCheckResponse
		var err error
		defer close(result)
		response, err = client.SyncQualityCheck(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SyncQualityCheckRequest is the request struct for api SyncQualityCheck
type SyncQualityCheckRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
}

// SyncQualityCheckResponse is the response struct for api SyncQualityCheck
type SyncQualityCheckResponse struct {
	*responses.BaseResponse
	Code      string                 `json:"Code" xml:"Code"`
	Message   string                 `json:"Message" xml:"Message"`
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Success   bool                   `json:"Success" xml:"Success"`
	Data      DataInSyncQualityCheck `json:"Data" xml:"Data"`
}

// CreateSyncQualityCheckRequest creates a request to invoke SyncQualityCheck API
func CreateSyncQualityCheckRequest() (request *SyncQualityCheckRequest) {
	request = &SyncQualityCheckRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "SyncQualityCheck", "", "")
	request.Method = requests.POST
	return
}

// CreateSyncQualityCheckResponse creates a response to parse from SyncQualityCheck response
func CreateSyncQualityCheckResponse() (response *SyncQualityCheckResponse) {
	response = &SyncQualityCheckResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
