package ivision

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchFace invokes the ivision.SearchFace API synchronously
func (client *Client) SearchFace(request *SearchFaceRequest) (response *SearchFaceResponse, err error) {
	response = CreateSearchFaceResponse()
	err = client.DoAction(request, response)
	return
}

// SearchFaceWithChan invokes the ivision.SearchFace API asynchronously
func (client *Client) SearchFaceWithChan(request *SearchFaceRequest) (<-chan *SearchFaceResponse, <-chan error) {
	responseChan := make(chan *SearchFaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchFace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchFaceWithCallback invokes the ivision.SearchFace API asynchronously
func (client *Client) SearchFaceWithCallback(request *SearchFaceRequest, callback func(response *SearchFaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchFaceResponse
		var err error
		defer close(result)
		response, err = client.SearchFace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchFaceRequest is the request struct for api SearchFace
type SearchFaceRequest struct {
	*requests.RpcRequest
	Content              string           `position:"Query" name:"Content"`
	DataType             string           `position:"Query" name:"DataType"`
	ProbabilityThreshold requests.Float   `position:"Query" name:"ProbabilityThreshold"`
	ShowLog              string           `position:"Query" name:"ShowLog"`
	GroupId              string           `position:"Query" name:"GroupId"`
	Count                requests.Integer `position:"Query" name:"Count"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// SearchFaceResponse is the response struct for api SearchFace
type SearchFaceResponse struct {
	*responses.BaseResponse
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	GroupId     string       `json:"GroupId" xml:"GroupId"`
	Rect        Rect         `json:"Rect" xml:"Rect"`
	FaceResults []FaceResult `json:"FaceResults" xml:"FaceResults"`
}

// CreateSearchFaceRequest creates a request to invoke SearchFace API
func CreateSearchFaceRequest() (request *SearchFaceRequest) {
	request = &SearchFaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ivision", "2019-03-08", "SearchFace", "ivision", "openAPI")
	request.Method = requests.GET
	return
}

// CreateSearchFaceResponse creates a response to parse from SearchFace response
func CreateSearchFaceResponse() (response *SearchFaceResponse) {
	response = &SearchFaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
