package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEnvTrafficControl invokes the edas.GetEnvTrafficControl API synchronously
func (client *Client) GetEnvTrafficControl(request *GetEnvTrafficControlRequest) (response *GetEnvTrafficControlResponse, err error) {
	response = CreateGetEnvTrafficControlResponse()
	err = client.DoAction(request, response)
	return
}

// GetEnvTrafficControlWithChan invokes the edas.GetEnvTrafficControl API asynchronously
func (client *Client) GetEnvTrafficControlWithChan(request *GetEnvTrafficControlRequest) (<-chan *GetEnvTrafficControlResponse, <-chan error) {
	responseChan := make(chan *GetEnvTrafficControlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEnvTrafficControl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEnvTrafficControlWithCallback invokes the edas.GetEnvTrafficControl API asynchronously
func (client *Client) GetEnvTrafficControlWithCallback(request *GetEnvTrafficControlRequest, callback func(response *GetEnvTrafficControlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEnvTrafficControlResponse
		var err error
		defer close(result)
		response, err = client.GetEnvTrafficControl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEnvTrafficControlRequest is the request struct for api GetEnvTrafficControl
type GetEnvTrafficControlRequest struct {
	*requests.RoaRequest
	PointcutName string `position:"Query" name:"PointcutName"`
}

// GetEnvTrafficControlResponse is the response struct for api GetEnvTrafficControl
type GetEnvTrafficControlResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetEnvTrafficControlRequest creates a request to invoke GetEnvTrafficControl API
func CreateGetEnvTrafficControlRequest() (request *GetEnvTrafficControlRequest) {
	request = &GetEnvTrafficControlRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "GetEnvTrafficControl", "/pop/v5/gray/env_traffic_control_list", "Edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetEnvTrafficControlResponse creates a response to parse from GetEnvTrafficControl response
func CreateGetEnvTrafficControlResponse() (response *GetEnvTrafficControlResponse) {
	response = &GetEnvTrafficControlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
