package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateRequestDiagnosis invokes the das.CreateRequestDiagnosis API synchronously
func (client *Client) CreateRequestDiagnosis(request *CreateRequestDiagnosisRequest) (response *CreateRequestDiagnosisResponse, err error) {
	response = CreateCreateRequestDiagnosisResponse()
	err = client.DoAction(request, response)
	return
}

// CreateRequestDiagnosisWithChan invokes the das.CreateRequestDiagnosis API asynchronously
func (client *Client) CreateRequestDiagnosisWithChan(request *CreateRequestDiagnosisRequest) (<-chan *CreateRequestDiagnosisResponse, <-chan error) {
	responseChan := make(chan *CreateRequestDiagnosisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateRequestDiagnosis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateRequestDiagnosisWithCallback invokes the das.CreateRequestDiagnosis API asynchronously
func (client *Client) CreateRequestDiagnosisWithCallback(request *CreateRequestDiagnosisRequest, callback func(response *CreateRequestDiagnosisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateRequestDiagnosisResponse
		var err error
		defer close(result)
		response, err = client.CreateRequestDiagnosis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateRequestDiagnosisRequest is the request struct for api CreateRequestDiagnosis
type CreateRequestDiagnosisRequest struct {
	*requests.RpcRequest
	Sql        string `position:"Query" name:"Sql"`
	Database   string `position:"Query" name:"Database"`
	InstanceId string `position:"Query" name:"InstanceId"`
	NodeId     string `position:"Query" name:"NodeId"`
}

// CreateRequestDiagnosisResponse is the response struct for api CreateRequestDiagnosis
type CreateRequestDiagnosisResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateCreateRequestDiagnosisRequest creates a request to invoke CreateRequestDiagnosis API
func CreateCreateRequestDiagnosisRequest() (request *CreateRequestDiagnosisRequest) {
	request = &CreateRequestDiagnosisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "CreateRequestDiagnosis", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateRequestDiagnosisResponse creates a response to parse from CreateRequestDiagnosis response
func CreateCreateRequestDiagnosisResponse() (response *CreateRequestDiagnosisResponse) {
	response = &CreateRequestDiagnosisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
