package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAggregateRemediation invokes the config.CreateAggregateRemediation API synchronously
func (client *Client) CreateAggregateRemediation(request *CreateAggregateRemediationRequest) (response *CreateAggregateRemediationResponse, err error) {
	response = CreateCreateAggregateRemediationResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAggregateRemediationWithChan invokes the config.CreateAggregateRemediation API asynchronously
func (client *Client) CreateAggregateRemediationWithChan(request *CreateAggregateRemediationRequest) (<-chan *CreateAggregateRemediationResponse, <-chan error) {
	responseChan := make(chan *CreateAggregateRemediationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAggregateRemediation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAggregateRemediationWithCallback invokes the config.CreateAggregateRemediation API asynchronously
func (client *Client) CreateAggregateRemediationWithCallback(request *CreateAggregateRemediationRequest, callback func(response *CreateAggregateRemediationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAggregateRemediationResponse
		var err error
		defer close(result)
		response, err = client.CreateAggregateRemediation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAggregateRemediationRequest is the request struct for api CreateAggregateRemediation
type CreateAggregateRemediationRequest struct {
	*requests.RpcRequest
	ConfigRuleId          string `position:"Body" name:"ConfigRuleId"`
	RemediationType       string `position:"Body" name:"RemediationType"`
	ClientToken           string `position:"Body" name:"ClientToken"`
	AggregatorId          string `position:"Body" name:"AggregatorId"`
	SourceType            string `position:"Body" name:"SourceType"`
	RemediationTemplateId string `position:"Body" name:"RemediationTemplateId"`
	Params                string `position:"Body" name:"Params"`
	InvokeType            string `position:"Body" name:"InvokeType"`
}

// CreateAggregateRemediationResponse is the response struct for api CreateAggregateRemediation
type CreateAggregateRemediationResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	RemediationId string `json:"RemediationId" xml:"RemediationId"`
}

// CreateCreateAggregateRemediationRequest creates a request to invoke CreateAggregateRemediation API
func CreateCreateAggregateRemediationRequest() (request *CreateAggregateRemediationRequest) {
	request = &CreateAggregateRemediationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "CreateAggregateRemediation", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateAggregateRemediationResponse creates a response to parse from CreateAggregateRemediation response
func CreateCreateAggregateRemediationResponse() (response *CreateAggregateRemediationResponse) {
	response = &CreateAggregateRemediationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
