package storagepoolapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/storagepool/mgmt/2020-03-15-preview/storagepool"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result storagepool.OperationListResult, err error)
}

var _ OperationsClientAPI = (*storagepool.OperationsClient)(nil)

// DiskPoolsClientAPI contains the set of methods on the DiskPoolsClient type.
type DiskPoolsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, diskPoolName string, diskPoolPayload storagepool.DiskPool) (result storagepool.DiskPoolsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, diskPoolName string) (result storagepool.DiskPoolsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, diskPoolName string) (result storagepool.DiskPool, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result storagepool.DiskPoolListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result storagepool.DiskPoolListResultIterator, err error)
	ListBySubscription(ctx context.Context) (result storagepool.DiskPoolListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result storagepool.DiskPoolListResultIterator, err error)
	Update(ctx context.Context, resourceGroupName string, diskPoolName string, diskPoolPayload storagepool.DiskPool) (result storagepool.DiskPool, err error)
}

var _ DiskPoolsClientAPI = (*storagepool.DiskPoolsClient)(nil)

// IscsiTargetsClientAPI contains the set of methods on the IscsiTargetsClient type.
type IscsiTargetsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, diskPoolName string, iscsiTargetName string, iscsiTargetPayload storagepool.IscsiTarget) (result storagepool.IscsiTargetsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, diskPoolName string, iscsiTargetName string) (result storagepool.IscsiTargetsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, diskPoolName string, iscsiTargetName string) (result storagepool.IscsiTarget, err error)
	ListByDiskPool(ctx context.Context, resourceGroupName string, diskPoolName string) (result storagepool.IscsiTargetListPage, err error)
	ListByDiskPoolComplete(ctx context.Context, resourceGroupName string, diskPoolName string) (result storagepool.IscsiTargetListIterator, err error)
}

var _ IscsiTargetsClientAPI = (*storagepool.IscsiTargetsClient)(nil)
