/*
 * Decompiled with CFR 0.152.
 */
package net.dot.android.crypto;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public final class PalPbkdf2 {
    private static final int ERROR_UNSUPPORTED_ALGORITHM = -1;
    private static final int SUCCESS = 1;

    public static int pbkdf2OneShot(String string, byte[] byArray, ByteBuffer byteBuffer, int n, ByteBuffer byteBuffer2) throws ShortBufferException, InvalidKeyException, IllegalArgumentException {
        Mac mac;
        if (string == null || byArray == null || byteBuffer2 == null) {
            throw new IllegalArgumentException("algorithmName, password, and destination must not be null.");
        }
        String string2 = "Hmac" + string;
        try {
            mac = Mac.getInstance(string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return -1;
        }
        if (byArray.length == 0) {
            byArray = new byte[]{0};
        }
        if (byteBuffer != null) {
            byteBuffer.mark();
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, string2);
        mac.init(secretKeySpec);
        int n2 = 1;
        int n3 = 0;
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[mac.getMacLength()];
        byte[] byArray4 = new byte[byArray3.length];
        while (n3 < byteBuffer2.capacity()) {
            PalPbkdf2.writeBigEndianInt(n2, byArray2);
            if (byteBuffer != null) {
                mac.update(byteBuffer);
                byteBuffer.reset();
            }
            mac.update(byArray2);
            mac.doFinal(byArray4, 0);
            System.arraycopy(byArray4, 0, byArray3, 0, byArray3.length);
            for (int i = 2; i <= n; ++i) {
                mac.update(byArray4);
                mac.doFinal(byArray4, 0);
                for (int j = 0; j < byArray4.length; ++j) {
                    int n4 = j;
                    byArray3[n4] = (byte)(byArray3[n4] ^ byArray4[j]);
                }
            }
            byteBuffer2.put(byArray3, 0, Math.min(byArray3.length, byteBuffer2.capacity() - n3));
            n3 += byArray3.length;
            ++n2;
        }
        return 1;
    }

    private static void writeBigEndianInt(int n, byte[] byArray) {
        byArray[0] = (byte)(n >> 24 & 0xFF);
        byArray[1] = (byte)(n >> 16 & 0xFF);
        byArray[2] = (byte)(n >> 8 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
    }
}

