/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.backend.split;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import com.jetbrains.rd.framework.IRdEndpoint;
import com.jetbrains.rd.ide.model.MarkupModelExtension;
import com.jetbrains.rd.ide.model.VcsGutterMarkersModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.daemon.BackendEditorMarkupModelContributor;
import com.jetbrains.rdserver.daemon.BackendMarkupModelContributor;
import com.jetbrains.rdserver.daemon.BackendProtocolMarkupModelExtensionHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/vcs/backend/split/BackendVcsGutterMarkExtensionHandler;", "Lcom/jetbrains/rdserver/daemon/BackendProtocolMarkupModelExtensionHandler;", "<init>", "()V", "consume", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "extensions", "", "Lcom/jetbrains/rd/ide/model/MarkupModelExtension;", "contributor", "Lcom/jetbrains/rdserver/daemon/BackendMarkupModelContributor;", "EditorMarkersContributor", "intellij.platform.vcs.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendVcsGutterMarkersHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendVcsGutterMarkersHost.kt\ncom/intellij/platform/vcs/backend/split/BackendVcsGutterMarkExtensionHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
final class BackendVcsGutterMarkExtensionHandler
implements BackendProtocolMarkupModelExtensionHandler {
    public void consume(@NotNull Lifetime lifetime, @NotNull List<? extends MarkupModelExtension> extensions, @NotNull BackendMarkupModelContributor contributor) {
        Object v1;
        Project project;
        block4: {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
            Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
            if (contributor instanceof BackendEditorMarkupModelContributor) {
                return;
            }
            Project project2 = contributor.getProject();
            if (project2 == null) {
                return;
            }
            project = project2;
            Iterable iterable = extensions;
            for (Object t : iterable) {
                MarkupModelExtension it = (MarkupModelExtension)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKey(), (Object)"VCS_GUTTER_PROVIDER_MODEL_KEY")) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        Object var6_10 = v1;
        VcsGutterMarkersModel vcsGutterMarkersModel = var6_10 instanceof VcsGutterMarkersModel ? (VcsGutterMarkersModel)var6_10 : null;
        if (vcsGutterMarkersModel == null) {
            return;
        }
        VcsGutterMarkersModel vcsMarkersModel = vcsGutterMarkersModel;
        new EditorMarkersContributor(lifetime, project, contributor, vcsMarkersModel);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J;\u0010\u0014\u001a\u0004\u0018\u0001H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u001c\u0010\u0016\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0018\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u0002H\u00150\u0017H\u0002\u00a2\u0006\u0002\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/vcs/backend/split/BackendVcsGutterMarkExtensionHandler$EditorMarkersContributor;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "contributor", "Lcom/jetbrains/rdserver/daemon/BackendMarkupModelContributor;", "vcsGutterMarkersModel", "Lcom/jetbrains/rd/ide/model/VcsGutterMarkersModel;", "<init>", "(Lcom/intellij/platform/vcs/backend/split/BackendVcsGutterMarkExtensionHandler;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rdserver/daemon/BackendMarkupModelContributor;Lcom/jetbrains/rd/ide/model/VcsGutterMarkersModel;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getContributor", "()Lcom/jetbrains/rdserver/daemon/BackendMarkupModelContributor;", "getRangeOldContent", "", "highlighterId", "", "performRangeOperation", "T", "task", "Lkotlin/Function2;", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "Lcom/intellij/openapi/vcs/ex/Range;", "(JLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "intellij.platform.vcs.backend.split"})
    private final class EditorMarkersContributor {
        @NotNull
        private final Project project;
        @NotNull
        private final BackendMarkupModelContributor contributor;

        public EditorMarkersContributor(@NotNull Lifetime lifetime, @NotNull Project project, @NotNull BackendMarkupModelContributor contributor, VcsGutterMarkersModel vcsGutterMarkersModel) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
            Intrinsics.checkNotNullParameter((Object)vcsGutterMarkersModel, (String)"vcsGutterMarkersModel");
            this.project = project;
            this.contributor = contributor;
            LineStatusTrackerManagerI lstm = LineStatusTrackerManager.Companion.getInstance(this.project);
            lstm.requestTrackerFor(this.contributor.getDocument(), (Object)this);
            lifetime.onTermination(() -> EditorMarkersContributor._init_$lambda$0(lstm, this));
            IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)vcsGutterMarkersModel.getGetOldContent()), null, null, arg_0 -> EditorMarkersContributor._init_$lambda$1(this, arg_0), (int)3, null);
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final BackendMarkupModelContributor getContributor() {
            return this.contributor;
        }

        private final String getRangeOldContent(long highlighterId) {
            return (String)this.performRangeOperation(highlighterId, EditorMarkersContributor::getRangeOldContent$lambda$2);
        }

        private final <T> T performRangeOperation(long highlighterId, Function2<? super LineStatusTracker<?>, ? super Range, ? extends T> task) {
            LineStatusTrackerManagerI manager = LineStatusTrackerManager.Companion.getInstance(this.project);
            LineStatusTracker lineStatusTracker = manager.getLineStatusTracker(this.contributor.getDocument());
            if (lineStatusTracker == null) {
                return null;
            }
            LineStatusTracker tracker = lineStatusTracker;
            RangeMarkerEx rangeMarkerEx = this.contributor.getRangeMarker(highlighterId);
            if (rangeMarkerEx == null) {
                return null;
            }
            RangeMarkerEx highlighter = rangeMarkerEx;
            TextRange textRange = highlighter.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            TextRange textRange2 = textRange;
            int line = this.contributor.getDocument().getLineNumber(textRange2.getStartOffset());
            Range range = tracker.getRangeForLine(line);
            if (range == null) {
                return null;
            }
            Range range2 = range;
            return (T)task.invoke((Object)tracker, (Object)range2);
        }

        private static final Unit _init_$lambda$0(LineStatusTrackerManagerI $lstm, EditorMarkersContributor this$0) {
            $lstm.releaseTrackerFor(this$0.contributor.getDocument(), (Object)this$0);
            return Unit.INSTANCE;
        }

        private static final String _init_$lambda$1(EditorMarkersContributor this$0, long id) {
            return this$0.getRangeOldContent(id);
        }

        private static final String getRangeOldContent$lambda$2(LineStatusTracker tracker, Range range) {
            Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            TextRange textRange = DiffUtil.getLinesRange((Document)tracker.getVcsDocument(), (int)range.getVcsLine1(), (int)range.getVcsLine2());
            return ((Object)textRange.subSequence(tracker.getVcsDocument().getImmutableCharSequence())).toString();
        }
    }
}

