/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import java.net.ConnectException;
import java.nio.channels.UnresolvedAddressException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/intellij/collaboration/ui/ExceptionUtil;", "", "<init>", "()V", "getPresentableMessage", "", "Lorg/jetbrains/annotations/Nls;", "exception", "", "intellij.platform.collaborationTools"})
public final class ExceptionUtil {
    @NotNull
    public static final ExceptionUtil INSTANCE = new ExceptionUtil();

    private ExceptionUtil() {
    }

    @NotNull
    public final String getPresentableMessage(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (exception.getLocalizedMessage() != null) {
            String string = exception.getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
            return string;
        }
        if (exception instanceof ConnectException) {
            if (exception.getCause() instanceof UnresolvedAddressException) {
                String string = CollaborationToolsBundle.message("error.address.unresolved", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
            String string = CollaborationToolsBundle.message("error.connection.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        String string = CollaborationToolsBundle.message("error.unknown", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

