/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtilRt;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LobInfo<T extends LobInfo<?>>
implements Comparable<T>,
Serializable {
    public final long length;
    private boolean isFullyReloaded;
    private static final ThreadLocal<byte[]> BUFFER = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[8192];
        }
    };

    public LobInfo(long length) {
        this.length = length;
    }

    public boolean isTruncated() {
        return this.length != this.getLoadedDataLength();
    }

    public boolean isFullyReloaded() {
        return this.isFullyReloaded;
    }

    public void setFullyReloaded(boolean fullyReloaded) {
        this.isFullyReloaded = fullyReloaded;
    }

    public abstract long getLoadedDataLength();

    @Override
    public int compareTo(T o) {
        return Long.compare(this.length, ((LobInfo)o).length);
    }

    public static void freeLob(Clob lob) {
        try {
            lob.free();
        }
        catch (Exception | LinkageError throwable) {
            // empty catch block
        }
    }

    public static void freeLob(Blob lob) {
        try {
            lob.free();
        }
        catch (Exception | LinkageError throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromClob(Clob lob, int maxLobLength) throws Exception {
        try {
            int subLength;
            long length = lob.length();
            int n = subLength = (long)maxLobLength < length ? maxLobLength : (int)length;
            ClobInfo clobInfo = new ClobInfo(length, length != (long)subLength && subLength <= 0 ? null : (subLength > 0 ? lob.getSubString(1L, subLength) : ""));
            return clobInfo;
        }
        finally {
            LobInfo.freeLob(lob);
        }
    }

    public static Object fromString(String string, int maxLobLength) {
        int length = string.length();
        int subLength = Math.min(maxLobLength, length);
        return subLength == length ? string : new ClobInfo(length, subLength <= 0 ? null : string.substring(0, subLength));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromBlob(Blob lob, int maxLobLength) throws Exception {
        try {
            int subLength;
            long length = lob.length();
            int n = subLength = (long)maxLobLength < length ? maxLobLength : (int)length;
            BlobInfo blobInfo = new BlobInfo(length, length != (long)subLength && subLength <= 0 ? null : (subLength > 0 ? lob.getBytes(1L, subLength) : ArrayUtilRt.EMPTY_BYTE_ARRAY));
            return blobInfo;
        }
        finally {
            LobInfo.freeLob(lob);
        }
    }

    private static byte[] loadBytes(@NotNull InputStream o, int maxLength) throws IOException {
        int read;
        if (o == null) {
            LobInfo.$$$reportNull$$$0(0);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        byte[] bytes = BUFFER.get();
        int count = 0;
        while ((read = o.read(bytes)) > 0) {
            boolean limit = (count += read) >= maxLength;
            int toCopy = limit ? read - (count - maxLength) : read;
            stream.write(bytes, 0, toCopy);
            if (!limit) continue;
            break;
        }
        return stream.toByteArray();
    }

    private static int realMaxLength(int maxLength) {
        return maxLength < 0 ? Integer.MAX_VALUE : maxLength;
    }

    @Nullable
    public static Object fromInputStream(InputStream o, int maxLength) throws IOException {
        return LobInfo.fromByteArray(LobInfo.loadBytes(o, LobInfo.realMaxLength(maxLength)), maxLength);
    }

    @Nullable
    public static Object fromReader(Reader o, int maxLength) throws IOException {
        return LobInfo.fromString(String.valueOf(FileUtilRt.loadText((Reader)o, (int)LobInfo.realMaxLength(maxLength))), maxLength);
    }

    public static Object fromByteArray(byte[] data, int maxLobLength) {
        Object object;
        int length = data.length;
        int subLength = Math.min(maxLobLength, length);
        if (subLength == length) {
            object = data;
        } else {
            BlobInfo blobInfo;
            object = blobInfo;
            blobInfo = new BlobInfo(length, subLength <= 0 ? null : Arrays.copyOf(data, subLength));
        }
        return object;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LobInfo)) {
            return false;
        }
        LobInfo info = (LobInfo)o;
        return !this.isTruncated() && !info.isTruncated() && this.length == info.length;
    }

    public int hashCode() {
        return (int)(this.length ^ this.length >>> 32);
    }

    private static boolean areFilePathsEqual(File file1, File file2) {
        String path1 = file1.getPath();
        String path2 = file2.getPath();
        return SystemInfoRt.isFileSystemCaseSensitive ? path1.equals(path2) : path1.equalsIgnoreCase(path2);
    }

    private static int computeFilePathHashcode(File file) {
        String path = file.getPath();
        return SystemInfoRt.isFileSystemCaseSensitive ? path.hashCode() : path.toLowerCase(Locale.ENGLISH).hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/remote/jdbc/LobInfo", "loadBytes"));
    }

    public static class ClobInfo
    extends LobInfo<ClobInfo> {
        public final String data;

        public ClobInfo(long length, String data) {
            super(length);
            this.data = data;
        }

        @Override
        public long getLoadedDataLength() {
            return this.data == null ? 0L : (long)this.data.length();
        }

        @Override
        public int compareTo(ClobInfo o) {
            int superVal = super.compareTo(o);
            if (superVal != 0) {
                return superVal;
            }
            return Comparing.compare((Comparable)((Object)this.data), (Comparable)((Object)o.data));
        }

        @Override
        public int compareTo(@NotNull String str) {
            int lenVal;
            if (str == null) {
                ClobInfo.$$$reportNull$$$0(0);
            }
            if ((lenVal = Long.compare(this.length, str.length())) != 0 || this.length == 0L) {
                return lenVal;
            }
            return Comparing.compare((Comparable)((Object)this.data), (Comparable)((Object)str));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClobInfo)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ClobInfo info = (ClobInfo)o;
            return Objects.equals(this.data, info.data);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/database/remote/jdbc/LobInfo$ClobInfo", "compareTo"));
        }
    }

    public static class BlobInfo
    extends LobInfo<BlobInfo> {
        public final byte[] data;

        public BlobInfo(long length, byte[] data) {
            super(length);
            this.data = data;
        }

        @Override
        public long getLoadedDataLength() {
            return this.data != null ? (long)this.data.length : 0L;
        }

        @Override
        public int compareTo(BlobInfo o) {
            int superVal = super.compareTo(o);
            if (superVal != 0 || this.length == 0L) {
                return superVal;
            }
            return Comparing.compare((byte[])this.data, (byte[])o.data);
        }

        @Override
        public int compareTo(@NotNull byte[] bytes) {
            int lenVal;
            if (bytes == null) {
                BlobInfo.$$$reportNull$$$0(0);
            }
            if ((lenVal = Long.compare(this.length, bytes.length)) != 0 || this.length == 0L) {
                return lenVal;
            }
            return Comparing.compare((byte[])this.data, (byte[])bytes);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BlobInfo)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BlobInfo info = (BlobInfo)o;
            return Arrays.equals(this.data, info.data);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.data != null ? Arrays.hashCode(this.data) : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/database/remote/jdbc/LobInfo$BlobInfo", "compareTo"));
        }
    }

    public static final class FileClobInfo
    extends ClobInfo {
        public final File file;
        public final String charset;

        public FileClobInfo(File file, String charset) {
            super(file.length(), "");
            this.file = file;
            this.charset = charset;
        }

        @Override
        public boolean isTruncated() {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileClobInfo)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FileClobInfo info = (FileClobInfo)o;
            if (!LobInfo.areFilePathsEqual(this.file, info.file)) {
                return false;
            }
            return Objects.equals(this.charset, info.charset);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + LobInfo.computeFilePathHashcode(this.file);
            result = 31 * result + (this.charset != null ? this.charset.hashCode() : 0);
            return result;
        }
    }

    public static final class FileBlobInfo
    extends BlobInfo {
        public final File file;

        public FileBlobInfo(File file) {
            super(file.length(), ArrayUtilRt.EMPTY_BYTE_ARRAY);
            this.file = file;
        }

        @Override
        public boolean isTruncated() {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileBlobInfo)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FileBlobInfo info = (FileBlobInfo)o;
            return LobInfo.areFilePathsEqual(this.file, info.file);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + LobInfo.computeFilePathHashcode(this.file);
            return result;
        }
    }
}

