/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views;

import com.intellij.execution.console.ConsolePromptDecorator;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Key;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.uiautomation.BeConsole;
import com.jetbrains.ide.model.uiautomation.BeConsolePrompt;
import com.jetbrains.rd.ui.bindable.ViewBinder;
import com.jetbrains.rd.ui.bindable.ViewRegistryKt;
import com.jetbrains.rd.ui.bindable.views.ThinClientConsoleEditorPanel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/ConsoleControl;", "Lcom/jetbrains/rd/ui/bindable/ViewBinder;", "Lcom/jetbrains/ide/model/uiautomation/BeConsole;", "<init>", "()V", "bind", "Ljavax/swing/JComponent;", "viewModel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "findEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "Companion", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nConsoleControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleControl.kt\ncom/jetbrains/rd/ui/bindable/views/ConsoleControl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n15#2:184\n808#3,11:185\n1#4:196\n*S KotlinDebug\n*F\n+ 1 ConsoleControl.kt\ncom/jetbrains/rd/ui/bindable/views/ConsoleControl\n*L\n50#1:184\n61#1:185,11\n*E\n"})
public final class ConsoleControl
implements ViewBinder<BeConsole> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Boolean> COMMAND_EDITOR_KEY;

    @Override
    @NotNull
    public JComponent bind(@NotNull BeConsole viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        JComponent editorPanel = ViewRegistryKt.getView(viewModel.getEditor(), lifetime);
        JComponent commandEditorPanel = ViewRegistryKt.getView(viewModel.getCommandEditor(), lifetime);
        EditorEx editor = this.findEditor(editorPanel);
        EditorEx commandEditor = this.findEditor(commandEditorPanel);
        if (editor == null || commandEditor == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ConsoleControl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Can't find editors for " + viewModel + " - " + editorPanel + " / " + commandEditorPanel);
            Splitter panel2 = new Splitter(true);
            panel2.setFirstComponent(editorPanel);
            panel2.setSecondComponent(commandEditorPanel);
            return (JComponent)panel2;
        }
        SourceExKt.adviseNotNull((ISource)((ISource)viewModel.getPrompt()), (Lifetime)lifetime, arg_0 -> ConsoleControl.bind$lambda$1(commandEditor, arg_0));
        ConsoleViewUtil.setupLanguageConsoleEditor((EditorEx)editor);
        ConsoleViewUtil.setupLanguageConsoleEditor((EditorEx)commandEditor);
        return new ThinClientConsoleEditorPanel(editor, commandEditor, editorPanel, commandEditorPanel, lifetime);
    }

    private final EditorEx findEditor(JComponent $this$findEditor) {
        EditorComponentImpl editorComponentImpl = (EditorComponentImpl)UIUtil.findComponentOfType((JComponent)$this$findEditor, EditorComponentImpl.class);
        if (editorComponentImpl == null) {
            return null;
        }
        EditorComponentImpl editorComponent = editorComponentImpl;
        return (EditorEx)editorComponent.getEditor();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit bind$lambda$1(EditorEx $commandEditor, BeConsolePrompt prompt) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        List list = $commandEditor.getGutter().getTextAnnotations();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTextAnnotations(...)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ConsolePromptDecorator)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List oldConsolePrompts = (List)destination$iv$iv;
        $commandEditor.getGutter().closeTextAnnotations((Collection)oldConsolePrompts);
        ConsolePromptDecorator promptDecorator = new ConsolePromptDecorator($commandEditor);
        promptDecorator.setMainPrompt(prompt.getMainPrompt());
        promptDecorator.setIndentPrompt(prompt.getIndentPrompt());
        if (prompt.getTextAttributeKey() != null) {
            Iterator iterator;
            block4: {
                Collection collection = ConsoleViewContentType.getRegisteredTypes();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRegisteredTypes(...)");
                Iterable iterable2 = collection;
                for (Iterator iterator2 : iterable2) {
                    ConsoleViewContentType it = (ConsoleViewContentType)iterator2;
                    boolean bl = false;
                    TextAttributesKey textAttributesKey = it.getAttributesKey();
                    if (!Intrinsics.areEqual((Object)(textAttributesKey != null ? textAttributesKey.getExternalName() : null), (Object)prompt.getTextAttributeKey())) continue;
                    iterator = iterator2;
                    break block4;
                }
                iterator = null;
            }
            ConsoleViewContentType contentType = (ConsoleViewContentType)iterator;
            if (contentType != null) {
                promptDecorator.setPromptAttributes(contentType);
            }
        }
        $commandEditor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)promptDecorator);
        $commandEditor.putUserData(COMMAND_EDITOR_KEY, (Object)true);
        return Unit.INSTANCE;
    }

    static {
        Key key = Key.create((String)"ConsoleControl.CommandEditor");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        COMMAND_EDITOR_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/ConsoleControl$Companion;", "", "<init>", "()V", "COMMAND_EDITOR_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getCOMMAND_EDITOR_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.rd.ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Boolean> getCOMMAND_EDITOR_KEY() {
            return COMMAND_EDITOR_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

