/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.YamlAnything;
import org.jetbrains.yaml.meta.model.YamlBooleanType;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlNumberType;
import org.jetbrains.yaml.meta.model.YamlStringType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlPsiUtilKt$getKeysInBetween$;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007\u001a\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0015H\u0000\u001a\u0014\u0010\u0018\u001a\u00020\u000f*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0015H\u0002\"\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"getKeysInBetween", "", "", "value", "Lorg/jetbrains/yaml/psi/YAMLValue;", "topSeq", "Lorg/jetbrains/yaml/psi/YAMLSequence;", "findStructuralSiblings", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/yaml/psi/YAMLPsiElement;", "keys", "types", "Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "kotlin.jvm.PlatformType", "isValid", "", "meta", "estimatedType", "scalar", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "findClosestAncestorWithoutIndent", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/openapi/editor/Document;", "element", "isAtStartOfLine", "intellij.yaml.backend"})
@SourceDebugExtension(value={"SMAP\nyamlPsiUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 yamlPsiUtil.kt\norg/jetbrains/yaml/psi/YamlPsiUtilKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,70:1\n477#2:71\n183#2,2:74\n66#3,2:72\n*S KotlinDebug\n*F\n+ 1 yamlPsiUtil.kt\norg/jetbrains/yaml/psi/YamlPsiUtilKt\n*L\n17#1:71\n53#1:74,2\n20#1:72,2\n*E\n"})
public final class YamlPsiUtilKt {
    @NotNull
    private static final Sequence<YamlMetaType> types;

    @NotNull
    public static final List<String> getKeysInBetween(@NotNull YAMLValue value, @NotNull YAMLSequence topSeq) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)topSeq, (String)"topSeq");
        Sequence $this$filterIsInstance$iv = SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.parents((PsiElement)((PsiElement)value), (boolean)false), arg_0 -> YamlPsiUtilKt.getKeysInBetween$lambda$0(topSeq, arg_0));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getKeysInBetween$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)sequence, YamlPsiUtilKt::getKeysInBetween$lambda$1)));
    }

    @NotNull
    public static final Sequence<YAMLPsiElement> findStructuralSiblings(@NotNull YAMLValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)value;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        YAMLSequence yAMLSequence = (YAMLSequence)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, YAMLSequence.class, (boolean)true);
        if (yAMLSequence == null) {
            return SequencesKt.emptySequence();
        }
        YAMLSequence topSeq = yAMLSequence;
        return YamlPsiUtilKt.findStructuralSiblings(topSeq, YamlPsiUtilKt.getKeysInBetween(value, topSeq));
    }

    @NotNull
    public static final Sequence<YAMLPsiElement> findStructuralSiblings(@NotNull YAMLSequence topSeq, @NotNull List<String> keys) {
        Intrinsics.checkNotNullParameter((Object)topSeq, (String)"topSeq");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        if (keys.isEmpty()) {
            List list = topSeq.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
            return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), YamlPsiUtilKt::findStructuralSiblings$lambda$2);
        }
        List list = topSeq.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        return SequencesKt.flatMap((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)list), YamlPsiUtilKt::findStructuralSiblings$lambda$5), arg_0 -> YamlPsiUtilKt.findStructuralSiblings$lambda$6(keys, arg_0));
    }

    private static final boolean isValid(YamlMetaType meta, YAMLValue value) {
        ProblemsHolder problemsHolder = new ProblemsHolder(InspectionManager.getInstance((Project)value.getProject()), value.getContainingFile(), false);
        meta.validateValue(value, problemsHolder);
        return !problemsHolder.hasResults();
    }

    @ApiStatus.Experimental
    @Nullable
    public static final YamlMetaType estimatedType(@NotNull YAMLScalar scalar) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)scalar, (String)"scalar");
            Sequence<YamlMetaType> $this$firstOrNull$iv = types;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                YamlMetaType it = (YamlMetaType)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!YamlPsiUtilKt.isValid(it, (YAMLValue)scalar)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public static final PsiElement findClosestAncestorWithoutIndent(@NotNull Document $this$findClosestAncestorWithoutIndent, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)$this$findClosestAncestorWithoutIndent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement current = element;
        while (!YamlPsiUtilKt.isAtStartOfLine($this$findClosestAncestorWithoutIndent, current)) {
            if (current.getParent() != null) continue;
            throw new IllegalStateException("the root of the PSI tree cannot be indented itself".toString());
        }
        return current;
    }

    private static final boolean isAtStartOfLine(Document $this$isAtStartOfLine, PsiElement element) {
        return $this$isAtStartOfLine.getLineStartOffset($this$isAtStartOfLine.getLineNumber(PsiTreeUtilKt.getStartOffset((PsiElement)element))) == PsiTreeUtilKt.getStartOffset((PsiElement)element);
    }

    private static final boolean getKeysInBetween$lambda$0(YAMLSequence $topSeq, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it != $topSeq;
    }

    private static final String getKeysInBetween$lambda$1(YAMLKeyValue it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKeyText();
    }

    private static final YAMLValue findStructuralSiblings$lambda$2(YAMLSequenceItem it) {
        return it.getValue();
    }

    private static final Sequence findStructuralSiblings$collect$lambda$3(List $tail, YAMLKeyValue it) {
        Intrinsics.checkNotNull((Object)it);
        return YamlPsiUtilKt.findStructuralSiblings$collect(it, $tail);
    }

    private static final Sequence findStructuralSiblings$collect$lambda$4(List $tail, YAMLKeyValue it) {
        Intrinsics.checkNotNull((Object)it);
        return YamlPsiUtilKt.findStructuralSiblings$collect(it, $tail);
    }

    private static final Sequence<YAMLPsiElement> findStructuralSiblings$collect(YAMLKeyValue root, List<String> keys) {
        Sequence sequence;
        Pair pair = UtilKt.headTailOrNull(keys);
        if (pair == null) {
            Object[] objectArray = new YAMLKeyValue[]{root};
            return SequencesKt.sequenceOf((Object[])objectArray);
        }
        Pair pair2 = pair;
        String head = (String)pair2.component1();
        List tail = (List)pair2.component2();
        if (!Intrinsics.areEqual((Object)root.getKeyText(), (Object)head)) {
            return SequencesKt.emptySequence();
        }
        YAMLValue v = root.getValue();
        if (v instanceof YAMLSequenceItem) {
            Collection collection = ((YAMLSequenceItem)v).getKeysValues();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getKeysValues(...)");
            sequence = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)collection), arg_0 -> YamlPsiUtilKt.findStructuralSiblings$collect$lambda$3(tail, arg_0));
        } else if (v instanceof YAMLMapping) {
            Collection collection = ((YAMLMapping)v).getKeyValues();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getKeyValues(...)");
            sequence = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)collection), arg_0 -> YamlPsiUtilKt.findStructuralSiblings$collect$lambda$4(tail, arg_0));
        } else {
            sequence = v instanceof YAMLKeyValue ? YamlPsiUtilKt.findStructuralSiblings$collect((YAMLKeyValue)v, tail) : (tail.isEmpty() ? UtilKt.sequenceOfNotNull((Object)v) : SequencesKt.emptySequence());
        }
        return sequence;
    }

    private static final Iterable findStructuralSiblings$lambda$5(YAMLSequenceItem it) {
        Collection collection = it.getKeysValues();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getKeysValues(...)");
        return collection;
    }

    private static final Sequence findStructuralSiblings$lambda$6(List $keys, YAMLKeyValue it) {
        Intrinsics.checkNotNull((Object)it);
        return YamlPsiUtilKt.findStructuralSiblings$collect(it, $keys);
    }

    static {
        Object[] objectArray = new YamlMetaType[]{YamlBooleanType.getSharedInstance(), YamlNumberType.getInstance(false), YamlStringType.getInstance(), YamlAnything.getInstance()};
        types = SequencesKt.sequenceOf((Object[])objectArray);
    }
}

