/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.toolwindow;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsEventLogToolWindow;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.util.text.DateFormatUtil;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import com.jetbrains.fus.reporting.model.lion3.LogEventAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\r\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\nJ\u001a\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002J2\u0010\u000e\u001a\u00020\u00052\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\n2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\nH\u0002J$\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0002J&\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u00012\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogMessageBuilder;", "", "<init>", "()V", "buildLogMessage", "", "logEvent", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "rawEventId", "rawData", "", "formatValue", "rawValue", "validatedValue", "eventDataToString", "eventData", "valueToString", "key", "value", "prepareValue", "shortenAnonymizedId", "anonymizedId", "Companion", "intellij.platform.statistics.devkit"})
@SourceDebugExtension(value={"SMAP\nStatisticsEventLogMessageBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatisticsEventLogMessageBuilder.kt\ncom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogMessageBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,78:1\n1755#2,3:79\n1187#2,2:93\n1261#2,4:95\n1567#2:99\n1598#2,4:100\n1755#2,3:104\n535#3:82\n520#3,6:83\n126#4:89\n153#4,3:90\n*S KotlinDebug\n*F\n+ 1 StatisticsEventLogMessageBuilder.kt\ncom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogMessageBuilder\n*L\n27#1:79,3\n46#1:93,2\n46#1:95,4\n51#1:99\n51#1:100,4\n62#1:104,3\n35#1:82\n35#1:83,6\n36#1:89\n36#1:90,3\n*E\n"})
public final class StatisticsEventLogMessageBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> systemFields;
    @NotNull
    private static final Set<String> fieldsToShorten;
    private static final int anonymizedIdPrefixSize = 8;
    private static final int anonymizedIdSuffixSize = 2;
    private static final int maxProjectIdSize = 10;

    @NotNull
    public final String buildLogMessage(@NotNull LogEvent logEvent, @Nullable String rawEventId, @Nullable Map<String, ? extends Object> rawData) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)logEvent, (String)"logEvent");
        StringBuilder $this$buildLogMessage_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildLogMessage_u24lambda_u240.append(DateFormatUtil.formatTimeWithSeconds((long)logEvent.getTime()));
        LogEventAction event = logEvent.getEvent();
        String groupId = logEvent.getGroup().getId();
        String eventId = this.formatValue(rawEventId, logEvent.getEvent().getId());
        $this$buildLogMessage_u24lambda_u240.append(" - [\"" + groupId + "\", v" + logEvent.getGroup().getVersion() + "]: \"" + eventId + "\" ");
        int count = event.getCount();
        if (!event.getState() && count > 1) {
            $this$buildLogMessage_u24lambda_u240.append("(count=" + count + ") ");
        }
        $this$buildLogMessage_u24lambda_u240.append("{");
        $this$buildLogMessage_u24lambda_u240.append(this.eventDataToString(event.getData(), rawData));
        $this$buildLogMessage_u24lambda_u240.append("}");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String formatValue(String rawValue, String validatedValue) {
        Object object;
        if (rawValue != null) {
            boolean bl;
            block5: {
                Iterable $this$any$iv = StatisticsEventLogToolWindow.Companion.getRejectedValidationTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ValidationResultType it = (ValidationResultType)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getDescription(), (Object)validatedValue)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                object = validatedValue + "[" + rawValue + "]";
                return object;
            }
        }
        object = validatedValue;
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final String eventDataToString(Map<String, ? extends Object> eventData, Map<String, ? extends Object> rawData) {
        void $this$mapTo$iv$iv;
        String key;
        Map.Entry entry;
        Map $this$filterTo$iv$iv;
        Map<String, ? extends Object> $this$filter$iv = eventData;
        boolean $i$f$filter = false;
        Map<String, ? extends Object> map2 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            entry = element$iv$iv = iterator.next();
            boolean bl = false;
            key = (String)entry.getKey();
            if (!(!systemFields.contains(key))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            entry = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            key = (String)entry.getKey();
            Object value = entry.getValue();
            Map<String, ? extends Object> map3 = rawData;
            object.add("\"" + key + "\":" + this.valueToString(key, value, map3 != null ? map3.get(key) : null));
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
    }

    private final String valueToString(String key, Object value, Object rawValue) {
        return new ObjectMapper().writeValueAsString(this.prepareValue(key, value, rawValue));
    }

    /*
     * WARNING - void declaration
     */
    private final Object prepareValue(String key, Object value, Object rawValue) {
        Object object;
        Object object2 = value;
        if (object2 instanceof Map) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = ((Map)value).entrySet();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                Map rawValuesMap = rawValue instanceof Map ? (Map)rawValue : null;
                Object k = it.getKey();
                Object k2 = it.getKey();
                Intrinsics.checkNotNull(k2, (String)"null cannot be cast to non-null type kotlin.String");
                Map map3 = rawValuesMap;
                it = TuplesKt.to(k, (Object)this.prepareValue((String)k2, it.getValue(), map3 != null ? map3.get(it.getKey()) : null));
                map2.put(it.getFirst(), it.getSecond());
            }
            object = destination$iv$iv;
        } else if (object2 instanceof List) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = (Iterable)value;
            boolean $i$f$mapIndexed = false;
            Iterable capacity$iv = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void element;
                List rawValuesList;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object it = item$iv$iv;
                int bl = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                List list = rawValuesList = rawValue instanceof List ? (List)rawValue : null;
                collection.add(this.prepareValue(key, element, list != null ? list.get((int)index) : null));
            }
            object = (List)destination$iv$iv;
        } else if (object2 instanceof String) {
            Object object3 = rawValue;
            object = this.formatValue(object3 != null ? object3.toString() : null, fieldsToShorten.contains(key) ? this.shortenAnonymizedId(((String)value).toString()) : (String)value);
        } else {
            object = value;
        }
        return object;
    }

    private final String shortenAnonymizedId(String anonymizedId) {
        boolean isRejected;
        int length;
        block4: {
            length = anonymizedId.length();
            Iterable $this$any$iv = StatisticsEventLogToolWindow.Companion.getRejectedValidationTypes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ValidationResultType it = (ValidationResultType)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getDescription(), (Object)anonymizedId)) continue;
                    v0 = true;
                    break block4;
                }
                v0 = isRejected = false;
            }
        }
        if (!isRejected && !StringsKt.isBlank((CharSequence)anonymizedId) && length > 10) {
            String string = anonymizedId.substring(0, 8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = anonymizedId.substring(length - 2, length);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return string + "..." + string2;
        }
        return anonymizedId;
    }

    static {
        Object[] objectArray = new String[]{"last", "created", "system_event_id", "system_headless"};
        systemFields = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"project", "file_path", "login_hash", "anonymous_id"};
        fieldsToShorten = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogMessageBuilder$Companion;", "", "<init>", "()V", "systemFields", "", "", "fieldsToShorten", "getFieldsToShorten$intellij_platform_statistics_devkit", "()Ljava/util/Set;", "anonymizedIdPrefixSize", "", "anonymizedIdSuffixSize", "maxProjectIdSize", "intellij.platform.statistics.devkit"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getFieldsToShorten$intellij_platform_statistics_devkit() {
            return fieldsToShorten;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

