/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.settings.state;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterAuthType;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterConfiguredServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterManagedServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.state.JupyterServerSecretState;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/settings/state/JupyterServerSerializer;", "", "<init>", "()V", "MANAGED_VERSION", "", "CONFIGURED_VERSION", "VERSION_FIELD", "", "ID_FIELD", "URL", "NAME_FIELD", "IS_LOCAL", "USE_SYSTEM_PROXY", "ENV_FIELD", "ARGS_FIELD", "WITH_PASSWORD", "AUTH_TYPE", "HUB_USERNAME", "serializeConfigured", "config", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterConfiguredServerConfig;", "deserializeConfigured", "json", "serializeManaged", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterManagedServerConfig;", "deserializeManaged", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterServerSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterServerSerializer.kt\ncom/intellij/jupyter/core/jupyter/connections/settings/state/JupyterServerSerializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,93:1\n1#2:94\n216#3,2:95\n662#4:97\n743#4,4:98\n*S KotlinDebug\n*F\n+ 1 JupyterServerSerializer.kt\ncom/intellij/jupyter/core/jupyter/connections/settings/state/JupyterServerSerializer\n*L\n71#1:95,2\n81#1:97\n81#1:98,4\n*E\n"})
public final class JupyterServerSerializer {
    @NotNull
    public static final JupyterServerSerializer INSTANCE = new JupyterServerSerializer();
    private static final int MANAGED_VERSION = 1;
    private static final int CONFIGURED_VERSION = 1;
    @NotNull
    private static final String VERSION_FIELD = "version";
    @NotNull
    private static final String ID_FIELD = "id";
    @NotNull
    private static final String URL = "url";
    @NotNull
    private static final String NAME_FIELD = "name";
    @NotNull
    private static final String IS_LOCAL = "isLocal";
    @NotNull
    private static final String USE_SYSTEM_PROXY = "useSystemProxy";
    @NotNull
    private static final String ENV_FIELD = "env";
    @NotNull
    private static final String ARGS_FIELD = "args";
    @NotNull
    private static final String WITH_PASSWORD = "password";
    @NotNull
    private static final String AUTH_TYPE = "authType";
    @NotNull
    private static final String HUB_USERNAME = "username";

    private JupyterServerSerializer() {
    }

    @NotNull
    public final String serializeConfigured(@NotNull JupyterConfiguredServerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        ObjectNode json = JupyterJsonKt.getJackson().createObjectNode();
        json.put(VERSION_FIELD, 1);
        json.put(ID_FIELD, config.getId());
        json.put(URL, config.getUri().toString());
        json.put(NAME_FIELD, config.getName());
        json.put(AUTH_TYPE, config.getAuthType().getId());
        json.put(IS_LOCAL, config.isLocal());
        json.put(HUB_USERNAME, config.getUsername());
        json.put(USE_SYSTEM_PROXY, config.getUseSystemProxy());
        String string = json.toPrettyString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toPrettyString(...)");
        return string;
    }

    @NotNull
    public final JupyterConfiguredServerConfig deserializeConfigured(@NotNull String json) {
        URI uRI;
        Object object;
        Object username;
        boolean isLocal;
        Object object2;
        Object name;
        String id;
        JsonNode readTree;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                readTree = JupyterJsonKt.getJackson().readTree(json);
                String string = readTree.get(ID_FIELD).asText();
                if (string == null) {
                    String string2 = UUID.randomUUID().toString();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                }
                id = string;
                Object object3 = readTree.get(NAME_FIELD);
                if (object3 == null || (object3 = object3.asText()) == null) {
                    object3 = name = "Unrecognized";
                }
                if ((object2 = readTree.get(AUTH_TYPE)) == null || (object2 = object2.asText()) == null) break block8;
                Object it = object2;
                boolean bl = false;
                JupyterAuthType jupyterAuthType = JupyterAuthType.Companion.getFor((String)it);
                object2 = jupyterAuthType;
                if (jupyterAuthType != null) break block9;
            }
            object2 = JupyterAuthType.NOTEBOOK;
        }
        Object authType = object2;
        JsonNode jsonNode = readTree.get(IS_LOCAL);
        boolean bl = jsonNode != null ? jsonNode.asBoolean() : (isLocal = false);
        Object object4 = readTree.get(HUB_USERNAME);
        if (object4 == null || (object4 = object4.asText()) == null) {
            object4 = username = "";
        }
        if ((object = readTree.get(URL)) != null && (object = object.asText()) != null) {
            Object it = object;
            boolean bl2 = false;
            uRI = new URI((String)it);
        } else {
            uRI = new URI("");
        }
        URI uri = uRI;
        JsonNode jsonNode2 = readTree.get(USE_SYSTEM_PROXY);
        boolean useSystemProxy = jsonNode2 != null ? jsonNode2.asBoolean() : false;
        return new JupyterConfiguredServerConfig(id, (String)name, uri, (JupyterAuthType)((Object)authType), "", "", (String)username, useSystemProxy, isLocal);
    }

    @NotNull
    public final String serializeManaged(@NotNull JupyterManagedServerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        ObjectNode json = JupyterJsonKt.getJackson().createObjectNode();
        json.put(VERSION_FIELD, 1);
        json.put(ID_FIELD, config.getId());
        json.put(NAME_FIELD, config.getName());
        json.put(ARGS_FIELD, config.getArgv());
        json.put(WITH_PASSWORD, !StringsKt.isBlank((CharSequence)config.getPassword()));
        ObjectNode envNode = json.putObject(ENV_FIELD);
        Map<String, String> $this$forEach$iv = config.getEnvironmentVariables();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            String value = entry.getValue();
            envNode.put(key, value);
        }
        String string = json.toPrettyString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toPrettyString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JupyterManagedServerConfig deserializeManaged(@NotNull String json) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JsonNode readTree = JupyterJsonKt.getJackson().readTree(json);
        String id = readTree.get(ID_FIELD).asText();
        Object object = readTree.get(NAME_FIELD);
        if (object == null || (object = object.asText()) == null) {
            object = JupyterManagedServerConfig.Companion.getCONNECTION_NAME();
        }
        Object name = object;
        Iterator iterator = readTree.get(ENV_FIELD).fields();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"fields(...)");
        Sequence $this$associate$iv = SequencesKt.asSequence((Iterator)iterator);
        boolean $i$f$associate = false;
        Sequence sequence = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getKey(), (Object)((JsonNode)it.getValue()).asText());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map env = destination$iv$iv;
        String args = readTree.get(ARGS_FIELD).asText();
        JsonNode jsonNode = readTree.get(WITH_PASSWORD);
        boolean withPassword = jsonNode != null ? jsonNode.asBoolean(false) : false;
        Intrinsics.checkNotNull((Object)id);
        String string = id;
        Intrinsics.checkNotNull((Object)args);
        String string2 = args;
        JupyterManagedServerConfig config = new JupyterManagedServerConfig(string, (String)name, string2, env, null, 16, null);
        return withPassword ? JupyterServerSecretState.INSTANCE.getUpdateManagedSettings(config) : config;
    }
}

