/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.settings;

import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterConfiguredServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterManagedServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.listeners.JupyterConnectionSettingsListener;
import com.intellij.jupyter.core.jupyter.connections.settings.state.JupyterModuleConfigState;
import com.intellij.jupyter.core.jupyter.connections.settings.state.JupyterServerConfigState;
import com.intellij.jupyter.core.jupyter.connections.settings.state.JupyterServerSecretState;
import com.intellij.jupyter.core.jupyter.connections.settings.state.JupyterVirtualFileConfigState;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.jupyter.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.jupyter.core.premium.JupyterLicence;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 A2\u00020\u0001:\u0001AB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u0010J\u000e\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0011J\u0016\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0011J\u0006\u0010%\u001a\u00020\u0011J\u0018\u0010&\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#2\u0006\u0010'\u001a\u00020\u0010H\u0007J \u0010(\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010)\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0011H\u0007J\u0016\u0010*\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#2\u0006\u0010'\u001a\u00020\u0010J\u0018\u0010+\u001a\u00020\u00112\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\"\u001a\u00020#J\u001a\u0010.\u001a\u0004\u0018\u00010\u00112\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\"\u001a\u00020#J\u0016\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u00020-2\u0006\u0010$\u001a\u00020\u0011J\u0016\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u00020-2\u0006\u0010\u001e\u001a\u00020\u0010J\u000e\u00101\u001a\u00020\u00172\u0006\u00100\u001a\u00020-J\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001003J\u0010\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\u0010J\u0012\u00107\u001a\u0004\u0018\u00010\u00112\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u00108\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0011H\u0002J\u0010\u00109\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0011H\u0002J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\u001cH\u0002J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u0002050\u001cH\u0002J\u0006\u0010=\u001a\u00020>J\u0006\u0010?\u001a\u00020\u0017J\u0006\u0010@\u001a\u00020>R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR'\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006B"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/settings/JupyterConnectionSettingsManager;", "Lcom/intellij/openapi/Disposable$Default;", "<init>", "()V", "notifier", "Lcom/intellij/jupyter/core/jupyter/connections/settings/listeners/JupyterConnectionSettingsListener;", "configStorage", "Lcom/intellij/jupyter/core/jupyter/connections/settings/state/JupyterServerConfigState;", "getConfigStorage", "()Lcom/intellij/jupyter/core/jupyter/connections/settings/state/JupyterServerConfigState;", "jupyterFileConfigStorage", "Lcom/intellij/jupyter/core/jupyter/connections/settings/state/JupyterVirtualFileConfigState;", "getJupyterFileConfigStorage", "()Lcom/intellij/jupyter/core/jupyter/connections/settings/state/JupyterVirtualFileConfigState;", "settings", "", "", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterServerConfig;", "getSettings", "()Ljava/util/Map;", "settings$delegate", "Lkotlin/Lazy;", "addListener", "", "eventListener", "disposable", "Lcom/intellij/openapi/Disposable;", "getAll", "", "getConfig", "configId", "addOrUpdateConfig", "new", "removeConfig", "project", "Lcom/intellij/openapi/project/Project;", "config", "getDefaultConfig", "getConfigForModule", "moduleFilePath", "setConfigForModule", "modulePath", "removeConfigForModule", "getConfigForVirtualFileOrDefault", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getConfigForVirtualFile", "setConfigForFile", "file", "removeConfigForFile", "getKnownAuthorities", "", "getConnectionSettingsForAuthority", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterConfiguredServerConfig;", "authority", "getCachedConfigForVirtualFile", "addInternalConfig", "removeInternalConfig", "loadManaged", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterManagedServerConfig;", "loadConfigured", "isMigrated", "", "setIsMigrated", "isMoreThanOneManaged", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterConnectionSettingsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterConnectionSettingsManager.kt\ncom/intellij/jupyter/core/jupyter/connections/settings/JupyterConnectionSettingsManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n774#2:221\n865#2,2:222\n295#2,2:224\n295#2,2:226\n1557#2:228\n1628#2,3:229\n295#2,2:232\n1557#2:235\n1628#2,3:236\n1202#2,2:239\n1230#2,4:241\n1#3:234\n*S KotlinDebug\n*F\n+ 1 JupyterConnectionSettingsManager.kt\ncom/intellij/jupyter/core/jupyter/connections/settings/JupyterConnectionSettingsManager\n*L\n57#1:221\n57#1:222,2\n100#1:224,2\n101#1:226,2\n162#1:228\n162#1:229,3\n167#1:232,2\n200#1:235\n200#1:236,3\n40#1:239,2\n40#1:241,4\n*E\n"})
public final class JupyterConnectionSettingsManager
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JupyterConnectionSettingsListener notifier = (JupyterConnectionSettingsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(JUPYTER_CONFIGS_TOPIC);
    @NotNull
    private final Lazy settings$delegate = LazyKt.lazy(() -> JupyterConnectionSettingsManager.settings_delegate$lambda$1(this));
    @NotNull
    private static final Topic<JupyterConnectionSettingsListener> JUPYTER_CONFIGS_TOPIC;

    public JupyterConnectionSettingsManager() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            JupyterCoroutineKt.launchBackground((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ JupyterConnectionSettingsManager this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.this$0.getSettings();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
    }

    private final JupyterServerConfigState getConfigStorage() {
        return JupyterServerConfigState.Companion.getInstance();
    }

    private final JupyterVirtualFileConfigState getJupyterFileConfigStorage() {
        return JupyterVirtualFileConfigState.Companion.getInstance();
    }

    private final Map<String, JupyterServerConfig> getSettings() {
        Lazy lazy = this.settings$delegate;
        return (Map)lazy.getValue();
    }

    public final void addListener(@NotNull JupyterConnectionSettingsListener eventListener, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)eventListener, (String)"eventListener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        ApplicationManager.getApplication().getMessageBus().connect(disposable).subscribe(JUPYTER_CONFIGS_TOPIC, (Object)eventListener);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<JupyterServerConfig> getAll() {
        void $this$filterTo$iv$iv;
        boolean isPaid = JupyterLicence.INSTANCE.isPaidVersion();
        Iterable $this$filter$iv = CollectionsKt.toList((Iterable)this.getSettings().values());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JupyterServerConfig it = (JupyterServerConfig)element$iv$iv;
            boolean bl = false;
            if (!(isPaid || it instanceof JupyterManagedServerConfig)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List serverConfigs = (List)destination$iv$iv;
        return serverConfigs;
    }

    @Nullable
    public final JupyterServerConfig getConfig(@NotNull String configId) {
        Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
        return this.getSettings().get(configId);
    }

    public final void addOrUpdateConfig(@NotNull JupyterServerConfig jupyterServerConfig) {
        Intrinsics.checkNotNullParameter((Object)jupyterServerConfig, (String)"new");
        JupyterServerConfig old = this.getConfig(jupyterServerConfig.getId());
        if (Intrinsics.areEqual((Object)old, (Object)jupyterServerConfig)) {
            return;
        }
        if (old != null) {
            this.removeInternalConfig(old);
            this.addInternalConfig(jupyterServerConfig);
            this.notifier.connectionUpdated(old, jupyterServerConfig);
        } else {
            this.addInternalConfig(jupyterServerConfig);
            this.notifier.connectionAdded(jupyterServerConfig);
        }
        JupyterCoroutineKt.launchEdt((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Application application = ApplicationManager.getApplication();
                        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
                        this.label = 1;
                        Object object3 = StoreUtilKt.saveSettings((ComponentManager)((ComponentManager)application), (boolean)true, (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public final void removeConfig(@NotNull Project project, @NotNull JupyterServerConfig config) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.removeInternalConfig(config);
        JupyterModuleConfigState.Companion.getInstance(project).clearConfig(config.getId());
        this.getJupyterFileConfigStorage().clearConfig(config.getId());
        this.notifier.connectionRemoved(config);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            JupyterCoroutineKt.launchEdt((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, null){
                Object L$0;
                int label;
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = this.$project;
                            $i$f$runInAutoSaveDisabledMode = false;
                            var4_6 = (AutoCloseable)SaveAndSyncHandler.Companion.getInstance().disableAutoSave();
                            var5_7 = null;
                            (AccessToken)var4_6;
                            $i$a$-use-StoreUtilKt$runInAutoSaveDisabledMode$1$iv = false;
                            $i$a$-runInAutoSaveDisabledMode-JupyterConnectionSettingsManager$removeConfig$1$1 = false;
                            this.L$0 = var4_6;
                            this.label = 1;
                            v0 = StoreUtilKt.saveSettings$default((ComponentManager)((ComponentManager)var2_3), (boolean)false, (Continuation)this, (int)2, null);
                            ** if (v0 != var9_2) goto lbl20
lbl19:
                            // 1 sources

                            return var9_2;
lbl20:
                            // 1 sources

                            ** GOTO lbl31
                        }
                        case 1: {
                            $i$f$runInAutoSaveDisabledMode = false;
                            $i$a$-use-StoreUtilKt$runInAutoSaveDisabledMode$1$iv = false;
                            $i$a$-runInAutoSaveDisabledMode-JupyterConnectionSettingsManager$removeConfig$1$1 = false;
                            var5_7 = null;
                            var4_6 = (AutoCloseable)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl31:
                                // 2 sources

                                var8_14 = Unit.INSTANCE;
                                ** GOTO lbl41
                            }
                            catch (Throwable var6_10) {
                                var5_7 = var6_10;
                                throw var6_10;
                            }
                        }
                        catch (Throwable var6_11) {
                            throw var6_11;
                        }
                        {
                            finally {
                                AutoCloseableKt.closeFinally((AutoCloseable)var4_6, (Throwable)var5_7);
                            }
lbl41:
                            // 1 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
    }

    @NotNull
    public final JupyterServerConfig getDefaultConfig() {
        JupyterServerConfig jupyterServerConfig;
        Object v0;
        block4: {
            Iterable $this$firstOrNull$iv = this.getSettings().values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JupyterServerConfig it = (JupyterServerConfig)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)JupyterManagedServerConfig.Companion.getDEFAULT().getId())) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        if ((jupyterServerConfig = (JupyterServerConfig)v0) == null) {
            Object v2;
            block5: {
                Iterable $this$firstOrNull$iv = this.getSettings().values();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    JupyterServerConfig it = (JupyterServerConfig)element$iv;
                    boolean bl = false;
                    if (!(it instanceof JupyterManagedServerConfig)) continue;
                    v2 = element$iv;
                    break block5;
                }
                v2 = null;
            }
            if ((jupyterServerConfig = (JupyterServerConfig)v2) == null && (jupyterServerConfig = (JupyterServerConfig)CollectionsKt.firstOrNull((Iterable)this.getSettings().values())) == null) {
                jupyterServerConfig = JupyterManagedServerConfig.Companion.getDEFAULT();
            }
        }
        return jupyterServerConfig;
    }

    @VisibleForTesting
    @NotNull
    public final JupyterServerConfig getConfigForModule(@NotNull Project project, @NotNull String moduleFilePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleFilePath, (String)"moduleFilePath");
        String string = JupyterModuleConfigState.Companion.getInstance(project).getModuleConfig(moduleFilePath);
        if (string == null) {
            return this.getDefaultConfig();
        }
        String savedConfigId = string;
        JupyterServerConfig jupyterServerConfig = this.getConfig(savedConfigId);
        if (jupyterServerConfig == null) {
            jupyterServerConfig = this.getDefaultConfig();
        }
        JupyterServerConfig config = jupyterServerConfig;
        return config;
    }

    @VisibleForTesting
    public final void setConfigForModule(@NotNull Project project, @NotNull String modulePath, @NotNull JupyterServerConfig config) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        JupyterModuleConfigState.Companion.getInstance(project).registerModuleConfig(modulePath, config.getId());
    }

    @NotNull
    public final JupyterServerConfig removeConfigForModule(@NotNull Project project, @NotNull String moduleFilePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleFilePath, (String)"moduleFilePath");
        JupyterModuleConfigState moduleConfigState = JupyterModuleConfigState.Companion.getInstance(project);
        String string = moduleConfigState.getModuleConfig(moduleFilePath);
        if (string == null) {
            return this.getDefaultConfig();
        }
        String savedConfigId = string;
        JupyterServerConfig jupyterServerConfig = this.getConfig(savedConfigId);
        if (jupyterServerConfig == null) {
            jupyterServerConfig = this.getDefaultConfig();
        }
        JupyterServerConfig config = jupyterServerConfig;
        return config;
    }

    @NotNull
    public final JupyterServerConfig getConfigForVirtualFileOrDefault(@Nullable VirtualFile virtualFile2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JupyterServerConfig jupyterServerConfig = this.getConfigForVirtualFile(virtualFile2, project);
        if (jupyterServerConfig == null) {
            jupyterServerConfig = this.getDefaultConfig();
        }
        return jupyterServerConfig;
    }

    @Nullable
    public final JupyterServerConfig getConfigForVirtualFile(@Nullable VirtualFile virtualFile2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (virtualFile2 == null) {
            return null;
        }
        if (virtualFile2 instanceof JupyterRemoteVirtualFile) {
            String authority = ((JupyterRemoteVirtualFile)virtualFile2).getRemotePath().getAuthority();
            return this.getConnectionSettingsForAuthority(authority);
        }
        JupyterServerConfig cachedConfig = this.getCachedConfigForVirtualFile(virtualFile2);
        if (cachedConfig != null) {
            return cachedConfig;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile2, (Project)project);
        if (module == null) {
            return null;
        }
        Module module2 = module;
        String string = module2.getModuleFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getModuleFilePath(...)");
        return this.getConfigForModule(project, string);
    }

    public final void setConfigForFile(@NotNull VirtualFile file, @NotNull JupyterServerConfig config) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.setConfigForFile(file, config.getId());
    }

    public final void setConfigForFile(@NotNull VirtualFile file, @NotNull String configId) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
        this.getJupyterFileConfigStorage().registerFileConfig(file, configId);
    }

    public final void removeConfigForFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.getJupyterFileConfigStorage().removeFileConfig(file);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<String> getKnownAuthorities() {
        void $this$mapTo$iv$iv;
        boolean isPaid = JupyterLicence.INSTANCE.isPaidVersion();
        if (!isPaid) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = this.getConfigStorage().getAllConfigured();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JupyterConfiguredServerConfig jupyterConfiguredServerConfig = (JupyterConfiguredServerConfig)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final JupyterConfiguredServerConfig getConnectionSettingsForAuthority(@NotNull String authority) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
            Iterable $this$firstOrNull$iv = this.getSettings().values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JupyterServerConfig it = (JupyterServerConfig)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getAuthority(), (Object)authority)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Object var2_8 = v0;
        return var2_8 instanceof JupyterConfiguredServerConfig ? (JupyterConfiguredServerConfig)var2_8 : null;
    }

    private final JupyterServerConfig getCachedConfigForVirtualFile(VirtualFile virtualFile2) {
        JupyterServerConfig jupyterServerConfig;
        JupyterServerConfig config;
        String string = this.getJupyterFileConfigStorage().getFileConfig(virtualFile2);
        if (string == null) {
            return null;
        }
        String fileConfigId = string;
        JupyterServerConfig jupyterServerConfig2 = config = this.getConfig(fileConfigId);
        if (jupyterServerConfig2 != null) {
            JupyterServerConfig jupyterServerConfig3;
            JupyterServerConfig it = jupyterServerConfig3 = jupyterServerConfig2;
            boolean bl = false;
            jupyterServerConfig = !Intrinsics.areEqual((Object)it, (Object)this.getDefaultConfig()) ? jupyterServerConfig3 : null;
        } else {
            jupyterServerConfig = null;
        }
        return jupyterServerConfig;
    }

    private final void addInternalConfig(JupyterServerConfig config) {
        Object object = config;
        if (object instanceof JupyterConfiguredServerConfig) {
            this.getConfigStorage().addConfigured((JupyterConfiguredServerConfig)config);
            JupyterServerSecretState.INSTANCE.saveConfiguredSettings((JupyterConfiguredServerConfig)config);
        } else if (object instanceof JupyterManagedServerConfig) {
            this.getConfigStorage().addManaged((JupyterManagedServerConfig)config);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        object = this.getSettings();
        Pair pair = TuplesKt.to((Object)config.getId(), (Object)config);
        object.put(pair.getFirst(), pair.getSecond());
    }

    private final void removeInternalConfig(JupyterServerConfig config) {
        this.getSettings().remove(config.getId());
        JupyterServerSecretState.INSTANCE.removeConfiguredSecret(config);
        JupyterServerConfig jupyterServerConfig = config;
        if (jupyterServerConfig instanceof JupyterConfiguredServerConfig) {
            this.getConfigStorage().removeConfigured((JupyterConfiguredServerConfig)config);
        } else if (jupyterServerConfig instanceof JupyterManagedServerConfig) {
            this.getConfigStorage().removeManaged((JupyterManagedServerConfig)config);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final List<JupyterManagedServerConfig> loadManaged() {
        Collection collection;
        Collection collection2 = this.getConfigStorage().getAllManaged();
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = CollectionsKt.listOf((Object)JupyterManagedServerConfig.Companion.getDEFAULT());
        } else {
            collection = collection2;
        }
        return (List)collection;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JupyterConfiguredServerConfig> loadConfigured() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getConfigStorage().getAllConfigured();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JupyterConfiguredServerConfig jupyterConfiguredServerConfig = (JupyterConfiguredServerConfig)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JupyterServerSecretState.INSTANCE.getUpdateConfiguredSettings((JupyterConfiguredServerConfig)it));
        }
        return (List)destination$iv$iv;
    }

    public final boolean isMigrated() {
        return this.getConfigStorage().isMigrated();
    }

    public final void setIsMigrated() {
        this.getConfigStorage().setMigrated(true);
    }

    public final boolean isMoreThanOneManaged() {
        return Companion.getInstance().getConfigStorage().getManagedSize() >= 2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map settings_delegate$lambda$1(JupyterConnectionSettingsManager this$0) {
        void $this$associateByTo$iv$iv;
        List allConfigs = CollectionsKt.plus((Collection)this$0.loadManaged(), (Iterable)this$0.loadConfigured());
        if (allConfigs.isEmpty()) {
            allConfigs = CollectionsKt.listOf((Object)JupyterManagedServerConfig.Companion.getDEFAULT());
        }
        Iterable $this$associateBy$iv = allConfigs;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            JupyterServerConfig jupyterServerConfig = (JupyterServerConfig)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getId(), element$iv$iv);
        }
        return MapsKt.toMutableMap((Map)destination$iv$iv);
    }

    static {
        Topic topic = Topic.create((String)JupyterConnectionSettingsListener.class.getCanonicalName(), JupyterConnectionSettingsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"create(...)");
        JUPYTER_CONFIGS_TOPIC = topic;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/settings/JupyterConnectionSettingsManager$Companion;", "", "<init>", "()V", "JUPYTER_CONFIGS_TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/jupyter/core/jupyter/connections/settings/listeners/JupyterConnectionSettingsListener;", "getJUPYTER_CONFIGS_TOPIC", "()Lcom/intellij/util/messages/Topic;", "getInstance", "Lcom/intellij/jupyter/core/jupyter/connections/settings/JupyterConnectionSettingsManager;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterConnectionSettingsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterConnectionSettingsManager.kt\ncom/intellij/jupyter/core/jupyter/connections/settings/JupyterConnectionSettingsManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,220:1\n31#2,2:221\n*S KotlinDebug\n*F\n+ 1 JupyterConnectionSettingsManager.kt\ncom/intellij/jupyter/core/jupyter/connections/settings/JupyterConnectionSettingsManager$Companion\n*L\n218#1:221,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Topic<JupyterConnectionSettingsListener> getJUPYTER_CONFIGS_TOPIC() {
            return JUPYTER_CONFIGS_TOPIC;
        }

        @NotNull
        public final JupyterConnectionSettingsManager getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<JupyterConnectionSettingsManager> serviceClass$iv = JupyterConnectionSettingsManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (JupyterConnectionSettingsManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

