/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.features.history;

import com.intellij.filePrediction.features.history.NextFileProbability;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0004R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/filePrediction/features/history/FilePredictionNGramFeatures;", "", "byFile", "", "", "", "<init>", "(Ljava/util/Map;)V", "minProbability", "maxProbability", "calculateFileFeatures", "Lcom/intellij/filePrediction/features/history/NextFileProbability;", "fileUrl", "intellij.platform.ml.impl"})
@ApiStatus.Internal
public final class FilePredictionNGramFeatures {
    @NotNull
    private final Map<String, Double> byFile;
    private final double minProbability;
    private final double maxProbability;

    public FilePredictionNGramFeatures(@NotNull Map<String, Double> byFile) {
        Intrinsics.checkNotNullParameter(byFile, (String)"byFile");
        this.byFile = byFile;
        double minProb = 1.0;
        double maxProb = 0.0;
        Iterator<Double> iterator = this.byFile.values().iterator();
        while (iterator.hasNext()) {
            double nGram = ((Number)iterator.next()).doubleValue();
            minProb = Math.min(minProb, nGram);
            maxProb = Math.max(maxProb, nGram);
        }
        this.minProbability = Math.max(minProb, 1.0E-4);
        this.maxProbability = Math.max(maxProb, 1.0E-4);
    }

    @Nullable
    public final NextFileProbability calculateFileFeatures(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Double probability = this.byFile.get(fileUrl);
        if (probability == null) {
            return null;
        }
        double mleToMin = !(this.minProbability == 0.0) ? probability / this.minProbability : 0.0;
        double mleToMax = !(this.maxProbability == 0.0) ? probability / this.maxProbability : 0.0;
        return new NextFileProbability(probability, this.minProbability, this.maxProbability, mleToMin, mleToMax);
    }
}

