/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.style;

public class Length {
    public static final int MAX_WIDTH = 0x3FFFFFFF;
    public static final int VARIABLE = 1;
    public static final int FIXED = 2;
    public static final int PERCENT = 3;
    private int _type = 1;
    private long _value = 0L;

    public Length() {
    }

    public Length(long value2, int type2) {
        this._value = value2;
        this._type = type2;
    }

    public void setValue(long value2) {
        this._value = value2;
    }

    public long value() {
        return this._value;
    }

    public void setType(int type2) {
        this._type = type2;
    }

    public int type() {
        return this._type;
    }

    public boolean isVariable() {
        return this._type == 1;
    }

    public boolean isFixed() {
        return this._type == 2;
    }

    public boolean isPercent() {
        return this._type == 3;
    }

    public long width(int maxWidth) {
        switch (this._type) {
            case 2: {
                return this._value;
            }
            case 3: {
                return (long)maxWidth * this._value / 100L;
            }
            case 1: {
                return maxWidth;
            }
        }
        return -1L;
    }

    public long minWidth(int maxWidth) {
        switch (this._type) {
            case 2: {
                return this._value;
            }
            case 3: {
                return (long)maxWidth * this._value / 100L;
            }
        }
        return 0L;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append("(type=");
        switch (this._type) {
            case 2: {
                result2.append("fixed");
                break;
            }
            case 3: {
                result2.append("percent");
                break;
            }
            case 1: {
                result2.append("variable");
                break;
            }
            default: {
                result2.append("unknown");
            }
        }
        result2.append(", value=");
        result2.append(this._value);
        result2.append(")");
        return result2.toString();
    }
}

