/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.search;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@com.intellij.openapi.components.State(name="ImageTags", storages={@Storage(value="imageTags.xml")})
public class ImageTagManager
implements PersistentStateComponent<State> {
    private State myState = new State();

    public static ImageTagManager getInstance(Project project) {
        return (ImageTagManager)project.getService(ImageTagManager.class);
    }

    public boolean hasTag(String tag, VirtualFile file) {
        State.Files files = this.myState.myTags.get(tag);
        return files != null && files.contains(file.getPath());
    }

    public void addTag(String tag, VirtualFile file) {
        State.Files files = this.myState.myTags.get(tag);
        if (files == null) {
            files = new State.Files();
            this.myState.myTags.put(tag, files);
        }
        files.add(file.getPath());
    }

    public void removeTag(String tag, VirtualFile file) {
        State.Files files = this.myState.myTags.get(tag);
        if (files != null) {
            files.remove(file.getPath());
        }
    }

    public @Unmodifiable List<String> getTags(VirtualFile file) {
        return ContainerUtil.filter(this.myState.myTags.keySet(), tag -> this.hasTag((String)tag, file));
    }

    public List<String> getAllTags() {
        return new ArrayList<String>(this.myState.myTags.keySet());
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            ImageTagManager.$$$reportNull$$$0(0);
        }
        this.myState = state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/intellij/images/search/ImageTagManager", "loadState"));
    }

    public static class State {
        @Property(surroundWithTag=false)
        @MapAnnotation(surroundKeyWithTag=false, surroundWithTag=false, entryTagName="tag", keyAttributeName="name", valueAttributeName="values")
        public final Map<@NlsSafe String, Files> myTags = new LinkedHashMap<String, Files>();

        @Property(surroundWithTag=false)
        @Tag(value="files")
        public static class Files {
            @Property(surroundWithTag=false)
            @XCollection(elementName="file", valueAttributeName="path")
            public final Set<String> myFiles = new LinkedHashSet<String>();

            public void remove(String path) {
                this.myFiles.remove(path);
            }

            public void add(String path) {
                this.myFiles.add(path);
            }

            public boolean contains(String path) {
                return this.myFiles.contains(path);
            }
        }
    }
}

