/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.internal.markup;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.platform.internal.DumpAction;
import com.jetbrains.rd.platform.internal.RdInternalShowTextDiffManager;
import com.jetbrains.rd.platform.internal.TextDiffPresentationData;
import com.jetbrains.rdclient.daemon.util.HighlighterTestUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdclient/internal/markup/CompareBackendAndFrontendHighlighterTrees;", "Lcom/jetbrains/rd/platform/internal/DumpAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.rd.client"})
public final class CompareBackendAndFrontendHighlighterTrees
extends DumpAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        String frontendTree = HighlighterTestUtilKt.getFrontendDump(editor2, true);
        String backendTree = HighlighterTestUtilKt.getBackendDumpSync$default(editor2, true, null, 4, null);
        TextDiffPresentationData highlighters = new TextDiffPresentationData("Backend Tree", backendTree);
        TextDiffPresentationData foldings = new TextDiffPresentationData("Frontend Tree", frontendTree);
        RdInternalShowTextDiffManager.INSTANCE.showDiff(project2, "Compare Backend vs Frontend Trees", highlighters, foldings);
    }
}

