// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A container for filter information for the selection of S3 objects encrypted with Amazon Web Services KMS.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct SseKmsEncryptedObjects {
    /// <p>Specifies whether Amazon S3 replicates objects created with server-side encryption using an Amazon Web Services KMS key stored in Amazon Web Services Key Management Service.</p>
    pub status: crate::types::SseKmsEncryptedObjectsStatus,
}
impl SseKmsEncryptedObjects {
    /// <p>Specifies whether Amazon S3 replicates objects created with server-side encryption using an Amazon Web Services KMS key stored in Amazon Web Services Key Management Service.</p>
    pub fn status(&self) -> &crate::types::SseKmsEncryptedObjectsStatus {
        &self.status
    }
}
impl SseKmsEncryptedObjects {
    /// Creates a new builder-style object to manufacture [`SseKmsEncryptedObjects`](crate::types::SseKmsEncryptedObjects).
    pub fn builder() -> crate::types::builders::SseKmsEncryptedObjectsBuilder {
        crate::types::builders::SseKmsEncryptedObjectsBuilder::default()
    }
}

/// A builder for [`SseKmsEncryptedObjects`](crate::types::SseKmsEncryptedObjects).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct SseKmsEncryptedObjectsBuilder {
    pub(crate) status: ::std::option::Option<crate::types::SseKmsEncryptedObjectsStatus>,
}
impl SseKmsEncryptedObjectsBuilder {
    /// <p>Specifies whether Amazon S3 replicates objects created with server-side encryption using an Amazon Web Services KMS key stored in Amazon Web Services Key Management Service.</p>
    /// This field is required.
    pub fn status(mut self, input: crate::types::SseKmsEncryptedObjectsStatus) -> Self {
        self.status = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies whether Amazon S3 replicates objects created with server-side encryption using an Amazon Web Services KMS key stored in Amazon Web Services Key Management Service.</p>
    pub fn set_status(mut self, input: ::std::option::Option<crate::types::SseKmsEncryptedObjectsStatus>) -> Self {
        self.status = input;
        self
    }
    /// <p>Specifies whether Amazon S3 replicates objects created with server-side encryption using an Amazon Web Services KMS key stored in Amazon Web Services Key Management Service.</p>
    pub fn get_status(&self) -> &::std::option::Option<crate::types::SseKmsEncryptedObjectsStatus> {
        &self.status
    }
    /// Consumes the builder and constructs a [`SseKmsEncryptedObjects`](crate::types::SseKmsEncryptedObjects).
    /// This method will fail if any of the following fields are not set:
    /// - [`status`](crate::types::builders::SseKmsEncryptedObjectsBuilder::status)
    pub fn build(self) -> ::std::result::Result<crate::types::SseKmsEncryptedObjects, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::SseKmsEncryptedObjects {
            status: self.status.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "status",
                    "status was not specified but it is required when building SseKmsEncryptedObjects",
                )
            })?,
        })
    }
}
