/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.Zip;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkLoadBehaviour;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkPredicate;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunk;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkSPLT;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkTextVar;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkUNKNOWN;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020$J&\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010#\u001a\u00020$J\u001a\u0010(\u001a\u00020$2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010*J\"\u0010,\u001a\b\u0012\u0004\u0012\u00020*0-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020*0-2\u0006\u0010/\u001a\u000200J\u0018\u00101\u001a\u00020\u00042\b\u00102\u001a\u0004\u0018\u00010\n2\u0006\u0010%\u001a\u00020&J\u000e\u00103\u001a\u00020$2\u0006\u00104\u001a\u00020\u0004J\u000e\u00105\u001a\u00020$2\u0006\u00104\u001a\u00020\u0004J\u000e\u00106\u001a\u00020$2\u0006\u00104\u001a\u00020\u0004J\u0010\u00107\u001a\u00020$2\b\u00108\u001a\u0004\u0018\u00010*J\u000e\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020\nJ\u0016\u0010;\u001a\u00020$2\u0006\u00104\u001a\u00020\u00042\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020\n2\u0006\u0010?\u001a\u00020\u0004J\u000e\u0010@\u001a\u00020\n2\u0006\u0010?\u001a\u00020\u0004J\u000e\u0010A\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\nJ\u001e\u0010A\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\n2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&J\u000e\u0010B\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\nJ\u001e\u0010B\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\n2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&J\u001c\u0010C\u001a\u00020&2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020*0D2\u0006\u0010E\u001a\u000200R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkHelper;", "", "()V", "IDAT", "", "IEND", "IHDR", "PLTE", "bKGD", "b_IDAT", "", "getB_IDAT", "()[B", "b_IEND", "getB_IEND", "b_IHDR", "getB_IHDR", "b_PLTE", "getB_PLTE", "cHRM", "gAMA", "hIST", "iCCP", "iTXt", "pHYs", "sBIT", "sPLT", "sRGB", "tEXt", "tIME", "tRNS", "tmpbuffer", "zTXt", "compressBytes", "ori", "compress", "", "offset", "", "len", "equivalent", "c1", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk;", "c2", "filterList", "", "target", "predicateKeep", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkPredicate;", "idFromBytes", "buf", "isCritical", "id", "isPublic", "isSafeToCopy", "isUnknown", "c", "posNullByte", "b", "shouldLoad", "behav", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkLoadBehaviour;", "toBytesLatin1", "x", "toBytesUTF8", "toStringLatin1", "toStringUTF8", "trimList", "", "predicateRemove", "plot-api"})
public final class ChunkHelper {
    @NotNull
    public static final ChunkHelper INSTANCE = new ChunkHelper();
    @NotNull
    public static final String IHDR = "IHDR";
    @NotNull
    public static final String PLTE = "PLTE";
    @NotNull
    public static final String IDAT = "IDAT";
    @NotNull
    public static final String IEND = "IEND";
    @NotNull
    public static final String cHRM = "cHRM";
    @NotNull
    public static final String gAMA = "gAMA";
    @NotNull
    public static final String iCCP = "iCCP";
    @NotNull
    public static final String sBIT = "sBIT";
    @NotNull
    public static final String sRGB = "sRGB";
    @NotNull
    public static final String bKGD = "bKGD";
    @NotNull
    public static final String hIST = "hIST";
    @NotNull
    public static final String tRNS = "tRNS";
    @NotNull
    public static final String pHYs = "pHYs";
    @NotNull
    public static final String sPLT = "sPLT";
    @NotNull
    public static final String tIME = "tIME";
    @NotNull
    public static final String iTXt = "iTXt";
    @NotNull
    public static final String tEXt = "tEXt";
    @NotNull
    public static final String zTXt = "zTXt";
    @NotNull
    private static final byte[] b_IHDR = INSTANCE.toBytesLatin1("IHDR");
    @NotNull
    private static final byte[] b_PLTE = INSTANCE.toBytesLatin1("PLTE");
    @NotNull
    private static final byte[] b_IDAT = INSTANCE.toBytesLatin1("IDAT");
    @NotNull
    private static final byte[] b_IEND = INSTANCE.toBytesLatin1("IEND");
    @NotNull
    private static final byte[] tmpbuffer = new byte[4096];

    private ChunkHelper() {
    }

    @NotNull
    public final byte[] getB_IHDR() {
        return b_IHDR;
    }

    @NotNull
    public final byte[] getB_PLTE() {
        return b_PLTE;
    }

    @NotNull
    public final byte[] getB_IDAT() {
        return b_IDAT;
    }

    @NotNull
    public final byte[] getB_IEND() {
        return b_IEND;
    }

    @NotNull
    public final byte[] toBytesLatin1(@NotNull String x2) {
        Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
        return StringsKt.encodeToByteArray((String)x2);
    }

    @NotNull
    public final String toStringLatin1(@NotNull byte[] x2) {
        Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
        return StringsKt.decodeToString((byte[])x2);
    }

    @NotNull
    public final String toStringLatin1(@NotNull byte[] x2, int offset2, int len) {
        Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
        return StringsKt.decodeToString$default((byte[])x2, (int)offset2, (int)(offset2 + len), (boolean)false, (int)4, null);
    }

    @NotNull
    public final byte[] toBytesUTF8(@NotNull String x2) {
        Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
        return StringsKt.encodeToByteArray((String)x2);
    }

    @NotNull
    public final String toStringUTF8(@NotNull byte[] x2) {
        Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
        return StringsKt.decodeToString((byte[])x2);
    }

    @NotNull
    public final String toStringUTF8(@NotNull byte[] x2, int offset2, int len) {
        Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
        return StringsKt.decodeToString$default((byte[])x2, (int)offset2, (int)(offset2 + len), (boolean)false, (int)4, null);
    }

    public final boolean isCritical(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return Character.isUpperCase(id.charAt(0));
    }

    public final boolean isPublic(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return Character.isUpperCase(id.charAt(1));
    }

    public final boolean isSafeToCopy(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return !Character.isUpperCase(id.charAt(3));
    }

    public final boolean isUnknown(@Nullable PngChunk c) {
        return c instanceof PngChunkUNKNOWN;
    }

    public final int posNullByte(@NotNull byte[] b2) {
        Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
        int n = b2.length;
        for (int i = 0; i < n; ++i) {
            if (b2[i] != 0) continue;
            return i;
        }
        return -1;
    }

    public final boolean shouldLoad(@NotNull String id, @NotNull ChunkLoadBehaviour behav) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)((Object)behav), (String)"behav");
        if (this.isCritical(id)) {
            return true;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[behav.ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = this.isSafeToCopy(id);
                break;
            }
            case 3: {
                bl = false;
                break;
            }
            case 4: {
                bl = Intrinsics.areEqual((Object)id, (Object)tRNS);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    public final byte[] compressBytes(@NotNull byte[] ori, boolean compress) {
        Intrinsics.checkNotNullParameter((Object)ori, (String)"ori");
        return this.compressBytes(ori, 0, ori.length, compress);
    }

    @NotNull
    public final byte[] compressBytes(@NotNull byte[] ori, int offset2, int len, boolean compress) {
        Intrinsics.checkNotNullParameter((Object)ori, (String)"ori");
        return Zip.INSTANCE.compressBytes(ori, offset2, len, compress);
    }

    @NotNull
    public final List<PngChunk> filterList(@NotNull List<? extends PngChunk> target, @NotNull ChunkPredicate predicateKeep) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)predicateKeep, (String)"predicateKeep");
        List result2 = new ArrayList();
        for (PngChunk pngChunk : target) {
            if (!predicateKeep.match(pngChunk)) continue;
            result2.add(pngChunk);
        }
        return result2;
    }

    public final int trimList(@NotNull List<PngChunk> target, @NotNull ChunkPredicate predicateRemove) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)predicateRemove, (String)"predicateRemove");
        Iterator<PngChunk> it = target.iterator();
        int cont = 0;
        while (it.hasNext()) {
            PngChunk c = it.next();
            if (!predicateRemove.match(c)) continue;
            it.remove();
            ++cont;
        }
        return cont;
    }

    public final boolean equivalent(@Nullable PngChunk c1, @Nullable PngChunk c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null || !Intrinsics.areEqual((Object)c1.getId(), (Object)c2.getId())) {
            return false;
        }
        if (c1.getCrit()) {
            return false;
        }
        if (c1.getClass() != c2.getClass()) {
            return false;
        }
        if (!c2.allowsMultiple()) {
            return true;
        }
        if (c1 instanceof PngChunkTextVar) {
            return StringsKt.equals$default((String)((PngChunkTextVar)c1).getKey(), (String)((PngChunkTextVar)c2).getKey(), (boolean)false, (int)2, null);
        }
        return c1 instanceof PngChunkSPLT ? StringsKt.equals$default((String)((PngChunkSPLT)c1).getPalName(), (String)((PngChunkSPLT)c2).getPalName(), (boolean)false, (int)2, null) : false;
    }

    @NotNull
    public final String idFromBytes(@Nullable byte[] buf, int offset2) {
        return buf == null || buf.length < 4 + offset2 ? "?" : this.toStringLatin1(buf, offset2, 4);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChunkLoadBehaviour.values().length];
            try {
                nArray[ChunkLoadBehaviour.LOAD_CHUNK_ALWAYS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChunkLoadBehaviour.LOAD_CHUNK_IF_SAFE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChunkLoadBehaviour.LOAD_CHUNK_NEVER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChunkLoadBehaviour.LOAD_CHUNK_MOST_IMPORTANT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

