/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchDialogKeys;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class StructuralSearchTemplatesCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        String prefix;
        Boolean test;
        StructuralSearchDialog dialog;
        if (parameters == null) {
            StructuralSearchTemplatesCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            StructuralSearchTemplatesCompletionContributor.$$$reportNull$$$0(1);
        }
        if (!((dialog = (StructuralSearchDialog)((Object)parameters.getEditor().getUserData(StructuralSearchDialogKeys.STRUCTURAL_SEARCH_DIALOG))) != null || (test = (Boolean)parameters.getEditor().getUserData(StructuralSearchDialogKeys.TEST_STRUCTURAL_SEARCH_DIALOG)) != null && test.booleanValue())) {
            return;
        }
        Document document = parameters.getEditor().getDocument();
        int end = parameters.getOffset();
        int line = document.getLineNumber(end);
        int start2 = document.getLineStartOffset(line);
        String shortPrefix = TextFieldWithAutoCompletionListProvider.getCompletionPrefix((CompletionParameters)parameters);
        CharSequence text = document.getCharsSequence();
        if (StringUtil.startsWithChar((CharSequence)shortPrefix, (char)'$')) {
            shortPrefix = shortPrefix.substring(1);
            LinkedHashSet variableNames = TemplateImplUtil.parseVariableNames((CharSequence)text);
            for (String name : variableNames) {
                if (!name.startsWith(shortPrefix) || name.equals(shortPrefix)) continue;
                result.addElement((LookupElement)LookupElementBuilder.create((String)("$" + name + "$")).withInsertHandler((context, item) -> {
                    char c;
                    int offset = context.getTailOffset();
                    if (text.length() > offset + 1 && (c = text.charAt(offset)) == '$') {
                        document.deleteString(offset, offset + 1);
                    }
                }));
            }
        }
        String string = prefix = parameters.isExtendedCompletion() ? shortPrefix : text.subSequence(start2, end).toString();
        if (StringUtil.containsChar((String)prefix, (char)'$')) {
            return;
        }
        result.runRemainingContributors(parameters, cr -> {
            if (cr.getLookupElement().getObject() instanceof String) {
                return;
            }
            result.passResult(cr);
        });
        CompletionResultSet insensitive = result.withPrefixMatcher((PrefixMatcher)new CamelHumpMatcher(prefix));
        ConfigurationManager configurationManager = ConfigurationManager.getInstance(parameters.getPosition().getProject());
        for (Configuration configuration : configurationManager.getAllConfigurations()) {
            LookupElementBuilder element = LookupElementBuilder.create((Object)configuration, (String)configuration.getMatchOptions().getSearchPattern()).withLookupString(configuration.getName()).withTypeText(configuration.getTypeText(), true).withIcon(configuration.getIcon()).withCaseSensitivity(false).withPresentableText(configuration.getName());
            if (dialog != null) {
                element = element.withInsertHandler((context, item) -> context.setLaterRunnable(() -> dialog.loadConfiguration((Configuration)item.getObject())));
            }
            insensitive.addElement((LookupElement)element);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchTemplatesCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

