/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.template.lang.core.templateLanguages.TemplateContextProvider;
import com.intellij.util.ObjectUtils;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.DjangoFunctionParams;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.python.FunctionParameter;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TemplateParametersEvaluator {
    private static final Set<String> TEMPLATE_METHODS_FIRST_ARG = Sets.newHashSet((Object[])new String[]{"get_template", "load_template", "load_template_source", "find_template", "find_template_source", "render_to_string", "inclusion_tag"});
    private static final Set<String> TEMPLATE_METHODS_SECOND_ARG = Sets.newHashSet((Object[])new String[]{"direct_to_template", "render", "TemplateResponse", "SimpleTemplateResponse"});

    private TemplateParametersEvaluator() {
    }

    public static boolean isRenderDecorator(@NotNull PyCallExpression call) {
        PyDecorator decorator;
        if (call == null) {
            TemplateParametersEvaluator.$$$reportNull$$$0(0);
        }
        PyDecorator pyDecorator = decorator = call instanceof PyDecorator ? (PyDecorator)call : (PyDecorator)ObjectUtils.tryCast((Object)call.getParent(), PyDecorator.class);
        if (decorator == null) {
            return false;
        }
        String name = decorator.getName();
        return name != null && name.contains("render");
    }

    @NotNull
    public static Collection<LookupElement> getTemplateContext(PsiFile template) {
        HashMap result = Maps.newHashMap();
        for (TemplateContextProvider provider : TemplateContextProvider.EP_NAME.getExtensionList()) {
            Collection<LookupElement> params = provider.getTemplateContext(template);
            if (params == null) continue;
            for (LookupElement el : params) {
                result.put(el.getLookupString(), el);
            }
        }
        Collection<LookupElement> collection = result.values();
        if (collection == null) {
            TemplateParametersEvaluator.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Nullable
    private static String getCalleeName(@NotNull PyCallExpression call) {
        PyExpression callee;
        if (call == null) {
            TemplateParametersEvaluator.$$$reportNull$$$0(2);
        }
        if ((callee = call.getCallee()) == null) {
            return null;
        }
        return callee.getName();
    }

    public static boolean isDirectMethod(@NotNull PyCallExpression call) {
        if (call == null) {
            TemplateParametersEvaluator.$$$reportNull$$$0(3);
        }
        return "direct_to_template".equals(TemplateParametersEvaluator.getCalleeName(call));
    }

    public static boolean isShortcutsRender(@NotNull PyCallExpression call) {
        if (call == null) {
            TemplateParametersEvaluator.$$$reportNull$$$0(4);
        }
        return "render".equals(TemplateParametersEvaluator.getCalleeName(call));
    }

    public static boolean isTemplateValueInRenderDecorated(PyStringLiteralExpression strLiteral) {
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)strLiteral, PyFunction.class);
        if (function == null) {
            return false;
        }
        PyDecoratorList decoratorList = function.getDecoratorList();
        if (decoratorList != null) {
            PyDecorator[] decorators = decoratorList.getDecorators();
            boolean flag = false;
            for (PyDecorator decorator : decorators) {
                if (!TemplateParametersEvaluator.isRenderDecorator((PyCallExpression)decorator)) continue;
                flag = true;
            }
            if (flag) {
                return TemplateParametersEvaluator.isTemplateDictValue(strLiteral, "TEMPLATE");
            }
            return false;
        }
        return false;
    }

    public static boolean isTemplateDictValue(PyStringLiteralExpression strLiteral, String ... keyNames) {
        PyDictLiteralExpression dict = (PyDictLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)strLiteral, PyDictLiteralExpression.class);
        if (dict != null) {
            for (PyKeyValueExpression exp : dict.getElements()) {
                String val = PyPsiUtils.getStringValue((PsiElement)exp.getKey());
                for (String key : keyNames) {
                    if (!key.equals(val)) continue;
                    return strLiteral == exp.getValue();
                }
            }
        }
        return false;
    }

    public static boolean isTemplateNameArg(PyStringLiteralExpression strLiteral) {
        PyCallExpression asViewCall = NameResolverTools.findCallExpParent((PsiElement)strLiteral, (FQNamesProvider)DjangoFQNamesProvider.TEMPLATE_AS_VIEW_FUNCTION);
        if (asViewCall == null) {
            return false;
        }
        return strLiteral.equals(asViewCall.getArgument((FunctionParameter)DjangoFunctionParams.AS_VIEW_TEMPLATE_NAME, PyStringLiteralExpression.class));
    }

    public static boolean isTemplateNameInViewClass(NavigatablePsiElement strLiteral) {
        if (!(strLiteral instanceof PyStringLiteralExpression)) {
            return false;
        }
        PyClass cls = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)strLiteral, PyClass.class);
        if (cls == null) {
            return false;
        }
        if (!DjangoPsiUtil.isTemplateResponseClass(cls)) {
            return false;
        }
        PyAssignmentStatement assignment = (PyAssignmentStatement)ObjectUtils.tryCast((Object)strLiteral.getParent(), PyAssignmentStatement.class);
        return assignment != null && assignment.isAssignmentTo("template_name");
    }

    static boolean isTemplateMethod(@NotNull String name, int argument) {
        if (name == null) {
            TemplateParametersEvaluator.$$$reportNull$$$0(5);
        }
        if (argument < 0 || argument > 1) {
            return false;
        }
        return (argument == 0 ? TEMPLATE_METHODS_FIRST_ARG : TEMPLATE_METHODS_SECOND_ARG).contains(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/TemplateParametersEvaluator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/TemplateParametersEvaluator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isRenderDecorator";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCalleeName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDirectMethod";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isShortcutsRender";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

