/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.multiselection;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.internal.texteditor.multiselection.AbstractMultiSelectionHandler;

public class MultiCaretDownHandler
extends AbstractMultiSelectionHandler {
    @Override
    public void execute() throws ExecutionException {
        if (this.selectionIsAboveAnchorRegion()) {
            this.removeFirstRegionFromSelection();
        } else {
            this.extendSelectionWithSamePositionInNextLine();
        }
    }

    private void extendSelectionWithSamePositionInNextLine() throws ExecutionException {
        IRegion[] regions = this.getSelectedRegions();
        if (regions == null || regions.length == 0) {
            return;
        }
        try {
            IRegion lastRegion = regions[regions.length - 1];
            int newOffset = this.offsetInNextLine(lastRegion.getOffset());
            IRegion nextLineRegion = this.createRegionIfValid(newOffset, lastRegion.getLength());
            this.selectRegions(this.addRegion(regions, nextLineRegion));
        }
        catch (BadLocationException e) {
            throw new ExecutionException("Internal error in extendSelectionWithSamePositionInNextLine", (Throwable)e);
        }
    }

    private void removeFirstRegionFromSelection() {
        this.selectRegions(this.removeFirstRegionButOne(this.getSelectedRegions()));
    }
}

