# Copyright (C) Internet Systems Consortium, Inc. ("ISC")
#
# SPDX-License-Identifier: MPL-2.0
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0.  If a copy of the MPL was not distributed with this
# file, you can obtain one at https://mozilla.org/MPL/2.0/.
#
# See the COPYRIGHT file distributed with this work for additional
# information regarding copyright ownership.

import pytest

import isctest.mark

pytestmark = pytest.mark.extra_artifacts(
    [
        "active.key",
        "activate-now-publish-1day.key",
        "autoksk.key",
        "autozsk.key",
        "del*.key",
        "delayksk.key",
        "delayzsk.key",
        "delzsk.key",
        "dig.out.*",
        "dsset-.",
        "dsset-bar.",
        "dsset-delay.example.",
        "inact.key",
        "inaczsk-ksk.key",
        "inaczsk-zsk.key",
        "noksk-ksk.key",
        "nopriv.key",
        "nozsk-ksk.key",
        "nozsk-zsk.key",
        "nsupdate.out*",
        "prepub.key",
        "rev.key",
        "settime.out.*",
        "signing.*out*",
        "standby.key",
        "sync.key",
        "unpub.key",
        "vanishing.key",
        "*/K*",
        "*/dsset-*",
        "*/*.signed",
        "*/*.jnl",
        "*/*.bk",
        "ns*/_default.nzf*",
        "ns*/_default.nzd*",
        "ns1/root.db",
        "ns1/signing.out",
        "ns1/trusted.conf",
        "ns2/bar.db",
        "ns2/child.nsec3.example.db",
        "ns2/child.optout.example.db",
        "ns2/dsset-dname-at-apex-nsec3.example.",
        "ns2/dsset-example.",
        "ns2/dsset-nsec3-to-nsec.example.",
        "ns2/dsset-nsec3.example.",
        "ns2/dsset-oldsigs.example.",
        "ns2/dsset-optout.example.",
        "ns2/dsset-private.secure.example.",
        "ns2/dsset-rsasha256.example.",
        "ns2/dsset-rsasha512.example.",
        "ns2/dsset-secure.example.",
        "ns2/example.db",
        "ns2/insecure.secure.example.db",
        "ns2/nsec3-with-ent.db",
        "ns2/optout-with-ent.db",
        "ns2/private.conf",
        "ns2/private.secure.example.db",
        "ns2/trusted.conf",
        "ns3/autonsec3.example.db",
        "ns3/cdnskey-delete.example.db",
        "ns3/cds-delete.example.db",
        "ns3/delzsk.example.db",
        "ns3/dname-at-apex-nsec3.example.db",
        "ns3/dsset-autonsec3.example.",
        "ns3/dsset-dname-at-apex-nsec3.example.",
        "ns3/dsset-inaczsk.example.",
        "ns3/dsset-inaczsk2.example.",
        "ns3/dsset-kskonly.example.",
        "ns3/dsset-noksk.example.",
        "ns3/dsset-nozsk.example.",
        "ns3/dsset-nsec-only.example.",
        "ns3/dsset-nsec3-to-nsec.example.",
        "ns3/dsset-nsec3-to-nsec3.example.",
        "ns3/dsset-nsec3.example.",
        "ns3/dsset-nsec3.nsec3.example.",
        "ns3/dsset-nsec3.optout.example.",
        "ns3/dsset-oldsigs.example.",
        "ns3/dsset-optout.example.",
        "ns3/dsset-optout.nsec3.example.",
        "ns3/dsset-optout.optout.example.",
        "ns3/dsset-prepub.example.",
        "ns3/dsset-rsasha256.example.",
        "ns3/dsset-rsasha512.example.",
        "ns3/dsset-secure.example.",
        "ns3/dsset-secure.nsec3.example.",
        "ns3/dsset-secure.optout.example.",
        "ns3/dsset-sync.example.",
        "ns3/inacksk2.example.db",
        "ns3/inacksk3.example.db",
        "ns3/inaczsk.example.db",
        "ns3/inaczsk2.example.db",
        "ns3/inaczsk3.example.db",
        "ns3/jitter.nsec3.example.db",
        "ns3/kg.out",
        "ns3/kskonly.example.db",
        "ns3/noksk.example.db",
        "ns3/nozsk.example.db",
        "ns3/nsec-only.example.db",
        "ns3/nsec3-to-nsec.example.db",
        "ns3/nsec3-to-nsec3.example.db",
        "ns3/nsec3.example.db",
        "ns3/nsec3.nsec3.example.db",
        "ns3/nsec3.optout.example.db",
        "ns3/oldsigs.example.db",
        "ns3/optout.example.db",
        "ns3/optout.nsec3.example.db",
        "ns3/optout.optout.example.db",
        "ns3/prepub.example.db",
        "ns3/prepub.example.db.in",
        "ns3/reconf.example.db",
        "ns3/rsasha256.example.db",
        "ns3/rsasha512.example.db",
        "ns3/s.out",
        "ns3/secure.example.db",
        "ns3/secure.nsec3.example.db",
        "ns3/secure.optout.example.db",
        "ns3/secure-to-insecure.example.db",
        "ns3/secure-to-insecure2.example.db",
        "ns3/st.out",
        "ns3/sync.example.db",
        "ns3/trusted.conf",
        "ns3/ttl1.example.db",
        "ns3/ttl2.example.db",
        "ns3/ttl3.example.db",
        "ns3/ttl4.example.db",
        "ns4/private.conf",
        "ns4/trusted.conf",
        "ns5/trusted.conf",
    ]
)


@isctest.mark.flaky(max_runs=2)
def test_autosign(run_tests_sh):
    run_tests_sh()
