/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 58361894790615L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1879150590 + -16587, 1879150590 + 23699, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1879150590 + -16588, -1879150590 + -17137, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 78573061502422L;
                thread = Thread.currentThread();
                String string = SshAgentIpcService.A();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (string != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-929810580 - -((char)-30776), 929810580 - (char)-26508, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-929810580 - -((char)-30775), 929810580 - 26494, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-929810580 - -((char)-30778), 929810580 - 30401, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                String string;
                l2 = 135798640099992L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    string = SshAgentIpcService.A();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(-364112460 + -((char)-29385), 364112460 + (char)-29193, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-364112460 + -((char)-29386), -364112460 + -17163, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-364112460 + -((char)-29387), -364112460 + -((char)-30897), (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (string != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-364112460 + -((char)-29372), -364112460 + -((char)-31427), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-364112460 + -((char)-29373), 364112460 + (char)-27880, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-364112460 + -((char)-29374), 364112460 + 6994, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-364112460 + -((char)-29372), -364112460 + -((char)-31427), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-364112460 + -((char)-29375), -364112460 + -22895, (int)l2));
            if (ActionTimestamp.A() == null) {
                SshAgentIpcService.A("lBdkNc");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String string;
                block6: {
                    long l2 = 58867563492491L;
                    string = SshAgentIpcService.A();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (string != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (string != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String string;
        long l2;
        block27: {
            block28: {
                l2 = 50131022430897L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            string = SshAgentIpcService.A();
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (string != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-164230710 - -((char)-365), -164099640 + -((char)-29668), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-164230710 - -((char)-369), -164099640 + -((char)-1686), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-164230710 - -((char)-366), 164230710 - (char)-387, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(-164230710 - -((char)-369), -164099640 + -((char)-1686), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-164230710 - -((char)-363), 164099640 + (char)-6627, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-164230710 - -((char)-365), -164099640 + -((char)-29668), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-164230710 - -((char)-369), -164099640 + -((char)-1686), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-164230710 - -((char)-364), 164099640 + (char)-13477, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (string != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-164230710 - -((char)-365), -164099640 + -((char)-29668), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-164230710 - -((char)-369), -164099640 + -((char)-1686), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-164230710 - -((char)-393), 164099640 + (char)-12998, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-164230710 - -((char)-369), -164099640 + -((char)-1686), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-164230710 - -((char)-394), -164099640 + -((char)-12624), (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (string != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string3 = WindowsNamedPipeAgentIpc.b(-164230710 - -((char)-369), -164099640 + -((char)-1686), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-164230710 - -((char)-363), 164099640 + (char)-6627, (int)l2) + this.state;
                throw new IllegalArgumentException(string3.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-164230710 - -((char)-365), -164099640 + -((char)-29668), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-164230710 - -((char)-369), -164099640 + -((char)-1686), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-164230710 - -((char)-391), -164099640 + -((char)-2015), (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 121803768830824L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-1503635040 + -((char)-21194), 1503635040 + (char)-27026, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 39036296288745L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-661510290 - -((char)-14468), -661510290 - -((char)-20166), (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00ed\u00a4\u00dd\u0085\fIv6X\u00fc\u00d1@\u008e\u008d\u00a1A\u0083|\u00f2\u0014:\u00b2'AH\u0013\u0083\u00f8d#\u0093o\u0004\u00911I|\u00bb\n\\";
                        var4_3 = "\u00ed\u00a4\u00dd\u0085\fIv6X\u00fc\u00d1@\u008e\u008d\u00a1A\u0083|\u00f2\u0014:\u00b2'AH\u0013\u0083\u00f8d#\u0093o\u0004\u00911I|\u00bb\n\\".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 126;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 11;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 72;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 100;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 41;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 125;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 125;
                                        break;
                                    }
                                    default: {
                                        v11 = 63;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x3702) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 115;
                            case 1 -> 72;
                            case 2 -> 125;
                            case 3 -> 182;
                            case 4 -> 205;
                            case 5 -> 107;
                            case 6 -> 168;
                            case 7 -> 116;
                            case 8 -> 79;
                            case 9 -> 61;
                            case 10 -> 109;
                            case 11 -> 136;
                            case 12 -> 170;
                            case 13 -> 146;
                            case 14 -> 247;
                            case 15 -> 4;
                            case 16 -> 67;
                            case 17 -> 35;
                            case 18 -> 199;
                            case 19 -> 172;
                            case 20 -> 142;
                            case 21 -> 81;
                            case 22 -> 58;
                            case 23 -> 47;
                            case 24 -> 159;
                            case 25 -> 102;
                            case 26 -> 74;
                            case 27 -> 91;
                            case 28 -> 150;
                            case 29 -> 126;
                            case 30 -> 253;
                            case 31 -> 215;
                            case 32 -> 230;
                            case 33 -> 154;
                            case 34 -> 227;
                            case 35 -> 140;
                            case 36 -> 113;
                            case 37 -> 108;
                            case 38 -> 121;
                            case 39 -> 96;
                            case 40 -> 137;
                            case 41 -> 40;
                            case 42 -> 12;
                            case 43 -> 19;
                            case 44 -> 235;
                            case 45 -> 250;
                            case 46 -> 56;
                            case 47 -> 54;
                            case 48 -> 188;
                            case 49 -> 222;
                            case 50 -> 42;
                            case 51 -> 252;
                            case 52 -> 145;
                            case 53 -> 127;
                            case 54 -> 26;
                            case 55 -> 89;
                            case 56 -> 240;
                            case 57 -> 2;
                            case 58 -> 85;
                            case 59 -> 190;
                            case 60 -> 152;
                            case 61 -> 3;
                            case 62 -> 37;
                            case 63 -> 20;
                            case 64 -> 178;
                            case 65 -> 220;
                            case 66 -> 76;
                            case 67 -> 13;
                            case 68 -> 213;
                            case 69 -> 211;
                            case 70 -> 7;
                            case 71 -> 59;
                            case 72 -> 147;
                            case 73 -> 38;
                            case 74 -> 112;
                            case 75 -> 143;
                            case 76 -> 86;
                            case 77 -> 68;
                            case 78 -> 155;
                            case 79 -> 32;
                            case 80 -> 45;
                            case 81 -> 66;
                            case 82 -> 239;
                            case 83 -> 166;
                            case 84 -> 149;
                            case 85 -> 33;
                            case 86 -> 52;
                            case 87 -> 245;
                            case 88 -> 255;
                            case 89 -> 218;
                            case 90 -> 238;
                            case 91 -> 39;
                            case 92 -> 48;
                            case 93 -> 138;
                            case 94 -> 16;
                            case 95 -> 88;
                            case 96 -> 129;
                            case 97 -> 1;
                            case 98 -> 36;
                            case 99 -> 203;
                            case 100 -> 219;
                            case 101 -> 169;
                            case 102 -> 151;
                            case 103 -> 216;
                            case 104 -> 6;
                            case 105 -> 123;
                            case 106 -> 69;
                            case 107 -> 246;
                            case 108 -> 9;
                            case 109 -> 223;
                            case 110 -> 196;
                            case 111 -> 171;
                            case 112 -> 114;
                            case 113 -> 212;
                            case 114 -> 110;
                            case 115 -> 55;
                            case 116 -> 65;
                            case 117 -> 103;
                            case 118 -> 164;
                            case 119 -> 70;
                            case 120 -> 49;
                            case 121 -> 244;
                            case 122 -> 226;
                            case 123 -> 183;
                            case 124 -> 231;
                            case 125 -> 117;
                            case 126 -> 43;
                            case 127 -> 101;
                            case 128 -> 232;
                            case 129 -> 195;
                            case 130 -> 100;
                            case 131 -> 128;
                            case 132 -> 224;
                            case 133 -> 73;
                            case 134 -> 221;
                            case 135 -> 201;
                            case 136 -> 27;
                            case 137 -> 118;
                            case 138 -> 25;
                            case 139 -> 133;
                            case 140 -> 234;
                            case 141 -> 63;
                            case 142 -> 122;
                            case 143 -> 179;
                            case 144 -> 237;
                            case 145 -> 242;
                            case 146 -> 95;
                            case 147 -> 132;
                            case 148 -> 254;
                            case 149 -> 105;
                            case 150 -> 228;
                            case 151 -> 10;
                            case 152 -> 176;
                            case 153 -> 139;
                            case 154 -> 87;
                            case 155 -> 191;
                            case 156 -> 53;
                            case 157 -> 46;
                            case 158 -> 158;
                            case 159 -> 243;
                            case 160 -> 198;
                            case 161 -> 148;
                            case 162 -> 157;
                            case 163 -> 75;
                            case 164 -> 173;
                            case 165 -> 156;
                            case 166 -> 225;
                            case 167 -> 98;
                            case 168 -> 62;
                            case 169 -> 187;
                            case 170 -> 208;
                            case 171 -> 34;
                            case 172 -> 130;
                            case 173 -> 174;
                            case 174 -> 5;
                            case 175 -> 209;
                            case 176 -> 14;
                            case 177 -> 185;
                            case 178 -> 134;
                            case 179 -> 92;
                            case 180 -> 233;
                            case 181 -> 177;
                            case 182 -> 181;
                            case 183 -> 120;
                            case 184 -> 28;
                            case 185 -> 194;
                            case 186 -> 8;
                            case 187 -> 160;
                            case 188 -> 119;
                            case 189 -> 189;
                            case 190 -> 94;
                            case 191 -> 131;
                            case 192 -> 22;
                            case 193 -> 210;
                            case 194 -> 111;
                            case 195 -> 31;
                            case 196 -> 24;
                            case 197 -> 97;
                            case 198 -> 161;
                            case 199 -> 144;
                            case 200 -> 77;
                            case 201 -> 206;
                            case 202 -> 41;
                            case 203 -> 30;
                            case 204 -> 93;
                            case 205 -> 15;
                            case 206 -> 184;
                            case 207 -> 21;
                            case 208 -> 214;
                            case 209 -> 57;
                            case 210 -> 51;
                            case 211 -> 207;
                            case 212 -> 193;
                            case 213 -> 11;
                            case 214 -> 186;
                            case 215 -> 165;
                            case 216 -> 83;
                            case 217 -> 18;
                            case 218 -> 192;
                            case 219 -> 251;
                            case 220 -> 197;
                            case 221 -> 162;
                            case 222 -> 163;
                            case 223 -> 50;
                            case 224 -> 202;
                            case 225 -> 229;
                            case 226 -> 60;
                            case 227 -> 0;
                            case 228 -> 71;
                            case 229 -> 124;
                            case 230 -> 64;
                            case 231 -> 106;
                            case 232 -> 82;
                            case 233 -> 90;
                            case 234 -> 204;
                            case 235 -> 241;
                            case 236 -> 17;
                            case 237 -> 84;
                            case 238 -> 104;
                            case 239 -> 141;
                            case 240 -> 29;
                            case 241 -> 175;
                            case 242 -> 78;
                            case 243 -> 249;
                            case 244 -> 180;
                            case 245 -> 236;
                            case 246 -> 135;
                            case 247 -> 44;
                            case 248 -> 23;
                            case 249 -> 217;
                            case 250 -> 153;
                            case 251 -> 248;
                            case 252 -> 99;
                            case 253 -> 167;
                            case 254 -> 200;
                            default -> 80;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (string != null) {
                ActionTimestamp.A(new ActionTimestamp[1]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 89668841863672L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String string = SshAgentIpcService.A();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (string != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1485416310 - (char)-2974, 1485416310 - (char)-8047, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1485416310 - (char)-2970, 1485416310 - (char)-929, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1485416310 - (char)-2965, -1485416310 - -((char)-22619), (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1485416310 - (char)-2974, 1485416310 - (char)-8047, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1485416310 - (char)-2970, 1485416310 - (char)-929, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1485416310 - (char)-2966, -1485416310 - -((char)-6046), (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String string2;
                    block13: {
                        long l2 = 134719539591830L;
                        String string3 = SshAgentIpcService.A();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(699651660 - (char)-6679, -699520590 + -((char)-7900), (int)l2));
                        string2 = string3;
                        try {
                            try {
                                try {
                                    try {
                                        if (string2 != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string4 = object.toString();
                                string = string4;
                                object = string4;
                                if (string2 != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(699651660 - (char)-6676, 699520590 + (char)-13109, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (string2 != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String string;
        long l2;
        block25: {
            block26: {
                l2 = 135275300347228L;
                String string2 = SshAgentIpcService.A();
                this.assertConnectionThread();
                string = string2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (string != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (string != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1010418630 - -23414, -1010418630 - -((char)-23033), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1010418630 - -23418, -1010418630 - -21369, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1010418630 - -23409, -1010418630 - -27620, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string3 = WindowsNamedPipeAgentIpc.b(-1010418630 - -23418, -1010418630 - -21369, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1010418630 - -23416, 1010418630 - (char)-32754, (int)l2) + this.state;
                        throw new IllegalArgumentException(string3.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1010418630 - -23414, -1010418630 - -((char)-23033), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1010418630 - -23418, -1010418630 - -21369, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1010418630 - -23402, -1010418630 - -29001, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (string != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1010418630 - -23414, -1010418630 - -((char)-23033), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1010418630 - -23418, -1010418630 - -21369, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1010418630 - -23403, -1010418630 - -21312, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (string != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1010418630 - -23414, -1010418630 - -((char)-23033), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1010418630 - -23418, -1010418630 - -21369, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1010418630 - -23404, 1010418630 - (char)-16086, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String string;
                block16: {
                    l2 = 104421271930668L;
                    Object object = this.lock;
                    string = SshAgentIpcService.A();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (string != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2026997550 + -((char)-21742), -2026997550 + -((char)-16223), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-2026997550 + -((char)-21746), -2026997550 + -((char)-23793), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2026997550 + -((char)-21765), -2026997550 + -((char)-29489), (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-2026997550 + -((char)-21758), 2026997550 + (char)-5895, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2026997550 + -((char)-21742), -2026997550 + -((char)-16223), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-2026997550 + -((char)-21746), -2026997550 + -((char)-23793), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2026997550 + -((char)-21759), 2026997550 + (char)-26910, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (string != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (string != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2026997550 + -((char)-21742), -2026997550 + -((char)-16223), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-2026997550 + -((char)-21746), -2026997550 + -((char)-23793), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2026997550 + -((char)-21760), 2026997550 + 31725, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2026997550 + -((char)-21742), -2026997550 + -((char)-16223), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-2026997550 + -((char)-21746), -2026997550 + -((char)-23793), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2026997550 + -((char)-21761), -2026997550 + -((char)-16148), (int)l2));
                    if (string != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2026997550 + -((char)-21742), -2026997550 + -((char)-16223), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-2026997550 + -((char)-21746), -2026997550 + -((char)-23793), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2026997550 + -((char)-21786), 2026997550 + (char)-4163, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-2026997550 + -((char)-21787), 2026997550 + (char)-10824, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00d5\"D\u00b2\u00eb\u00a2x\"\u0014\u00cb\u00d9\u00bf*j9\u00e7K\u00a6l\f\u00ed\u0016\u001f\u000b\u0086d\u00d7\u00fd&\u0006\u008cqo\u00d8\u00e4\u00ae\u0018\u00f8X\u00b9*(\u00fc\u00ad3'\u001e3\u00d3\u0097'i\u0003\u0081\u000eo\u0080{)/!\t\u001a^{[\u001bM\u00d3M\u00d4\u0005(\u00fd\u00fbIl\b\u0097\u0007\fg\u00b0>\u0015S\u0014\u00ef:C\u00cd\u0098\u00cd\u008cB\u00a5\u0090\u00c7\u00c6%\u00d9\u00d6\u00b3\u00cd\u00a21\u00ca\u0005,}{Y|\u001e/[\u000e\u00f9OB\u00e3\u009eK\u00bf\u00f5`\u0003qY\u00adfJA\u00fc\u0012\u0089\u000e\u00f8N\u00da\n#\\\u0005\u0010,\u00ca\u008a\u000e\u0088\u008e\u00ed\u00fe\u00f7\u0001\u00efJFa^0\t\u0000P\u00ee\u008b\u00fap\u00c9uy\u0010\u00f9v0\u0099\u00df|\u0007\u00a0\u00aa\u00caD33N\u00f0\u00d5?\u00f6\u00ea=\u00cf$\u008d\u000b\u000b'\u00dc=\u00f7\u00a5u\u00b0\u0014\u009e\u0018#s\u00d0*-\u00ea:p\u0089\u00c2\u001bo\u0014lm\u008e\u00ce\u00e2\u0095G\u0016\u0086\u0011P\u00bb\u0091\u00e6\u00c6]S\"\u00a2\u00dd\u008a\u0006c!\u0017\u00ad\u00a4\u0015?a\u0093\u00c0\b~\u008517\u00174\u00e1\u0012\f\u0017\u0005\f<\u00ad7Xuh8NiFfi\"\u00b1h\u0086\u00e0C\u007f\u00f2\u00a6\u00f4@\u001d\u0013?\u0016\u001a2\u009c\u00e0\u0085(-\u00ac\u00a3\u00a8\u00b3\u0080h]\u00b0x\u00a3\u00aefC\u009ag\u00f9\u00ac\u00aa\u00875\u00bf\u00d7\"\f*\u00b1\u00baB\u0005\u00ecW\u00fd\u00fc\u008d\u00a9\u00a6\u00c5\u00c9\b\u0080\u00f7D\u00b0D`\u0082\u001f\u00f54U\u0014$\u00ff\u008e)\u00e6I@\u00be\u00b5\u00b7\u0084\u00c4\u00a6\u008f$\u008euG5\u008aHD\u00dd<\u00bb\u00178\u000b\u0010\u00e4\u00ec\u0000\u00b1\u00b0\u00db\u0085\u0018*J\u0015}\u00eaA\u00c2\u0003\u0080a\u00feq\u00a5\u00af\u00e8\u00f6\u00d1\u00f1^\u00f3HS\u000f\u00ad)\u00ab\u00a5\u009e&]\u00b9\u00a1\u00e1\u0003P\u00fc\u009d&\u00d9h\fd\u001e\u00a7\u001b\u00f5\u008d\u00e3\u00cb\u00fd%\u00bch\u00b8i\u00da\u00aev\u00c5\t'\u00a9\u00af\u00b1\u00f6\u00d5\u0007\u00dbT\u009a\u0002\u00f9`\u00ae\u0007\u00cf\u00ee|9\u00c2\u00e8\u00df(\u00f4%9\u0017\u0019\u00f5\u00dfO\u00bcR!\u00eb\u00be\u00969fI\u00fe\u00acD\u00f5X\u008c\u00ba\u0080\u00b7\u00a5A\u00ac,\u0083\u001f\u00a6\u0098\u008d!\u0083\u0012g\u00b2\u000f\u00b8\u00b8\u00fe\u008d\t\u00caxk=[\u00b0\u009b,\u00cc\u00f5\"z\u001f\u00a4q\u001aSI\u00bc\u001e\u00fb_\u00e8Q{\u00e2\u0096\u00dedz\u0016\u00a4,i\u00af?\u00fd)\u00ad.\u00e3\u00aa\u00f8V\u00fc\u000e=\u00adN/\u001f\u009e\u00ba\u00e1e\n\u00bb\u00b1A\u0083\u001bP%\u00e4;\u00b1\u00a9\u00fa[:\u00da\u00dd\u00aa\u00dd\u00d6U5\u0080\u00ba\fQQ\u00f0\u00a4\u0092\u00cd7\"\n\u00bc\u00ef\u00bde\u008e\u0086\u00ce\u0094\u0017A\u0018\u00c0\u00d4\u00f6\b\u00f2s\u00b3^\r\u00b3\u00f9\u0018\u00e0\u00d3\u000e\u00b4\u009c\u008bX\u000e\u00a3P\u00a1\u00d5)s5\u00854>\u00fb\u00cd\u00a9\u008eYM\u00bc\u0014\u00f4\u00b1\u00d2!\u00b0\u00d0\u000b!\u009f0\u0085\u00f2~\u00c0\u00efd\u00c5\u00fa\u00aaW\u009b\u00f8xI`\u00ad\u000fV\t\u00a2}\u00ba0z\u00c8\u008f9\f";
                var4_3 = "\u00d5\"D\u00b2\u00eb\u00a2x\"\u0014\u00cb\u00d9\u00bf*j9\u00e7K\u00a6l\f\u00ed\u0016\u001f\u000b\u0086d\u00d7\u00fd&\u0006\u008cqo\u00d8\u00e4\u00ae\u0018\u00f8X\u00b9*(\u00fc\u00ad3'\u001e3\u00d3\u0097'i\u0003\u0081\u000eo\u0080{)/!\t\u001a^{[\u001bM\u00d3M\u00d4\u0005(\u00fd\u00fbIl\b\u0097\u0007\fg\u00b0>\u0015S\u0014\u00ef:C\u00cd\u0098\u00cd\u008cB\u00a5\u0090\u00c7\u00c6%\u00d9\u00d6\u00b3\u00cd\u00a21\u00ca\u0005,}{Y|\u001e/[\u000e\u00f9OB\u00e3\u009eK\u00bf\u00f5`\u0003qY\u00adfJA\u00fc\u0012\u0089\u000e\u00f8N\u00da\n#\\\u0005\u0010,\u00ca\u008a\u000e\u0088\u008e\u00ed\u00fe\u00f7\u0001\u00efJFa^0\t\u0000P\u00ee\u008b\u00fap\u00c9uy\u0010\u00f9v0\u0099\u00df|\u0007\u00a0\u00aa\u00caD33N\u00f0\u00d5?\u00f6\u00ea=\u00cf$\u008d\u000b\u000b'\u00dc=\u00f7\u00a5u\u00b0\u0014\u009e\u0018#s\u00d0*-\u00ea:p\u0089\u00c2\u001bo\u0014lm\u008e\u00ce\u00e2\u0095G\u0016\u0086\u0011P\u00bb\u0091\u00e6\u00c6]S\"\u00a2\u00dd\u008a\u0006c!\u0017\u00ad\u00a4\u0015?a\u0093\u00c0\b~\u008517\u00174\u00e1\u0012\f\u0017\u0005\f<\u00ad7Xuh8NiFfi\"\u00b1h\u0086\u00e0C\u007f\u00f2\u00a6\u00f4@\u001d\u0013?\u0016\u001a2\u009c\u00e0\u0085(-\u00ac\u00a3\u00a8\u00b3\u0080h]\u00b0x\u00a3\u00aefC\u009ag\u00f9\u00ac\u00aa\u00875\u00bf\u00d7\"\f*\u00b1\u00baB\u0005\u00ecW\u00fd\u00fc\u008d\u00a9\u00a6\u00c5\u00c9\b\u0080\u00f7D\u00b0D`\u0082\u001f\u00f54U\u0014$\u00ff\u008e)\u00e6I@\u00be\u00b5\u00b7\u0084\u00c4\u00a6\u008f$\u008euG5\u008aHD\u00dd<\u00bb\u00178\u000b\u0010\u00e4\u00ec\u0000\u00b1\u00b0\u00db\u0085\u0018*J\u0015}\u00eaA\u00c2\u0003\u0080a\u00feq\u00a5\u00af\u00e8\u00f6\u00d1\u00f1^\u00f3HS\u000f\u00ad)\u00ab\u00a5\u009e&]\u00b9\u00a1\u00e1\u0003P\u00fc\u009d&\u00d9h\fd\u001e\u00a7\u001b\u00f5\u008d\u00e3\u00cb\u00fd%\u00bch\u00b8i\u00da\u00aev\u00c5\t'\u00a9\u00af\u00b1\u00f6\u00d5\u0007\u00dbT\u009a\u0002\u00f9`\u00ae\u0007\u00cf\u00ee|9\u00c2\u00e8\u00df(\u00f4%9\u0017\u0019\u00f5\u00dfO\u00bcR!\u00eb\u00be\u00969fI\u00fe\u00acD\u00f5X\u008c\u00ba\u0080\u00b7\u00a5A\u00ac,\u0083\u001f\u00a6\u0098\u008d!\u0083\u0012g\u00b2\u000f\u00b8\u00b8\u00fe\u008d\t\u00caxk=[\u00b0\u009b,\u00cc\u00f5\"z\u001f\u00a4q\u001aSI\u00bc\u001e\u00fb_\u00e8Q{\u00e2\u0096\u00dedz\u0016\u00a4,i\u00af?\u00fd)\u00ad.\u00e3\u00aa\u00f8V\u00fc\u000e=\u00adN/\u001f\u009e\u00ba\u00e1e\n\u00bb\u00b1A\u0083\u001bP%\u00e4;\u00b1\u00a9\u00fa[:\u00da\u00dd\u00aa\u00dd\u00d6U5\u0080\u00ba\fQQ\u00f0\u00a4\u0092\u00cd7\"\n\u00bc\u00ef\u00bde\u008e\u0086\u00ce\u0094\u0017A\u0018\u00c0\u00d4\u00f6\b\u00f2s\u00b3^\r\u00b3\u00f9\u0018\u00e0\u00d3\u000e\u00b4\u009c\u008bX\u000e\u00a3P\u00a1\u00d5)s5\u00854>\u00fb\u00cd\u00a9\u008eYM\u00bc\u0014\u00f4\u00b1\u00d2!\u00b0\u00d0\u000b!\u009f0\u0085\u00f2~\u00c0\u00efd\u00c5\u00fa\u00aaW\u009b\u00f8xI`\u00ad\u000fV\t\u00a2}\u00ba0z\u00c8\u008f9\f".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 29;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "2\u00a9akn\u00dc\u000b\u0081\u009a\u0090\u0003I\u0011\u0086\u00ddP` dQ.'\u00ee\u0080N\u000e\nha\u0014?\u0082\u00ed\u008d\u00ec\u0001\u00fb\u0080\u00e9\u00d9)\u0097~\u009c\u00ca:\u0090\u008c\u00af\u0081";
                    var4_3 = "2\u00a9akn\u00dc\u000b\u0081\u009a\u0090\u0003I\u0011\u0086\u00ddP` dQ.'\u00ee\u0080N\u000e\nha\u0014?\u0082\u00ed\u008d\u00ec\u0001\u00fb\u0080\u00e9\u00d9)\u0097~\u009c\u00ca:\u0090\u008c\u00af\u0081".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 89;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 1;
                            break;
                        }
                        case 1: {
                            v15 = 42;
                            break;
                        }
                        case 2: {
                            v15 = 110;
                            break;
                        }
                        case 3: {
                            v15 = 44;
                            break;
                        }
                        case 4: {
                            v15 = 62;
                            break;
                        }
                        case 5: {
                            v15 = 103;
                            break;
                        }
                        default: {
                            v15 = 82;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFCAE0) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 146;
                case 1 -> 143;
                case 2 -> 115;
                case 3 -> 205;
                case 4 -> 238;
                case 5 -> 121;
                case 6 -> 219;
                case 7 -> 216;
                case 8 -> 12;
                case 9 -> 45;
                case 10 -> 94;
                case 11 -> 241;
                case 12 -> 224;
                case 13 -> 227;
                case 14 -> 92;
                case 15 -> 99;
                case 16 -> 231;
                case 17 -> 57;
                case 18 -> 82;
                case 19 -> 16;
                case 20 -> 200;
                case 21 -> 104;
                case 22 -> 188;
                case 23 -> 251;
                case 24 -> 199;
                case 25 -> 84;
                case 26 -> 93;
                case 27 -> 161;
                case 28 -> 183;
                case 29 -> 232;
                case 30 -> 129;
                case 31 -> 35;
                case 32 -> 13;
                case 33 -> 165;
                case 34 -> 178;
                case 35 -> 41;
                case 36 -> 98;
                case 37 -> 148;
                case 38 -> 53;
                case 39 -> 211;
                case 40 -> 108;
                case 41 -> 51;
                case 42 -> 62;
                case 43 -> 229;
                case 44 -> 245;
                case 45 -> 1;
                case 46 -> 9;
                case 47 -> 123;
                case 48 -> 175;
                case 49 -> 125;
                case 50 -> 59;
                case 51 -> 243;
                case 52 -> 151;
                case 53 -> 182;
                case 54 -> 87;
                case 55 -> 90;
                case 56 -> 163;
                case 57 -> 179;
                case 58 -> 117;
                case 59 -> 11;
                case 60 -> 222;
                case 61 -> 50;
                case 62 -> 139;
                case 63 -> 154;
                case 64 -> 173;
                case 65 -> 67;
                case 66 -> 181;
                case 67 -> 24;
                case 68 -> 79;
                case 69 -> 42;
                case 70 -> 6;
                case 71 -> 66;
                case 72 -> 23;
                case 73 -> 83;
                case 74 -> 32;
                case 75 -> 177;
                case 76 -> 185;
                case 77 -> 29;
                case 78 -> 217;
                case 79 -> 203;
                case 80 -> 44;
                case 81 -> 110;
                case 82 -> 112;
                case 83 -> 81;
                case 84 -> 91;
                case 85 -> 172;
                case 86 -> 73;
                case 87 -> 192;
                case 88 -> 150;
                case 89 -> 206;
                case 90 -> 54;
                case 91 -> 225;
                case 92 -> 220;
                case 93 -> 102;
                case 94 -> 25;
                case 95 -> 254;
                case 96 -> 134;
                case 97 -> 124;
                case 98 -> 140;
                case 99 -> 72;
                case 100 -> 33;
                case 101 -> 96;
                case 102 -> 202;
                case 103 -> 156;
                case 104 -> 197;
                case 105 -> 15;
                case 106 -> 119;
                case 107 -> 196;
                case 108 -> 34;
                case 109 -> 20;
                case 110 -> 235;
                case 111 -> 226;
                case 112 -> 186;
                case 113 -> 116;
                case 114 -> 19;
                case 115 -> 28;
                case 116 -> 5;
                case 117 -> 255;
                case 118 -> 253;
                case 119 -> 218;
                case 120 -> 61;
                case 121 -> 142;
                case 122 -> 131;
                case 123 -> 204;
                case 124 -> 132;
                case 125 -> 21;
                case 126 -> 63;
                case 127 -> 234;
                case 128 -> 4;
                case 129 -> 152;
                case 130 -> 107;
                case 131 -> 48;
                case 132 -> 157;
                case 133 -> 130;
                case 134 -> 38;
                case 135 -> 101;
                case 136 -> 190;
                case 137 -> 228;
                case 138 -> 80;
                case 139 -> 128;
                case 140 -> 221;
                case 141 -> 195;
                case 142 -> 68;
                case 143 -> 167;
                case 144 -> 22;
                case 145 -> 240;
                case 146 -> 215;
                case 147 -> 69;
                case 148 -> 189;
                case 149 -> 71;
                case 150 -> 170;
                case 151 -> 147;
                case 152 -> 144;
                case 153 -> 180;
                case 154 -> 166;
                case 155 -> 46;
                case 156 -> 52;
                case 157 -> 210;
                case 158 -> 2;
                case 159 -> 223;
                case 160 -> 127;
                case 161 -> 58;
                case 162 -> 213;
                case 163 -> 137;
                case 164 -> 65;
                case 165 -> 168;
                case 166 -> 85;
                case 167 -> 176;
                case 168 -> 187;
                case 169 -> 88;
                case 170 -> 26;
                case 171 -> 120;
                case 172 -> 109;
                case 173 -> 246;
                case 174 -> 64;
                case 175 -> 244;
                case 176 -> 0;
                case 177 -> 169;
                case 178 -> 27;
                case 179 -> 113;
                case 180 -> 136;
                case 181 -> 209;
                case 182 -> 118;
                case 183 -> 135;
                case 184 -> 47;
                case 185 -> 198;
                case 186 -> 36;
                case 187 -> 158;
                case 188 -> 10;
                case 189 -> 60;
                case 190 -> 70;
                case 191 -> 111;
                case 192 -> 14;
                case 193 -> 106;
                case 194 -> 212;
                case 195 -> 43;
                case 196 -> 55;
                case 197 -> 75;
                case 198 -> 30;
                case 199 -> 97;
                case 200 -> 17;
                case 201 -> 141;
                case 202 -> 31;
                case 203 -> 100;
                case 204 -> 191;
                case 205 -> 207;
                case 206 -> 76;
                case 207 -> 164;
                case 208 -> 201;
                case 209 -> 95;
                case 210 -> 105;
                case 211 -> 239;
                case 212 -> 145;
                case 213 -> 18;
                case 214 -> 138;
                case 215 -> 40;
                case 216 -> 3;
                case 217 -> 242;
                case 218 -> 153;
                case 219 -> 250;
                case 220 -> 86;
                case 221 -> 248;
                case 222 -> 247;
                case 223 -> 237;
                case 224 -> 171;
                case 225 -> 78;
                case 226 -> 174;
                case 227 -> 193;
                case 228 -> 252;
                case 229 -> 155;
                case 230 -> 184;
                case 231 -> 149;
                case 232 -> 122;
                case 233 -> 214;
                case 234 -> 56;
                case 235 -> 7;
                case 236 -> 230;
                case 237 -> 103;
                case 238 -> 194;
                case 239 -> 208;
                case 240 -> 159;
                case 241 -> 8;
                case 242 -> 74;
                case 243 -> 77;
                case 244 -> 126;
                case 245 -> 233;
                case 246 -> 39;
                case 247 -> 89;
                case 248 -> 49;
                case 249 -> 249;
                case 250 -> 133;
                case 251 -> 160;
                case 252 -> 162;
                case 253 -> 37;
                case 254 -> 114;
                default -> 236;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 37174450602628L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1508615700 + -28116, 1508615700 + 31997, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String string;
                        block4: {
                            l2 = 133203921467782L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            string = SshAgentIpcService.A();
                            try {
                                hANDLE2 = hANDLE;
                                if (string != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (string != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(194245740 + 25263, -194245740 + -14947, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(194245740 + 25260, -194245740 + -21171, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(194245740 + 25261, 194245740 + 26444, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "J\u0019\u00a5W~\u00f7\"\u00f0\u0010\u00c5\u0006\u00a5\u0015\u00c4\u0004\u008c\u00d7\u00926\u00c1\u0005j`\u00a3Y";
                    var4_3 = "J\u0019\u00a5W~\u00f7\"\u00f0\u0010\u00c5\u0006\u00a5\u0015\u00c4\u0004\u008c\u00d7\u00926\u00c1\u0005j`\u00a3Y".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 14;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "76\u009c$\u00bf5\u000f\u00c7\u008cvo\u00c7w\u0092\f\u00b3\u0016\u00e3\u00f1\u00c0CQzm\u001734I\u00c2V\u00b2w\u00f8vK\u0016K\u0010E\u00c2\u00b1\u00c4`-\u00f8\u009f\u0003\"\u0080\u00e8P\u0016F\u00a4\u008bD$\u00f7h";
                        var4_3 = "76\u009c$\u00bf5\u000f\u00c7\u008cvo\u00c7w\u0092\f\u00b3\u0016\u00e3\u00f1\u00c0CQzm\u001734I\u00c2V\u00b2w\u00f8vK\u0016K\u0010E\u00c2\u00b1\u00c4`-\u00f8\u009f\u0003\"\u0080\u00e8P\u0016F\u00a4\u008bD$\u00f7h".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 26;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 107;
                                break;
                            }
                            case 1: {
                                v15 = 85;
                                break;
                            }
                            case 2: {
                                v15 = 64;
                                break;
                            }
                            case 3: {
                                v15 = 48;
                                break;
                            }
                            case 4: {
                                v15 = 35;
                                break;
                            }
                            case 5: {
                                v15 = 124;
                                break;
                            }
                            default: {
                                v15 = 104;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFAE9C) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 53;
                    case 1 -> 224;
                    case 2 -> 27;
                    case 3 -> 137;
                    case 4 -> 79;
                    case 5 -> 152;
                    case 6 -> 61;
                    case 7 -> 173;
                    case 8 -> 182;
                    case 9 -> 75;
                    case 10 -> 101;
                    case 11 -> 90;
                    case 12 -> 200;
                    case 13 -> 121;
                    case 14 -> 20;
                    case 15 -> 6;
                    case 16 -> 89;
                    case 17 -> 31;
                    case 18 -> 133;
                    case 19 -> 208;
                    case 20 -> 105;
                    case 21 -> 221;
                    case 22 -> 69;
                    case 23 -> 178;
                    case 24 -> 169;
                    case 25 -> 114;
                    case 26 -> 175;
                    case 27 -> 11;
                    case 28 -> 35;
                    case 29 -> 155;
                    case 30 -> 117;
                    case 31 -> 116;
                    case 32 -> 0;
                    case 33 -> 44;
                    case 34 -> 177;
                    case 35 -> 98;
                    case 36 -> 162;
                    case 37 -> 130;
                    case 38 -> 254;
                    case 39 -> 205;
                    case 40 -> 32;
                    case 41 -> 91;
                    case 42 -> 134;
                    case 43 -> 232;
                    case 44 -> 25;
                    case 45 -> 107;
                    case 46 -> 197;
                    case 47 -> 54;
                    case 48 -> 251;
                    case 49 -> 46;
                    case 50 -> 213;
                    case 51 -> 161;
                    case 52 -> 217;
                    case 53 -> 123;
                    case 54 -> 166;
                    case 55 -> 128;
                    case 56 -> 16;
                    case 57 -> 100;
                    case 58 -> 118;
                    case 59 -> 241;
                    case 60 -> 233;
                    case 61 -> 14;
                    case 62 -> 63;
                    case 63 -> 231;
                    case 64 -> 170;
                    case 65 -> 215;
                    case 66 -> 242;
                    case 67 -> 143;
                    case 68 -> 109;
                    case 69 -> 174;
                    case 70 -> 49;
                    case 71 -> 211;
                    case 72 -> 55;
                    case 73 -> 203;
                    case 74 -> 199;
                    case 75 -> 228;
                    case 76 -> 144;
                    case 77 -> 158;
                    case 78 -> 59;
                    case 79 -> 74;
                    case 80 -> 22;
                    case 81 -> 193;
                    case 82 -> 13;
                    case 83 -> 220;
                    case 84 -> 40;
                    case 85 -> 36;
                    case 86 -> 167;
                    case 87 -> 58;
                    case 88 -> 85;
                    case 89 -> 23;
                    case 90 -> 126;
                    case 91 -> 28;
                    case 92 -> 45;
                    case 93 -> 235;
                    case 94 -> 15;
                    case 95 -> 163;
                    case 96 -> 183;
                    case 97 -> 72;
                    case 98 -> 223;
                    case 99 -> 222;
                    case 100 -> 119;
                    case 101 -> 38;
                    case 102 -> 187;
                    case 103 -> 186;
                    case 104 -> 102;
                    case 105 -> 132;
                    case 106 -> 164;
                    case 107 -> 81;
                    case 108 -> 87;
                    case 109 -> 145;
                    case 110 -> 243;
                    case 111 -> 141;
                    case 112 -> 26;
                    case 113 -> 148;
                    case 114 -> 157;
                    case 115 -> 127;
                    case 116 -> 60;
                    case 117 -> 184;
                    case 118 -> 4;
                    case 119 -> 179;
                    case 120 -> 180;
                    case 121 -> 239;
                    case 122 -> 43;
                    case 123 -> 57;
                    case 124 -> 149;
                    case 125 -> 2;
                    case 126 -> 250;
                    case 127 -> 237;
                    case 128 -> 171;
                    case 129 -> 216;
                    case 130 -> 255;
                    case 131 -> 18;
                    case 132 -> 84;
                    case 133 -> 159;
                    case 134 -> 76;
                    case 135 -> 136;
                    case 136 -> 191;
                    case 137 -> 115;
                    case 138 -> 209;
                    case 139 -> 225;
                    case 140 -> 212;
                    case 141 -> 249;
                    case 142 -> 154;
                    case 143 -> 135;
                    case 144 -> 244;
                    case 145 -> 219;
                    case 146 -> 80;
                    case 147 -> 236;
                    case 148 -> 10;
                    case 149 -> 52;
                    case 150 -> 88;
                    case 151 -> 33;
                    case 152 -> 96;
                    case 153 -> 165;
                    case 154 -> 62;
                    case 155 -> 9;
                    case 156 -> 112;
                    case 157 -> 77;
                    case 158 -> 252;
                    case 159 -> 73;
                    case 160 -> 240;
                    case 161 -> 234;
                    case 162 -> 17;
                    case 163 -> 104;
                    case 164 -> 48;
                    case 165 -> 21;
                    case 166 -> 146;
                    case 167 -> 188;
                    case 168 -> 229;
                    case 169 -> 218;
                    case 170 -> 66;
                    case 171 -> 103;
                    case 172 -> 50;
                    case 173 -> 3;
                    case 174 -> 42;
                    case 175 -> 7;
                    case 176 -> 37;
                    case 177 -> 86;
                    case 178 -> 41;
                    case 179 -> 113;
                    case 180 -> 176;
                    case 181 -> 247;
                    case 182 -> 230;
                    case 183 -> 30;
                    case 184 -> 140;
                    case 185 -> 195;
                    case 186 -> 181;
                    case 187 -> 253;
                    case 188 -> 78;
                    case 189 -> 142;
                    case 190 -> 204;
                    case 191 -> 206;
                    case 192 -> 238;
                    case 193 -> 172;
                    case 194 -> 151;
                    case 195 -> 67;
                    case 196 -> 248;
                    case 197 -> 202;
                    case 198 -> 153;
                    case 199 -> 245;
                    case 200 -> 138;
                    case 201 -> 139;
                    case 202 -> 131;
                    case 203 -> 198;
                    case 204 -> 83;
                    case 205 -> 5;
                    case 206 -> 194;
                    case 207 -> 189;
                    case 208 -> 56;
                    case 209 -> 168;
                    case 210 -> 64;
                    case 211 -> 106;
                    case 212 -> 120;
                    case 213 -> 29;
                    case 214 -> 160;
                    case 215 -> 93;
                    case 216 -> 71;
                    case 217 -> 24;
                    case 218 -> 70;
                    case 219 -> 65;
                    case 220 -> 207;
                    case 221 -> 68;
                    case 222 -> 108;
                    case 223 -> 1;
                    case 224 -> 125;
                    case 225 -> 196;
                    case 226 -> 19;
                    case 227 -> 192;
                    case 228 -> 92;
                    case 229 -> 124;
                    case 230 -> 51;
                    case 231 -> 246;
                    case 232 -> 156;
                    case 233 -> 39;
                    case 234 -> 97;
                    case 235 -> 110;
                    case 236 -> 210;
                    case 237 -> 122;
                    case 238 -> 129;
                    case 239 -> 214;
                    case 240 -> 201;
                    case 241 -> 99;
                    case 242 -> 12;
                    case 243 -> 47;
                    case 244 -> 227;
                    case 245 -> 95;
                    case 246 -> 111;
                    case 247 -> 185;
                    case 248 -> 82;
                    case 249 -> 34;
                    case 250 -> 8;
                    case 251 -> 150;
                    case 252 -> 94;
                    case 253 -> 190;
                    case 254 -> 226;
                    default -> 147;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 130730441602344L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "h\u00061 \u0005%,1\to\f\"*Hg1-J";
                    var5_4 = "h\u00061 \u0005%,1\to\f\"*Hg1-J".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 121;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 122;
                                    break;
                                }
                                case 1: {
                                    v11 = 26;
                                    break;
                                }
                                case 2: {
                                    v11 = 58;
                                    break;
                                }
                                case 3: {
                                    v11 = 55;
                                    break;
                                }
                                case 4: {
                                    v11 = 25;
                                    break;
                                }
                                case 5: {
                                    v11 = 48;
                                    break;
                                }
                                default: {
                                    v11 = 102;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 76730879437710L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "~fZn9x&\u0004xxVt\ntg]t5z>^fT\ttg]t5z>Rl\rsa@y?w$RkGs>~";
                    var5_4 = "~fZn9x&\u0004xxVt\ntg]t5z>^fT\ttg]t5z>Rl\rsa@y?w$RkGs>~".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 5;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "iyAt$j0\u0006iyAt(`";
                        var5_4 = "iyAt$j0\u0006iyAt(`".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 24;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 50;
                                break;
                            }
                            case 1: {
                                v15 = 13;
                                break;
                            }
                            case 2: {
                                v15 = 54;
                                break;
                            }
                            case 3: {
                                v15 = 31;
                                break;
                            }
                            case 4: {
                                v15 = 85;
                                break;
                            }
                            case 5: {
                                v15 = 28;
                                break;
                            }
                            default: {
                                v15 = 79;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 117453369952028L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-1100725860 - -((char)-32621), 1100725860 - 30286, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 92488874032214L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00ea\u0006g\u00d4\f\u0003\u0091\u0088\u00bc\u0005\u00d9\u00ae'\u0005\u00e7\rI\u0087\u0003j\u0096eP\u00aa\u00fc\u00edK\u008a\u00c6\u0010\u0099+\u00de\u0014\u0012?\u00eb\u00dcB\u00a7\u007f\u008e\u00a6\u00acV\u00fc\u0005\u0017*\u00fe\u0095\u00dc3\u00fc\u0094\u00925N_P\u00c4HY\u00b5x9#\u0089\u0012u,\u00ae\u0096\u008f\u0001y\u00b1<;M\u0082\u00b9\u0096LoK\u0006\u00bb\u00cdq(X\u001a\u0007\u00e3\u00ebH*BH\u0089\u00e8+\u0012";
                    var4_3 = "\u00ea\u0006g\u00d4\f\u0003\u0091\u0088\u00bc\u0005\u00d9\u00ae'\u0005\u00e7\rI\u0087\u0003j\u0096eP\u00aa\u00fc\u00edK\u008a\u00c6\u0010\u0099+\u00de\u0014\u0012?\u00eb\u00dcB\u00a7\u007f\u008e\u00a6\u00acV\u00fc\u0005\u0017*\u00fe\u0095\u00dc3\u00fc\u0094\u00925N_P\u00c4HY\u00b5x9#\u0089\u0012u,\u00ae\u0096\u008f\u0001y\u00b1<;M\u0082\u00b9\u0096LoK\u0006\u00bb\u00cdq(X\u001a\u0007\u00e3\u00ebH*BH\u0089\u00e8+\u0012".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 81;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0088\u000b`\u008cY\u00b0\u001e\u00b1`\u0096\u00a74!g:\u0019L\u00f8p\u0099)L\u00cc\u00d2Pp9\tx\u00fa`\u00d2\u0080\u00873\u0093\u001f\u00dc\u00c8\u00a5\u00b6\u0018\u00acp*xV\u0007\u0084\u00ae\t\u00ea\u00ac\u00f5Fn-kd5Yx\"U!%\u0096\u00df\u00c3\u00d3\u001f\n\u00a3D\u000f\u0099\u00c9H[\u0084/\u00fa\u00cfQ\u00d8\u009b\u008f\u00a8\u00ad'\u00a9\u008a\u00db";
                        var4_3 = "\u0088\u000b`\u008cY\u00b0\u001e\u00b1`\u0096\u00a74!g:\u0019L\u00f8p\u0099)L\u00cc\u00d2Pp9\tx\u00fa`\u00d2\u0080\u00873\u0093\u001f\u00dc\u00c8\u00a5\u00b6\u0018\u00acp*xV\u0007\u0084\u00ae\t\u00ea\u00ac\u00f5Fn-kd5Yx\"U!%\u0096\u00df\u00c3\u00d3\u001f\n\u00a3D\u000f\u0099\u00c9H[\u0084/\u00fa\u00cfQ\u00d8\u009b\u008f\u00a8\u00ad'\u00a9\u008a\u00db".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 7;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 18;
                                break;
                            }
                            case 1: {
                                v15 = 125;
                                break;
                            }
                            case 2: {
                                v15 = 43;
                                break;
                            }
                            case 3: {
                                v15 = 37;
                                break;
                            }
                            case 4: {
                                v15 = 67;
                                break;
                            }
                            case 5: {
                                v15 = 113;
                                break;
                            }
                            default: {
                                v15 = 109;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x533) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 32;
                    case 1 -> 239;
                    case 2 -> 240;
                    case 3 -> 211;
                    case 4 -> 177;
                    case 5 -> 147;
                    case 6 -> 194;
                    case 7 -> 19;
                    case 8 -> 214;
                    case 9 -> 163;
                    case 10 -> 159;
                    case 11 -> 131;
                    case 12 -> 4;
                    case 13 -> 155;
                    case 14 -> 29;
                    case 15 -> 165;
                    case 16 -> 116;
                    case 17 -> 170;
                    case 18 -> 102;
                    case 19 -> 31;
                    case 20 -> 97;
                    case 21 -> 101;
                    case 22 -> 152;
                    case 23 -> 15;
                    case 24 -> 93;
                    case 25 -> 127;
                    case 26 -> 229;
                    case 27 -> 130;
                    case 28 -> 91;
                    case 29 -> 135;
                    case 30 -> 231;
                    case 31 -> 86;
                    case 32 -> 164;
                    case 33 -> 228;
                    case 34 -> 10;
                    case 35 -> 16;
                    case 36 -> 74;
                    case 37 -> 87;
                    case 38 -> 28;
                    case 39 -> 35;
                    case 40 -> 108;
                    case 41 -> 250;
                    case 42 -> 172;
                    case 43 -> 24;
                    case 44 -> 65;
                    case 45 -> 189;
                    case 46 -> 122;
                    case 47 -> 83;
                    case 48 -> 180;
                    case 49 -> 252;
                    case 50 -> 48;
                    case 51 -> 99;
                    case 52 -> 115;
                    case 53 -> 143;
                    case 54 -> 246;
                    case 55 -> 37;
                    case 56 -> 154;
                    case 57 -> 234;
                    case 58 -> 148;
                    case 59 -> 70;
                    case 60 -> 133;
                    case 61 -> 169;
                    case 62 -> 88;
                    case 63 -> 174;
                    case 64 -> 81;
                    case 65 -> 186;
                    case 66 -> 173;
                    case 67 -> 114;
                    case 68 -> 12;
                    case 69 -> 255;
                    case 70 -> 120;
                    case 71 -> 112;
                    case 72 -> 171;
                    case 73 -> 232;
                    case 74 -> 92;
                    case 75 -> 119;
                    case 76 -> 215;
                    case 77 -> 123;
                    case 78 -> 95;
                    case 79 -> 244;
                    case 80 -> 43;
                    case 81 -> 42;
                    case 82 -> 36;
                    case 83 -> 53;
                    case 84 -> 201;
                    case 85 -> 13;
                    case 86 -> 149;
                    case 87 -> 207;
                    case 88 -> 134;
                    case 89 -> 188;
                    case 90 -> 195;
                    case 91 -> 121;
                    case 92 -> 25;
                    case 93 -> 141;
                    case 94 -> 138;
                    case 95 -> 132;
                    case 96 -> 151;
                    case 97 -> 144;
                    case 98 -> 158;
                    case 99 -> 109;
                    case 100 -> 205;
                    case 101 -> 68;
                    case 102 -> 63;
                    case 103 -> 7;
                    case 104 -> 9;
                    case 105 -> 46;
                    case 106 -> 96;
                    case 107 -> 167;
                    case 108 -> 38;
                    case 109 -> 237;
                    case 110 -> 76;
                    case 111 -> 235;
                    case 112 -> 245;
                    case 113 -> 181;
                    case 114 -> 111;
                    case 115 -> 8;
                    case 116 -> 73;
                    case 117 -> 225;
                    case 118 -> 45;
                    case 119 -> 52;
                    case 120 -> 64;
                    case 121 -> 51;
                    case 122 -> 183;
                    case 123 -> 137;
                    case 124 -> 71;
                    case 125 -> 223;
                    case 126 -> 17;
                    case 127 -> 197;
                    case 128 -> 89;
                    case 129 -> 1;
                    case 130 -> 60;
                    case 131 -> 196;
                    case 132 -> 206;
                    case 133 -> 41;
                    case 134 -> 209;
                    case 135 -> 175;
                    case 136 -> 220;
                    case 137 -> 140;
                    case 138 -> 242;
                    case 139 -> 49;
                    case 140 -> 182;
                    case 141 -> 153;
                    case 142 -> 191;
                    case 143 -> 54;
                    case 144 -> 162;
                    case 145 -> 218;
                    case 146 -> 56;
                    case 147 -> 85;
                    case 148 -> 217;
                    case 149 -> 79;
                    case 150 -> 5;
                    case 151 -> 249;
                    case 152 -> 142;
                    case 153 -> 128;
                    case 154 -> 176;
                    case 155 -> 166;
                    case 156 -> 219;
                    case 157 -> 184;
                    case 158 -> 11;
                    case 159 -> 20;
                    case 160 -> 0;
                    case 161 -> 157;
                    case 162 -> 110;
                    case 163 -> 241;
                    case 164 -> 69;
                    case 165 -> 58;
                    case 166 -> 22;
                    case 167 -> 126;
                    case 168 -> 168;
                    case 169 -> 66;
                    case 170 -> 90;
                    case 171 -> 227;
                    case 172 -> 233;
                    case 173 -> 247;
                    case 174 -> 84;
                    case 175 -> 14;
                    case 176 -> 34;
                    case 177 -> 106;
                    case 178 -> 98;
                    case 179 -> 150;
                    case 180 -> 80;
                    case 181 -> 222;
                    case 182 -> 100;
                    case 183 -> 23;
                    case 184 -> 33;
                    case 185 -> 6;
                    case 186 -> 30;
                    case 187 -> 212;
                    case 188 -> 139;
                    case 189 -> 50;
                    case 190 -> 94;
                    case 191 -> 118;
                    case 192 -> 40;
                    case 193 -> 202;
                    case 194 -> 124;
                    case 195 -> 161;
                    case 196 -> 3;
                    case 197 -> 117;
                    case 198 -> 160;
                    case 199 -> 226;
                    case 200 -> 145;
                    case 201 -> 47;
                    case 202 -> 129;
                    case 203 -> 251;
                    case 204 -> 59;
                    case 205 -> 253;
                    case 206 -> 57;
                    case 207 -> 125;
                    case 208 -> 55;
                    case 209 -> 104;
                    case 210 -> 136;
                    case 211 -> 193;
                    case 212 -> 204;
                    case 213 -> 179;
                    case 214 -> 103;
                    case 215 -> 2;
                    case 216 -> 221;
                    case 217 -> 61;
                    case 218 -> 113;
                    case 219 -> 77;
                    case 220 -> 62;
                    case 221 -> 198;
                    case 222 -> 254;
                    case 223 -> 238;
                    case 224 -> 213;
                    case 225 -> 187;
                    case 226 -> 18;
                    case 227 -> 203;
                    case 228 -> 200;
                    case 229 -> 210;
                    case 230 -> 185;
                    case 231 -> 199;
                    case 232 -> 236;
                    case 233 -> 146;
                    case 234 -> 208;
                    case 235 -> 26;
                    case 236 -> 230;
                    case 237 -> 39;
                    case 238 -> 224;
                    case 239 -> 192;
                    case 240 -> 27;
                    case 241 -> 75;
                    case 242 -> 72;
                    case 243 -> 248;
                    case 244 -> 105;
                    case 245 -> 21;
                    case 246 -> 78;
                    case 247 -> 243;
                    case 248 -> 216;
                    case 249 -> 190;
                    case 250 -> 107;
                    case 251 -> 67;
                    case 252 -> 156;
                    case 253 -> 178;
                    case 254 -> 82;
                    default -> 44;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 13379225209401L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-402122760 - -31830, 402122760 - (char)-23759, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 127336084587999L;
                    String string = SshAgentIpcService.A();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1105837590 - (char)-23955, 1105837590 - (char)-32372, (int)l2));
                    String string2 = string;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (string2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 110083372914962L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00bb\u000b\u00a7\u0097\u00fe\u0003\u00d0[\u009c";
                var4_3 = "\u00bb\u000b\u00a7\u0097\u00fe\u0003\u00d0[\u009c".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 87;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 104;
                                break;
                            }
                            case 1: {
                                v11 = 62;
                                break;
                            }
                            case 2: {
                                v11 = 72;
                                break;
                            }
                            case 3: {
                                v11 = 105;
                                break;
                            }
                            case 4: {
                                v11 = 3;
                                break;
                            }
                            case 5: {
                                v11 = 94;
                                break;
                            }
                            default: {
                                v11 = 111;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFDE77) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 210;
                    case 1 -> 71;
                    case 2 -> 96;
                    case 3 -> 192;
                    case 4 -> 162;
                    case 5 -> 118;
                    case 6 -> 195;
                    case 7 -> 233;
                    case 8 -> 236;
                    case 9 -> 250;
                    case 10 -> 127;
                    case 11 -> 43;
                    case 12 -> 254;
                    case 13 -> 227;
                    case 14 -> 172;
                    case 15 -> 213;
                    case 16 -> 39;
                    case 17 -> 125;
                    case 18 -> 97;
                    case 19 -> 224;
                    case 20 -> 186;
                    case 21 -> 223;
                    case 22 -> 47;
                    case 23 -> 247;
                    case 24 -> 177;
                    case 25 -> 93;
                    case 26 -> 5;
                    case 27 -> 61;
                    case 28 -> 37;
                    case 29 -> 60;
                    case 30 -> 99;
                    case 31 -> 3;
                    case 32 -> 0;
                    case 33 -> 57;
                    case 34 -> 181;
                    case 35 -> 27;
                    case 36 -> 182;
                    case 37 -> 26;
                    case 38 -> 100;
                    case 39 -> 68;
                    case 40 -> 33;
                    case 41 -> 137;
                    case 42 -> 124;
                    case 43 -> 64;
                    case 44 -> 12;
                    case 45 -> 174;
                    case 46 -> 252;
                    case 47 -> 228;
                    case 48 -> 226;
                    case 49 -> 107;
                    case 50 -> 36;
                    case 51 -> 109;
                    case 52 -> 66;
                    case 53 -> 126;
                    case 54 -> 102;
                    case 55 -> 31;
                    case 56 -> 80;
                    case 57 -> 153;
                    case 58 -> 214;
                    case 59 -> 106;
                    case 60 -> 42;
                    case 61 -> 253;
                    case 62 -> 86;
                    case 63 -> 206;
                    case 64 -> 95;
                    case 65 -> 237;
                    case 66 -> 54;
                    case 67 -> 105;
                    case 68 -> 22;
                    case 69 -> 92;
                    case 70 -> 167;
                    case 71 -> 62;
                    case 72 -> 50;
                    case 73 -> 133;
                    case 74 -> 91;
                    case 75 -> 24;
                    case 76 -> 73;
                    case 77 -> 193;
                    case 78 -> 28;
                    case 79 -> 196;
                    case 80 -> 159;
                    case 81 -> 13;
                    case 82 -> 225;
                    case 83 -> 69;
                    case 84 -> 113;
                    case 85 -> 108;
                    case 86 -> 160;
                    case 87 -> 35;
                    case 88 -> 110;
                    case 89 -> 189;
                    case 90 -> 132;
                    case 91 -> 84;
                    case 92 -> 51;
                    case 93 -> 30;
                    case 94 -> 217;
                    case 95 -> 211;
                    case 96 -> 168;
                    case 97 -> 231;
                    case 98 -> 8;
                    case 99 -> 59;
                    case 100 -> 101;
                    case 101 -> 89;
                    case 102 -> 204;
                    case 103 -> 72;
                    case 104 -> 46;
                    case 105 -> 176;
                    case 106 -> 198;
                    case 107 -> 23;
                    case 108 -> 1;
                    case 109 -> 139;
                    case 110 -> 164;
                    case 111 -> 82;
                    case 112 -> 149;
                    case 113 -> 170;
                    case 114 -> 147;
                    case 115 -> 44;
                    case 116 -> 146;
                    case 117 -> 143;
                    case 118 -> 187;
                    case 119 -> 103;
                    case 120 -> 200;
                    case 121 -> 184;
                    case 122 -> 234;
                    case 123 -> 87;
                    case 124 -> 7;
                    case 125 -> 165;
                    case 126 -> 188;
                    case 127 -> 128;
                    case 128 -> 123;
                    case 129 -> 41;
                    case 130 -> 171;
                    case 131 -> 199;
                    case 132 -> 9;
                    case 133 -> 17;
                    case 134 -> 248;
                    case 135 -> 220;
                    case 136 -> 208;
                    case 137 -> 157;
                    case 138 -> 29;
                    case 139 -> 90;
                    case 140 -> 154;
                    case 141 -> 249;
                    case 142 -> 65;
                    case 143 -> 161;
                    case 144 -> 74;
                    case 145 -> 145;
                    case 146 -> 18;
                    case 147 -> 78;
                    case 148 -> 251;
                    case 149 -> 58;
                    case 150 -> 119;
                    case 151 -> 135;
                    case 152 -> 115;
                    case 153 -> 122;
                    case 154 -> 156;
                    case 155 -> 169;
                    case 156 -> 242;
                    case 157 -> 121;
                    case 158 -> 56;
                    case 159 -> 202;
                    case 160 -> 40;
                    case 161 -> 88;
                    case 162 -> 116;
                    case 163 -> 141;
                    case 164 -> 155;
                    case 165 -> 150;
                    case 166 -> 178;
                    case 167 -> 205;
                    case 168 -> 148;
                    case 169 -> 77;
                    case 170 -> 21;
                    case 171 -> 235;
                    case 172 -> 140;
                    case 173 -> 63;
                    case 174 -> 173;
                    case 175 -> 19;
                    case 176 -> 230;
                    case 177 -> 83;
                    case 178 -> 10;
                    case 179 -> 131;
                    case 180 -> 190;
                    case 181 -> 129;
                    case 182 -> 203;
                    case 183 -> 79;
                    case 184 -> 81;
                    case 185 -> 55;
                    case 186 -> 180;
                    case 187 -> 152;
                    case 188 -> 183;
                    case 189 -> 52;
                    case 190 -> 70;
                    case 191 -> 243;
                    case 192 -> 76;
                    case 193 -> 239;
                    case 194 -> 48;
                    case 195 -> 16;
                    case 196 -> 216;
                    case 197 -> 25;
                    case 198 -> 201;
                    case 199 -> 4;
                    case 200 -> 14;
                    case 201 -> 244;
                    case 202 -> 6;
                    case 203 -> 215;
                    case 204 -> 2;
                    case 205 -> 163;
                    case 206 -> 175;
                    case 207 -> 207;
                    case 208 -> 218;
                    case 209 -> 67;
                    case 210 -> 212;
                    case 211 -> 98;
                    case 212 -> 221;
                    case 213 -> 112;
                    case 214 -> 197;
                    case 215 -> 179;
                    case 216 -> 38;
                    case 217 -> 138;
                    case 218 -> 222;
                    case 219 -> 232;
                    case 220 -> 191;
                    case 221 -> 245;
                    case 222 -> 144;
                    case 223 -> 114;
                    case 224 -> 240;
                    case 225 -> 94;
                    case 226 -> 158;
                    case 227 -> 15;
                    case 228 -> 229;
                    case 229 -> 134;
                    case 230 -> 246;
                    case 231 -> 111;
                    case 232 -> 53;
                    case 233 -> 20;
                    case 234 -> 75;
                    case 235 -> 117;
                    case 236 -> 194;
                    case 237 -> 238;
                    case 238 -> 136;
                    case 239 -> 185;
                    case 240 -> 130;
                    case 241 -> 241;
                    case 242 -> 34;
                    case 243 -> 120;
                    case 244 -> 104;
                    case 245 -> 45;
                    case 246 -> 166;
                    case 247 -> 32;
                    case 248 -> 219;
                    case 249 -> 49;
                    case 250 -> 11;
                    case 251 -> 151;
                    case 252 -> 142;
                    case 253 -> 85;
                    case 254 -> 255;
                    default -> 209;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

