/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.completion.trigger.model.polyglot;

import com.intellij.ml.inline.completion.impl.MLCompletionRequest;
import com.intellij.ml.inline.completion.impl.control.ControlModel;
import com.intellij.ml.inline.completion.impl.control.ControlModelBypassReason;
import com.intellij.ml.inline.completion.impl.control.ControlModelPrediction;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/completion/trigger/model/polyglot/PolyglotTriggerModel;", "Lcom/intellij/ml/inline/completion/impl/control/ControlModel;", "baseMlApiModel", "<init>", "(Lcom/intellij/ml/inline/completion/impl/control/ControlModel;)V", "metadata", "", "", "", "getMetadata", "()Ljava/util/Map;", "langaugeIds", "", "getLangaugeIds", "()Ljava/util/Set;", "langaugeIds$delegate", "Lkotlin/Lazy;", "predict", "Lcom/intellij/ml/inline/completion/impl/control/ControlModelPrediction;", "request", "Lcom/intellij/ml/inline/completion/impl/MLCompletionRequest;", "(Lcom/intellij/ml/inline/completion/impl/MLCompletionRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.ml.llm.completion.trigger.model.polyglot"})
public final class PolyglotTriggerModel
implements ControlModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ControlModel baseMlApiModel;
    @NotNull
    private final Lazy langaugeIds$delegate;
    @NotNull
    public static final String INFO_KEY_LANGUAGE_IDS = "languages_supported";

    public PolyglotTriggerModel(@NotNull ControlModel baseMlApiModel) {
        Intrinsics.checkNotNullParameter((Object)baseMlApiModel, (String)"baseMlApiModel");
        this.baseMlApiModel = baseMlApiModel;
        this.langaugeIds$delegate = LazyKt.lazy(() -> PolyglotTriggerModel.langaugeIds_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public Map<String, Object> getMetadata() {
        return this.baseMlApiModel.getMetadata();
    }

    private final Set<String> getLangaugeIds() {
        Lazy lazy = this.langaugeIds$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @Nullable
    public Object predict(@NotNull MLCompletionRequest request, @NotNull Continuation<? super ControlModelPrediction> $completion) {
        if (!this.getLangaugeIds().contains(request.getParameters().getAccurateLanguage().getID())) {
            return new ControlModelPrediction.Skipped(ControlModelBypassReason.UNAVAILABLE_LANGUAGE);
        }
        return this.baseMlApiModel.predict(request, $completion);
    }

    private static final Set langaugeIds_delegate$lambda$0(PolyglotTriggerModel this$0) {
        Object idsFromInfoRaw = this$0.baseMlApiModel.getMetadata().get(INFO_KEY_LANGUAGE_IDS);
        Collection collection = idsFromInfoRaw instanceof Collection ? (Collection)idsFromInfoRaw : null;
        if (collection == null) {
            throw new IllegalStateException("Polyglot model with id " + this$0.baseMlApiModel + " was expected to have key languages_supported in the info with a collection of languages, but it was " + idsFromInfoRaw);
        }
        Collection idsFromInfo = collection;
        return CollectionsKt.toSet((Iterable)idsFromInfo);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/completion/trigger/model/polyglot/PolyglotTriggerModel$Companion;", "", "<init>", "()V", "INFO_KEY_LANGUAGE_IDS", "", "intellij.ml.llm.completion.trigger.model.polyglot"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

