#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 252
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 67
#define ALIAS_COUNT 0
#define TOKEN_COUNT 34
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 6
#define MAX_ALIAS_SEQUENCE_LENGTH 5
#define PRODUCTION_ID_COUNT 9

enum {
  sym_text_node = 1,
  anon_sym_SQUOTE = 2,
  aux_sym__single_quote_string_literal_token1 = 3,
  anon_sym_DQUOTE = 4,
  aux_sym__double_quote_string_literal_token1 = 5,
  sym_number_literal = 6,
  anon_sym_true = 7,
  anon_sym_false = 8,
  sym_tag_name = 9,
  anon_sym_LT = 10,
  anon_sym_GT = 11,
  anon_sym_LT_SLASH = 12,
  anon_sym_SLASH_GT = 13,
  sym_attribute_name = 14,
  sym__splattributes = 15,
  anon_sym_EQ = 16,
  sym__mustache_safe_single_quote_string_literal_content = 17,
  sym__mustache_safe_double_quote_string_literal_content = 18,
  anon_sym_as = 19,
  anon_sym_PIPE = 20,
  sym_identifier = 21,
  anon_sym_DOT = 22,
  anon_sym_LBRACE_LBRACE = 23,
  anon_sym_LBRACE_LBRACE_TILDE = 24,
  anon_sym_RBRACE_RBRACE = 25,
  anon_sym_TILDE_RBRACE_RBRACE = 26,
  anon_sym_LPAREN = 27,
  anon_sym_RPAREN = 28,
  anon_sym_LBRACE_LBRACE_POUND = 29,
  anon_sym_LBRACE_LBRACE_TILDE_POUND = 30,
  anon_sym_LBRACE_LBRACE_SLASH = 31,
  anon_sym_LBRACE_LBRACE_TILDE_SLASH = 32,
  sym_comment = 33,
  sym_template = 34,
  sym__declaration = 35,
  sym_string_literal = 36,
  sym__single_quote_string_literal = 37,
  sym__double_quote_string_literal = 38,
  sym_boolean_literal = 39,
  sym_element_node_start = 40,
  sym_element_node_end = 41,
  sym_element_node_void = 42,
  sym_element_node = 43,
  sym_attribute_node = 44,
  sym_concat_statement = 45,
  sym__single_quote_concat_statement = 46,
  sym__double_quote_concat_statement = 47,
  sym_block_params = 48,
  sym_path_expression = 49,
  sym__expression = 50,
  sym_hash_pair = 51,
  sym_mustache_statement = 52,
  sym_sub_expression = 53,
  sym__arguments = 54,
  sym_helper_invocation = 55,
  sym_block_statement_start = 56,
  sym_block_statement_end = 57,
  sym_block_statement = 58,
  aux_sym_template_repeat1 = 59,
  aux_sym_element_node_start_repeat1 = 60,
  aux_sym__single_quote_concat_statement_repeat1 = 61,
  aux_sym__double_quote_concat_statement_repeat1 = 62,
  aux_sym_block_params_repeat1 = 63,
  aux_sym_path_expression_repeat1 = 64,
  aux_sym__arguments_repeat1 = 65,
  aux_sym__arguments_repeat2 = 66,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_text_node] = "text_node",
  [anon_sym_SQUOTE] = "'",
  [aux_sym__single_quote_string_literal_token1] = "_single_quote_string_literal_token1",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__double_quote_string_literal_token1] = "_double_quote_string_literal_token1",
  [sym_number_literal] = "number_literal",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_tag_name] = "tag_name",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_SLASH] = "</",
  [anon_sym_SLASH_GT] = "/>",
  [sym_attribute_name] = "attribute_name",
  [sym__splattributes] = "attribute_name",
  [anon_sym_EQ] = "=",
  [sym__mustache_safe_single_quote_string_literal_content] = "_mustache_safe_single_quote_string_literal_content",
  [sym__mustache_safe_double_quote_string_literal_content] = "_mustache_safe_double_quote_string_literal_content",
  [anon_sym_as] = "as",
  [anon_sym_PIPE] = "|",
  [sym_identifier] = "identifier",
  [anon_sym_DOT] = ".",
  [anon_sym_LBRACE_LBRACE] = "{{",
  [anon_sym_LBRACE_LBRACE_TILDE] = "{{~",
  [anon_sym_RBRACE_RBRACE] = "}}",
  [anon_sym_TILDE_RBRACE_RBRACE] = "~}}",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_LBRACE_LBRACE_POUND] = "{{#",
  [anon_sym_LBRACE_LBRACE_TILDE_POUND] = "{{~#",
  [anon_sym_LBRACE_LBRACE_SLASH] = "{{/",
  [anon_sym_LBRACE_LBRACE_TILDE_SLASH] = "{{~/",
  [sym_comment] = "comment_statement",
  [sym_template] = "template",
  [sym__declaration] = "_declaration",
  [sym_string_literal] = "string_literal",
  [sym__single_quote_string_literal] = "_single_quote_string_literal",
  [sym__double_quote_string_literal] = "_double_quote_string_literal",
  [sym_boolean_literal] = "boolean_literal",
  [sym_element_node_start] = "element_node_start",
  [sym_element_node_end] = "element_node_end",
  [sym_element_node_void] = "element_node_void",
  [sym_element_node] = "element_node",
  [sym_attribute_node] = "attribute_node",
  [sym_concat_statement] = "concat_statement",
  [sym__single_quote_concat_statement] = "_single_quote_concat_statement",
  [sym__double_quote_concat_statement] = "_double_quote_concat_statement",
  [sym_block_params] = "block_params",
  [sym_path_expression] = "path_expression",
  [sym__expression] = "_expression",
  [sym_hash_pair] = "hash_pair",
  [sym_mustache_statement] = "mustache_statement",
  [sym_sub_expression] = "sub_expression",
  [sym__arguments] = "_arguments",
  [sym_helper_invocation] = "helper_invocation",
  [sym_block_statement_start] = "block_statement_start",
  [sym_block_statement_end] = "block_statement_end",
  [sym_block_statement] = "block_statement",
  [aux_sym_template_repeat1] = "template_repeat1",
  [aux_sym_element_node_start_repeat1] = "element_node_start_repeat1",
  [aux_sym__single_quote_concat_statement_repeat1] = "_single_quote_concat_statement_repeat1",
  [aux_sym__double_quote_concat_statement_repeat1] = "_double_quote_concat_statement_repeat1",
  [aux_sym_block_params_repeat1] = "block_params_repeat1",
  [aux_sym_path_expression_repeat1] = "path_expression_repeat1",
  [aux_sym__arguments_repeat1] = "_arguments_repeat1",
  [aux_sym__arguments_repeat2] = "_arguments_repeat2",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_text_node] = sym_text_node,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym__single_quote_string_literal_token1] = aux_sym__single_quote_string_literal_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__double_quote_string_literal_token1] = aux_sym__double_quote_string_literal_token1,
  [sym_number_literal] = sym_number_literal,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_tag_name] = sym_tag_name,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_SLASH] = anon_sym_LT_SLASH,
  [anon_sym_SLASH_GT] = anon_sym_SLASH_GT,
  [sym_attribute_name] = sym_attribute_name,
  [sym__splattributes] = sym_attribute_name,
  [anon_sym_EQ] = anon_sym_EQ,
  [sym__mustache_safe_single_quote_string_literal_content] = sym__mustache_safe_single_quote_string_literal_content,
  [sym__mustache_safe_double_quote_string_literal_content] = sym__mustache_safe_double_quote_string_literal_content,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [sym_identifier] = sym_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LBRACE_LBRACE] = anon_sym_LBRACE_LBRACE,
  [anon_sym_LBRACE_LBRACE_TILDE] = anon_sym_LBRACE_LBRACE_TILDE,
  [anon_sym_RBRACE_RBRACE] = anon_sym_RBRACE_RBRACE,
  [anon_sym_TILDE_RBRACE_RBRACE] = anon_sym_TILDE_RBRACE_RBRACE,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_LBRACE_LBRACE_POUND] = anon_sym_LBRACE_LBRACE_POUND,
  [anon_sym_LBRACE_LBRACE_TILDE_POUND] = anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [anon_sym_LBRACE_LBRACE_SLASH] = anon_sym_LBRACE_LBRACE_SLASH,
  [anon_sym_LBRACE_LBRACE_TILDE_SLASH] = anon_sym_LBRACE_LBRACE_TILDE_SLASH,
  [sym_comment] = sym_comment,
  [sym_template] = sym_template,
  [sym__declaration] = sym__declaration,
  [sym_string_literal] = sym_string_literal,
  [sym__single_quote_string_literal] = sym__single_quote_string_literal,
  [sym__double_quote_string_literal] = sym__double_quote_string_literal,
  [sym_boolean_literal] = sym_boolean_literal,
  [sym_element_node_start] = sym_element_node_start,
  [sym_element_node_end] = sym_element_node_end,
  [sym_element_node_void] = sym_element_node_void,
  [sym_element_node] = sym_element_node,
  [sym_attribute_node] = sym_attribute_node,
  [sym_concat_statement] = sym_concat_statement,
  [sym__single_quote_concat_statement] = sym__single_quote_concat_statement,
  [sym__double_quote_concat_statement] = sym__double_quote_concat_statement,
  [sym_block_params] = sym_block_params,
  [sym_path_expression] = sym_path_expression,
  [sym__expression] = sym__expression,
  [sym_hash_pair] = sym_hash_pair,
  [sym_mustache_statement] = sym_mustache_statement,
  [sym_sub_expression] = sym_sub_expression,
  [sym__arguments] = sym__arguments,
  [sym_helper_invocation] = sym_helper_invocation,
  [sym_block_statement_start] = sym_block_statement_start,
  [sym_block_statement_end] = sym_block_statement_end,
  [sym_block_statement] = sym_block_statement,
  [aux_sym_template_repeat1] = aux_sym_template_repeat1,
  [aux_sym_element_node_start_repeat1] = aux_sym_element_node_start_repeat1,
  [aux_sym__single_quote_concat_statement_repeat1] = aux_sym__single_quote_concat_statement_repeat1,
  [aux_sym__double_quote_concat_statement_repeat1] = aux_sym__double_quote_concat_statement_repeat1,
  [aux_sym_block_params_repeat1] = aux_sym_block_params_repeat1,
  [aux_sym_path_expression_repeat1] = aux_sym_path_expression_repeat1,
  [aux_sym__arguments_repeat1] = aux_sym__arguments_repeat1,
  [aux_sym__arguments_repeat2] = aux_sym__arguments_repeat2,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_text_node] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__single_quote_string_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__double_quote_string_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_number_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_tag_name] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_attribute_name] = {
    .visible = true,
    .named = true,
  },
  [sym__splattributes] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym__mustache_safe_single_quote_string_literal_content] = {
    .visible = false,
    .named = true,
  },
  [sym__mustache_safe_double_quote_string_literal_content] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_RBRACE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE_TILDE_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE_TILDE_SLASH] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_template] = {
    .visible = true,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__single_quote_string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__double_quote_string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_boolean_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_element_node_start] = {
    .visible = true,
    .named = true,
  },
  [sym_element_node_end] = {
    .visible = true,
    .named = true,
  },
  [sym_element_node_void] = {
    .visible = true,
    .named = true,
  },
  [sym_element_node] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_node] = {
    .visible = true,
    .named = true,
  },
  [sym_concat_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__single_quote_concat_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__double_quote_concat_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_block_params] = {
    .visible = true,
    .named = true,
  },
  [sym_path_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_hash_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_mustache_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_sub_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__arguments] = {
    .visible = false,
    .named = true,
  },
  [sym_helper_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym_block_statement_start] = {
    .visible = true,
    .named = true,
  },
  [sym_block_statement_end] = {
    .visible = true,
    .named = true,
  },
  [sym_block_statement] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_template_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_element_node_start_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__single_quote_concat_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__double_quote_concat_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_params_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_path_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__arguments_repeat2] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_argument = 1,
  field_helper = 2,
  field_key = 3,
  field_path = 4,
  field_program = 5,
  field_value = 6,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_argument] = "argument",
  [field_helper] = "helper",
  [field_key] = "key",
  [field_path] = "path",
  [field_program] = "program",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 1},
  [5] = {.index = 5, .length = 2},
  [6] = {.index = 7, .length = 2},
  [7] = {.index = 9, .length = 1},
  [8] = {.index = 10, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_argument, 0},
  [1] =
    {field_argument, 1, .inherited = true},
    {field_helper, 0},
  [3] =
    {field_argument, 0, .inherited = true},
  [4] =
    {field_program, 1},
  [5] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [7] =
    {field_argument, 2, .inherited = true},
    {field_path, 1},
  [9] =
    {field_path, 1},
  [10] =
    {field_key, 0},
    {field_value, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 5,
  [6] = 5,
  [7] = 4,
  [8] = 4,
  [9] = 9,
  [10] = 10,
  [11] = 9,
  [12] = 12,
  [13] = 13,
  [14] = 9,
  [15] = 10,
  [16] = 10,
  [17] = 17,
  [18] = 18,
  [19] = 18,
  [20] = 18,
  [21] = 13,
  [22] = 17,
  [23] = 17,
  [24] = 24,
  [25] = 13,
  [26] = 26,
  [27] = 24,
  [28] = 24,
  [29] = 29,
  [30] = 30,
  [31] = 30,
  [32] = 30,
  [33] = 30,
  [34] = 29,
  [35] = 30,
  [36] = 29,
  [37] = 29,
  [38] = 29,
  [39] = 29,
  [40] = 30,
  [41] = 41,
  [42] = 41,
  [43] = 41,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 44,
  [50] = 47,
  [51] = 51,
  [52] = 45,
  [53] = 45,
  [54] = 47,
  [55] = 46,
  [56] = 51,
  [57] = 57,
  [58] = 44,
  [59] = 59,
  [60] = 48,
  [61] = 46,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 57,
  [66] = 62,
  [67] = 48,
  [68] = 63,
  [69] = 51,
  [70] = 70,
  [71] = 64,
  [72] = 72,
  [73] = 73,
  [74] = 73,
  [75] = 72,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 70,
  [91] = 91,
  [92] = 57,
  [93] = 93,
  [94] = 78,
  [95] = 88,
  [96] = 72,
  [97] = 97,
  [98] = 73,
  [99] = 84,
  [100] = 83,
  [101] = 86,
  [102] = 87,
  [103] = 85,
  [104] = 76,
  [105] = 77,
  [106] = 106,
  [107] = 77,
  [108] = 85,
  [109] = 86,
  [110] = 87,
  [111] = 63,
  [112] = 64,
  [113] = 88,
  [114] = 84,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 62,
  [119] = 89,
  [120] = 76,
  [121] = 121,
  [122] = 77,
  [123] = 83,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 70,
  [128] = 128,
  [129] = 89,
  [130] = 78,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 46,
  [136] = 48,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 51,
  [143] = 137,
  [144] = 134,
  [145] = 57,
  [146] = 51,
  [147] = 48,
  [148] = 139,
  [149] = 46,
  [150] = 72,
  [151] = 73,
  [152] = 62,
  [153] = 153,
  [154] = 48,
  [155] = 155,
  [156] = 64,
  [157] = 57,
  [158] = 134,
  [159] = 63,
  [160] = 77,
  [161] = 46,
  [162] = 137,
  [163] = 139,
  [164] = 77,
  [165] = 51,
  [166] = 64,
  [167] = 167,
  [168] = 168,
  [169] = 62,
  [170] = 63,
  [171] = 171,
  [172] = 73,
  [173] = 72,
  [174] = 155,
  [175] = 175,
  [176] = 176,
  [177] = 57,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 73,
  [182] = 62,
  [183] = 180,
  [184] = 180,
  [185] = 180,
  [186] = 72,
  [187] = 187,
  [188] = 180,
  [189] = 189,
  [190] = 187,
  [191] = 180,
  [192] = 155,
  [193] = 187,
  [194] = 64,
  [195] = 63,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 199,
  [201] = 201,
  [202] = 202,
  [203] = 198,
  [204] = 196,
  [205] = 205,
  [206] = 197,
  [207] = 196,
  [208] = 198,
  [209] = 199,
  [210] = 197,
  [211] = 201,
  [212] = 205,
  [213] = 197,
  [214] = 201,
  [215] = 198,
  [216] = 197,
  [217] = 205,
  [218] = 197,
  [219] = 196,
  [220] = 198,
  [221] = 205,
  [222] = 205,
  [223] = 196,
  [224] = 196,
  [225] = 198,
  [226] = 202,
  [227] = 205,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 202,
  [234] = 234,
  [235] = 228,
  [236] = 229,
  [237] = 232,
  [238] = 231,
  [239] = 232,
  [240] = 231,
  [241] = 228,
  [242] = 229,
  [243] = 243,
  [244] = 229,
  [245] = 228,
  [246] = 229,
  [247] = 228,
  [248] = 248,
  [249] = 228,
  [250] = 229,
  [251] = 251,
};

static inline bool sym_attribute_name_character_set_1(int32_t c) {
  return (c < '\''
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c >= ' ' && c <= '"')))
    : (c <= ')' || (c < '<'
      ? (c < '.'
        ? c == ','
        : c <= '/')
      : (c <= '?' || (c >= '{' && c <= '}')))));
}

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < '\''
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c >= ' ' && c <= '"')))
    : (c <= ')' || (c < '<'
      ? (c < '.'
        ? c == ','
        : c <= '/')
      : (c <= '>' || (c >= '{' && c <= '}')))));
}

static inline bool sym_identifier_character_set_2(int32_t c) {
  return (c < '\''
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c >= ' ' && c <= '"')))
    : (c <= ')' || (c < '<'
      ? (c < '.'
        ? c == ','
        : c <= '/')
      : (c <= '>' || (c >= '{' && c <= '|')))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(33);
      if (lookahead == '"') ADVANCE(39);
      if (lookahead == '\'') ADVANCE(36);
      if (lookahead == '(') ADVANCE(83);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '.') ADVANCE(74);
      if (lookahead == '/') ADVANCE(14);
      if (lookahead == '<') ADVANCE(48);
      if (lookahead == '=') ADVANCE(55);
      if (lookahead == '>') ADVANCE(49);
      if (lookahead == 'a') ADVANCE(68);
      if (lookahead == 'f') ADVANCE(63);
      if (lookahead == 't') ADVANCE(67);
      if (lookahead == '{') ADVANCE(25);
      if (lookahead == '|') ADVANCE(62);
      if (lookahead == '}') ADVANCE(28);
      if (lookahead == '~') ADVANCE(71);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(42);
      if (lookahead != 0 &&
          lookahead != '!' &&
          lookahead != ',') ADVANCE(72);
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(39);
      if (lookahead == '\'') ADVANCE(36);
      if (lookahead == '(') ADVANCE(83);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '.') ADVANCE(73);
      if (lookahead == '=') ADVANCE(55);
      if (lookahead == 'f') ADVANCE(63);
      if (lookahead == 't') ADVANCE(67);
      if (lookahead == '}') ADVANCE(28);
      if (lookahead == '~') ADVANCE(71);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(1)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(42);
      if (lookahead != 0 &&
          lookahead != '!' &&
          lookahead != ',' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead) &&
          lookahead != '{' &&
          lookahead != '|') ADVANCE(72);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(39);
      if (lookahead == '\'') ADVANCE(36);
      if (lookahead == '(') ADVANCE(83);
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '.') ADVANCE(73);
      if (lookahead == '=') ADVANCE(55);
      if (lookahead == 'f') ADVANCE(63);
      if (lookahead == 't') ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(42);
      if (lookahead != 0 &&
          lookahead != '!' &&
          lookahead != ',' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead) &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(72);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(39);
      if (lookahead == '\'') ADVANCE(36);
      if (lookahead == '(') ADVANCE(83);
      if (lookahead == '.') ADVANCE(73);
      if (lookahead == '=') ADVANCE(55);
      if (lookahead == 'a') ADVANCE(68);
      if (lookahead == 'f') ADVANCE(63);
      if (lookahead == 't') ADVANCE(67);
      if (lookahead == '}') ADVANCE(28);
      if (lookahead == '~') ADVANCE(71);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(42);
      if (lookahead != 0 &&
          lookahead != '!' &&
          lookahead != ')' &&
          lookahead != ',' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead) &&
          lookahead != '{' &&
          lookahead != '|') ADVANCE(72);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(39);
      if (lookahead == '\'') ADVANCE(36);
      if (lookahead == '{') ADVANCE(27);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(43);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(39);
      if (lookahead == '{') ADVANCE(27);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(58);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(59);
      END_STATE();
    case 6:
      if (lookahead == '\'') ADVANCE(36);
      if (lookahead == '{') ADVANCE(27);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(56);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(57);
      END_STATE();
    case 7:
      if (lookahead == ')') ADVANCE(84);
      if (lookahead == '.') ADVANCE(73);
      if (lookahead == '|') ADVANCE(62);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (lookahead != 0 &&
          lookahead != '!' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '(' &&
          lookahead != ',' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead) &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(72);
      END_STATE();
    case 8:
      if (lookahead == '.') ADVANCE(9);
      END_STATE();
    case 9:
      if (lookahead == '.') ADVANCE(15);
      END_STATE();
    case 10:
      if (lookahead == '.') ADVANCE(73);
      if (lookahead == 'a') ADVANCE(68);
      if (lookahead == '}') ADVANCE(28);
      if (lookahead == '~') ADVANCE(71);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10)
      if (lookahead != 0 &&
          lookahead != '!' &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ',' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead) &&
          lookahead != '{' &&
          lookahead != '|') ADVANCE(72);
      END_STATE();
    case 11:
      if (lookahead == '.') ADVANCE(73);
      if (lookahead == '}') ADVANCE(28);
      if (lookahead == '~') ADVANCE(71);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      if (lookahead != 0 &&
          lookahead != '!' &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ',' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead) &&
          lookahead != '{' &&
          lookahead != '|') ADVANCE(72);
      END_STATE();
    case 12:
      if (lookahead == '.') ADVANCE(8);
      if (lookahead == '/') ADVANCE(14);
      if (lookahead == '=') ADVANCE(55);
      if (lookahead == '>') ADVANCE(49);
      if (lookahead == 'a') ADVANCE(52);
      if (lookahead == '{') ADVANCE(27);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (lookahead != 0 &&
          lookahead != '!' &&
          lookahead != '"' &&
          (lookahead < '\'' || ')' < lookahead) &&
          lookahead != ',' &&
          (lookahead < '<' || '?' < lookahead) &&
          lookahead != '|' &&
          lookahead != '}') ADVANCE(53);
      END_STATE();
    case 13:
      if (lookahead == '<') ADVANCE(47);
      if (lookahead == '{') ADVANCE(25);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(34);
      if (lookahead != 0 &&
          lookahead != '>' &&
          lookahead != '}') ADVANCE(35);
      END_STATE();
    case 14:
      if (lookahead == '>') ADVANCE(51);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(23);
      END_STATE();
    case 16:
      if (lookahead == 'b') ADVANCE(24);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(20);
      END_STATE();
    case 18:
      if (lookahead == 'i') ADVANCE(16);
      END_STATE();
    case 19:
      if (lookahead == 'r') ADVANCE(18);
      END_STATE();
    case 20:
      if (lookahead == 's') ADVANCE(54);
      END_STATE();
    case 21:
      if (lookahead == 't') ADVANCE(19);
      END_STATE();
    case 22:
      if (lookahead == 't') ADVANCE(17);
      END_STATE();
    case 23:
      if (lookahead == 't') ADVANCE(21);
      END_STATE();
    case 24:
      if (lookahead == 'u') ADVANCE(22);
      END_STATE();
    case 25:
      if (lookahead == '{') ADVANCE(75);
      END_STATE();
    case 26:
      if (lookahead == '{') ADVANCE(76);
      END_STATE();
    case 27:
      if (lookahead == '{') ADVANCE(77);
      END_STATE();
    case 28:
      if (lookahead == '}') ADVANCE(81);
      END_STATE();
    case 29:
      if (lookahead == '}') ADVANCE(82);
      END_STATE();
    case 30:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(46);
      END_STATE();
    case 31:
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(46);
      if (lookahead == '@') ADVANCE(30);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(31)
      END_STATE();
    case 32:
      if (eof) ADVANCE(33);
      if (lookahead == '<') ADVANCE(48);
      if (lookahead == '{') ADVANCE(26);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(34);
      if (lookahead != 0 &&
          lookahead != '>' &&
          lookahead != '}') ADVANCE(35);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(sym_text_node);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(34);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(35);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(sym_text_node);
      if (lookahead != 0 &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(35);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(aux_sym__single_quote_string_literal_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(37);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(38);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(aux_sym__single_quote_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(38);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(aux_sym__double_quote_string_literal_token1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(40);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(41);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(aux_sym__double_quote_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(41);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(sym_number_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(42);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(72);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_number_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(43);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_true);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(72);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_false);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(72);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_tag_name);
      if (lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= ':') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(46);
      if (lookahead == '@') ADVANCE(30);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '/') ADVANCE(50);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_LT_SLASH);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_SLASH_GT);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_attribute_name);
      if (lookahead == 's') ADVANCE(60);
      if (!sym_attribute_name_character_set_1(lookahead)) ADVANCE(53);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_attribute_name);
      if (!sym_attribute_name_character_set_1(lookahead)) ADVANCE(53);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym__splattributes);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym__mustache_safe_single_quote_string_literal_content);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(56);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(57);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym__mustache_safe_single_quote_string_literal_content);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(57);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym__mustache_safe_double_quote_string_literal_content);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(58);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(59);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym__mustache_safe_double_quote_string_literal_content);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(59);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_as);
      if (!sym_attribute_name_character_set_1(lookahead)) ADVANCE(53);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_as);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(72);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(66);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(72);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(44);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(72);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(45);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(72);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(69);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(72);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(70);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(72);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(61);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(72);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(65);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(72);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(64);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(72);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '}') ADVANCE(29);
      if (!sym_identifier_character_set_2(lookahead)) ADVANCE(72);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_identifier);
      if (!sym_identifier_character_set_1(lookahead)) ADVANCE(72);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(9);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '/') ADVANCE(87);
      if (lookahead == '~') ADVANCE(80);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '~') ADVANCE(79);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE);
      if (lookahead == '~') ADVANCE(78);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE_TILDE);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE_TILDE);
      if (lookahead == '#') ADVANCE(86);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE_TILDE);
      if (lookahead == '#') ADVANCE(86);
      if (lookahead == '/') ADVANCE(88);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_RBRACE_RBRACE);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_TILDE_RBRACE_RBRACE);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE_POUND);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE_TILDE_POUND);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE_SLASH);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE_TILDE_SLASH);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 32, .external_lex_state = 1},
  [2] = {.lex_state = 1},
  [3] = {.lex_state = 2},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 1},
  [6] = {.lex_state = 2},
  [7] = {.lex_state = 1},
  [8] = {.lex_state = 2},
  [9] = {.lex_state = 13, .external_lex_state = 1},
  [10] = {.lex_state = 13, .external_lex_state = 1},
  [11] = {.lex_state = 13, .external_lex_state = 1},
  [12] = {.lex_state = 2},
  [13] = {.lex_state = 0},
  [14] = {.lex_state = 13, .external_lex_state = 1},
  [15] = {.lex_state = 13, .external_lex_state = 1},
  [16] = {.lex_state = 13, .external_lex_state = 1},
  [17] = {.lex_state = 32, .external_lex_state = 1},
  [18] = {.lex_state = 32, .external_lex_state = 1},
  [19] = {.lex_state = 32, .external_lex_state = 1},
  [20] = {.lex_state = 32, .external_lex_state = 1},
  [21] = {.lex_state = 1},
  [22] = {.lex_state = 32, .external_lex_state = 1},
  [23] = {.lex_state = 32, .external_lex_state = 1},
  [24] = {.lex_state = 13, .external_lex_state = 1},
  [25] = {.lex_state = 2},
  [26] = {.lex_state = 32, .external_lex_state = 1},
  [27] = {.lex_state = 32, .external_lex_state = 1},
  [28] = {.lex_state = 32, .external_lex_state = 1},
  [29] = {.lex_state = 2},
  [30] = {.lex_state = 2},
  [31] = {.lex_state = 2},
  [32] = {.lex_state = 2},
  [33] = {.lex_state = 2},
  [34] = {.lex_state = 2},
  [35] = {.lex_state = 2},
  [36] = {.lex_state = 2},
  [37] = {.lex_state = 2},
  [38] = {.lex_state = 2},
  [39] = {.lex_state = 2},
  [40] = {.lex_state = 2},
  [41] = {.lex_state = 2},
  [42] = {.lex_state = 2},
  [43] = {.lex_state = 2},
  [44] = {.lex_state = 3},
  [45] = {.lex_state = 12, .external_lex_state = 1},
  [46] = {.lex_state = 3},
  [47] = {.lex_state = 12, .external_lex_state = 1},
  [48] = {.lex_state = 3},
  [49] = {.lex_state = 1},
  [50] = {.lex_state = 12, .external_lex_state = 1},
  [51] = {.lex_state = 3},
  [52] = {.lex_state = 12, .external_lex_state = 1},
  [53] = {.lex_state = 12, .external_lex_state = 1},
  [54] = {.lex_state = 12, .external_lex_state = 1},
  [55] = {.lex_state = 1},
  [56] = {.lex_state = 1},
  [57] = {.lex_state = 3},
  [58] = {.lex_state = 2},
  [59] = {.lex_state = 12, .external_lex_state = 1},
  [60] = {.lex_state = 1},
  [61] = {.lex_state = 2},
  [62] = {.lex_state = 0},
  [63] = {.lex_state = 1},
  [64] = {.lex_state = 1},
  [65] = {.lex_state = 1},
  [66] = {.lex_state = 1},
  [67] = {.lex_state = 2},
  [68] = {.lex_state = 0},
  [69] = {.lex_state = 2},
  [70] = {.lex_state = 0},
  [71] = {.lex_state = 0},
  [72] = {.lex_state = 1},
  [73] = {.lex_state = 1},
  [74] = {.lex_state = 0},
  [75] = {.lex_state = 0},
  [76] = {.lex_state = 13, .external_lex_state = 1},
  [77] = {.lex_state = 13, .external_lex_state = 1},
  [78] = {.lex_state = 13, .external_lex_state = 1},
  [79] = {.lex_state = 12, .external_lex_state = 1},
  [80] = {.lex_state = 13, .external_lex_state = 1},
  [81] = {.lex_state = 13, .external_lex_state = 1},
  [82] = {.lex_state = 13, .external_lex_state = 1},
  [83] = {.lex_state = 13, .external_lex_state = 1},
  [84] = {.lex_state = 13, .external_lex_state = 1},
  [85] = {.lex_state = 13, .external_lex_state = 1},
  [86] = {.lex_state = 13, .external_lex_state = 1},
  [87] = {.lex_state = 13, .external_lex_state = 1},
  [88] = {.lex_state = 13, .external_lex_state = 1},
  [89] = {.lex_state = 13, .external_lex_state = 1},
  [90] = {.lex_state = 1},
  [91] = {.lex_state = 13, .external_lex_state = 1},
  [92] = {.lex_state = 2},
  [93] = {.lex_state = 4},
  [94] = {.lex_state = 32, .external_lex_state = 1},
  [95] = {.lex_state = 32, .external_lex_state = 1},
  [96] = {.lex_state = 2},
  [97] = {.lex_state = 32, .external_lex_state = 1},
  [98] = {.lex_state = 2},
  [99] = {.lex_state = 32, .external_lex_state = 1},
  [100] = {.lex_state = 32, .external_lex_state = 1},
  [101] = {.lex_state = 32, .external_lex_state = 1},
  [102] = {.lex_state = 32, .external_lex_state = 1},
  [103] = {.lex_state = 32, .external_lex_state = 1},
  [104] = {.lex_state = 32, .external_lex_state = 1},
  [105] = {.lex_state = 32, .external_lex_state = 1},
  [106] = {.lex_state = 12, .external_lex_state = 1},
  [107] = {.lex_state = 32, .external_lex_state = 1},
  [108] = {.lex_state = 32, .external_lex_state = 1},
  [109] = {.lex_state = 32, .external_lex_state = 1},
  [110] = {.lex_state = 32, .external_lex_state = 1},
  [111] = {.lex_state = 2},
  [112] = {.lex_state = 2},
  [113] = {.lex_state = 32, .external_lex_state = 1},
  [114] = {.lex_state = 32, .external_lex_state = 1},
  [115] = {.lex_state = 12, .external_lex_state = 1},
  [116] = {.lex_state = 12, .external_lex_state = 1},
  [117] = {.lex_state = 32, .external_lex_state = 1},
  [118] = {.lex_state = 2},
  [119] = {.lex_state = 32, .external_lex_state = 1},
  [120] = {.lex_state = 32, .external_lex_state = 1},
  [121] = {.lex_state = 12, .external_lex_state = 1},
  [122] = {.lex_state = 12, .external_lex_state = 1},
  [123] = {.lex_state = 32, .external_lex_state = 1},
  [124] = {.lex_state = 12, .external_lex_state = 1},
  [125] = {.lex_state = 32, .external_lex_state = 1},
  [126] = {.lex_state = 12, .external_lex_state = 1},
  [127] = {.lex_state = 2},
  [128] = {.lex_state = 12, .external_lex_state = 1},
  [129] = {.lex_state = 32, .external_lex_state = 1},
  [130] = {.lex_state = 32, .external_lex_state = 1},
  [131] = {.lex_state = 6},
  [132] = {.lex_state = 5},
  [133] = {.lex_state = 6},
  [134] = {.lex_state = 10},
  [135] = {.lex_state = 10},
  [136] = {.lex_state = 10},
  [137] = {.lex_state = 10},
  [138] = {.lex_state = 5},
  [139] = {.lex_state = 10},
  [140] = {.lex_state = 5},
  [141] = {.lex_state = 6},
  [142] = {.lex_state = 10},
  [143] = {.lex_state = 11},
  [144] = {.lex_state = 11},
  [145] = {.lex_state = 10},
  [146] = {.lex_state = 11},
  [147] = {.lex_state = 11},
  [148] = {.lex_state = 11},
  [149] = {.lex_state = 11},
  [150] = {.lex_state = 10},
  [151] = {.lex_state = 10},
  [152] = {.lex_state = 10},
  [153] = {.lex_state = 0},
  [154] = {.lex_state = 7},
  [155] = {.lex_state = 10},
  [156] = {.lex_state = 10},
  [157] = {.lex_state = 11},
  [158] = {.lex_state = 7},
  [159] = {.lex_state = 10},
  [160] = {.lex_state = 5},
  [161] = {.lex_state = 7},
  [162] = {.lex_state = 7},
  [163] = {.lex_state = 7},
  [164] = {.lex_state = 6},
  [165] = {.lex_state = 7},
  [166] = {.lex_state = 11},
  [167] = {.lex_state = 0},
  [168] = {.lex_state = 7},
  [169] = {.lex_state = 11},
  [170] = {.lex_state = 11},
  [171] = {.lex_state = 0},
  [172] = {.lex_state = 11},
  [173] = {.lex_state = 11},
  [174] = {.lex_state = 11},
  [175] = {.lex_state = 0},
  [176] = {.lex_state = 7},
  [177] = {.lex_state = 7},
  [178] = {.lex_state = 7},
  [179] = {.lex_state = 0},
  [180] = {.lex_state = 0},
  [181] = {.lex_state = 7},
  [182] = {.lex_state = 7},
  [183] = {.lex_state = 0},
  [184] = {.lex_state = 0},
  [185] = {.lex_state = 0},
  [186] = {.lex_state = 7},
  [187] = {.lex_state = 0},
  [188] = {.lex_state = 0},
  [189] = {.lex_state = 0},
  [190] = {.lex_state = 0},
  [191] = {.lex_state = 0},
  [192] = {.lex_state = 7},
  [193] = {.lex_state = 0},
  [194] = {.lex_state = 7},
  [195] = {.lex_state = 7},
  [196] = {.lex_state = 7},
  [197] = {.lex_state = 0},
  [198] = {.lex_state = 0},
  [199] = {.lex_state = 0},
  [200] = {.lex_state = 0},
  [201] = {.lex_state = 0},
  [202] = {.lex_state = 31},
  [203] = {.lex_state = 0},
  [204] = {.lex_state = 7},
  [205] = {.lex_state = 0},
  [206] = {.lex_state = 0},
  [207] = {.lex_state = 7},
  [208] = {.lex_state = 0},
  [209] = {.lex_state = 0},
  [210] = {.lex_state = 0},
  [211] = {.lex_state = 0},
  [212] = {.lex_state = 0},
  [213] = {.lex_state = 0},
  [214] = {.lex_state = 0},
  [215] = {.lex_state = 0},
  [216] = {.lex_state = 0},
  [217] = {.lex_state = 0},
  [218] = {.lex_state = 0},
  [219] = {.lex_state = 7},
  [220] = {.lex_state = 0},
  [221] = {.lex_state = 0},
  [222] = {.lex_state = 0},
  [223] = {.lex_state = 7},
  [224] = {.lex_state = 7},
  [225] = {.lex_state = 0},
  [226] = {.lex_state = 31},
  [227] = {.lex_state = 0},
  [228] = {.lex_state = 37},
  [229] = {.lex_state = 40},
  [230] = {.lex_state = 0},
  [231] = {.lex_state = 31},
  [232] = {.lex_state = 7},
  [233] = {.lex_state = 31},
  [234] = {.lex_state = 0},
  [235] = {.lex_state = 37},
  [236] = {.lex_state = 40},
  [237] = {.lex_state = 7},
  [238] = {.lex_state = 31},
  [239] = {.lex_state = 7},
  [240] = {.lex_state = 31},
  [241] = {.lex_state = 37},
  [242] = {.lex_state = 40},
  [243] = {.lex_state = 0},
  [244] = {.lex_state = 40},
  [245] = {.lex_state = 37},
  [246] = {.lex_state = 40},
  [247] = {.lex_state = 37},
  [248] = {.lex_state = 0},
  [249] = {.lex_state = 37},
  [250] = {.lex_state = 40},
  [251] = {.lex_state = 7},
};

enum {
  ts_external_token_comment = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_comment] = sym_comment,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_comment] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_number_literal] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_SLASH] = ACTIONS(1),
    [anon_sym_SLASH_GT] = ACTIONS(1),
    [sym__splattributes] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE_TILDE] = ACTIONS(1),
    [anon_sym_RBRACE_RBRACE] = ACTIONS(1),
    [anon_sym_TILDE_RBRACE_RBRACE] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE_POUND] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE_TILDE_POUND] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE_SLASH] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE_TILDE_SLASH] = ACTIONS(1),
    [sym_comment] = ACTIONS(1),
  },
  [1] = {
    [sym_template] = STATE(248),
    [sym__declaration] = STATE(26),
    [sym_element_node_start] = STATE(20),
    [sym_element_node_void] = STATE(129),
    [sym_element_node] = STATE(26),
    [sym_mustache_statement] = STATE(26),
    [sym_block_statement_start] = STATE(9),
    [sym_block_statement] = STATE(26),
    [aux_sym_template_repeat1] = STATE(26),
    [ts_builtin_sym_end] = ACTIONS(3),
    [sym_text_node] = ACTIONS(5),
    [anon_sym_LT] = ACTIONS(7),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(9),
    [anon_sym_LBRACE_LBRACE_TILDE] = ACTIONS(9),
    [anon_sym_LBRACE_LBRACE_POUND] = ACTIONS(11),
    [anon_sym_LBRACE_LBRACE_TILDE_POUND] = ACTIONS(11),
    [sym_comment] = ACTIONS(5),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 14,
    ACTIONS(13), 1,
      anon_sym_SQUOTE,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(17), 1,
      sym_number_literal,
    ACTIONS(21), 1,
      sym_identifier,
    ACTIONS(23), 1,
      anon_sym_DOT,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    STATE(7), 1,
      aux_sym__arguments_repeat1,
    STATE(55), 1,
      aux_sym_path_expression_repeat1,
    STATE(167), 1,
      sym__arguments,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
    STATE(73), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(148), 2,
      sym_hash_pair,
      aux_sym__arguments_repeat2,
    STATE(90), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym_path_expression,
      sym__expression,
      sym_sub_expression,
  [51] = 14,
    ACTIONS(25), 1,
      anon_sym_RPAREN,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      sym_number_literal,
    ACTIONS(37), 1,
      sym_identifier,
    ACTIONS(39), 1,
      anon_sym_DOT,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    STATE(8), 1,
      aux_sym__arguments_repeat1,
    STATE(61), 1,
      aux_sym_path_expression_repeat1,
    STATE(167), 1,
      sym__arguments,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(98), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(163), 2,
      sym_hash_pair,
      aux_sym__arguments_repeat2,
    STATE(127), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym_path_expression,
      sym__expression,
      sym_sub_expression,
  [101] = 12,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      sym_number_literal,
    ACTIONS(51), 1,
      anon_sym_as,
    ACTIONS(53), 1,
      sym_identifier,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    STATE(13), 1,
      aux_sym__arguments_repeat1,
    ACTIONS(49), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(55), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
    STATE(74), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(137), 2,
      sym_hash_pair,
      aux_sym__arguments_repeat2,
    STATE(70), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym_path_expression,
      sym__expression,
      sym_sub_expression,
  [146] = 12,
    ACTIONS(13), 1,
      anon_sym_SQUOTE,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(17), 1,
      sym_number_literal,
    ACTIONS(21), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    STATE(7), 1,
      aux_sym__arguments_repeat1,
    STATE(179), 1,
      sym__arguments,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(25), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
    STATE(73), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(148), 2,
      sym_hash_pair,
      aux_sym__arguments_repeat2,
    STATE(90), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym_path_expression,
      sym__expression,
      sym_sub_expression,
  [191] = 12,
    ACTIONS(25), 1,
      anon_sym_RPAREN,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      sym_number_literal,
    ACTIONS(37), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    STATE(8), 1,
      aux_sym__arguments_repeat1,
    STATE(179), 1,
      sym__arguments,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(98), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(163), 2,
      sym_hash_pair,
      aux_sym__arguments_repeat2,
    STATE(127), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym_path_expression,
      sym__expression,
      sym_sub_expression,
  [235] = 11,
    ACTIONS(13), 1,
      anon_sym_SQUOTE,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(17), 1,
      sym_number_literal,
    ACTIONS(21), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    STATE(21), 1,
      aux_sym__arguments_repeat1,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(55), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
    STATE(73), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(143), 2,
      sym_hash_pair,
      aux_sym__arguments_repeat2,
    STATE(90), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym_path_expression,
      sym__expression,
      sym_sub_expression,
  [277] = 11,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_DQUOTE,
    ACTIONS(33), 1,
      sym_number_literal,
    ACTIONS(37), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      anon_sym_RPAREN,
    STATE(25), 1,
      aux_sym__arguments_repeat1,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(98), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(162), 2,
      sym_hash_pair,
      aux_sym__arguments_repeat2,
    STATE(127), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym_path_expression,
      sym__expression,
      sym_sub_expression,
  [318] = 10,
    ACTIONS(61), 1,
      anon_sym_LT,
    STATE(11), 1,
      sym_block_statement_start,
    STATE(19), 1,
      sym_element_node_start,
    STATE(89), 1,
      sym_element_node_void,
    STATE(123), 1,
      sym_block_statement_end,
    ACTIONS(11), 2,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
    ACTIONS(59), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(63), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    ACTIONS(65), 2,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
    STATE(15), 5,
      sym__declaration,
      sym_element_node,
      sym_mustache_statement,
      sym_block_statement,
      aux_sym_template_repeat1,
  [357] = 10,
    ACTIONS(61), 1,
      anon_sym_LT,
    STATE(11), 1,
      sym_block_statement_start,
    STATE(19), 1,
      sym_element_node_start,
    STATE(89), 1,
      sym_element_node_void,
    STATE(109), 1,
      sym_block_statement_end,
    ACTIONS(11), 2,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
    ACTIONS(63), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    ACTIONS(67), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(69), 2,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
    STATE(24), 5,
      sym__declaration,
      sym_element_node,
      sym_mustache_statement,
      sym_block_statement,
      aux_sym_template_repeat1,
  [396] = 10,
    ACTIONS(61), 1,
      anon_sym_LT,
    STATE(11), 1,
      sym_block_statement_start,
    STATE(19), 1,
      sym_element_node_start,
    STATE(83), 1,
      sym_block_statement_end,
    STATE(89), 1,
      sym_element_node_void,
    ACTIONS(11), 2,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
    ACTIONS(63), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    ACTIONS(71), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(73), 2,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
    STATE(16), 5,
      sym__declaration,
      sym_element_node,
      sym_mustache_statement,
      sym_block_statement,
      aux_sym_template_repeat1,
  [435] = 11,
    ACTIONS(43), 1,
      anon_sym_SQUOTE,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      sym_number_literal,
    ACTIONS(53), 1,
      sym_identifier,
    ACTIONS(57), 1,
      anon_sym_LPAREN,
    STATE(4), 1,
      aux_sym__arguments_repeat1,
    STATE(153), 1,
      sym__arguments,
    ACTIONS(49), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(74), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(139), 2,
      sym_hash_pair,
      aux_sym__arguments_repeat2,
    STATE(70), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym_path_expression,
      sym__expression,
      sym_sub_expression,
  [476] = 11,
    ACTIONS(75), 1,
      anon_sym_SQUOTE,
    ACTIONS(78), 1,
      anon_sym_DQUOTE,
    ACTIONS(81), 1,
      sym_number_literal,
    ACTIONS(87), 1,
      anon_sym_as,
    ACTIONS(89), 1,
      sym_identifier,
    ACTIONS(94), 1,
      anon_sym_LPAREN,
    STATE(13), 1,
      aux_sym__arguments_repeat1,
    ACTIONS(84), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(92), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
    STATE(74), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(70), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym_path_expression,
      sym__expression,
      sym_sub_expression,
  [517] = 10,
    ACTIONS(61), 1,
      anon_sym_LT,
    STATE(11), 1,
      sym_block_statement_start,
    STATE(19), 1,
      sym_element_node_start,
    STATE(89), 1,
      sym_element_node_void,
    STATE(100), 1,
      sym_block_statement_end,
    ACTIONS(11), 2,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
    ACTIONS(63), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    ACTIONS(69), 2,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
    ACTIONS(97), 2,
      sym_comment,
      sym_text_node,
    STATE(10), 5,
      sym__declaration,
      sym_element_node,
      sym_mustache_statement,
      sym_block_statement,
      aux_sym_template_repeat1,
  [556] = 10,
    ACTIONS(61), 1,
      anon_sym_LT,
    STATE(11), 1,
      sym_block_statement_start,
    STATE(19), 1,
      sym_element_node_start,
    STATE(89), 1,
      sym_element_node_void,
    STATE(101), 1,
      sym_block_statement_end,
    ACTIONS(11), 2,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
    ACTIONS(63), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    ACTIONS(65), 2,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
    ACTIONS(67), 2,
      sym_comment,
      sym_text_node,
    STATE(24), 5,
      sym__declaration,
      sym_element_node,
      sym_mustache_statement,
      sym_block_statement,
      aux_sym_template_repeat1,
  [595] = 10,
    ACTIONS(61), 1,
      anon_sym_LT,
    STATE(11), 1,
      sym_block_statement_start,
    STATE(19), 1,
      sym_element_node_start,
    STATE(86), 1,
      sym_block_statement_end,
    STATE(89), 1,
      sym_element_node_void,
    ACTIONS(11), 2,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
    ACTIONS(63), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    ACTIONS(67), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(73), 2,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
    STATE(24), 5,
      sym__declaration,
      sym_element_node,
      sym_mustache_statement,
      sym_block_statement,
      aux_sym_template_repeat1,
  [634] = 10,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_LT_SLASH,
    STATE(14), 1,
      sym_block_statement_start,
    STATE(18), 1,
      sym_element_node_start,
    STATE(108), 1,
      sym_element_node_end,
    STATE(119), 1,
      sym_element_node_void,
    ACTIONS(11), 2,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
    ACTIONS(99), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(105), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    STATE(27), 5,
      sym__declaration,
      sym_element_node,
      sym_mustache_statement,
      sym_block_statement,
      aux_sym_template_repeat1,
  [672] = 10,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_LT_SLASH,
    STATE(14), 1,
      sym_block_statement_start,
    STATE(18), 1,
      sym_element_node_start,
    STATE(99), 1,
      sym_element_node_end,
    STATE(119), 1,
      sym_element_node_void,
    ACTIONS(11), 2,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
    ACTIONS(105), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    ACTIONS(107), 2,
      sym_comment,
      sym_text_node,
    STATE(17), 5,
      sym__declaration,
      sym_element_node,
      sym_mustache_statement,
      sym_block_statement,
      aux_sym_template_repeat1,
  [710] = 10,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(111), 1,
      anon_sym_LT_SLASH,
    STATE(14), 1,
      sym_block_statement_start,
    STATE(18), 1,
      sym_element_node_start,
    STATE(84), 1,
      sym_element_node_end,
    STATE(119), 1,
      sym_element_node_void,
    ACTIONS(11), 2,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
    ACTIONS(105), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    ACTIONS(109), 2,
      sym_comment,
      sym_text_node,
    STATE(23), 5,
      sym__declaration,
      sym_element_node,
      sym_mustache_statement,
      sym_block_statement,
      aux_sym_template_repeat1,
  [748] = 10,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(115), 1,
      anon_sym_LT_SLASH,
    STATE(14), 1,
      sym_block_statement_start,
    STATE(18), 1,
      sym_element_node_start,
    STATE(114), 1,
      sym_element_node_end,
    STATE(119), 1,
      sym_element_node_void,
    ACTIONS(11), 2,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
    ACTIONS(105), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    ACTIONS(113), 2,
      sym_comment,
      sym_text_node,
    STATE(22), 5,
      sym__declaration,
      sym_element_node,
      sym_mustache_statement,
      sym_block_statement,
      aux_sym_template_repeat1,
  [786] = 10,
    ACTIONS(117), 1,
      anon_sym_SQUOTE,
    ACTIONS(120), 1,
      anon_sym_DQUOTE,
    ACTIONS(123), 1,
      sym_number_literal,
    ACTIONS(129), 1,
      sym_identifier,
    ACTIONS(132), 1,
      anon_sym_LPAREN,
    STATE(21), 1,
      aux_sym__arguments_repeat1,
    ACTIONS(92), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
    ACTIONS(126), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(73), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(90), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym_path_expression,
      sym__expression,
      sym_sub_expression,
  [824] = 10,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(115), 1,
      anon_sym_LT_SLASH,
    STATE(14), 1,
      sym_block_statement_start,
    STATE(18), 1,
      sym_element_node_start,
    STATE(103), 1,
      sym_element_node_end,
    STATE(119), 1,
      sym_element_node_void,
    ACTIONS(11), 2,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
    ACTIONS(99), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(105), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    STATE(27), 5,
      sym__declaration,
      sym_element_node,
      sym_mustache_statement,
      sym_block_statement,
      aux_sym_template_repeat1,
  [862] = 10,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(111), 1,
      anon_sym_LT_SLASH,
    STATE(14), 1,
      sym_block_statement_start,
    STATE(18), 1,
      sym_element_node_start,
    STATE(85), 1,
      sym_element_node_end,
    STATE(119), 1,
      sym_element_node_void,
    ACTIONS(11), 2,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
    ACTIONS(99), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(105), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    STATE(27), 5,
      sym__declaration,
      sym_element_node,
      sym_mustache_statement,
      sym_block_statement,
      aux_sym_template_repeat1,
  [900] = 9,
    ACTIONS(138), 1,
      anon_sym_LT,
    STATE(11), 1,
      sym_block_statement_start,
    STATE(19), 1,
      sym_element_node_start,
    STATE(89), 1,
      sym_element_node_void,
    ACTIONS(135), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(141), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    ACTIONS(144), 2,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
    ACTIONS(147), 2,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
    STATE(24), 5,
      sym__declaration,
      sym_element_node,
      sym_mustache_statement,
      sym_block_statement,
      aux_sym_template_repeat1,
  [936] = 10,
    ACTIONS(92), 1,
      anon_sym_RPAREN,
    ACTIONS(149), 1,
      anon_sym_SQUOTE,
    ACTIONS(152), 1,
      anon_sym_DQUOTE,
    ACTIONS(155), 1,
      sym_number_literal,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(164), 1,
      anon_sym_LPAREN,
    STATE(25), 1,
      aux_sym__arguments_repeat1,
    ACTIONS(158), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(98), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(127), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym_path_expression,
      sym__expression,
      sym_sub_expression,
  [973] = 9,
    ACTIONS(7), 1,
      anon_sym_LT,
    ACTIONS(167), 1,
      ts_builtin_sym_end,
    STATE(9), 1,
      sym_block_statement_start,
    STATE(20), 1,
      sym_element_node_start,
    STATE(129), 1,
      sym_element_node_void,
    ACTIONS(9), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    ACTIONS(11), 2,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
    ACTIONS(169), 2,
      sym_comment,
      sym_text_node,
    STATE(28), 5,
      sym__declaration,
      sym_element_node,
      sym_mustache_statement,
      sym_block_statement,
      aux_sym_template_repeat1,
  [1008] = 9,
    ACTIONS(147), 1,
      anon_sym_LT_SLASH,
    ACTIONS(174), 1,
      anon_sym_LT,
    STATE(14), 1,
      sym_block_statement_start,
    STATE(18), 1,
      sym_element_node_start,
    STATE(119), 1,
      sym_element_node_void,
    ACTIONS(144), 2,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
    ACTIONS(171), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(177), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    STATE(27), 5,
      sym__declaration,
      sym_element_node,
      sym_mustache_statement,
      sym_block_statement,
      aux_sym_template_repeat1,
  [1043] = 9,
    ACTIONS(180), 1,
      ts_builtin_sym_end,
    ACTIONS(185), 1,
      anon_sym_LT,
    STATE(9), 1,
      sym_block_statement_start,
    STATE(20), 1,
      sym_element_node_start,
    STATE(129), 1,
      sym_element_node_void,
    ACTIONS(144), 2,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
    ACTIONS(182), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(188), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    STATE(28), 5,
      sym__declaration,
      sym_element_node,
      sym_mustache_statement,
      sym_block_statement,
      aux_sym_template_repeat1,
  [1078] = 9,
    ACTIONS(13), 1,
      anon_sym_SQUOTE,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      sym_number_literal,
    ACTIONS(193), 1,
      sym_identifier,
    STATE(6), 1,
      sym_path_expression,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(73), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(198), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym__expression,
      sym_sub_expression,
      sym_helper_invocation,
  [1112] = 9,
    ACTIONS(13), 1,
      anon_sym_SQUOTE,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      sym_number_literal,
    ACTIONS(197), 1,
      sym_identifier,
    STATE(5), 1,
      sym_path_expression,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(73), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(191), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym__expression,
      sym_sub_expression,
      sym_helper_invocation,
  [1146] = 9,
    ACTIONS(13), 1,
      anon_sym_SQUOTE,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(197), 1,
      sym_identifier,
    ACTIONS(199), 1,
      sym_number_literal,
    STATE(5), 1,
      sym_path_expression,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(73), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(183), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym__expression,
      sym_sub_expression,
      sym_helper_invocation,
  [1180] = 9,
    ACTIONS(13), 1,
      anon_sym_SQUOTE,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(197), 1,
      sym_identifier,
    ACTIONS(201), 1,
      sym_number_literal,
    STATE(5), 1,
      sym_path_expression,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(73), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(184), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym__expression,
      sym_sub_expression,
      sym_helper_invocation,
  [1214] = 9,
    ACTIONS(13), 1,
      anon_sym_SQUOTE,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(197), 1,
      sym_identifier,
    ACTIONS(203), 1,
      sym_number_literal,
    STATE(5), 1,
      sym_path_expression,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(73), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(185), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym__expression,
      sym_sub_expression,
      sym_helper_invocation,
  [1248] = 9,
    ACTIONS(13), 1,
      anon_sym_SQUOTE,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(205), 1,
      sym_number_literal,
    STATE(6), 1,
      sym_path_expression,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(73), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(220), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym__expression,
      sym_sub_expression,
      sym_helper_invocation,
  [1282] = 9,
    ACTIONS(13), 1,
      anon_sym_SQUOTE,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(197), 1,
      sym_identifier,
    ACTIONS(207), 1,
      sym_number_literal,
    STATE(5), 1,
      sym_path_expression,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(73), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(188), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym__expression,
      sym_sub_expression,
      sym_helper_invocation,
  [1316] = 9,
    ACTIONS(13), 1,
      anon_sym_SQUOTE,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(209), 1,
      sym_number_literal,
    STATE(6), 1,
      sym_path_expression,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(73), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(215), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym__expression,
      sym_sub_expression,
      sym_helper_invocation,
  [1350] = 9,
    ACTIONS(13), 1,
      anon_sym_SQUOTE,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(211), 1,
      sym_number_literal,
    STATE(6), 1,
      sym_path_expression,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(73), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(225), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym__expression,
      sym_sub_expression,
      sym_helper_invocation,
  [1384] = 9,
    ACTIONS(13), 1,
      anon_sym_SQUOTE,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(213), 1,
      sym_number_literal,
    STATE(6), 1,
      sym_path_expression,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(73), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(203), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym__expression,
      sym_sub_expression,
      sym_helper_invocation,
  [1418] = 9,
    ACTIONS(13), 1,
      anon_sym_SQUOTE,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(193), 1,
      sym_identifier,
    ACTIONS(215), 1,
      sym_number_literal,
    STATE(6), 1,
      sym_path_expression,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(73), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(208), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym__expression,
      sym_sub_expression,
      sym_helper_invocation,
  [1452] = 9,
    ACTIONS(13), 1,
      anon_sym_SQUOTE,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(197), 1,
      sym_identifier,
    ACTIONS(217), 1,
      sym_number_literal,
    STATE(5), 1,
      sym_path_expression,
    ACTIONS(19), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(73), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(180), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym__expression,
      sym_sub_expression,
      sym_helper_invocation,
  [1486] = 8,
    ACTIONS(219), 1,
      anon_sym_SQUOTE,
    ACTIONS(221), 1,
      anon_sym_DQUOTE,
    ACTIONS(223), 1,
      sym_number_literal,
    ACTIONS(227), 1,
      sym_identifier,
    ACTIONS(229), 1,
      anon_sym_LPAREN,
    ACTIONS(225), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(151), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(155), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym_path_expression,
      sym__expression,
      sym_sub_expression,
  [1517] = 8,
    ACTIONS(231), 1,
      anon_sym_SQUOTE,
    ACTIONS(233), 1,
      anon_sym_DQUOTE,
    ACTIONS(235), 1,
      sym_number_literal,
    ACTIONS(239), 1,
      sym_identifier,
    ACTIONS(241), 1,
      anon_sym_LPAREN,
    ACTIONS(237), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(181), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(192), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym_path_expression,
      sym__expression,
      sym_sub_expression,
  [1548] = 8,
    ACTIONS(243), 1,
      anon_sym_SQUOTE,
    ACTIONS(245), 1,
      anon_sym_DQUOTE,
    ACTIONS(247), 1,
      sym_number_literal,
    ACTIONS(251), 1,
      sym_identifier,
    ACTIONS(253), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(172), 2,
      sym__single_quote_string_literal,
      sym__double_quote_string_literal,
    STATE(174), 5,
      sym_string_literal,
      sym_boolean_literal,
      sym_path_expression,
      sym__expression,
      sym_sub_expression,
  [1579] = 5,
    ACTIONS(257), 1,
      anon_sym_EQ,
    ACTIONS(259), 1,
      anon_sym_DOT,
    STATE(46), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(25), 5,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
    ACTIONS(255), 5,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      anon_sym_as,
      sym_identifier,
  [1603] = 10,
    ACTIONS(261), 1,
      anon_sym_GT,
    ACTIONS(263), 1,
      anon_sym_SLASH_GT,
    ACTIONS(265), 1,
      sym_attribute_name,
    ACTIONS(267), 1,
      sym__splattributes,
    ACTIONS(269), 1,
      anon_sym_as,
    ACTIONS(271), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(273), 1,
      anon_sym_LBRACE_LBRACE_TILDE,
    ACTIONS(275), 1,
      sym_comment,
    STATE(230), 1,
      sym_block_params,
    STATE(50), 3,
      sym_attribute_node,
      sym_mustache_statement,
      aux_sym_element_node_start_repeat1,
  [1636] = 4,
    ACTIONS(259), 1,
      anon_sym_DOT,
    STATE(48), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(277), 5,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
    ACTIONS(279), 5,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      anon_sym_as,
      sym_identifier,
  [1657] = 10,
    ACTIONS(265), 1,
      sym_attribute_name,
    ACTIONS(267), 1,
      sym__splattributes,
    ACTIONS(269), 1,
      anon_sym_as,
    ACTIONS(271), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(273), 1,
      anon_sym_LBRACE_LBRACE_TILDE,
    ACTIONS(281), 1,
      anon_sym_GT,
    ACTIONS(283), 1,
      anon_sym_SLASH_GT,
    ACTIONS(285), 1,
      sym_comment,
    STATE(243), 1,
      sym_block_params,
    STATE(59), 3,
      sym_attribute_node,
      sym_mustache_statement,
      aux_sym_element_node_start_repeat1,
  [1690] = 4,
    ACTIONS(291), 1,
      anon_sym_DOT,
    STATE(48), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(287), 5,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
    ACTIONS(289), 5,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      anon_sym_as,
      sym_identifier,
  [1711] = 5,
    ACTIONS(23), 1,
      anon_sym_DOT,
    ACTIONS(294), 1,
      anon_sym_EQ,
    STATE(55), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(255), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(25), 5,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
  [1734] = 10,
    ACTIONS(265), 1,
      sym_attribute_name,
    ACTIONS(267), 1,
      sym__splattributes,
    ACTIONS(269), 1,
      anon_sym_as,
    ACTIONS(271), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(273), 1,
      anon_sym_LBRACE_LBRACE_TILDE,
    ACTIONS(281), 1,
      anon_sym_GT,
    ACTIONS(285), 1,
      sym_comment,
    ACTIONS(296), 1,
      anon_sym_SLASH_GT,
    STATE(243), 1,
      sym_block_params,
    STATE(59), 3,
      sym_attribute_node,
      sym_mustache_statement,
      aux_sym_element_node_start_repeat1,
  [1767] = 4,
    ACTIONS(259), 1,
      anon_sym_DOT,
    STATE(46), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(25), 5,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
    ACTIONS(255), 5,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      anon_sym_as,
      sym_identifier,
  [1788] = 10,
    ACTIONS(261), 1,
      anon_sym_GT,
    ACTIONS(265), 1,
      sym_attribute_name,
    ACTIONS(267), 1,
      sym__splattributes,
    ACTIONS(269), 1,
      anon_sym_as,
    ACTIONS(271), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(273), 1,
      anon_sym_LBRACE_LBRACE_TILDE,
    ACTIONS(298), 1,
      anon_sym_SLASH_GT,
    ACTIONS(300), 1,
      sym_comment,
    STATE(230), 1,
      sym_block_params,
    STATE(54), 3,
      sym_attribute_node,
      sym_mustache_statement,
      aux_sym_element_node_start_repeat1,
  [1821] = 10,
    ACTIONS(261), 1,
      anon_sym_GT,
    ACTIONS(265), 1,
      sym_attribute_name,
    ACTIONS(267), 1,
      sym__splattributes,
    ACTIONS(269), 1,
      anon_sym_as,
    ACTIONS(271), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(273), 1,
      anon_sym_LBRACE_LBRACE_TILDE,
    ACTIONS(302), 1,
      anon_sym_SLASH_GT,
    ACTIONS(304), 1,
      sym_comment,
    STATE(230), 1,
      sym_block_params,
    STATE(47), 3,
      sym_attribute_node,
      sym_mustache_statement,
      aux_sym_element_node_start_repeat1,
  [1854] = 10,
    ACTIONS(265), 1,
      sym_attribute_name,
    ACTIONS(267), 1,
      sym__splattributes,
    ACTIONS(269), 1,
      anon_sym_as,
    ACTIONS(271), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(273), 1,
      anon_sym_LBRACE_LBRACE_TILDE,
    ACTIONS(281), 1,
      anon_sym_GT,
    ACTIONS(285), 1,
      sym_comment,
    ACTIONS(306), 1,
      anon_sym_SLASH_GT,
    STATE(243), 1,
      sym_block_params,
    STATE(59), 3,
      sym_attribute_node,
      sym_mustache_statement,
      aux_sym_element_node_start_repeat1,
  [1887] = 4,
    ACTIONS(23), 1,
      anon_sym_DOT,
    STATE(60), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(279), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(277), 5,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
  [1907] = 4,
    ACTIONS(23), 1,
      anon_sym_DOT,
    STATE(55), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(255), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(25), 5,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
  [1927] = 2,
    ACTIONS(289), 5,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      anon_sym_as,
      sym_identifier,
    ACTIONS(287), 6,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_DOT,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
  [1943] = 5,
    ACTIONS(39), 1,
      anon_sym_DOT,
    ACTIONS(308), 1,
      anon_sym_EQ,
    STATE(61), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(25), 4,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(255), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [1965] = 8,
    ACTIONS(312), 1,
      sym_attribute_name,
    ACTIONS(315), 1,
      sym__splattributes,
    ACTIONS(318), 1,
      anon_sym_as,
    ACTIONS(320), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(323), 1,
      anon_sym_LBRACE_LBRACE_TILDE,
    ACTIONS(326), 1,
      sym_comment,
    ACTIONS(310), 2,
      anon_sym_GT,
      anon_sym_SLASH_GT,
    STATE(59), 3,
      sym_attribute_node,
      sym_mustache_statement,
      aux_sym_element_node_start_repeat1,
  [1993] = 4,
    ACTIONS(329), 1,
      anon_sym_DOT,
    STATE(60), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(289), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(287), 5,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
  [2013] = 4,
    ACTIONS(39), 1,
      anon_sym_DOT,
    STATE(67), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(277), 4,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(279), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [2032] = 2,
    ACTIONS(332), 5,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
    ACTIONS(334), 5,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      anon_sym_as,
      sym_identifier,
  [2047] = 2,
    ACTIONS(338), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(336), 6,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [2062] = 2,
    ACTIONS(342), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(340), 6,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [2077] = 2,
    ACTIONS(289), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(287), 6,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_DOT,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
  [2092] = 2,
    ACTIONS(334), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(332), 6,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [2107] = 4,
    ACTIONS(344), 1,
      anon_sym_DOT,
    STATE(67), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(287), 4,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(289), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [2126] = 2,
    ACTIONS(336), 5,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
    ACTIONS(338), 5,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      anon_sym_as,
      sym_identifier,
  [2141] = 4,
    ACTIONS(39), 1,
      anon_sym_DOT,
    STATE(61), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(25), 4,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(255), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [2160] = 2,
    ACTIONS(347), 5,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
    ACTIONS(349), 5,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      anon_sym_as,
      sym_identifier,
  [2175] = 2,
    ACTIONS(340), 5,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
    ACTIONS(342), 5,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      anon_sym_as,
      sym_identifier,
  [2190] = 2,
    ACTIONS(353), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(351), 6,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [2205] = 2,
    ACTIONS(357), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(355), 6,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [2220] = 2,
    ACTIONS(355), 5,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
    ACTIONS(357), 5,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      anon_sym_as,
      sym_identifier,
  [2235] = 2,
    ACTIONS(351), 5,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
    ACTIONS(353), 5,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      anon_sym_as,
      sym_identifier,
  [2250] = 2,
    ACTIONS(359), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(361), 7,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
  [2264] = 2,
    ACTIONS(363), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(365), 7,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
  [2278] = 2,
    ACTIONS(367), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(369), 7,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
  [2292] = 3,
    ACTIONS(375), 1,
      anon_sym_EQ,
    ACTIONS(373), 3,
      sym_attribute_name,
      anon_sym_as,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(371), 5,
      sym_comment,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym__splattributes,
      anon_sym_LBRACE_LBRACE_TILDE,
  [2308] = 2,
    ACTIONS(377), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(379), 7,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
  [2322] = 2,
    ACTIONS(381), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(383), 7,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
  [2336] = 2,
    ACTIONS(381), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(383), 7,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
  [2350] = 2,
    ACTIONS(385), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(387), 7,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
  [2364] = 2,
    ACTIONS(389), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(391), 7,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
  [2378] = 2,
    ACTIONS(393), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(395), 7,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
  [2392] = 2,
    ACTIONS(397), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(399), 7,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
  [2406] = 2,
    ACTIONS(401), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(403), 7,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
  [2420] = 2,
    ACTIONS(405), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(407), 7,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
  [2434] = 2,
    ACTIONS(409), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(411), 7,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
  [2448] = 2,
    ACTIONS(349), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(347), 5,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_LPAREN,
  [2462] = 2,
    ACTIONS(377), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(379), 7,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
      anon_sym_LBRACE_LBRACE_SLASH,
      anon_sym_LBRACE_LBRACE_TILDE_SLASH,
  [2476] = 2,
    ACTIONS(289), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
    ACTIONS(287), 5,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [2490] = 7,
    ACTIONS(271), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(273), 1,
      anon_sym_LBRACE_LBRACE_TILDE,
    ACTIONS(413), 1,
      anon_sym_SQUOTE,
    ACTIONS(415), 1,
      anon_sym_DQUOTE,
    ACTIONS(417), 1,
      sym_number_literal,
    STATE(106), 2,
      sym_concat_statement,
      sym_mustache_statement,
    STATE(116), 2,
      sym__single_quote_concat_statement,
      sym__double_quote_concat_statement,
  [2514] = 2,
    ACTIONS(367), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(369), 6,
      anon_sym_LT,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2527] = 2,
    ACTIONS(405), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(407), 6,
      anon_sym_LT,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2540] = 2,
    ACTIONS(351), 4,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(353), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [2553] = 2,
    ACTIONS(419), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(421), 6,
      anon_sym_LT,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2566] = 2,
    ACTIONS(355), 4,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(357), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [2579] = 2,
    ACTIONS(389), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(391), 6,
      anon_sym_LT,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2592] = 2,
    ACTIONS(385), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(387), 6,
      anon_sym_LT,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2605] = 2,
    ACTIONS(397), 3,
      sym_comment,
      ts_builtin_sym_end,
      sym_text_node,
    ACTIONS(399), 5,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2618] = 2,
    ACTIONS(401), 3,
      sym_comment,
      ts_builtin_sym_end,
      sym_text_node,
    ACTIONS(403), 5,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2631] = 2,
    ACTIONS(393), 3,
      sym_comment,
      ts_builtin_sym_end,
      sym_text_node,
    ACTIONS(395), 5,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2644] = 2,
    ACTIONS(359), 3,
      sym_comment,
      ts_builtin_sym_end,
      sym_text_node,
    ACTIONS(361), 5,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2657] = 2,
    ACTIONS(363), 3,
      sym_comment,
      ts_builtin_sym_end,
      sym_text_node,
    ACTIONS(365), 5,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2670] = 2,
    ACTIONS(425), 3,
      sym_attribute_name,
      anon_sym_as,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(423), 5,
      sym_comment,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym__splattributes,
      anon_sym_LBRACE_LBRACE_TILDE,
  [2683] = 2,
    ACTIONS(363), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(365), 6,
      anon_sym_LT,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2696] = 2,
    ACTIONS(393), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(395), 6,
      anon_sym_LT,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2709] = 2,
    ACTIONS(397), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(399), 6,
      anon_sym_LT,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2722] = 2,
    ACTIONS(401), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(403), 6,
      anon_sym_LT,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2735] = 2,
    ACTIONS(336), 4,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(338), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [2748] = 2,
    ACTIONS(340), 4,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(342), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [2761] = 2,
    ACTIONS(405), 3,
      sym_comment,
      ts_builtin_sym_end,
      sym_text_node,
    ACTIONS(407), 5,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2774] = 2,
    ACTIONS(389), 3,
      sym_comment,
      ts_builtin_sym_end,
      sym_text_node,
    ACTIONS(391), 5,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2787] = 2,
    ACTIONS(429), 3,
      sym_attribute_name,
      anon_sym_as,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(427), 5,
      sym_comment,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym__splattributes,
      anon_sym_LBRACE_LBRACE_TILDE,
  [2800] = 2,
    ACTIONS(433), 3,
      sym_attribute_name,
      anon_sym_as,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(431), 5,
      sym_comment,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym__splattributes,
      anon_sym_LBRACE_LBRACE_TILDE,
  [2813] = 2,
    ACTIONS(435), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(437), 6,
      anon_sym_LT,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2826] = 2,
    ACTIONS(332), 4,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(334), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [2839] = 2,
    ACTIONS(409), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(411), 6,
      anon_sym_LT,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2852] = 2,
    ACTIONS(359), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(361), 6,
      anon_sym_LT,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2865] = 2,
    ACTIONS(373), 3,
      sym_attribute_name,
      anon_sym_as,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(371), 5,
      sym_comment,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym__splattributes,
      anon_sym_LBRACE_LBRACE_TILDE,
  [2878] = 2,
    ACTIONS(365), 3,
      sym_attribute_name,
      anon_sym_as,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(363), 5,
      sym_comment,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym__splattributes,
      anon_sym_LBRACE_LBRACE_TILDE,
  [2891] = 2,
    ACTIONS(385), 3,
      sym_comment,
      ts_builtin_sym_end,
      sym_text_node,
    ACTIONS(387), 5,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2904] = 2,
    ACTIONS(441), 3,
      sym_attribute_name,
      anon_sym_as,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(439), 5,
      sym_comment,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym__splattributes,
      anon_sym_LBRACE_LBRACE_TILDE,
  [2917] = 2,
    ACTIONS(443), 2,
      sym_comment,
      sym_text_node,
    ACTIONS(445), 6,
      anon_sym_LT,
      anon_sym_LT_SLASH,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2930] = 2,
    ACTIONS(449), 3,
      sym_attribute_name,
      anon_sym_as,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(447), 5,
      sym_comment,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym__splattributes,
      anon_sym_LBRACE_LBRACE_TILDE,
  [2943] = 2,
    ACTIONS(347), 4,
      anon_sym_SQUOTE,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
    ACTIONS(349), 4,
      sym_number_literal,
      anon_sym_true,
      anon_sym_false,
      sym_identifier,
  [2956] = 2,
    ACTIONS(453), 3,
      sym_attribute_name,
      anon_sym_as,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(451), 5,
      sym_comment,
      anon_sym_GT,
      anon_sym_SLASH_GT,
      sym__splattributes,
      anon_sym_LBRACE_LBRACE_TILDE,
  [2969] = 2,
    ACTIONS(409), 3,
      sym_comment,
      ts_builtin_sym_end,
      sym_text_node,
    ACTIONS(411), 5,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2982] = 2,
    ACTIONS(367), 3,
      sym_comment,
      ts_builtin_sym_end,
      sym_text_node,
    ACTIONS(369), 5,
      anon_sym_LT,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
      anon_sym_LBRACE_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE_TILDE_POUND,
  [2995] = 4,
    ACTIONS(455), 1,
      anon_sym_SQUOTE,
    ACTIONS(457), 1,
      sym__mustache_safe_single_quote_string_literal_content,
    ACTIONS(459), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    STATE(133), 2,
      sym_mustache_statement,
      aux_sym__single_quote_concat_statement_repeat1,
  [3010] = 4,
    ACTIONS(461), 1,
      anon_sym_DQUOTE,
    ACTIONS(463), 1,
      sym__mustache_safe_double_quote_string_literal_content,
    ACTIONS(465), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    STATE(138), 2,
      sym_mustache_statement,
      aux_sym__double_quote_concat_statement_repeat1,
  [3025] = 4,
    ACTIONS(467), 1,
      anon_sym_SQUOTE,
    ACTIONS(469), 1,
      sym__mustache_safe_single_quote_string_literal_content,
    ACTIONS(472), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    STATE(133), 2,
      sym_mustache_statement,
      aux_sym__single_quote_concat_statement_repeat1,
  [3040] = 4,
    ACTIONS(475), 1,
      anon_sym_as,
    ACTIONS(477), 1,
      sym_identifier,
    ACTIONS(480), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
    STATE(134), 2,
      sym_hash_pair,
      aux_sym__arguments_repeat2,
  [3055] = 4,
    ACTIONS(482), 1,
      anon_sym_DOT,
    STATE(136), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(277), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
    ACTIONS(279), 2,
      anon_sym_as,
      sym_identifier,
  [3070] = 4,
    ACTIONS(484), 1,
      anon_sym_DOT,
    STATE(136), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(287), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
    ACTIONS(289), 2,
      anon_sym_as,
      sym_identifier,
  [3085] = 4,
    ACTIONS(487), 1,
      anon_sym_as,
    ACTIONS(489), 1,
      sym_identifier,
    ACTIONS(491), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
    STATE(134), 2,
      sym_hash_pair,
      aux_sym__arguments_repeat2,
  [3100] = 4,
    ACTIONS(493), 1,
      anon_sym_DQUOTE,
    ACTIONS(495), 1,
      sym__mustache_safe_double_quote_string_literal_content,
    ACTIONS(498), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    STATE(138), 2,
      sym_mustache_statement,
      aux_sym__double_quote_concat_statement_repeat1,
  [3115] = 4,
    ACTIONS(489), 1,
      sym_identifier,
    ACTIONS(501), 1,
      anon_sym_as,
    ACTIONS(503), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
    STATE(134), 2,
      sym_hash_pair,
      aux_sym__arguments_repeat2,
  [3130] = 4,
    ACTIONS(505), 1,
      anon_sym_DQUOTE,
    ACTIONS(507), 1,
      sym__mustache_safe_double_quote_string_literal_content,
    ACTIONS(465), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    STATE(132), 2,
      sym_mustache_statement,
      aux_sym__double_quote_concat_statement_repeat1,
  [3145] = 4,
    ACTIONS(509), 1,
      anon_sym_SQUOTE,
    ACTIONS(511), 1,
      sym__mustache_safe_single_quote_string_literal_content,
    ACTIONS(459), 2,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
    STATE(131), 2,
      sym_mustache_statement,
      aux_sym__single_quote_concat_statement_repeat1,
  [3160] = 4,
    ACTIONS(482), 1,
      anon_sym_DOT,
    STATE(135), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(25), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
    ACTIONS(255), 2,
      anon_sym_as,
      sym_identifier,
  [3175] = 3,
    ACTIONS(513), 1,
      sym_identifier,
    ACTIONS(491), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
    STATE(144), 2,
      sym_hash_pair,
      aux_sym__arguments_repeat2,
  [3187] = 3,
    ACTIONS(515), 1,
      sym_identifier,
    ACTIONS(480), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
    STATE(144), 2,
      sym_hash_pair,
      aux_sym__arguments_repeat2,
  [3199] = 2,
    ACTIONS(289), 2,
      anon_sym_as,
      sym_identifier,
    ACTIONS(287), 3,
      anon_sym_DOT,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3209] = 4,
    ACTIONS(255), 1,
      sym_identifier,
    ACTIONS(518), 1,
      anon_sym_DOT,
    STATE(149), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(25), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3223] = 4,
    ACTIONS(289), 1,
      sym_identifier,
    ACTIONS(520), 1,
      anon_sym_DOT,
    STATE(147), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(287), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3237] = 3,
    ACTIONS(513), 1,
      sym_identifier,
    ACTIONS(503), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
    STATE(144), 2,
      sym_hash_pair,
      aux_sym__arguments_repeat2,
  [3249] = 4,
    ACTIONS(279), 1,
      sym_identifier,
    ACTIONS(518), 1,
      anon_sym_DOT,
    STATE(147), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(277), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3263] = 2,
    ACTIONS(351), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
    ACTIONS(353), 2,
      anon_sym_as,
      sym_identifier,
  [3272] = 2,
    ACTIONS(355), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
    ACTIONS(357), 2,
      anon_sym_as,
      sym_identifier,
  [3281] = 2,
    ACTIONS(332), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
    ACTIONS(334), 2,
      anon_sym_as,
      sym_identifier,
  [3290] = 4,
    ACTIONS(523), 1,
      anon_sym_as,
    ACTIONS(525), 1,
      anon_sym_RBRACE_RBRACE,
    ACTIONS(527), 1,
      anon_sym_TILDE_RBRACE_RBRACE,
    STATE(189), 1,
      sym_block_params,
  [3303] = 3,
    ACTIONS(529), 1,
      anon_sym_DOT,
    STATE(154), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(287), 2,
      sym_identifier,
      anon_sym_RPAREN,
  [3314] = 2,
    ACTIONS(532), 2,
      anon_sym_as,
      sym_identifier,
    ACTIONS(534), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3323] = 2,
    ACTIONS(340), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
    ACTIONS(342), 2,
      anon_sym_as,
      sym_identifier,
  [3332] = 2,
    ACTIONS(289), 1,
      sym_identifier,
    ACTIONS(287), 3,
      anon_sym_DOT,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3341] = 3,
    ACTIONS(480), 1,
      anon_sym_RPAREN,
    ACTIONS(536), 1,
      sym_identifier,
    STATE(158), 2,
      sym_hash_pair,
      aux_sym__arguments_repeat2,
  [3352] = 2,
    ACTIONS(336), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
    ACTIONS(338), 2,
      anon_sym_as,
      sym_identifier,
  [3361] = 2,
    ACTIONS(363), 1,
      sym__mustache_safe_double_quote_string_literal_content,
    ACTIONS(365), 3,
      anon_sym_DQUOTE,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
  [3370] = 3,
    ACTIONS(539), 1,
      anon_sym_DOT,
    STATE(154), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(277), 2,
      sym_identifier,
      anon_sym_RPAREN,
  [3381] = 3,
    ACTIONS(491), 1,
      anon_sym_RPAREN,
    ACTIONS(541), 1,
      sym_identifier,
    STATE(158), 2,
      sym_hash_pair,
      aux_sym__arguments_repeat2,
  [3392] = 3,
    ACTIONS(503), 1,
      anon_sym_RPAREN,
    ACTIONS(541), 1,
      sym_identifier,
    STATE(158), 2,
      sym_hash_pair,
      aux_sym__arguments_repeat2,
  [3403] = 2,
    ACTIONS(363), 1,
      sym__mustache_safe_single_quote_string_literal_content,
    ACTIONS(365), 3,
      anon_sym_SQUOTE,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_LBRACE_TILDE,
  [3412] = 3,
    ACTIONS(539), 1,
      anon_sym_DOT,
    STATE(161), 1,
      aux_sym_path_expression_repeat1,
    ACTIONS(25), 2,
      sym_identifier,
      anon_sym_RPAREN,
  [3423] = 2,
    ACTIONS(342), 1,
      sym_identifier,
    ACTIONS(340), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3431] = 1,
    ACTIONS(543), 3,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_RPAREN,
  [3437] = 3,
    ACTIONS(545), 1,
      anon_sym_PIPE,
    ACTIONS(547), 1,
      sym_identifier,
    STATE(176), 1,
      aux_sym_block_params_repeat1,
  [3447] = 2,
    ACTIONS(334), 1,
      sym_identifier,
    ACTIONS(332), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3455] = 2,
    ACTIONS(338), 1,
      sym_identifier,
    ACTIONS(336), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3463] = 1,
    ACTIONS(549), 3,
      anon_sym_GT,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3469] = 2,
    ACTIONS(357), 1,
      sym_identifier,
    ACTIONS(355), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3477] = 2,
    ACTIONS(353), 1,
      sym_identifier,
    ACTIONS(351), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3485] = 2,
    ACTIONS(532), 1,
      sym_identifier,
    ACTIONS(534), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3493] = 1,
    ACTIONS(551), 3,
      anon_sym_GT,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3499] = 3,
    ACTIONS(553), 1,
      anon_sym_PIPE,
    ACTIONS(555), 1,
      sym_identifier,
    STATE(176), 1,
      aux_sym_block_params_repeat1,
  [3509] = 1,
    ACTIONS(287), 3,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_RPAREN,
  [3515] = 3,
    ACTIONS(558), 1,
      anon_sym_PIPE,
    ACTIONS(560), 1,
      sym_identifier,
    STATE(168), 1,
      aux_sym_block_params_repeat1,
  [3525] = 1,
    ACTIONS(543), 3,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
      anon_sym_RPAREN,
  [3531] = 1,
    ACTIONS(562), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3536] = 1,
    ACTIONS(355), 2,
      sym_identifier,
      anon_sym_RPAREN,
  [3541] = 1,
    ACTIONS(332), 2,
      sym_identifier,
      anon_sym_RPAREN,
  [3546] = 1,
    ACTIONS(564), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3551] = 1,
    ACTIONS(566), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3556] = 1,
    ACTIONS(568), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3561] = 1,
    ACTIONS(351), 2,
      sym_identifier,
      anon_sym_RPAREN,
  [3566] = 1,
    ACTIONS(570), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3571] = 1,
    ACTIONS(572), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3576] = 2,
    ACTIONS(574), 1,
      anon_sym_RBRACE_RBRACE,
    ACTIONS(576), 1,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3583] = 1,
    ACTIONS(578), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3588] = 1,
    ACTIONS(580), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3593] = 1,
    ACTIONS(534), 2,
      sym_identifier,
      anon_sym_RPAREN,
  [3598] = 1,
    ACTIONS(582), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_TILDE_RBRACE_RBRACE,
  [3603] = 1,
    ACTIONS(340), 2,
      sym_identifier,
      anon_sym_RPAREN,
  [3608] = 1,
    ACTIONS(336), 2,
      sym_identifier,
      anon_sym_RPAREN,
  [3613] = 1,
    ACTIONS(584), 1,
      sym_identifier,
  [3617] = 1,
    ACTIONS(586), 1,
      anon_sym_DQUOTE,
  [3621] = 1,
    ACTIONS(588), 1,
      anon_sym_RPAREN,
  [3625] = 1,
    ACTIONS(590), 1,
      anon_sym_GT,
  [3629] = 1,
    ACTIONS(592), 1,
      anon_sym_GT,
  [3633] = 1,
    ACTIONS(257), 1,
      anon_sym_EQ,
  [3637] = 1,
    ACTIONS(594), 1,
      sym_tag_name,
  [3641] = 1,
    ACTIONS(596), 1,
      anon_sym_RPAREN,
  [3645] = 1,
    ACTIONS(598), 1,
      sym_identifier,
  [3649] = 1,
    ACTIONS(600), 1,
      anon_sym_SQUOTE,
  [3653] = 1,
    ACTIONS(602), 1,
      anon_sym_DQUOTE,
  [3657] = 1,
    ACTIONS(604), 1,
      sym_identifier,
  [3661] = 1,
    ACTIONS(606), 1,
      anon_sym_RPAREN,
  [3665] = 1,
    ACTIONS(608), 1,
      anon_sym_GT,
  [3669] = 1,
    ACTIONS(610), 1,
      anon_sym_DQUOTE,
  [3673] = 1,
    ACTIONS(308), 1,
      anon_sym_EQ,
  [3677] = 1,
    ACTIONS(612), 1,
      anon_sym_SQUOTE,
  [3681] = 1,
    ACTIONS(614), 1,
      anon_sym_DQUOTE,
  [3685] = 1,
    ACTIONS(294), 1,
      anon_sym_EQ,
  [3689] = 1,
    ACTIONS(616), 1,
      anon_sym_RPAREN,
  [3693] = 1,
    ACTIONS(618), 1,
      anon_sym_DQUOTE,
  [3697] = 1,
    ACTIONS(620), 1,
      anon_sym_SQUOTE,
  [3701] = 1,
    ACTIONS(622), 1,
      anon_sym_DQUOTE,
  [3705] = 1,
    ACTIONS(624), 1,
      sym_identifier,
  [3709] = 1,
    ACTIONS(626), 1,
      anon_sym_RPAREN,
  [3713] = 1,
    ACTIONS(628), 1,
      anon_sym_SQUOTE,
  [3717] = 1,
    ACTIONS(630), 1,
      anon_sym_SQUOTE,
  [3721] = 1,
    ACTIONS(632), 1,
      sym_identifier,
  [3725] = 1,
    ACTIONS(634), 1,
      sym_identifier,
  [3729] = 1,
    ACTIONS(636), 1,
      anon_sym_RPAREN,
  [3733] = 1,
    ACTIONS(638), 1,
      sym_tag_name,
  [3737] = 1,
    ACTIONS(640), 1,
      anon_sym_SQUOTE,
  [3741] = 1,
    ACTIONS(642), 1,
      aux_sym__single_quote_string_literal_token1,
  [3745] = 1,
    ACTIONS(644), 1,
      aux_sym__double_quote_string_literal_token1,
  [3749] = 1,
    ACTIONS(281), 1,
      anon_sym_GT,
  [3753] = 1,
    ACTIONS(646), 1,
      sym_tag_name,
  [3757] = 1,
    ACTIONS(648), 1,
      sym_identifier,
  [3761] = 1,
    ACTIONS(650), 1,
      sym_tag_name,
  [3765] = 1,
    ACTIONS(652), 1,
      anon_sym_PIPE,
  [3769] = 1,
    ACTIONS(654), 1,
      aux_sym__single_quote_string_literal_token1,
  [3773] = 1,
    ACTIONS(656), 1,
      aux_sym__double_quote_string_literal_token1,
  [3777] = 1,
    ACTIONS(658), 1,
      sym_identifier,
  [3781] = 1,
    ACTIONS(660), 1,
      sym_tag_name,
  [3785] = 1,
    ACTIONS(662), 1,
      sym_identifier,
  [3789] = 1,
    ACTIONS(664), 1,
      sym_tag_name,
  [3793] = 1,
    ACTIONS(666), 1,
      aux_sym__single_quote_string_literal_token1,
  [3797] = 1,
    ACTIONS(668), 1,
      aux_sym__double_quote_string_literal_token1,
  [3801] = 1,
    ACTIONS(670), 1,
      anon_sym_GT,
  [3805] = 1,
    ACTIONS(672), 1,
      aux_sym__double_quote_string_literal_token1,
  [3809] = 1,
    ACTIONS(674), 1,
      aux_sym__single_quote_string_literal_token1,
  [3813] = 1,
    ACTIONS(676), 1,
      aux_sym__double_quote_string_literal_token1,
  [3817] = 1,
    ACTIONS(678), 1,
      aux_sym__single_quote_string_literal_token1,
  [3821] = 1,
    ACTIONS(680), 1,
      ts_builtin_sym_end,
  [3825] = 1,
    ACTIONS(682), 1,
      aux_sym__single_quote_string_literal_token1,
  [3829] = 1,
    ACTIONS(684), 1,
      aux_sym__double_quote_string_literal_token1,
  [3833] = 1,
    ACTIONS(686), 1,
      sym_identifier,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 51,
  [SMALL_STATE(4)] = 101,
  [SMALL_STATE(5)] = 146,
  [SMALL_STATE(6)] = 191,
  [SMALL_STATE(7)] = 235,
  [SMALL_STATE(8)] = 277,
  [SMALL_STATE(9)] = 318,
  [SMALL_STATE(10)] = 357,
  [SMALL_STATE(11)] = 396,
  [SMALL_STATE(12)] = 435,
  [SMALL_STATE(13)] = 476,
  [SMALL_STATE(14)] = 517,
  [SMALL_STATE(15)] = 556,
  [SMALL_STATE(16)] = 595,
  [SMALL_STATE(17)] = 634,
  [SMALL_STATE(18)] = 672,
  [SMALL_STATE(19)] = 710,
  [SMALL_STATE(20)] = 748,
  [SMALL_STATE(21)] = 786,
  [SMALL_STATE(22)] = 824,
  [SMALL_STATE(23)] = 862,
  [SMALL_STATE(24)] = 900,
  [SMALL_STATE(25)] = 936,
  [SMALL_STATE(26)] = 973,
  [SMALL_STATE(27)] = 1008,
  [SMALL_STATE(28)] = 1043,
  [SMALL_STATE(29)] = 1078,
  [SMALL_STATE(30)] = 1112,
  [SMALL_STATE(31)] = 1146,
  [SMALL_STATE(32)] = 1180,
  [SMALL_STATE(33)] = 1214,
  [SMALL_STATE(34)] = 1248,
  [SMALL_STATE(35)] = 1282,
  [SMALL_STATE(36)] = 1316,
  [SMALL_STATE(37)] = 1350,
  [SMALL_STATE(38)] = 1384,
  [SMALL_STATE(39)] = 1418,
  [SMALL_STATE(40)] = 1452,
  [SMALL_STATE(41)] = 1486,
  [SMALL_STATE(42)] = 1517,
  [SMALL_STATE(43)] = 1548,
  [SMALL_STATE(44)] = 1579,
  [SMALL_STATE(45)] = 1603,
  [SMALL_STATE(46)] = 1636,
  [SMALL_STATE(47)] = 1657,
  [SMALL_STATE(48)] = 1690,
  [SMALL_STATE(49)] = 1711,
  [SMALL_STATE(50)] = 1734,
  [SMALL_STATE(51)] = 1767,
  [SMALL_STATE(52)] = 1788,
  [SMALL_STATE(53)] = 1821,
  [SMALL_STATE(54)] = 1854,
  [SMALL_STATE(55)] = 1887,
  [SMALL_STATE(56)] = 1907,
  [SMALL_STATE(57)] = 1927,
  [SMALL_STATE(58)] = 1943,
  [SMALL_STATE(59)] = 1965,
  [SMALL_STATE(60)] = 1993,
  [SMALL_STATE(61)] = 2013,
  [SMALL_STATE(62)] = 2032,
  [SMALL_STATE(63)] = 2047,
  [SMALL_STATE(64)] = 2062,
  [SMALL_STATE(65)] = 2077,
  [SMALL_STATE(66)] = 2092,
  [SMALL_STATE(67)] = 2107,
  [SMALL_STATE(68)] = 2126,
  [SMALL_STATE(69)] = 2141,
  [SMALL_STATE(70)] = 2160,
  [SMALL_STATE(71)] = 2175,
  [SMALL_STATE(72)] = 2190,
  [SMALL_STATE(73)] = 2205,
  [SMALL_STATE(74)] = 2220,
  [SMALL_STATE(75)] = 2235,
  [SMALL_STATE(76)] = 2250,
  [SMALL_STATE(77)] = 2264,
  [SMALL_STATE(78)] = 2278,
  [SMALL_STATE(79)] = 2292,
  [SMALL_STATE(80)] = 2308,
  [SMALL_STATE(81)] = 2322,
  [SMALL_STATE(82)] = 2336,
  [SMALL_STATE(83)] = 2350,
  [SMALL_STATE(84)] = 2364,
  [SMALL_STATE(85)] = 2378,
  [SMALL_STATE(86)] = 2392,
  [SMALL_STATE(87)] = 2406,
  [SMALL_STATE(88)] = 2420,
  [SMALL_STATE(89)] = 2434,
  [SMALL_STATE(90)] = 2448,
  [SMALL_STATE(91)] = 2462,
  [SMALL_STATE(92)] = 2476,
  [SMALL_STATE(93)] = 2490,
  [SMALL_STATE(94)] = 2514,
  [SMALL_STATE(95)] = 2527,
  [SMALL_STATE(96)] = 2540,
  [SMALL_STATE(97)] = 2553,
  [SMALL_STATE(98)] = 2566,
  [SMALL_STATE(99)] = 2579,
  [SMALL_STATE(100)] = 2592,
  [SMALL_STATE(101)] = 2605,
  [SMALL_STATE(102)] = 2618,
  [SMALL_STATE(103)] = 2631,
  [SMALL_STATE(104)] = 2644,
  [SMALL_STATE(105)] = 2657,
  [SMALL_STATE(106)] = 2670,
  [SMALL_STATE(107)] = 2683,
  [SMALL_STATE(108)] = 2696,
  [SMALL_STATE(109)] = 2709,
  [SMALL_STATE(110)] = 2722,
  [SMALL_STATE(111)] = 2735,
  [SMALL_STATE(112)] = 2748,
  [SMALL_STATE(113)] = 2761,
  [SMALL_STATE(114)] = 2774,
  [SMALL_STATE(115)] = 2787,
  [SMALL_STATE(116)] = 2800,
  [SMALL_STATE(117)] = 2813,
  [SMALL_STATE(118)] = 2826,
  [SMALL_STATE(119)] = 2839,
  [SMALL_STATE(120)] = 2852,
  [SMALL_STATE(121)] = 2865,
  [SMALL_STATE(122)] = 2878,
  [SMALL_STATE(123)] = 2891,
  [SMALL_STATE(124)] = 2904,
  [SMALL_STATE(125)] = 2917,
  [SMALL_STATE(126)] = 2930,
  [SMALL_STATE(127)] = 2943,
  [SMALL_STATE(128)] = 2956,
  [SMALL_STATE(129)] = 2969,
  [SMALL_STATE(130)] = 2982,
  [SMALL_STATE(131)] = 2995,
  [SMALL_STATE(132)] = 3010,
  [SMALL_STATE(133)] = 3025,
  [SMALL_STATE(134)] = 3040,
  [SMALL_STATE(135)] = 3055,
  [SMALL_STATE(136)] = 3070,
  [SMALL_STATE(137)] = 3085,
  [SMALL_STATE(138)] = 3100,
  [SMALL_STATE(139)] = 3115,
  [SMALL_STATE(140)] = 3130,
  [SMALL_STATE(141)] = 3145,
  [SMALL_STATE(142)] = 3160,
  [SMALL_STATE(143)] = 3175,
  [SMALL_STATE(144)] = 3187,
  [SMALL_STATE(145)] = 3199,
  [SMALL_STATE(146)] = 3209,
  [SMALL_STATE(147)] = 3223,
  [SMALL_STATE(148)] = 3237,
  [SMALL_STATE(149)] = 3249,
  [SMALL_STATE(150)] = 3263,
  [SMALL_STATE(151)] = 3272,
  [SMALL_STATE(152)] = 3281,
  [SMALL_STATE(153)] = 3290,
  [SMALL_STATE(154)] = 3303,
  [SMALL_STATE(155)] = 3314,
  [SMALL_STATE(156)] = 3323,
  [SMALL_STATE(157)] = 3332,
  [SMALL_STATE(158)] = 3341,
  [SMALL_STATE(159)] = 3352,
  [SMALL_STATE(160)] = 3361,
  [SMALL_STATE(161)] = 3370,
  [SMALL_STATE(162)] = 3381,
  [SMALL_STATE(163)] = 3392,
  [SMALL_STATE(164)] = 3403,
  [SMALL_STATE(165)] = 3412,
  [SMALL_STATE(166)] = 3423,
  [SMALL_STATE(167)] = 3431,
  [SMALL_STATE(168)] = 3437,
  [SMALL_STATE(169)] = 3447,
  [SMALL_STATE(170)] = 3455,
  [SMALL_STATE(171)] = 3463,
  [SMALL_STATE(172)] = 3469,
  [SMALL_STATE(173)] = 3477,
  [SMALL_STATE(174)] = 3485,
  [SMALL_STATE(175)] = 3493,
  [SMALL_STATE(176)] = 3499,
  [SMALL_STATE(177)] = 3509,
  [SMALL_STATE(178)] = 3515,
  [SMALL_STATE(179)] = 3525,
  [SMALL_STATE(180)] = 3531,
  [SMALL_STATE(181)] = 3536,
  [SMALL_STATE(182)] = 3541,
  [SMALL_STATE(183)] = 3546,
  [SMALL_STATE(184)] = 3551,
  [SMALL_STATE(185)] = 3556,
  [SMALL_STATE(186)] = 3561,
  [SMALL_STATE(187)] = 3566,
  [SMALL_STATE(188)] = 3571,
  [SMALL_STATE(189)] = 3576,
  [SMALL_STATE(190)] = 3583,
  [SMALL_STATE(191)] = 3588,
  [SMALL_STATE(192)] = 3593,
  [SMALL_STATE(193)] = 3598,
  [SMALL_STATE(194)] = 3603,
  [SMALL_STATE(195)] = 3608,
  [SMALL_STATE(196)] = 3613,
  [SMALL_STATE(197)] = 3617,
  [SMALL_STATE(198)] = 3621,
  [SMALL_STATE(199)] = 3625,
  [SMALL_STATE(200)] = 3629,
  [SMALL_STATE(201)] = 3633,
  [SMALL_STATE(202)] = 3637,
  [SMALL_STATE(203)] = 3641,
  [SMALL_STATE(204)] = 3645,
  [SMALL_STATE(205)] = 3649,
  [SMALL_STATE(206)] = 3653,
  [SMALL_STATE(207)] = 3657,
  [SMALL_STATE(208)] = 3661,
  [SMALL_STATE(209)] = 3665,
  [SMALL_STATE(210)] = 3669,
  [SMALL_STATE(211)] = 3673,
  [SMALL_STATE(212)] = 3677,
  [SMALL_STATE(213)] = 3681,
  [SMALL_STATE(214)] = 3685,
  [SMALL_STATE(215)] = 3689,
  [SMALL_STATE(216)] = 3693,
  [SMALL_STATE(217)] = 3697,
  [SMALL_STATE(218)] = 3701,
  [SMALL_STATE(219)] = 3705,
  [SMALL_STATE(220)] = 3709,
  [SMALL_STATE(221)] = 3713,
  [SMALL_STATE(222)] = 3717,
  [SMALL_STATE(223)] = 3721,
  [SMALL_STATE(224)] = 3725,
  [SMALL_STATE(225)] = 3729,
  [SMALL_STATE(226)] = 3733,
  [SMALL_STATE(227)] = 3737,
  [SMALL_STATE(228)] = 3741,
  [SMALL_STATE(229)] = 3745,
  [SMALL_STATE(230)] = 3749,
  [SMALL_STATE(231)] = 3753,
  [SMALL_STATE(232)] = 3757,
  [SMALL_STATE(233)] = 3761,
  [SMALL_STATE(234)] = 3765,
  [SMALL_STATE(235)] = 3769,
  [SMALL_STATE(236)] = 3773,
  [SMALL_STATE(237)] = 3777,
  [SMALL_STATE(238)] = 3781,
  [SMALL_STATE(239)] = 3785,
  [SMALL_STATE(240)] = 3789,
  [SMALL_STATE(241)] = 3793,
  [SMALL_STATE(242)] = 3797,
  [SMALL_STATE(243)] = 3801,
  [SMALL_STATE(244)] = 3805,
  [SMALL_STATE(245)] = 3809,
  [SMALL_STATE(246)] = 3813,
  [SMALL_STATE(247)] = 3817,
  [SMALL_STATE(248)] = 3821,
  [SMALL_STATE(249)] = 3825,
  [SMALL_STATE(250)] = 3829,
  [SMALL_STATE(251)] = 3833,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(202),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(31),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(251),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(90),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(72),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(49),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [25] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(58),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(70),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(75),
  [51] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__arguments, 1, .production_id = 3),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [55] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__arguments, 1, .production_id = 3),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(233),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(237),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(232),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(239),
  [75] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__arguments_repeat1, 2, .production_id = 5), SHIFT_REPEAT(228),
  [78] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__arguments_repeat1, 2, .production_id = 5), SHIFT_REPEAT(229),
  [81] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__arguments_repeat1, 2, .production_id = 5), SHIFT_REPEAT(70),
  [84] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__arguments_repeat1, 2, .production_id = 5), SHIFT_REPEAT(75),
  [87] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__arguments_repeat1, 2, .production_id = 5),
  [89] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__arguments_repeat1, 2, .production_id = 5), SHIFT_REPEAT(51),
  [92] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__arguments_repeat1, 2, .production_id = 5),
  [94] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__arguments_repeat1, 2, .production_id = 5), SHIFT_REPEAT(29),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [101] = {.entry = {.count = 1, .reusable = false}}, SHIFT(226),
  [103] = {.entry = {.count = 1, .reusable = false}}, SHIFT(231),
  [105] = {.entry = {.count = 1, .reusable = false}}, SHIFT(32),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [111] = {.entry = {.count = 1, .reusable = false}}, SHIFT(238),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [115] = {.entry = {.count = 1, .reusable = false}}, SHIFT(240),
  [117] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__arguments_repeat1, 2, .production_id = 5), SHIFT_REPEAT(247),
  [120] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__arguments_repeat1, 2, .production_id = 5), SHIFT_REPEAT(244),
  [123] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__arguments_repeat1, 2, .production_id = 5), SHIFT_REPEAT(90),
  [126] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__arguments_repeat1, 2, .production_id = 5), SHIFT_REPEAT(72),
  [129] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__arguments_repeat1, 2, .production_id = 5), SHIFT_REPEAT(56),
  [132] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__arguments_repeat1, 2, .production_id = 5), SHIFT_REPEAT(38),
  [135] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_template_repeat1, 2), SHIFT_REPEAT(24),
  [138] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_template_repeat1, 2), SHIFT_REPEAT(233),
  [141] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_template_repeat1, 2), SHIFT_REPEAT(40),
  [144] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_template_repeat1, 2), SHIFT_REPEAT(251),
  [147] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_template_repeat1, 2),
  [149] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__arguments_repeat1, 2, .production_id = 5), SHIFT_REPEAT(235),
  [152] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__arguments_repeat1, 2, .production_id = 5), SHIFT_REPEAT(236),
  [155] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__arguments_repeat1, 2, .production_id = 5), SHIFT_REPEAT(127),
  [158] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__arguments_repeat1, 2, .production_id = 5), SHIFT_REPEAT(96),
  [161] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__arguments_repeat1, 2, .production_id = 5), SHIFT_REPEAT(69),
  [164] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__arguments_repeat1, 2, .production_id = 5), SHIFT_REPEAT(39),
  [167] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template, 1),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [171] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_template_repeat1, 2), SHIFT_REPEAT(27),
  [174] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_template_repeat1, 2), SHIFT_REPEAT(226),
  [177] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_template_repeat1, 2), SHIFT_REPEAT(32),
  [180] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_template_repeat1, 2),
  [182] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_template_repeat1, 2), SHIFT_REPEAT(28),
  [185] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_template_repeat1, 2), SHIFT_REPEAT(202),
  [188] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_template_repeat1, 2), SHIFT_REPEAT(31),
  [191] = {.entry = {.count = 1, .reusable = false}}, SHIFT(198),
  [193] = {.entry = {.count = 1, .reusable = false}}, SHIFT(3),
  [195] = {.entry = {.count = 1, .reusable = false}}, SHIFT(191),
  [197] = {.entry = {.count = 1, .reusable = false}}, SHIFT(2),
  [199] = {.entry = {.count = 1, .reusable = false}}, SHIFT(183),
  [201] = {.entry = {.count = 1, .reusable = false}}, SHIFT(184),
  [203] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [205] = {.entry = {.count = 1, .reusable = false}}, SHIFT(220),
  [207] = {.entry = {.count = 1, .reusable = false}}, SHIFT(188),
  [209] = {.entry = {.count = 1, .reusable = false}}, SHIFT(215),
  [211] = {.entry = {.count = 1, .reusable = false}}, SHIFT(225),
  [213] = {.entry = {.count = 1, .reusable = false}}, SHIFT(203),
  [215] = {.entry = {.count = 1, .reusable = false}}, SHIFT(208),
  [217] = {.entry = {.count = 1, .reusable = false}}, SHIFT(180),
  [219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [223] = {.entry = {.count = 1, .reusable = false}}, SHIFT(155),
  [225] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [227] = {.entry = {.count = 1, .reusable = false}}, SHIFT(142),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [235] = {.entry = {.count = 1, .reusable = false}}, SHIFT(192),
  [237] = {.entry = {.count = 1, .reusable = false}}, SHIFT(186),
  [239] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [247] = {.entry = {.count = 1, .reusable = false}}, SHIFT(174),
  [249] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [251] = {.entry = {.count = 1, .reusable = false}}, SHIFT(146),
  [253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [255] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1),
  [257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [265] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [269] = {.entry = {.count = 1, .reusable = false}}, SHIFT(234),
  [271] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [277] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_path_expression, 2),
  [279] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_path_expression, 2),
  [281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [287] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2),
  [289] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_path_expression_repeat1, 2),
  [291] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(207),
  [294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [310] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_element_node_start_repeat1, 2),
  [312] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_element_node_start_repeat1, 2), SHIFT_REPEAT(79),
  [315] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_element_node_start_repeat1, 2), SHIFT_REPEAT(121),
  [318] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_element_node_start_repeat1, 2),
  [320] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_element_node_start_repeat1, 2), SHIFT_REPEAT(30),
  [323] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_element_node_start_repeat1, 2), SHIFT_REPEAT(30),
  [326] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_element_node_start_repeat1, 2), SHIFT_REPEAT(59),
  [329] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(204),
  [332] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sub_expression, 3),
  [334] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sub_expression, 3),
  [336] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__single_quote_string_literal, 3),
  [338] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__single_quote_string_literal, 3),
  [340] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__double_quote_string_literal, 3),
  [342] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__double_quote_string_literal, 3),
  [344] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(223),
  [347] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__arguments_repeat1, 1, .production_id = 1),
  [349] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__arguments_repeat1, 1, .production_id = 1),
  [351] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean_literal, 1),
  [353] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean_literal, 1),
  [355] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string_literal, 1),
  [357] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_literal, 1),
  [359] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_statement_end, 3, .production_id = 7),
  [361] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_statement_end, 3, .production_id = 7),
  [363] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mustache_statement, 3),
  [365] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mustache_statement, 3),
  [367] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_node_void, 3),
  [369] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element_node_void, 3),
  [371] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_node, 1),
  [373] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute_node, 1),
  [375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [377] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_statement_start, 4, .production_id = 6),
  [379] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_statement_start, 4, .production_id = 6),
  [381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_statement_start, 5, .production_id = 6),
  [383] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_statement_start, 5, .production_id = 6),
  [385] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_statement, 2),
  [387] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_statement, 2),
  [389] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_node, 2),
  [391] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element_node, 2),
  [393] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_node, 3),
  [395] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element_node, 3),
  [397] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_statement, 3, .production_id = 4),
  [399] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_statement, 3, .production_id = 4),
  [401] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_node_void, 4),
  [403] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element_node_void, 4),
  [405] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_node_end, 3),
  [407] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element_node_end, 3),
  [409] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_node, 1),
  [411] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element_node, 1),
  [413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [419] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_node_start, 4),
  [421] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element_node_start, 4),
  [423] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_node, 3),
  [425] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute_node, 3),
  [427] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__double_quote_concat_statement, 3),
  [429] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__double_quote_concat_statement, 3),
  [431] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_concat_statement, 1),
  [433] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_concat_statement, 1),
  [435] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_node_start, 5),
  [437] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element_node_start, 5),
  [439] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__single_quote_concat_statement, 3),
  [441] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__single_quote_concat_statement, 3),
  [443] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_element_node_start, 3),
  [445] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_element_node_start, 3),
  [447] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__double_quote_concat_statement, 2),
  [449] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__double_quote_concat_statement, 2),
  [451] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__single_quote_concat_statement, 2),
  [453] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__single_quote_concat_statement, 2),
  [455] = {.entry = {.count = 1, .reusable = false}}, SHIFT(124),
  [457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [459] = {.entry = {.count = 1, .reusable = false}}, SHIFT(35),
  [461] = {.entry = {.count = 1, .reusable = false}}, SHIFT(115),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [465] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [467] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__single_quote_concat_statement_repeat1, 2),
  [469] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__single_quote_concat_statement_repeat1, 2), SHIFT_REPEAT(133),
  [472] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__single_quote_concat_statement_repeat1, 2), SHIFT_REPEAT(35),
  [475] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__arguments_repeat2, 2),
  [477] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__arguments_repeat2, 2), SHIFT_REPEAT(201),
  [480] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__arguments_repeat2, 2),
  [482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [484] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(219),
  [487] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__arguments, 2, .production_id = 3),
  [489] = {.entry = {.count = 1, .reusable = false}}, SHIFT(201),
  [491] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__arguments, 2, .production_id = 3),
  [493] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__double_quote_concat_statement_repeat1, 2),
  [495] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__double_quote_concat_statement_repeat1, 2), SHIFT_REPEAT(138),
  [498] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__double_quote_concat_statement_repeat1, 2), SHIFT_REPEAT(33),
  [501] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__arguments, 1),
  [503] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__arguments, 1),
  [505] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [509] = {.entry = {.count = 1, .reusable = false}}, SHIFT(128),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [513] = {.entry = {.count = 1, .reusable = false}}, SHIFT(214),
  [515] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__arguments_repeat2, 2), SHIFT_REPEAT(214),
  [518] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [520] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(196),
  [523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [529] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_path_expression_repeat1, 2), SHIFT_REPEAT(224),
  [532] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_hash_pair, 3, .production_id = 8),
  [534] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_hash_pair, 3, .production_id = 8),
  [536] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__arguments_repeat2, 2), SHIFT_REPEAT(211),
  [539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [543] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_helper_invocation, 2, .production_id = 2),
  [545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [549] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_params, 3),
  [551] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_params, 4),
  [553] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_block_params_repeat1, 2),
  [555] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_params_repeat1, 2), SHIFT_REPEAT(176),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [622] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [624] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [628] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [630] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [632] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [634] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [636] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [638] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [640] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [642] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [644] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [646] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [648] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [652] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [654] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [656] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [658] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [668] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [674] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [676] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [678] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [680] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [682] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [686] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_glimmer_external_scanner_create(void);
void tree_sitter_glimmer_external_scanner_destroy(void *);
bool tree_sitter_glimmer_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_glimmer_external_scanner_serialize(void *, char *);
void tree_sitter_glimmer_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_glimmer(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_glimmer_external_scanner_create,
      tree_sitter_glimmer_external_scanner_destroy,
      tree_sitter_glimmer_external_scanner_scan,
      tree_sitter_glimmer_external_scanner_serialize,
      tree_sitter_glimmer_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
