/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import sun.security.action.GetIntegerAction;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SessionId;
import sun.security.util.Cache;

final class SSLSessionContextImpl
implements SSLSessionContext {
    private static final int DEFAULT_MAX_CACHE_SIZE = 20480;
    private final Cache<SessionId, SSLSessionImpl> sessionCache;
    private final Cache<String, SSLSessionImpl> sessionHostPortCache;
    private int cacheLimit = SSLSessionContextImpl.getDefaultCacheLimit();
    private int timeout = 86400;

    SSLSessionContextImpl() {
        this.sessionCache = Cache.newSoftMemoryCache(this.cacheLimit, this.timeout);
        this.sessionHostPortCache = Cache.newSoftMemoryCache(this.cacheLimit, this.timeout);
    }

    @Override
    public SSLSession getSession(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("session id cannot be null");
        }
        SSLSessionImpl sSLSessionImpl = this.sessionCache.get(new SessionId(byArray));
        if (!this.isTimedout(sSLSessionImpl)) {
            return sSLSessionImpl;
        }
        return null;
    }

    @Override
    public Enumeration<byte[]> getIds() {
        SessionCacheVisitor sessionCacheVisitor = new SessionCacheVisitor();
        this.sessionCache.accept(sessionCacheVisitor);
        return sessionCacheVisitor.getSessionIds();
    }

    @Override
    public void setSessionTimeout(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (this.timeout != n) {
            this.sessionCache.setTimeout(n);
            this.sessionHostPortCache.setTimeout(n);
            this.timeout = n;
        }
    }

    @Override
    public int getSessionTimeout() {
        return this.timeout;
    }

    @Override
    public void setSessionCacheSize(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (this.cacheLimit != n) {
            this.sessionCache.setCapacity(n);
            this.sessionHostPortCache.setCapacity(n);
            this.cacheLimit = n;
        }
    }

    @Override
    public int getSessionCacheSize() {
        return this.cacheLimit;
    }

    SSLSessionImpl get(byte[] byArray) {
        return (SSLSessionImpl)this.getSession(byArray);
    }

    SSLSessionImpl pull(byte[] byArray) {
        if (byArray != null) {
            return this.sessionCache.pull(new SessionId(byArray));
        }
        return null;
    }

    SSLSessionImpl get(String string, int n) {
        if (string == null && n == -1) {
            return null;
        }
        SSLSessionImpl sSLSessionImpl = this.sessionHostPortCache.get(SSLSessionContextImpl.getKey(string, n));
        if (!this.isTimedout(sSLSessionImpl)) {
            return sSLSessionImpl;
        }
        return null;
    }

    private static String getKey(String string, int n) {
        return (string + ":" + String.valueOf(n)).toLowerCase(Locale.ENGLISH);
    }

    void put(SSLSessionImpl sSLSessionImpl) {
        this.sessionCache.put(sSLSessionImpl.getSessionId(), sSLSessionImpl);
        if (sSLSessionImpl.getPeerHost() != null && sSLSessionImpl.getPeerPort() != -1) {
            this.sessionHostPortCache.put(SSLSessionContextImpl.getKey(sSLSessionImpl.getPeerHost(), sSLSessionImpl.getPeerPort()), sSLSessionImpl);
        }
        sSLSessionImpl.setContext(this);
    }

    void remove(SessionId sessionId) {
        SSLSessionImpl sSLSessionImpl = this.sessionCache.get(sessionId);
        if (sSLSessionImpl != null) {
            this.sessionCache.remove(sessionId);
            this.sessionHostPortCache.remove(SSLSessionContextImpl.getKey(sSLSessionImpl.getPeerHost(), sSLSessionImpl.getPeerPort()));
        }
    }

    private static int getDefaultCacheLimit() {
        block4: {
            try {
                int n = AccessController.doPrivileged(new GetIntegerAction("javax.net.ssl.sessionCacheSize", 20480));
                if (n >= 0) {
                    return n;
                }
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.warning("invalid System Property javax.net.ssl.sessionCacheSize, use the default session cache size (20480) instead", new Object[0]);
                }
            }
            catch (Exception exception) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl")) break block4;
                SSLLogger.warning("the System Property javax.net.ssl.sessionCacheSize is not available, use the default value (20480) instead", new Object[0]);
            }
        }
        return 20480;
    }

    private boolean isTimedout(SSLSession sSLSession) {
        if (this.timeout == 0) {
            return false;
        }
        if (sSLSession != null && sSLSession.getCreationTime() + (long)this.timeout * 1000L <= System.currentTimeMillis()) {
            sSLSession.invalidate();
            return true;
        }
        return false;
    }

    private final class SessionCacheVisitor
    implements Cache.CacheVisitor<SessionId, SSLSessionImpl> {
        ArrayList<byte[]> ids = null;

        private SessionCacheVisitor() {
        }

        @Override
        public void visit(Map<SessionId, SSLSessionImpl> map) {
            this.ids = new ArrayList(map.size());
            for (SessionId sessionId : map.keySet()) {
                SSLSessionImpl sSLSessionImpl = map.get(sessionId);
                if (SSLSessionContextImpl.this.isTimedout(sSLSessionImpl)) continue;
                this.ids.add(sessionId.getId());
            }
        }

        Enumeration<byte[]> getSessionIds() {
            return this.ids != null ? Collections.enumeration(this.ids) : Collections.emptyEnumeration();
        }
    }
}

