Helpful Configuration Macro
===========================

Find here the source for setup.el, that defines the `setup` macro.
This simplifies repetitive configuration patterns, by providing
context-sensitive local macros in `setup` bodies.

This definition is rather terse, but describes the package and the
main macro pretty well.  If you are interested in more details and
further examples, check out the [SetupEl] page on Emacs Wiki.

Feel free to contribute to this wiki page, either by adding your own
local macros or adding any other examples.  No accounts is necessary
to make changes to Emacs Wiki, and everything can be done anonymously.

[SetupEl]:
	https://www.emacswiki.org/emacs/SetupEl

Installation
------------

`setup.el` is avaliable from [GNU ELPA]. It can be installed by
invoking

	M-x package-install RET setup RET

[GNU ELPA]:
	http://elpa.gnu.org/packages/setup.html

Usage
-----

The `setup` macro is autoloaded, and can be used directly.  The code
generated by `setup` does not depend on `setup.el`, meaning that your
initialization file can be byte-compiled more efficiently.

There exist no configuration options for `setup`.  Anything you might
want to add or change can be done by defining or overwriting a local
macro using `setup-define`.

All local macros are (dynamically) documented as part of the `setup`
docstring.

Contribute
----------

As `setup.el` is distribed as part of [GNU ELPA], and therefore
requires a [copyright assignment] to the [FSF], for all non-trivial
code contributions.

I am currently hesitant to add more local macros.  The current set is
already reduced to those that (IMO) do a good job at highlighting
`setup`s features or are instructive examples on how to define your
own local macros.  Anything that could just as well be an alias or a
custom, context-insensitive macro is not worthwhile adding to
`setup.el`.

[copyright assignment]:
	https://www.gnu.org/software/emacs/manual/html_node/emacs/Copyright-Assignment.html
[FSF]:
	https://www.fsf.org/

Source code
-----------

`setup` is developed on [Codeberg].

[Codeberg]:
	https://codeberg.org/pkal/setup.el

Bugs and Patches
----------------

Bugs, patches, comments or questions can be submitted via [Codeberg's
issue system] or my sending [me] an email.

[Codeberg's issue system]:
	https://codeberg.org/pkal/setup.el/issues
[me]:
	https://amodernist.com/#email

Distribution
------------

`setup.el` and all other source files in this directory are
distributed under the [GNU Public License], Version 3 (like Emacs
itself).

[GNU Public License]:
	https://www.gnu.org/licenses/gpl-3.0.en.html
