+++
title = "Community"
layout = "single"
+++

wazero is the only zero dependency WebAssembly runtime written in Go. It is
used as a library dependency, allowing Go applications to embed or execute code
written in other languages. It is also used as a CLI, to invoke WebAssembly
binaries, a.k.a. wasm files.

### wazero community

[tetratelabs/wazero][1] holds the Apache licensed, open source code and tests
that ensure the project. A team of full-time staff at [Tetrate](https://tetrate.io/)
steward the wazero, and you can read [history]({{< relref "/history.md" >}}) for how everything
began!

Today, wazero is a vibrant community of dozens of community members,
leveraged by many open source projects and commercial products. Please have a
look at our [users]({{< relref "/users.md" >}}) page, as you may find something you need!

### Keeping up to date

wazero writes detailed release notes. Click Watch, Custom then Releases on the
[tetratelabs/wazero][1] repository to automatically get notifications. You can
also watch for the tag #wazero on various social media.

We also have a [gophers slack](https://gophers.slack.com/) `#wazero` channel
for support, updates and conversation! Note: You may need an [invite][2] to
join gophers.

Regardless, if you like what we are doing, please [star][3] our repo as folks
appreciate it.

### How change works in wazero

Most wazero efforts start as localized experiments, then progressively build
traction before becoming a feature. Before you start a large effort, be it docs or
a test framework or a feature, check with one of the above channels. Someone may
already have worked on this in the past and might join your effort. Sometimes,
features are intentionally absent, usually with rationale documented in an issue.
Regardless, the best advice is to join the community before proposing change, and
read one of our [CONTRIBUTING](https://github.com/tetratelabs/wazero/blob/main/CONTRIBUTING.md) files
which explains technical aspects of change culture.

[1]: https://github.com/tetratelabs/wazero
[2]: https://invite.slack.golangbridge.org/
[3]: https://github.com/tetratelabs/wazero/stargazers
