/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.lob.BlobImpl;
import net.sf.hibernate.lob.ClobImpl;
import net.sf.hibernate.proxy.HibernateProxy;
import net.sf.hibernate.proxy.HibernateProxyHelper;
import net.sf.hibernate.type.BigDecimalType;
import net.sf.hibernate.type.BinaryType;
import net.sf.hibernate.type.BlobType;
import net.sf.hibernate.type.BooleanType;
import net.sf.hibernate.type.ByteType;
import net.sf.hibernate.type.CalendarDateType;
import net.sf.hibernate.type.CalendarType;
import net.sf.hibernate.type.CharacterType;
import net.sf.hibernate.type.ClassType;
import net.sf.hibernate.type.ClobType;
import net.sf.hibernate.type.CompositeCustomType;
import net.sf.hibernate.type.CurrencyType;
import net.sf.hibernate.type.CustomType;
import net.sf.hibernate.type.DateType;
import net.sf.hibernate.type.DoubleType;
import net.sf.hibernate.type.FloatType;
import net.sf.hibernate.type.IntegerType;
import net.sf.hibernate.type.LocaleType;
import net.sf.hibernate.type.LongType;
import net.sf.hibernate.type.ManyToOneType;
import net.sf.hibernate.type.NullableType;
import net.sf.hibernate.type.ObjectType;
import net.sf.hibernate.type.PersistentEnumType;
import net.sf.hibernate.type.SerializableType;
import net.sf.hibernate.type.ShortType;
import net.sf.hibernate.type.StringType;
import net.sf.hibernate.type.TimeType;
import net.sf.hibernate.type.TimeZoneType;
import net.sf.hibernate.type.TimestampType;
import net.sf.hibernate.type.TrueFalseType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.type.YesNoType;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Hibernate {
    public static final NullableType LONG = new LongType();
    public static final NullableType SHORT = new ShortType();
    public static final NullableType INTEGER = new IntegerType();
    public static final NullableType BYTE = new ByteType();
    public static final NullableType FLOAT = new FloatType();
    public static final NullableType DOUBLE = new DoubleType();
    public static final NullableType CHARACTER = new CharacterType();
    public static final NullableType STRING = new StringType();
    public static final NullableType TIME = new TimeType();
    public static final NullableType DATE = new DateType();
    public static final NullableType TIMESTAMP = new TimestampType();
    public static final NullableType BOOLEAN = new BooleanType();
    public static final NullableType TRUE_FALSE = new TrueFalseType();
    public static final NullableType YES_NO = new YesNoType();
    public static final NullableType BIG_DECIMAL = new BigDecimalType();
    public static final NullableType BINARY = new BinaryType();
    public static final NullableType BLOB = new BlobType();
    public static final NullableType CLOB = new ClobType();
    public static final NullableType CALENDAR = new CalendarType();
    public static final NullableType CALENDAR_DATE = new CalendarDateType();
    public static final NullableType LOCALE = new LocaleType();
    public static final NullableType CURRENCY = new CurrencyType();
    public static final NullableType TIMEZONE = new TimeZoneType();
    public static final NullableType CLASS = new ClassType();
    public static final NullableType SERIALIZABLE = new SerializableType(class$java$io$Serializable == null ? (class$java$io$Serializable = Hibernate.class$("java.io.Serializable")) : class$java$io$Serializable);
    public static final Type OBJECT = new ObjectType();
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$net$sf$hibernate$CompositeUserType;

    private Hibernate() {
        throw new UnsupportedOperationException();
    }

    public static Type enum(Class enumClass) throws MappingException {
        return new PersistentEnumType(enumClass);
    }

    public static Type serializable(Class serializableClass) {
        return new SerializableType(serializableClass);
    }

    public static Type any(Type metaType, Type identifierType) {
        return new ObjectType(metaType, identifierType);
    }

    public static Type association(Class persistentClass) {
        return new ManyToOneType(persistentClass);
    }

    public static Type entity(Class persistentClass) {
        return new ManyToOneType(persistentClass);
    }

    public static Type custom(Class userTypeClass) throws HibernateException {
        if ((class$net$sf$hibernate$CompositeUserType == null ? (class$net$sf$hibernate$CompositeUserType = Hibernate.class$("net.sf.hibernate.CompositeUserType")) : class$net$sf$hibernate$CompositeUserType).isAssignableFrom(userTypeClass)) {
            return new CompositeCustomType(userTypeClass);
        }
        return new CustomType(userTypeClass);
    }

    public static void initialize(Object proxy) throws HibernateException {
        if (proxy == null) {
            return;
        }
        if (proxy instanceof HibernateProxy) {
            HibernateProxyHelper.getLazyInitializer((HibernateProxy)proxy).initialize();
        } else if (proxy instanceof PersistentCollection) {
            ((PersistentCollection)proxy).forceLoad();
        }
    }

    public static boolean isInitialized(Object proxy) {
        if (proxy instanceof HibernateProxy) {
            return !HibernateProxyHelper.getLazyInitializer((HibernateProxy)proxy).isUninitialized();
        }
        if (proxy instanceof PersistentCollection) {
            return ((PersistentCollection)proxy).wasInitialized();
        }
        return true;
    }

    public static Class getClass(Object proxy) throws HibernateException {
        if (proxy instanceof HibernateProxy) {
            return HibernateProxyHelper.getLazyInitializer((HibernateProxy)proxy).getImplementation().getClass();
        }
        return proxy.getClass();
    }

    public static Blob createBlob(byte[] bytes) {
        return new BlobImpl(bytes);
    }

    public static Blob createBlob(InputStream stream, int length) {
        return new BlobImpl(stream, length);
    }

    public static Blob createBlob(InputStream stream) throws IOException {
        return new BlobImpl(stream, stream.available());
    }

    public static Clob createClob(String string) {
        return new ClobImpl(string);
    }

    public static Clob createClob(Reader reader, int length) {
        return new ClobImpl(reader, length);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

