/*
 * Decompiled with CFR 0.152.
 */
package net.eyde.personalblog.service;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class CachedObject {
    public Object object = null;
    private Date dateofExpiration = null;
    private String identifier = null;
    private Date lastAccessTime = new Date();
    private long numAccess = 1L;
    private int size;

    public CachedObject(Object obj, String id, int minutesToLive) {
        this.object = obj;
        this.identifier = id;
        this.size = CachedObject.objectSize(obj);
        this.lastAccessTime = new Date();
        if (minutesToLive != 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.lastAccessTime);
            cal.add(12, minutesToLive);
            this.dateofExpiration = cal.getTime();
        }
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public boolean isExpired() {
        return this.dateofExpiration != null && this.dateofExpiration.before(new Date());
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Object getObject() {
        return this.object;
    }

    public Date getDateofExpiration() {
        return this.dateofExpiration;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getNumAccess() {
        return this.numAccess;
    }

    public long getSize() {
        return this.size;
    }

    public double getMixCost() {
        long milis = new Date().getTime() - this.lastAccessTime.getTime();
        if (milis == 0L) {
            milis = 1L;
        }
        return (double)this.numAccess / (double)milis / (double)this.size;
    }

    public double getLRUCost() {
        long milis = new Date().getTime() - this.lastAccessTime.getTime();
        if (milis == 0L) {
            milis = 1L;
        }
        return 1.0 / (double)milis;
    }

    public double getLFUCost() {
        return this.numAccess;
    }

    public void incNumAccess() {
        ++this.numAccess;
    }

    public boolean equals(Object o2) {
        try {
            String key2 = ((CachedObject)o2).getIdentifier();
            return this.identifier.equals(key2);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static int objectSize(Object o) {
        try {
            int size = ((List)o).size();
            return size + 1;
        }
        catch (Exception e) {
            return 1;
        }
    }
}

