package config

var BW6_633 = Curve{
	Name:         "bw6-633",
	CurvePackage: "bw6633",
	EnumID:       "BW6_633",
	FrModulus:    "39705142709513438335025689890408969744933502416914749335064285505637884093126342347073617133569",
	FpModulus:    "20494478644167774678813387386538961497669590920908778075528754551012016751717791778743535050360001387419576570244406805463255765034468441182772056330021723098661967429339971741066259394985997",
	G1: Point{
		CoordType:        "fp.Element",
		CoordExtDegree:   1,
		PointName:        "g1",
		GLV:              true,
		CofactorCleaning: true,
		CRange:           []int{4, 5, 8, 16},
	},
	G2: Point{
		CoordType:        "fp.Element",
		CoordExtDegree:   1,
		PointName:        "g2",
		GLV:              true,
		CofactorCleaning: true,
		CRange:           []int{4, 5, 8, 16},
		Projective:       true,
	},
	// 7-isogeny
	HashE1: &HashSuiteSswu{
		A: []string{"0xb5b90ddda6922f2689cf6d2cd62fc7c093d1edbb9b9cb78ba3a6fbeb5740830110ea006288b01bc5c3ff21599bc76c3cc068855d91995e0a03f25ad67e9b0cb86f833df84de9affcac130e2de80208"},
		B: []string{"0xbb475f2945d16aae79792dd2f17748101c2558a952d4221e5a52bee6083040e779fc8d5e9c51ac35df601e0273b10c72f2b0d48da6bbc3859a3b185a7ee3060030e001265b3803227cb9d879f408d9"},
		Z: []int{11},
		Isogeny: &Isogeny{
			XMap: RationalPolynomial{
				Num: [][]string{
					{"0x172ae0280920320d5154453cfc38fb78e8f3cc1f3e35c38bfe870403008707ab1c9d324595b739426a3f8e03cc03f4d2e6a3b21c833c83d2c147adc9dd927523d2b556276090b4e6217d4125c656bc"},
					{"0x3ac72438aeb5851d31e592b661151b037c9a2aab88cd7a2da79158e39dddee35c360788859c6aa878660fba8caaa9f8ff6480a0abcb9f9122c929e9b673eb8cb8ea164ca1e9eddd03b4155f0ca87aa"},
					{"0x6f2cca97746292add854c01e5d06bfd8282d74cbcd0e7169e2e310ca27302cee61398208840e20a9d6ffe43db9c520799710059df25e8ce05c304f59d65d4e596cd1c587a7f6f1096e53656f93f1cc"},
					{"0xab5eb0567468008b2665f73dd0c7711c3166659434e0df8f5902de8acae5cccd4707d236e5af68f88a02aacae38e2a2bd3b5bf4442e127a36d13a47260eee3fc97ba5d9d5e15d105e256c0d86e9b96"},
					{"0xd6c992e6deb66a0d2cc1008c227fcbfdedcd136cca4dd9708cf0217e554124030fb2032803e9620d8af19f3aed51abf6d98ab2be038495edf761550d84fd1fc92f803661d045879877b8eeb2d62c3f"},
					{"0x5964f96bcd18903bd4385390d129f87d141bfa129dd9b10c1657e88b13aa4830591458fe69f1c5422f8a9c04dd9ae4dfc55d44546d129f4b4bc708af118b9ce685bd0b9480e21af262b9fdde470769"},
					{"0xdea100c7e48b278c46938a6636d0988eabab86cc555a2988cae5b7c5ec0c8e9090740796a622b4ba807360da51be9823c7844464113d8cf0d134409f68758d4500cdf13cf6bc705cbb3b26a6b91ffd"},
					{"0xcc44dbc9cd7135b427007ff6d3fe49ce12b5c3cdec0a6af272524c19b15decb7c66941fc70b0e1cea225709a41d8da2dac0afeaf69770aaa930ca8be861e392fb2f3f5b8662e2a3757495ea31eb1ab"},
				},
				Den: [][]string{
					{"0xdcedc9bc56dade3f84967eaab07772e6382d825c853b5f21b2aa334ece09ca419a918ad532943018c0af9c373d006d5a5db3dae9cacbac8e1f7ca091dbb63f6e6f6beaee1370beaea58439a6b07a79"},
					{"0x195b81736d1c96d7a634ccd1a30ce5322c4d511b000e0c45cbe40e4fc193787b0b60086e3e4d2eeaf56537fcc1d7dde1305f6f1f43da15fa5a860515b5ebd80a71de65dfa88d88b4dde8a70ebbe4d0"},
					{"0x7306846c2c81b999dc05637178c43d7bcaa8f060fa6118084a2a801ba72736fbd0a2af9da70982f1e36c1c2485775de607d049a5faf6494d4d3eedd3ff5a760faf17ed0596c1e1a8aee8112ae305ff"},
					{"0xf148e1a26098d0488ff6183b6455f5e6605c502a1eb3c11e32096d10f777563a99faa0dba8835bfea9529f125f36903c681c7d9dd0bc814a1786cf0813388a804eca85fbaa5bdd78f7d746269d6bba"},
					{"0xde8e351bd12bb3d5af8b63954d0f78bfb4bc60813ad171eb74cf3eba9f691dfb1dfe147ffef06b9aca6a77d845184de3d4ea5948fe12fccec2371477802f2f6e865c39af78f97e392a54f81cb069fb"},
					{"0x10795e5f91d91e69bcdf124c64c0f1e2507ffc99bacb24dbe7d3cb6a07de6bfab41b8f939edbacfafd0ce0b72a847fa1169d64cae412d7eac428a1e2a570a85c42e5ab2bd355b6a2460289e03f1d8c"},
				},
			},
			YMap: RationalPolynomial{
				Num: [][]string{
					{"0xc0e9192eb96da62a98ed351e9c479d437e885f7b173bc0e8b5e117be8f9bc0b8784293b4edd36184584c570f1bbacfa6390dfdab92c1102aff64793eba4e0ca54166b6ea37f041d97e17d6b8793f59"},
					{"0x2ad94cfbe3e7c1f6c73f4b7986081a8747e453a324f5fef697f4bcd681b93764606aea1c234fcc16f02941c568e7e0fc9c970db8891079fecbb13a701870973155097603fa2a95f3a9814d630920ce"},
					{"0x4fe83943570d36473c925cb80651566f48ed1a12583a0ba466a4002cd5d81324bedc2af4685ce69e8ac8c982eff0e88e8983860fc7c365efd617110a18f8d2cd2c5f5a764656d1f0acd219dfa36482"},
					{"0xb2169bd7a853b597c830c30e580e9a4d2e3c25dd81b72667ca4370b2a978cdeb7bc9812693ef630bc510a4151170ad8c0618c4a038608977391fd3d83479456ea6802236a0b3de82ce1017e1a8ca6d"},
					{"0x7f25b01ef9844f28aa0a93cffc07a16e1cc68544c7f6772babb491e4a268f152a38b8b45123c9b054de66169553ba6059e8af4dc33ee26093d08489f85450d8c5be80f1ba5aeb2c0d0afd9f92a9122"},
					{"0x566545c6ba909462ad89503f026cd53fa3d34c013226c353b14aa982fb2fb682901be8b4a6341ee81a65270009af992892249cef724bf97898b1c3fc17377d4432a23894970c6dcb3583b60c84fa24"},
					{"0x63e2ccd9a60b841370ac46210ce9788ae1562f251ffddbf6c1999647217f1fb641c6b28725006db4784cda2bb6149c5f7e8a0e1262cf65258d29f63eedcf4651d9cc6f36cf1754ac816f22fc61b9c7"},
					{"0x3f2fa1f528148f6695c61636ddc28b114cbe73a59ff01987fa09ce591615c9c3588f43eee553df2b678321a7348d1d9609316cb0a7a99d816beb08586b2c6f140dbef23f030253c0e4c06208d60788"},
					{"0xf607a90cc520cf3642e858f10134f611165201f1a19d8aa556830a8d119c70f050ade9579d2af2437e4daed7e8413b7eaa57066a4f1637a9eb355979a9069b53019d4f6a3b12bd11e65f30fb97928"},
					{"0xcdfc4b597b44fc122ba1d93dbe1c643d84e251481f80d31b34e546493c89bd3a651ed920fb518fce37f21fcd0850fe6e97f9e08e774242b04f71dff19a9b401ee3c8d55d71cb9849041ef6054c20e"},
				},
				Den: [][]string{
					{"0xecfc2a8f34b76242cf9989e6693e365112eac88902ea95115bccd5bb49a664d72b2eec54104241f9c5f1a68018d8eb3db2d854d09b081df9a369bd4312614d50899c909fbb2d2b52a7635c4d17f8b7"},
					{"0x742dda08c1fcb9436c2bc5f52af4d8189585537efd4b1a7f91fa77b5f737b8c6fabc388a01078294e7dd2198b8a32fa89354400dcec753d887b198f206ae05288915451a752ef75b75d8c360ea36bb"},
					{"0xc1d1190593e7a0686859a609ff1b46e11c0327a20872f72279a21b183a44281d0cee21d747715e9dc19f973b098c1dd3599593b70f85733addf045ea08642a6f840f99002986bec1f94bee017cd4f1"},
					{"0x97e05de3ca9556f56ecf4d1ea23a7e2d2712c0ae94ae9e446d965d7004b483b7422f99fed04fdddbc0c2d7fcc1145f04ad2f384637ed52da52a2fda64c67d29b756381ab78f85d74ec8086cfcb9179"},
					{"0x75ad4fd71ac6a390fe643f2d7e58ab8e47679afea937b2fa282221167c5e439b8d0b71d9d9c415aced0755ce72f558c6b966b4103521c4d576e232006e02ce0aea7d969d59bb6aa7fd0464bb753ee9"},
					{"0xaf031142ce65bb40b7b4a865ddf8b662e90c8f6496d6e4efd790353e79905de96971b0e90ecbe0ca95cb602145603cf7e33d79207c766500002418e725368fd15fef6ad5fd2d70dde8e192180d408b"},
					{"0x906c22013e788817b69f3c5705a7dbb9efeedabf5d8f091b518cde2891e351aa73cff16f909a2aeb160dc3e26f0ea78b07d327cc073494f8fa334f7b15c42f6454ec151ac079a3a0802d1f9eabbbc1"},
					{"0x9435c646c7573441604b5c0e0a53569e9440440e3e8df291c6ad158f942080d9a60829e933883e3bdbc574fc459c167608aa11e7b0ad4ec1c35e29c0cc81bf2b7481e35d0821b52e5ee02dde63ecf2"},
					{"0x18b60d8f5ac5ad9e9b4e9b7297216ad378bffae69830b749dbbdb11f0bcda1f80e29575d6e4983787b935112bfc6bf71a1ec1730561c43e0263cf2d3f828fc8a645880c1bd0091f36903ced05eac52"},
				},
			},
		},
	},
	// 2-isogeny
	HashE2: &HashSuiteSswu{
		A: []string{"0x37406b7fa0e08ee1ffbb1ff2ff0ac49e29ba75a3caa8356b90991ae70b94d33807a85e57856205541ab2cb490d6980835d627d3d10b29e4d73a43caf3b5042cf1f7ab420fd005e2d747ffe14"},
		B: []string{"0xb0"},
		Z: []int{2},
		Isogeny: &Isogeny{
			XMap: RationalPolynomial{
				Num: [][]string{
					{"0x75c14b832491ee6015aa114d85d2ae69f27a247446da31831298835185ff04f44ee6dccb2179be43cf8cd0695188add97e49c08a2a617963eb40e8291283e4750d0e7862161f19fc5d41132e666653"},
					{"0x3ae0a5bf44ef27340179bf3c1b1d57bfae1f8ba310fd8743c24a07d811f3b8d9abeaa1653f0e462703b0da08e15133e1856a302131162f7bee2f30da626a15980dd9c8e5109d60f3a3f1f25d03333f"},
					{"0xdcca6d90b6878afd13917b416160083ebda295861b5e157ac318f4234ce3a3a0fdfd10bc26fb6c8aa3f786e2f81d371e8ae63cb24e3b05e1c85adc0a2b519bede8f4de4cf5f96da176d12fb414000a"},
				},
				Den: [][]string{
					{"0xeb8296fd13bc9cd005e6fcf06c755efeb87e2e8c43f61d0f09281f6047cee366afaa8594fc39189c0ec368238544cf8615a8c084c458bdefb8bcc36989a8566037672394427583ce8fc7c9740cccfc"},
				},
			},
			YMap: RationalPolynomial{
				Num: [][]string{
					{"0x126633cc0f35f63fc1a174f01d72ab5a8fcd8c75d79d2c74e59769ad9bbda2f8152a6c0fadea490b8da9f5e83f57c497e0e8850edbda407d7b5ce7ab839c2253d369bd31147f73cd74916ea456fffff"},
					{"0x93319e5991a24209f0f9cb40f4315c749d13cfe9859aaf2dd7b49ffacac9badf36b8f97c7a467d6bc10f04bea464bb9d5a14180b32825c49c49373ada8597cb731458fa4b4a51a4c047faf74280044"},
					{"0xeb8296ff61166ccc0f42465b14415e74039bb5235665ae8cd02a5930f8daad072b3352954de7b196f2d8f64f4cb7f2914f6370a8a8734b25c02e06a3b0803302b01496e03ce7afd91a7660ae3ccce5"},
					{"0x6e6536c85b43c57e89c8bda0b0b0041f5ed14ac30daf0abd618c7a11a671d1d07efe885e137db64551fbc3717c0e9b8f45731e59271d82f0e42d6e0515a8cdf6f47a6f267afcb6d0bb6897da0a0005"},
				},
				Den: [][]string{
					{"0x126633cc0f35f63fc1a174f01d72ab5a8fcd8c75d79d2c74e59769ad9bbda2f8152a6c0fadea490b8da9f5e83f57c497e0e8850edbda407d7b5ce7ab839c2253d369bd31147f73cd74916ea456fffcd"},
					{"0xb0a1f1145e7cd5e35c021434850010ffc24b2c49e7205af348b606dbc306fd4454217a29fee410d1018e8f069ddb24da811e2ddd8964a0a74496d8786c10bd5bad5b3f5795d10a1d2b8f34ffa99b2b"},
					{"0x75c14b7554770e77dd8658cd970ab1aa2fc8fce9d83cc890688b286d5fb84b3169b20ec937622862770b7b62a4d5db9623e99fb2d1c22a1fbe9954cc2974b8a638fdc49a377211bd1d2987d14666da"},
				},
			},
		},
	},
}

var tBW6_633 = TwistedEdwardsCurve{
	Name:     BW6_633.Name,
	Package:  "twistededwards",
	EnumID:   BW6_633.EnumID,
	A:        "-1",
	D:        "37248940285811842784899494310834635440994424264352085037441815381151934266434102922992043546621",
	Cofactor: "8",
	Order:    "4963142838689179791878211236301121218116687802119716497817028544854034649070444389864454748079",
	BaseX:    "37635937024655419978837220647164498012335808680404874556501960268316961933409049243153117555100",
	BaseY:    "23823085625708063001015413934245381846960101450148849601038571303382730455875805408244170280142",
}

func init() {
	addCurve(&BW6_633)
	addTwistedEdwardCurve(&tBW6_633)
}
